/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proother.freeze.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proother.contract.bean.ContractEntity;
import com.ejianc.business.proother.contract.service.IContractService;
import com.ejianc.business.proother.freeze.bean.FreezeEntity;
import com.ejianc.business.proother.freeze.service.IFreezeService;
import com.ejianc.business.proother.freeze.vo.FreezeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"freeze"})
public class FreezeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "OTH_FRE";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IFreezeService service;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IProjectSetApi projectSetApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FreezeVO> saveOrUpdate(@RequestBody FreezeVO saveorUpdateVO) {
        CommonResponse projectRes = this.projectSetApi.getProjectId(saveorUpdateVO.getProjectId());
        if (projectRes.isSuccess() && "16".equals(((ProjectPoolSetVO)projectRes.getData()).getCapitalStatus())) {
            throw new BusinessException("\u8be5\u9879\u76ee\u8d44\u91d1\u7ba1\u63a7\u72b6\u6001\u4e3a\u3010\u6210\u672c\u5173\u95e8\u3011\uff0c\u4e0d\u5141\u8bb8\u6b64\u64cd\u4f5c!");
        }
        FreezeEntity entity = (FreezeEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, FreezeEntity.class));
        if (entity.getId() == null) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("contractId", new Parameter("eq", (Object)entity.getContractId()));
                queryParam.getParams().put("performanceStatus", new Parameter("eq", (Object)entity.getPerformanceStatus()));
                ArrayList<Integer> list = new ArrayList<Integer>();
                list.add(0);
                list.add(2);
                list.add(5);
                queryParam.getParams().put("billState", new Parameter("in", list));
                List freezeEntities = this.service.queryList(queryParam);
                if (!freezeEntities.isEmpty()) {
                    throw new BusinessException("\u5f53\u524d\u5408\u540c\u4e0b\u6709\u672a\u751f\u6548\u7684\u51bb\u7ed3/\u89e3\u51bb \u5355\u4e0d\u80fd\u518d\u6b21\u53d1\u8d77\u51bb\u7ed3/\u89e3\u51bb\u8bf7\u6c42");
                }
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setBillState(0);
        this.service.saveOrUpdate((Object)entity, false);
        FreezeVO vo = (FreezeVO)BeanMapper.map((Object)((Object)entity), FreezeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FreezeVO> queryDetail(Long id) {
        FreezeEntity entity = (FreezeEntity)((Object)this.service.selectById(id));
        FreezeVO vo = (FreezeVO)BeanMapper.map((Object)((Object)entity), FreezeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FreezeVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FreezeVO>> queryList(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("create_time", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FreezeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getContractPerformanceStatus"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> getContractPerformanceStatus(Long contractId) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        if (null != contractEntity && null != contractEntity.getPerformanceStatus()) {
            return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7\uff0c\u8be5\u5408\u540c\u53ef\u4ee5\u65b0\u589e\u51bb\u7ed3\u5355\uff01", (Object)contractEntity.getPerformanceStatus());
        }
        return CommonResponse.error((String)"\u6821\u9a8c\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5408\u540c\u6216\u5408\u540c\u72b6\u6001\u4e3a\u7a7a\uff01");
    }
}

