/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proother.relieve.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.proother.contract.bean.ContractEntity;
import com.ejianc.business.proother.contract.service.IContractService;
import com.ejianc.business.proother.enums.SignatureStatusEnum;
import com.ejianc.business.proother.relieve.bean.ContractRelieveEntity;
import com.ejianc.business.proother.relieve.service.IContractRelieveService;
import com.ejianc.business.proother.relieve.service.IRelieveSignatureService;
import com.ejianc.business.proother.relieve.vo.ContractRelieveVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="relieveSignatureService")
public class RelieveSignatureServiceImpl
implements IRelieveSignatureService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${contract.relieveContract}")
    private String relieveContract;
    @Autowired
    private IContractRelieveService service;
    @Autowired
    private IContractService contractService;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IExecutionApi executionApi;

    @Override
    public CommonResponse<String> relieveContract(Long id, String signatureStatus, String refCode) {
        this.logger.info("\u66f4\u65b0\u5408\u540c\u89e3\u9664\u5355\u636e\u7b7e\u7ae0\u72b6\u6001\u548c\u5408\u540c\u72b6\u6001\uff0c\u5165\u53c2--id\uff1b{}\uff0csignatureStatus\uff1a{}\uff0crefCode\uff1a{}", new Object[]{id, signatureStatus, refCode});
        if (refCode.equals(this.relieveContract)) {
            ContractRelieveEntity contractRelieveEntity = (ContractRelieveEntity)((Object)this.service.selectById(id));
            contractRelieveEntity.setSignatureStatus(signatureStatus);
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractRelieveEntity.getContractId()));
            if (contractEntity == null) {
                throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u53ef\u4fee\u6539\u72b6\u6001\u7684\u5408\u540c\uff01");
            }
            this.logger.info("\u5373\u5c06\u4fee\u6539\u7684\u5408\u540c\u4fe1\u606f--{}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
            if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(signatureStatus) && ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode().equals(contractEntity.getPerformanceStatus())) {
                contractRelieveEntity.setEffectiveDate(new Date());
                contractEntity.setPerformanceStatus(ContractPerformanceStateEnum.\u5df2\u7ec8\u6b62.getStateCode());
                this.contractService.saveOrUpdate((Object)contractEntity, false);
                this.logger.info("\u5408\u540c\u5df2\u4f5c\u5e9f\uff01");
                String linkUrl = this.BaseHost + "ejc-proother-frontend/#/contractRelieve/Card?id=" + contractRelieveEntity.getId();
                ExecutionVO executionVO = this.service.targetCost((ContractRelieveVO)BeanMapper.map((Object)((Object)contractRelieveEntity), ContractRelieveVO.class), linkUrl);
                this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
                CommonResponse response = this.executionApi.aggPush(executionVO);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
                }
            }
            this.service.saveOrUpdate((Object)contractRelieveEntity, false);
            return CommonResponse.success((String)"\u5408\u540c\u89e3\u9664\u5355\u636e\u7b7e\u7ae0\u72b6\u6001\u66f4\u65b0\u6210\u529f\uff01");
        }
        return CommonResponse.error((String)"\u5408\u540c\u89e3\u9664\u5355\u636e\u7b7e\u7ae0\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff01");
    }
}

