package com.ejianc.business.proother.contract.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.proother.contract.bean.ChangeEntity;
import com.ejianc.business.proother.contract.bean.ContractEntity;
import com.ejianc.business.proother.contract.service.IChangeService;
import com.ejianc.business.proother.contract.service.IContractAsyncService;
import com.ejianc.business.proother.contract.service.IContractService;
import com.ejianc.business.proother.enums.*;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.*;

@Service("change") 
public class ChangeBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IChangeService changeService;

	@Autowired
	private IContractService contractService;

    @Autowired
    private SessionManager sessionManager;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";

	@Autowired
	private IParamConfigApi paramConfigApi;

	@Autowired
	private ISignatureCommonApi signatureCommonApi;

	@Autowired
	private IContractAsyncService contractAsyncService;

	@Autowired
	private IAttachmentApi attachmentApi;

	@Autowired
	private IProjectPoolApi projectPoolApi;

	/**
	 * 提交完回调
	 *
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//设置单据提交人信息
		ChangeEntity e = changeService.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();

		e.setCommitDate(new Date());
		e.setCommitUserCode(userContext.getUserCode());
		e.setCommitUserName(userContext.getUserName());
		changeService.saveOrUpdate(e, false);
		return CommonResponse.success("变更回调处理完成！");
	}



	/**
	 * 终审审核完回调
	 * 审批回调逻辑：
	 * 1、将现合同数据复制到合同记录表
	 * 2、将现合同附件同步到合同记录
	 * 3、将变更单据数据复制到合同表
	 * 4、将变更单附件信息同步到现合同中
	 * 5、修改合同变更状态、变更单状态
	 *
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		/**更新变更的审批时间  begin */
		ChangeEntity changeEntity = changeService.selectById(billId);
		//如果当前变更合同的主合同的合同状态不是履约中（冻结、解除、封账），则变更的合同不能进行提交
		ContractEntity contractEntity = contractService.selectById(changeEntity.getContractId());
		if (null != contractEntity && !contractEntity.getPerformanceStatus().equals(ContractPerformanceStateEnum.履约中.getStateCode())){
			return CommonResponse.error("当前变更合同所属的主合同状态不是履约中，该变更合同不能进行提交操作！");
		}

		//合同文件检查
		checkContractFile(changeEntity);

        // 水印系统参数
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("获取水印系统参数请求失败，失败原因：" + response.getMsg());
        }
        String valueData = response.getData().getValueData();
        Assert.hasText(valueData, "获取的水印系统参数不能为空!");

        // 是否限制： 0:不限制，1:限制
        if ("0".equals(valueData)) {
            // 转换水印参数配置：默认规则
            WatermarkVO watermarkVO = signatureCommonApi.fetchWatermarkConfig(changeEntity.getChangeFileId(), changeEntity.getId(),
                    changeEntity.getBillCode(), ProotherBillTypeEnum.其他合同变更.getBillTypeCode(),
                    "proOtherContractChange");
            Assert.notNull(watermarkVO, "获取水印系统参数失败!");
            // 获取上下文并异步调用添加水印
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));
            contractAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
        }

		Boolean commitState = false;
        if(state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
			commitState = true;
            //直审设置单据提交人信息
            changeEntity.setCommitDate(new Date());
            changeEntity.setCommitUserCode(sessionManager.getUserContext().getUserCode());
            changeEntity.setCommitUserName(sessionManager.getUserContext().getUserName());
        }
        if (DraftTypeEnum.线下签订.getCode().equals(changeEntity.getChangeDraftType())){
		    //调用生效回写服务
			return changeService.effectiveSaveWriteContract(billId, billTypeCode, commitState,false);
		}else {
			//变更单更新
			if (commitState){
				changeService.saveOrUpdate(changeEntity);
			}
			//回写主合同信息
			contractEntity.setChangeStatus(ChangeStatusEnum.变更单据审批通过.getCode());
			contractService.saveOrUpdate(contractEntity, false);
			logger.info("更新合同表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractEntity));
		}

		return CommonResponse.success("审批回调合同成功！");
	}


	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return doBpmBack(billId, state, billTypeCode);
	}

//	/**
//	 * 弃审后事件回调
//	 * 回调逻辑：
//	 * 1、校验变更单签章状态，若已有签章流程，则不允许撤回操作
//	 * 2、将原合同附件信息删除，记录对应的附件同步至原合同
//	 * 3、删除记录表、删除记录对应附件信息
//	 * 4、查询对应记录表，将记录主子表数据还原到原合同中
//	 * 5、将合同变更状态修改为：变更中，生效状态清空，变更单签章状态还原
//	 *
//	 * @param billId
//	 * @param state
//	 * @return
//	 */
//	@Override
//	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
//		return doBpmBack(billId, state, billTypeCode);
//	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return doBpmBack(billId, state, billTypeCode);
	}

	/**
	 * @param billId
	 * @param state
	 * @param billTypeCode
	 * @return
	 */
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
		CommonResponse<String> resp = null;
		//提交通过、且待签章则可弃审
		ChangeEntity changeEntity = changeService.selectById(billId);

		// 审批可以撤回的签章状态集合
		ArrayList<String> statusList = new ArrayList<>();
		statusList.add(SignatureStatusEnum.待签章.getCode());
		statusList.add(SignatureStatusEnum.已退回.getCode());
		statusList.add(SignatureStatusEnum.已撤回.getCode());
		statusList.add(SignatureStatusEnum.已过期.getCode());
		logger.info("进入变更撤回！");
		logger.info("变更合同信息：{}", JSONObject.toJSONString(changeEntity));
		//已提交或审批通过的变更合同不能撤回
		if ((BillStateEnum.COMMITED_STATE.getBillStateCode().equals(changeEntity.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(changeEntity.getBillState()))
			&& (DraftTypeEnum.线下签订.getCode().equals(changeEntity.getChangeDraftType()) ||
				(DraftTypeEnum.上传合同.getCode().equals(changeEntity.getChangeDraftType()) && !statusList.contains(changeEntity.getSignatureStatus())))){
			return CommonResponse.error("已生效或已发起签章的变更合同不能撤回/弃审！");
		}

//		if(!DraftTypeEnum.线下签订.getCode().equals(changeEntity.getChangeDraftType()) && !statusList.contains(changeEntity.getSignatureStatus())) {
//			return CommonResponse.error("当前单据已有签章流程，不能撤回！");
//		} else if(SignatureStatusEnum.已签章.getCode().equals(changeEntity.getSignatureStatus())) {
//
//		}
		changeEntity.setSignatureStatus(SignatureStatusEnum.待签章.getCode());

		changeEntity.setCommitDate(null);
		changeEntity.setCommitUserCode(null);
		changeEntity.setCommitUserName(null);
		changeService.saveOrUpdate(changeEntity);
		logger.info("撤回更新变更表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(changeEntity));

		ContractEntity contractEntity = contractService.selectById(changeEntity.getContractId());
		contractEntity.setChangeStatus(ChangeStatusEnum.变更中.getCode());
		contractService.saveOrUpdate(contractEntity, false);
		logger.info("撤回更新合同表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractEntity));

		return CommonResponse.success("执行变更单撤回回调逻辑成功！");
	}

	/**
	 * 检查合同文件
	 *
	 * @param changeEntity
	 */
	private void checkContractFile(ChangeEntity changeEntity) {
		//查询合同对饮附件是否存在
		CommonResponse<AttachmentVO> attachResp = attachmentApi.queryDetail(changeEntity.getChangeFileId().toString());
		if(!attachResp.isSuccess() || null == attachResp.getData()) {
			logger.info("合同存储变更文件Id-{}在文件中心不存在，根据参数sourceId-{}, sourceType-{}, billType-{} 查询对应文件信息",
					changeEntity.getChangeFileId(),
					changeEntity.getId(),
					"contractChangeFile",
					ProotherBillTypeEnum.其他合同变更.getBillTypeCode());
			//合同附件不存在，根据合同Id、业务类型、查询是否存在对应的文件信息，若存在则更新到合同中，否则抛出异常
			CommonResponse<List<AttachmentVO>> attachListResp = attachmentApi.queryListBySourceId(changeEntity.getId(),
					ProotherBillTypeEnum.其他合同变更.getBillTypeCode(),
					"subContractFile", "desc");

			logger.info("根据参数sourceId-{}, sourceType-{}, billType-{} 查询对应变更文件信息结果：{}",
					changeEntity.getId(),
					"subContractFile",
					ProotherBillTypeEnum.其他合同变更.getBillTypeCode(),
					JSONObject.toJSONString(attachListResp));
			if(attachListResp.isSuccess() || CollectionUtils.isEmpty(attachListResp.getData())) {
				AttachmentVO attachmentVO = attachListResp.getData().get(0);
				logger.info("将合同id-{}对应合同变更文件Id-{}改为{}", changeEntity.getId(), changeEntity.getChangeFileId(), attachmentVO.getId());
				changeEntity.setChangeFileId(attachmentVO.getId());
				changeEntity.setChangeFilePath(attachmentVO.getTruePath());
			} else {
				throw new BusinessException("审批失败，获取合同变更文件信息失败, 请检查合同变更文件！");
			}
		}
	}

	/**
	 * 审批--获取当前节点的审批人---从服务中选择
	 *
	 * @param billId 单据id
	 * @param billTypeCode 单据类型编码
	 * @param sign 节点标志
	 * @return
	 */
	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
		JSONArray arr = new JSONArray();
		logger.info("sign:{}",sign);

		//根据标识判断是否（成本相关人员审批的）节点
		if ("choseCostUser".equals(sign)){
			//获取表单详情数据

			//根据项目id获取项目基本信息中的成本对接人信息
			ChangeEntity entity = changeService.selectById(billId);
			Long projectId = entity.getProjectId();

			JSONObject jsonObject = new JSONObject();
			CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(projectId);


			if(!commonResponse.isSuccess()){
				throw new BusinessException("查询项目失败!");
			}
			JSONArray array = commonResponse.getData();
			List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);

			logger.info("vos:{}",JSONObject.toJSONString(vos));

			ProjectPoolSetVO vo = vos.get(0);
			Long costAdapter = vo.getCostAdapter();
			String costAdapterName = vo.getCostAdapterName();

			logger.info("userId:{}",costAdapter);
			logger.info("userName:{}",costAdapterName);


			jsonObject.put("userId",costAdapter);
			jsonObject.put("userName",costAdapterName);

			arr.add(jsonObject);

		}
		return CommonResponse.success(arr);
	}

}
