/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proother.relieve.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.proother.contract.bean.ContractEntity;
import com.ejianc.business.proother.contract.service.IContractService;
import com.ejianc.business.proother.enums.SignatureStatusEnum;
import com.ejianc.business.proother.relieve.bean.ContractRelieveEntity;
import com.ejianc.business.proother.relieve.service.IContractRelieveService;
import com.ejianc.business.proother.relieve.vo.ContractRelieveVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="contractRelieve")
public class ContractRelieveBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractRelieveService service;
    @Autowired
    private IContractService contractService;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ContractRelieveEntity e = (ContractRelieveEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.logger.info("======\u63d0\u4ea4\u5b8c\u56de\u8c03======,{}", (Object)JSONObject.toJSONString((Object)((Object)e)));
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u5408\u540c\u89e3\u9664\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ContractRelieveEntity entity = (ContractRelieveEntity)((Object)this.service.selectById(billId));
        if (entity != null) {
            if (entity.getDraftType() == 2) {
                entity.setSignatureStatus("4");
                entity.setPerformanceStatus(Integer.valueOf(ContractPerformanceStateEnum.\u5df2\u4f5c\u5e9f.getStateCode()));
                entity.setEffectiveDate(new Date());
                this.service.saveOrUpdate((Object)entity, false);
                QueryParam param = new QueryParam();
                param.getParams().put("id", new Parameter("eq", (Object)entity.getContractId()));
                List contractEntities = this.contractService.queryList(param, false);
                ((ContractEntity)((Object)contractEntities.get(0))).setPerformanceStatus(ContractPerformanceStateEnum.\u5df2\u4f5c\u5e9f.getStateCode());
                this.logger.info("======\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03,\u5df2\u7b7e\u7ae0======,{}", (Object)JSONObject.toJSONString(contractEntities.get(0)));
                this.contractService.saveOrUpdate(contractEntities.get(0), false);
                String linkUrl = this.BaseHost + "ejc-proother-frontend/#/contractRelieve/Card?id=" + entity.getId();
                ExecutionVO executionVO = this.service.targetCost((ContractRelieveVO)BeanMapper.map((Object)((Object)entity), ContractRelieveVO.class), linkUrl);
                this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
                CommonResponse response = this.executionApi.aggPush(executionVO);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
                }
            } else if (entity.getDraftType() == 1) {
                entity.setSignatureStatus("1");
                this.logger.info("======\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03,\u521d\u59cb\u5316\u6210\u5f85\u7b7e\u7ae0======,{}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
                this.service.saveOrUpdate((Object)entity, false);
            }
            ContractPoolVO contractPoolVO = new ContractPoolVO();
            contractPoolVO.setSourceId(entity.getContractId());
            contractPoolVO.setPerformanceStatus(ContractPerformanceStateEnum.\u5df2\u4f5c\u5e9f.getStateCode());
            this.contractPoolApi.updatePerformanceStatusByContractId(contractPoolVO);
        }
        return CommonResponse.success((String)"\u5408\u540c\u89e3\u9664\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\u5904\u7406\u6210\u529f!");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        ContractRelieveEntity entity = (ContractRelieveEntity)((Object)this.service.selectById(billId));
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(SignatureStatusEnum.\u5f85\u7b7e\u7ae0.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u9000\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u64a4\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u8fc7\u671f.getCode());
        if ("1".equals(entity.getDraftType()) && !statusList.contains(entity.getSignatureStatus())) {
            return CommonResponse.error((String)("\u5408\u540c\u89e3\u9664" + (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(entity.getSignatureStatus()) ? "\u5df2\u751f\u6548" : "\u5df2\u6709\u7b7e\u7ae0\u6d41\u7a0b") + "\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1!"));
        }
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(entity.getSignatureStatus())) {
            entity.setSignatureStatus(SignatureStatusEnum.\u5f85\u7b7e\u7ae0.getCode());
            this.service.saveOrUpdate((Object)entity, false);
        }
        return CommonResponse.success((String)"\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
        JSONArray arr = new JSONArray();
        this.logger.info("sign:{}", (Object)sign);
        if ("choseCostUser".equals(sign)) {
            ContractRelieveEntity entity = (ContractRelieveEntity)((Object)this.service.selectById(billId));
            Long projectId = entity.getProjectId();
            JSONObject jsonObject = new JSONObject();
            CommonResponse commonResponse = this.projectPoolApi.queryProjectPoolById(projectId);
            if (!commonResponse.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u5931\u8d25!");
            }
            JSONArray array = (JSONArray)commonResponse.getData();
            List vos = JSONObject.parseArray((String)array.toJSONString(), ProjectPoolSetVO.class);
            this.logger.info("vos:{}", (Object)JSONObject.toJSONString((Object)vos));
            ProjectPoolSetVO vo = (ProjectPoolSetVO)vos.get(0);
            Long costAdapter = vo.getCostAdapter();
            String costAdapterName = vo.getCostAdapterName();
            this.logger.info("userId:{}", (Object)costAdapter);
            this.logger.info("userName:{}", (Object)costAdapterName);
            jsonObject.put("userId", (Object)costAdapter);
            jsonObject.put("userName", (Object)costAdapterName);
            arr.add((Object)jsonObject);
        }
        return CommonResponse.success((Object)arr);
    }
}

