/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proother.relieve.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.proother.contract.bean.ContractEntity;
import com.ejianc.business.proother.contract.service.IContractService;
import com.ejianc.business.proother.relieve.bean.ContractRelieveEntity;
import com.ejianc.business.proother.relieve.mapper.ContractRelieveMapper;
import com.ejianc.business.proother.relieve.service.IContractRelieveService;
import com.ejianc.business.proother.relieve.vo.ContractRelieveVO;
import com.ejianc.business.proother.settle.bean.SettleEntity;
import com.ejianc.business.proother.settle.service.ISettleService;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractRelieveService")
public class ContractRelieveServiceImpl
extends BaseServiceImpl<ContractRelieveMapper, ContractRelieveEntity>
implements IContractRelieveService {
    @Autowired
    private IContractRelieveService service;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private IContractService contractService;

    @Override
    public Boolean isCanRelieve(Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter("eq", (Object)contractId));
        List list = this.service.queryList(param);
        return list.isEmpty();
    }

    @Override
    public ExecutionVO targetCost(ContractRelieveVO contractRelieveVO, String linkUrl) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList detailList = new ArrayList();
        totalVO.setSourceId(contractRelieveVO.getId());
        totalVO.setTenantId(contractRelieveVO.getTenantId());
        totalVO.setBillCode(contractRelieveVO.getBillCode());
        totalVO.setBillType("BT220317000000014");
        totalVO.setBussinessType(BussinessTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setProjectId(contractRelieveVO.getProjectId());
        totalVO.setOrgId(contractRelieveVO.getOrgId());
        BigDecimal totalMny = BigDecimal.ZERO;
        BigDecimal totalTaxMny = BigDecimal.ZERO;
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        list.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.in(SettleEntity::getBillState, list);
        wrapper.eq(SettleEntity::getContractId, (Object)contractRelieveVO.getContractId());
        List settleList = this.settleService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)settleList)) {
            totalMny = settleList.stream().map(SettleEntity::getMny).reduce(totalMny, BigDecimal::add);
            totalTaxMny = settleList.stream().map(SettleEntity::getTaxMny).reduce(totalTaxMny, BigDecimal::add);
        }
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(contractRelieveVO.getContractId()));
        totalVO.setMoney(ComputeUtil.safeSub((BigDecimal)totalMny, (BigDecimal)contract.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)totalTaxMny, (BigDecimal)contract.getContractTaxMny()));
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }
}

