package com.ejianc.business.proother.contract.service;

import com.ejianc.business.proother.contract.bean.ChangeEntity;
import com.ejianc.business.proother.contract.vo.ChangeDetailVO;
import com.ejianc.business.proother.contract.vo.ChangeVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * 分包变更实体
 * 
 * @author generator
 * 
 */
public interface IChangeService extends IBaseService<ChangeEntity> {

    /**
     * 校验  其他支出合同-变更  【合同金额】控【变更金额】  变更金额 > 合同金额*X%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
     *
     * @param changeVO
     * @param flag
     * @return
     */
    List<ParamsCheckVO> changeMnyCtrl(ChangeVO changeVO, Boolean flag);

    ChangeVO queryDetailRecord(Long id);

    Boolean editChangeFlag(Long id);

    ChangeVO addConvertByConId(Long contractId, Long changeId);

    ChangeVO insertOrUpdate(ChangeVO saveorUpdateVO, Boolean isControl);

    String getLinkUrl(ChangeVO cv);

    ChangeVO queryDetail(Long id);

    CommonResponse<String> deleteById(Long changeBillId);

    Map<String, Object> queryChangeCompare(Long id);

    ChangeVO queryChangeRecord(Long contractId, Long changeId);

    CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState,boolean filingFlag);

    List<ChangeDetailVO> selectUsefulByIds(List<Long> srcTblIdList);

    /**
     * 转目标成本VO
     *
     * @param changeVO  变更单据
     * @param linkUrl 变更单对应详情路由地址
     * @param contractType 合同类型
     * @param lastSourceId 是否需要传递上一版本业务单据Id
     * @return
     */
    ExecutionVO targetCost(ChangeVO changeVO, String linkUrl, Integer contractType, boolean lastSourceId);
}
