package com.ejianc.business.proother.freeze.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;

/**
 * 合同冻结表
 */
@TableName("ejc_proother_contract_freeze")
public class FreezeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    /**
     *  项目Id
     */
    @TableField(value="project_id")
    private Long projectId;
    /**
     * 项目名称（带入）
     */
    @TableField(value="project_name")
    private String projectName;
    /**
     * 项目编码
     */
    @TableField(value="project_code")
    private String projectCode;
    /**
     * 合同名称
     */
    @TableField(value="contract_name")
    private String contractName;
    /**
     * 合同id
     */
    @TableField(value=" ")
    private Long contractId;
    /**
     * 合同编码
     */
    @TableField(value="contract_code")
    private String contractCode;
    /**
     * 合同类型：0-劳务合同 1-专业合同
     */
    @TableField(value="contract_type")
    private Integer contractType;
    /**
     * 合同类型：0-主合同 1-补充协议
     */
    @TableField(value="contract_flag")
    private Integer contractFlag;
    /**
     * 项目部id
     */
    @TableField(value="org_id")
    private Long orgId;
    /**
     * 项目部名称
     */
    @TableField(value="org_name")
    private String orgName;
    /**
     * 项目部编码
     */
    @TableField(value="org_code")
    private String orgCode;
    /**
     * 项目部所属组织id
     */
    @TableField(value="parent_org_id")
    private Long parentOrgId;
    /**
     * 项目部所属组织名称
     */
    @TableField(value="parent_org_name")
    private String parentOrgName;
    /**
     * 供应商id(乙方)
     */
    @TableField(value="parent_org_code")
    private String parentOrgCode;
    /**
     * 供应商id(乙方)
     */
    @TableField(value="supplier_id")
    private Long supplierId;
    /**
     * 供应商名称（乙方）
     */
    @TableField(value="supplier_name")
    private String supplierName;
    /**
     * 申请人 即经办人
     */
    @TableField(value="employee_id")
    private Long employeeId;
    /**
     * 申请人信息 即经办人
     */
    @TableField(value="employee_name")
    private String employeeName;
    /**
     *经办单位id
     */
    @TableField(value="department_id")
    private Long departmentId;
    /**
     * 经办单位
     */
    @TableField(value="department_name")
    private String departmentName;
    /**
     * 经办单位编码
     */
    @TableField(value="department_code")
    private String departmentCode;
    /**
     * 甲方
     */
    @TableField(value="first_party_name")
    private String firstPartyName;
    /**
     * 甲方id
     */
    @TableField(value="first_party_id")
    private Long firstPartyId;
    /**
     *   冻结/取消冻结 原因
     */
    @TableField(value="freeze_cause")
    private String freezeCause;
    /**
     *  合同状态 1、未签订；2、履约中；3、已终止；4、已作废 ；5 已冻结
     */
    @TableField(value="performance_status")
    private Integer performanceStatus;
    /**
     * 单据编号
     */
    @TableField(value="bill_code")
    private String billCode;
    /**
     *  冻结日期（默认当前时间 可修改）
     */
    @TableField(value="freeze_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date freezeDate;
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    @TableField(value="bill_state")
    private Integer billState;
    /**
     *
     */
    @TableField(value = "bill_type_code")
    private String billTypeCode;

    @TableField(value = "commit_date")
    private Date commitDate; // 提交日期
    @TableField(value = "commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value = "commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value = "effective_date")
    private Date effectiveDate; // 生效日期

    public Integer getContractFlag() {
        return contractFlag;
    }

    public void setContractFlag(Integer contractFlag) {
        this.contractFlag = contractFlag;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getBillTypeCode() {
        return billTypeCode;
    }

    public void setBillTypeCode(String billTypeCode) {
        this.billTypeCode = billTypeCode;
    }

    /**
     * 项目Id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目Id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称（带入）
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称（带入）
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同id
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同编码
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编码
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 合同类型：0-劳务合同 1-专业合同
     */
    public Integer getContractType() {
        return contractType;
    }

    /**
     * 合同类型：0-劳务合同 1-专业合同
     */
    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }
    /**
     * 合同类型：0-主合同 1-补充协议
     */
    public Integer getSupplementFlag() {
        return contractFlag;
    }

    /**
     * 合同类型：0-主合同 1-补充协议
     */
    public void setSupplementFlag(Integer supplementFlag) {
        this.contractFlag = supplementFlag;
    }
    /**
     * 项目部id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 项目部id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目部编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 项目部所属组织id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部所属组织id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部所属组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部所属组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部所属组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部所属组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 供应商id(乙方)
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商id(乙方)
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称（乙方）
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称（乙方）
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 申请人 即经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 申请人 即经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 申请人信息 即经办人
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 申请人信息 即经办人
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getDepartmentCode() {
        return departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }

    /**
     * 甲方
     */
    public String getFirstPartyName() {
        return firstPartyName;
    }

    /**
     * 甲方
     */
    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }
    /**
     * 甲方id
     */
    public Long getFirstPartyId() {
        return firstPartyId;
    }

    /**
     * 甲方id
     */
    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }
    /**
     * 冻结/取消冻结 原因
     */
    public String getFreezeCause() {
        return freezeCause;
    }

    /**
     * 冻结/取消冻结 原因
     */
    public void setFreezeCause(String freezeCause) {
        this.freezeCause = freezeCause;
    }
    /**
     * 合同状态 1、未签订；2、履约中；3、已终止；4、已作废 ；5 已冻结
     */
    public Integer getPerformanceStatus() {
        return performanceStatus;
    }

    /**
     * 合同状态 1、未签订；2、履约中；3、已终止；4、已作废 ；5 已冻结
     */
    public void setPerformanceStatus(Integer performanceStatus) {
        this.performanceStatus = performanceStatus;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 冻结日期（默认当前时间 可修改）
     */
    public Date getFreezeDate() {
        return freezeDate;
    }

    /**
     * 冻结日期（默认当前时间 可修改）
     */
    public void setFreezeDate(Date freezeDate) {
        this.freezeDate = freezeDate;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

}
