package com.ejianc.business.proother.settle.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.enums.ContractFlagEnum;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.business.proother.contract.bean.ChangeEntity;
import com.ejianc.business.proother.contract.bean.ContractEntity;
import com.ejianc.business.proother.contract.service.IChangeService;
import com.ejianc.business.proother.contract.service.IContractService;
import com.ejianc.business.proother.contract.vo.ContractVO;
import com.ejianc.business.proother.enums.ProotherBillTypeEnum;
import com.ejianc.business.proother.settle.bean.SettleDetailEntity;
import com.ejianc.business.proother.settle.bean.SettleEntity;
import com.ejianc.business.proother.settle.bean.SettleOtherEntity;
import com.ejianc.business.proother.settle.enums.SettleTypeEnum;
import com.ejianc.business.proother.settle.mapper.SettleMapper;
import com.ejianc.business.proother.settle.service.ISettleService;
import com.ejianc.business.proother.settle.vo.SettleDetailVO;
import com.ejianc.business.proother.settle.vo.SettleOtherVO;
import com.ejianc.business.proother.settle.vo.SettleRecordVO;
import com.ejianc.business.proother.settle.vo.SettleVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.business.temporary.settlement.vo.TemporarySettlementDetailVO;
import com.ejianc.business.temporary.settlement.vo.TemporarySettlementFeeVO;
import com.ejianc.business.temporary.settlement.vo.TemporarySettlementVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 结算实体
 *
 * @author generator
 */
@Service("settleService")
public class SettleServiceImpl extends BaseServiceImpl<SettleMapper, SettleEntity> implements ISettleService {

    @Autowired
    private IChangeService changeService;

    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IContractService contractService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private IExecutionApi executionApi;
    @Value("${common.env.base-host}")
    private String BaseHost;
    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Autowired
    private ISettleService settleService;

    // 其他支出合同结算
    private static final String PRO_OTHER_CHECK_PARAM_NAME = "P-C4JSb946";
    private static final String PRO_OTHER_CHECK_PARAM_NAME_FINAL = "P-A352K50163";
    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "OTH_SET";//此处需要根据实际修改

    @Override
    public CommonResponse<SettleVO> queryUnusedContract(Long contractId, Date settleDate, Integer settleType) {
        SettleVO settleVO = new SettleVO();
        //若当前合同有完工结算单子 或 当前合同有其他未生效的结算单子 则不能添加新的结算单
        LambdaQueryWrapper<SettleEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(SettleEntity::getContractId, contractId);
        lambda.eq(SettleEntity::getSettleType, SettleTypeEnum.完工.getCode());
        lambda.and(c -> c.notIn(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));
        int resultCount = super.count(lambda);
        if (resultCount > 0) {
            return CommonResponse.error("当前合同已进行完工结算，请选择其他合同。");
        }
        QueryWrapper<ContractEntity> contractQuery = new QueryWrapper<>();
        contractQuery.eq("contract_id", contractId);
        ContractEntity contractEntity = contractService.selectById(contractId);
        if (null != contractEntity && null != contractEntity.getChangeId() && settleType == 1) {
            LambdaQueryWrapper<ChangeEntity> changeContractLambda = new LambdaQueryWrapper<>();
            changeContractLambda.eq(ChangeEntity::getId, contractEntity.getChangeId());
            changeContractLambda.and(c -> c.in(ChangeEntity::getBillState, BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
            int changeResultCount = changeService.count(changeContractLambda);
            if (changeResultCount > 0) {
                return CommonResponse.error("当前合同正在进行变更，不可以进行完工结算！");
            }
        }

        LambdaQueryWrapper<SettleEntity> settleLambda = new LambdaQueryWrapper<>();
        settleLambda.eq(SettleEntity::getContractId, contractId);
        settleLambda.and(c -> c.notIn(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));

        List<SettleEntity> resultList = super.list(settleLambda);

        if (resultList.size() > 0 && null != resultList.get(0)) {
            String settleTypeName = (null != resultList.get(0).getSettleType()) ? SettleTypeEnum.getDescriptionByCode(resultList.get(0).getSettleType()).getDescription() : "";
            return CommonResponse.error("当前合同有未审批的" + settleTypeName + "结算单，请选择其他合同。");
        }

//        //设置最小可用结算日期
//        Date resultDate = settleMapper.selectMaxSettleDate(contractId);
//        if (null == resultDate) {
//            resultDate = null != settleDate ? settleDate : new Date();
//            settleVO.setMinSettleDate(null);
//        } else {
//            //如果页面日期大于当前查询出最大日期，则返回页面日期，否则返回最大日期加1
//            resultDate = DateUtils.addDays(resultDate, 1);
//            settleVO.setMinSettleDate(resultDate);
//            if (null != settleDate && settleDate.compareTo(resultDate) > 0) {
//                resultDate = settleDate;
//            }
//        }
//        settleVO.setSettleDate(resultDate);
        //查询当前合同结算金额 已提交的
        QueryWrapper<SettleEntity> listQuery = new QueryWrapper<>();
        listQuery.eq("contract_id", contractId);
        listQuery.eq("settle_type", settleType);
        listQuery.in("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        listQuery.orderByDesc("create_time");
        List<SettleEntity> list = super.list(listQuery);
        BigDecimal settleScale = BigDecimal.ZERO;
        //设置 已结算数据
        if (list.size() > 0) {
            settleVO.setSettleScale(list.get(0).getTotalSettleScale() == null ? BigDecimal.ZERO : list.get(0).getTotalSettleScale());
            settleVO.setLastTaxMny(list.get(0).getTotalTaxMny() == null ? BigDecimal.ZERO : list.get(0).getTotalTaxMny());
            settleVO.setLastMny(list.get(0).getTotalMny() == null ? BigDecimal.ZERO : list.get(0).getTotalTaxMny());
        } else {
            settleVO.setLastTaxMny(BigDecimal.ZERO);
            settleVO.setLastMny(BigDecimal.ZERO);
            settleVO.setSettleScale(BigDecimal.ZERO);
        }

        //设置结算次数
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        List<SettleEntity> settleEntityList = super.queryList(queryParam);
        if (CollectionUtils.isNotEmpty(settleEntityList)){
            settleVO.setSettleTimes(settleEntityList.size());
        }else {
            settleVO.setSettleTimes(0);
        }

        return CommonResponse.success("当前合同可用！", settleVO);
    }

    @Override
    public SettleRecordVO queryDetailRecord(Long contractId, Integer settleType) {
        SettleRecordVO settleRecordVO = new SettleRecordVO();

        ContractEntity contract = contractService.selectById(contractId);
        settleRecordVO.setContractId(contract.getId());
        settleRecordVO.setContractMny(contract.getContractMny());
        settleRecordVO.setContractTaxMny(contract.getContractTaxMny());
        settleRecordVO.setPerformanceStatus(contract.getPerformanceStatus());

        QueryWrapper<SettleEntity> listQuery = new QueryWrapper<>();
        listQuery.eq("contract_id", contractId);
//        listQuery.eq("settle_type", settleType);
        listQuery.in("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        listQuery.orderByDesc("create_time");
        List<SettleEntity> list = super.list(listQuery);
        List<SettleVO> settleVOS = BeanMapper.mapList(list, SettleVO.class);
        settleVOS.forEach(vo -> {
            if (vo.getSettleType() == 1) {
                vo.setSettleTypeStr("完工结算");
            } else if (vo.getSettleType() == 0) {
                vo.setSettleTypeStr("过程结算");
            }
            if (vo.getTotalSettleScale() != null) {
                int i = vo.getTotalSettleScale().toString().indexOf(".");
                String substring = vo.getTotalSettleScale().toString().substring(0, i + 3);
                vo.setTotalSettleScaleStr(substring + '%');

            }
        });
        settleRecordVO.setSettleList(settleVOS);
        //取第一条数据计算累计结算金额 与比例
        SettleEntity lastSettleRecord = CollectionUtils.isNotEmpty(list) ? list.get(0) : null;
        if (lastSettleRecord != null) {
            settleRecordVO.setTotalSettleMny(lastSettleRecord.getTotalTaxMny());
            settleRecordVO.setSettleRatio(lastSettleRecord.getTotalSettleScale());
            //检测是否可以创建新的结算单
        } else {
            settleRecordVO.setTotalSettleMny(BigDecimal.ZERO);
            settleRecordVO.setSettleRatio(BigDecimal.ZERO);
        }
        //检测是否可以创建新的结算单
        //归档参数控制校验
        String filingTypeFlag = contractService.getFilingTypeConfig();
        if ("0".equals(filingTypeFlag)){//不控制
            settleRecordVO.setCanAddNewSettleFlag(StringUtils.isBlank(beforeNewSettleCheck(contractId, settleType)));
        }else {
            if (StringUtils.isBlank(beforeNewSettleCheck(contractId, settleType)) && 1 == contract.getFilingStatus()){//已归档
                settleRecordVO.setCanAddNewSettleFlag(true);
            }else {
                settleRecordVO.setCanAddNewSettleFlag(false);
            }
        }
        return settleRecordVO;
    }


    /**
     * 校验逻辑
     * <p>
     * 节点结算：
     * 2）判断是否有未生效的过程结算、节点结算单子，如果有不可以进行过程结算（一个合同只可以有一个未生效的节点结算单据）
     * 3）判断是否有完工结算单据，不管有生效还是未生效的，只要产生，都不可以进行节点结算
     * <p>
     * 过程结算：
     * 1）判断是否有未生效的过程结算、节点结算单子，如果有不可以进行过程结算（一个合同只可以有一个未生效的过程结算单据）
     * 2）是否有完工结算单据，不管有生效还是未生效的，只要产生，都不可以进行过程结算
     * <p>
     * 完工结算：
     * 1）是否有出库单没有进行领料结算，如果有，不可以进行完工结算
     * 2）是否有未生效的分包计量、领料结算、零工登记、奖罚单的单据，如果有，不可以进行完工结算
     * 3）判断是否有未生效的过程结算、节点结算单子，如果有不可以进行完工结算（一个合同只可以有一个未生效的过程结算单据）
     * 4）是否有完工结算单据，不管有生效还是未生效的，只要产生，都不可以进行完工结算
     *
     * @param contractId
     * @param settleType
     * @return
     */
    @Override
    public String beforeNewSettleCheck(Long contractId, Integer settleType) {
        QueryWrapper<SettleEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractId);
        query.and(q -> q.in("settle_type", SettleTypeEnum.节点.getCode(), SettleTypeEnum.过程.getCode())
                .in("bill_state", BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                        BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                        BillStateEnum.UNAPPROVED.getBillStateCode(),
                        BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode())
        ).or().and(q -> q.eq("settle_type", SettleTypeEnum.完工));

        List<SettleEntity> billList = super.list(query);
        if (CollectionUtils.isNotEmpty(billList)) {
            if (SettleTypeEnum.完工.getCode().equals(settleType)) {
                return "合同已经生成了完工结算，不可以进行 " + SettleTypeEnum.getDescriptionByCode(settleType) + "结算";
            } else {
                return "有未生效的过" + SettleTypeEnum.getDescriptionByCode(SettleTypeEnum.节点.getCode()) + "算单据，不可以进行" + SettleTypeEnum.getDescriptionByCode(settleType) + "结算";
            }
        }

        if (SettleTypeEnum.完工.getCode().equals(settleType)) {
            //TODO 1、是否有出库单没有进行领料结算，如果有，不可以进行完工结算
            //2、是否有未生效的分包计量、领料结算、零工登记、奖罚单的单据，如果有，不可以进行完工结算
            StringBuffer sp = new StringBuffer();
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
            queryParam.getParams().put("bill_state", new Parameter(QueryParam.EQ, BillStateEnum.APPROVING_HAS_STATE));
            QueryWrapper<ContractEntity> contractQuery = new QueryWrapper<>();
            contractQuery.eq("contract_id", contractId);
            ContractEntity contractEntity = contractService.selectById(contractId);
            if (null != contractEntity && null != contractEntity.getChangeId()) {
                LambdaQueryWrapper<ChangeEntity> changeContractLambda = new LambdaQueryWrapper<>();
                changeContractLambda.eq(ChangeEntity::getId, contractEntity.getChangeId());
                changeContractLambda.and(c -> c.in(ChangeEntity::getBillState, BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
                int changeResultCount = changeService.count(changeContractLambda);
                if (changeResultCount > 0) {
                    return "当前合同正在进行变更，不可以进行完工结算！";
                }
            }
        }

        return null;
    }

    //推送至结算池
    @Override
    public boolean pushSettleToPool(SettleVO settleVO) {
        SettlePoolVO poolVO = new SettlePoolVO();
        try {
            logger.info("结算单对象 -> 结算池对象自动转换开始");
            BeanConvertorUtil.convert(settleVO, poolVO);
            logger.info("结算单对象 -> 结算池对象自动转换结束，下面开始手动转换");
            // 个别字段需要手动封装
            convertSettleVOToSettlePoolVO(settleVO, poolVO);
            poolVO.setBillCodeUrl("/ejc-proother-frontend/#/settleList/card?id=" + settleVO.getId());
            CommonResponse<SettlePoolVO> res = settlePoolApi.saveOrUpdateSettle(poolVO);
            if (res.isSuccess()) {
                logger.info("结算单推送至结算池成功！结算单id-{}", settleVO.getId());
                return true;
            } else {
                logger.error("结算单推送合同池失败！结算单id-{}，{}", settleVO.getId(), JSONObject.toJSONString(res));
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", settleVO.getId(), e);
        }
        return false;
    }

    @Override
    public void convertSettleVOToSettlePoolVO(SettleVO settleVO, SettlePoolVO poolVO) {
        if (null == settleVO || null == poolVO) {
            logger.error("将结算单推送至结算池失败！原因：结算单对象为空或结算池对象为空，结算单对象 -> 结算池对象无法转换！");
            return;
        }
        logger.info("结算单对象 -> 结算池对象手动转换开始");
        poolVO.setSourceType(settleVO.getSettleType() == 0 ? SettleSourceTypeEnum.其他支出合同过程结算.getCode() : SettleSourceTypeEnum.其他支出合同最终结算.getCode());
        poolVO.setSourceTypeName(settleVO.getSettleType() == 0 ? SettleSourceTypeEnum.其他支出合同过程结算.getName() : SettleSourceTypeEnum.其他支出合同最终结算.getName());
        poolVO.setSettleProperty(0);// 属性类型：支出
        poolVO.setUltimateFlag(settleVO.getSettleType() == 1 ? 1 : 0);// 是否最终结算：否
        poolVO.setLastTaxMny(settleVO.getLastTaxMny());// 累计结算金额（含税）
        poolVO.setLastMny(settleVO.getLastMny());// 累计结算金额（无税）
        poolVO.setLastTax(getSubStractAbs(settleVO.getLastTaxMny(), settleVO.getLastMny()));// 累计结算税额
        poolVO.setContractType(ContractTypeEnum.其他支出.getTypeCode());
        poolVO.setContractTypeName(ContractTypeEnum.其他支出.getTypeName());
        ContractEntity ce = contractService.selectById(settleVO.getContractId());
        logger.info("结算单推送至结算池过程中，根据合同id查询合同，合同id-{}", settleVO.getContractId());
        if (ce == null) {
            logger.info("结算单推送至结算池过程中，根据合同id查询合同，合同id-{}，未查询到合同信息，故结算单的 主合同/甲方/乙方/签订日期/创建时间和人员/更新时间和人员 等信息无法推送至结算池", settleVO.getContractId());
            return;
        }
        // 主合同
        poolVO.setMaiContractId(ce.getMainContractId());
        poolVO.setMaiContractName(ce.getMainContractName());
        poolVO.setMaiContractCode(ce.getMainContractCode());
        // 甲方
        poolVO.setPartyaId(ce.getFirstPartyId());
        poolVO.setPartyaName(ce.getFirstPartyName());
        // 签订日期
        poolVO.setSignDate(ce.getSignDate());
        // 创建时间和人员 使用 结算单的创建时间和人员
        poolVO.setCreateTime(settleVO.getCreateTime());
        poolVO.setCreateUserCode(settleVO.getCreateUserCode());
        // 更新时间和人员 使用 结算单的更新时间和人员
        poolVO.setUpdateTime(settleVO.getUpdateTime());
        poolVO.setUpdateUserCode(settleVO.getUpdateUserCode());

        poolVO.setHandleType(0); //业务系统推送结算池
        poolVO.setContractFlag(ContractFlagEnum.有合同结算.getContractFlagCode());
        poolVO.setContractTypeName(ContractFlagEnum.有合同结算.getContractFlagCodeName());

        logger.info("结算单对象 -> 结算池对象手动转换完成，下面开始推送至结算池");
    }

    // 从结算池中删除数据
    @Override
    public String delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        spv.setSourceId(id);

        CommonResponse<SettlePoolVO> res = settlePoolApi.deleteSettle(spv);
        if (res.isSuccess()) {
            logger.info("将结算单从结算池中删除成功！结算单id-{}", id);
            return null;
        }

        logger.error("将结算单从结算池中删除失败！结算单id-{}，{}", id, res.getMsg());
        return StringUtils.isNotBlank(res.getMsg()) ? res.getMsg() : "网络问题，删除失败！";
    }

    /**
     * 计算差值
     *
     * @param a 变量a
     * @param b 变量b
     * @return 差值的绝对值，当其中一个变量为null时 或 计算出来的差值为null时 返回null
     */
    private BigDecimal getSubStractAbs(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal subtract = a.subtract(b);
        if (subtract == null) {
            return null;
        }
        return subtract.abs();
    }

    @Override
    public ExecutionVO targetCost(SettleVO settleVO, String linkUrl) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(settleVO.getId());
        totalVO.setTenantId(settleVO.getTenantId());
        totalVO.setBillCode(settleVO.getBillCode());
        totalVO.setOrgId(settleVO.getOrgId());
        totalVO.setProjectId(settleVO.getProjectId());
        totalVO.setBillType("BT220317000000001");
        totalVO.setBussinessType(BussinessTypeEnum.其他支出合同.getCode());
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());

        // 根据结算单的合同id查询合同详情
        ContractEntity contract = contractService.selectById(settleVO.getContractId());

        // 所有已生效结算单（包含过程结算和最终结算）
        // 生效的单据状态
        ArrayList<Integer> list = new ArrayList<>();
        list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        list.add(BillStateEnum.PASSED_STATE.getBillStateCode());

        // 查询生效的结算单累计值
        LambdaQueryWrapper<SettleEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SettleEntity::getDr, 0);
        wrapper.in(SettleEntity::getBillState, list);
        wrapper.eq(SettleEntity::getContractId, settleVO.getContractId());
        List<SettleEntity> settleList = settleService.list(wrapper);

        // 【本期结算金额】累计值
        BigDecimal totalMny = settleList.stream().map(SettleEntity::getMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalTaxMny = settleList.stream().map(SettleEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        // 推总金额执行表 【结算金额累计】 - 【合同金额】
        totalVO.setMoney(ComputeUtil.safeSub(totalMny, contract.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub(totalTaxMny, contract.getContractTaxMny()));

        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }


    @Override
    public ParamsCheckVO mnyCtrl(SettleVO settleVO, Boolean flag) {

        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO resp = new ParamsCheckVO();

        CommonResponse<List<BillParamVO>> paramListResp = null;
        if(settleVO.getSettleType() == 0) {
            paramListResp = paramConfigApi.getBillParamByCodeAndOrgId(PRO_OTHER_CHECK_PARAM_NAME, settleVO.getOrgId());
        } else {
            paramListResp = paramConfigApi.getBillParamByCodeAndOrgId(PRO_OTHER_CHECK_PARAM_NAME_FINAL, settleVO.getOrgId());
        }

        if (!paramListResp.isSuccess()) {
            logger.error("获取其他支出合同参数-[{}]控制规则失败， {}", "P-C4JSb946", JSONObject.toJSONString(paramListResp));
            return resp;
        }

        // 最新版本合同金额，最新的合同金额
        ContractEntity contract = contractService.selectById(settleVO.getContractId());
        if (null == contract) {
            logger.info("获取合同信息失败！");
            throw new BusinessException("获取合同信息失败！");
        }

        // 控制规则值
        List<ParamsCheckVO> checkVOList = new ArrayList<>();
        BigDecimal roleValue = null;
        ParamsCheckVO paramsCheckVO = null;
        List<ParamsCheckDsVO> checkDsVOS = null;
        for(BillParamVO billParamVO : paramListResp.getData()) {
            checkDsVOS = new ArrayList<>();
            paramsCheckVO = new ParamsCheckVO();
            roleValue = billParamVO.getRoleValue();
            // 默认控制方式为提醒
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }

            if (!"none".equals(paramsCheckVO.getWarnType())) {
                // 金额计算
                // 本次月度结算金额
                BigDecimal taxMny = settleVO.getTaxMny();
                // 含本次累计月度结算金额
                BigDecimal totalTaxMny = this.getLastTaxMny(settleVO.getContractId(), taxMny, flag);
                // 合同金额
                BigDecimal contractTaxMny = this.getContractTaxMny(contract.getContractTaxMny(), roleValue);

                // 控制金额
                if (totalTaxMny.compareTo(contractTaxMny) > 0) {
                    // 超结金额
                    BigDecimal overTaxMny = this.getOverTaxMny(totalTaxMny, contractTaxMny);

                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("合同超结");
                    paramsCheckDsVO.setWarnName("累计结算金额大于合同金额");

                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("本次结算金额：").append(taxMny.setScale(2, RoundingMode.DOWN)).append("，含本次累计结算金额：").append(totalTaxMny.setScale(2, RoundingMode.DOWN))
                            .append("，合同金额*").append(roleValue).append("%：").append(contractTaxMny.setScale(2, RoundingMode.DOWN)).append("。超结金额：").append(overTaxMny.setScale(2, RoundingMode.DOWN));

                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    checkDsVOS.add(paramsCheckDsVO);
                    paramsCheckVO.setDataSource(checkDsVOS);
                } else {
                    paramsCheckVO.setWarnType(paramsArray[0]);
                }

                checkVOList.add(paramsCheckVO);
            }
        }

        /*--start---目标成本控制*/
        if (null == settleVO.getId()) {
            settleVO.setId(IdWorker.getId());
        }
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = BaseHost;
        }
        String linkUrl = frontendBaseHost+"ejc-proother-frontend/#/settle/card?id="+settleVO.getId();
        ExecutionVO executionVO = this.settleCost(settleVO,linkUrl);
        logger.error("目标成本控制推送传参：" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("目标成本控制失败," + response.getMsg());
        }
        ParamsCheckVO tarRes = response.getData();
        if(null!=tarRes){
            checkVOList.add(tarRes);
        }
        /*--end---目标成本控制*/

        /*--start---成本科目控制*/
        CostCtrlVO costCtrlVO = this.sjCost(settleVO);
        if(null!=costCtrlVO){
            CommonResponse<ParamsCheckVO> costResponse = executionApi.ctrlCost(costCtrlVO);
            if (!costResponse.isSuccess()) {
                throw new BusinessException("成本科目控制失败," + costResponse.getMsg());
            }
            ParamsCheckVO costRes = costResponse.getData();
            if(null!=costRes){
                checkVOList.add(costRes);
            }
        }
        /*--end---成本科目控制*/

        //设置最高预警登记
        Map<String, List<ParamsCheckVO>> checkListMap = checkVOList.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));

        List<ParamsCheckVO> result = new ArrayList<>();
        if(null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            resp.setWarnType("alert");
        } else if(null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            resp.setWarnType("warn");
        } else {
            resp.setWarnType("none");
        }

        if(CollectionUtils.isNotEmpty(result)) {
            for(ParamsCheckVO p : result) {
                resp.getDataSource().addAll(p.getDataSource());
            }
        }

        return resp;
    }

    public CostCtrlVO sjCost(SettleVO vo){
        List<SettleDetailVO> detailVOList = vo.getDetailList();
        List<SettleOtherVO> otherList = vo.getOtherList();
        Map<Long,CostCtrlDetailVO> map = new HashMap<>();
        if (CollectionUtils.isNotEmpty(detailVOList)) {
            for (SettleDetailVO detailVO : detailVOList) {
                if (null != detailVO.getDetailSubjectId() && !"del".equals(detailVO.getRowState())) {
                    BigDecimal mny = detailVO.getSettleMny() == null ? BigDecimal.ZERO : detailVO.getSettleMny();
                    BigDecimal taxMny = detailVO.getSettleTaxMny() == null ? BigDecimal.ZERO : detailVO.getSettleTaxMny();
                    if (map.containsKey(detailVO.getDetailSubjectId())) {
                        CostCtrlDetailVO costCtrlDetailVO = map.get(detailVO.getDetailSubjectId());
                        costCtrlDetailVO.setMny(ComputeUtil.safeAdd(costCtrlDetailVO.getMny(), mny));
                        costCtrlDetailVO.setTaxMny(ComputeUtil.safeAdd(costCtrlDetailVO.getTaxMny(), taxMny));
                    } else {
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(detailVO.getDetailSubjectId());
                        costCtrlDetailVO.setMny(mny);
                        costCtrlDetailVO.setTaxMny(taxMny);
                        map.put(detailVO.getDetailSubjectId(), costCtrlDetailVO);
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(otherList)) {
            for (SettleOtherVO otherVO : otherList) {
                if (null != otherVO.getOtherSubjectId() && !"del".equals(otherVO.getRowState())) {
                    BigDecimal mny = otherVO.getMny() == null ? BigDecimal.ZERO : otherVO.getMny();
                    BigDecimal taxMny = otherVO.getTaxMny() == null ? BigDecimal.ZERO : otherVO.getTaxMny();
                    if (map.containsKey(otherVO.getOtherSubjectId())) {
                        CostCtrlDetailVO costCtrlDetailVO = map.get(otherVO.getOtherSubjectId());
                        costCtrlDetailVO.setMny(ComputeUtil.safeAdd(costCtrlDetailVO.getMny(), mny));
                        costCtrlDetailVO.setTaxMny(ComputeUtil.safeAdd(costCtrlDetailVO.getTaxMny(), taxMny));
                    } else {
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(otherVO.getOtherSubjectId());
                        costCtrlDetailVO.setMny(mny);
                        costCtrlDetailVO.setTaxMny(taxMny);
                        map.put(otherVO.getOtherSubjectId(), costCtrlDetailVO);
                    }
                }
            }
        }
        if( null != map && !map.isEmpty()){
            CostCtrlVO ctrlVO = new CostCtrlVO();
            if (vo.getId() != null) {
                ctrlVO.setSourceId(vo.getId());
            }
            ctrlVO.setOrgId(vo.getOrgId());
            ctrlVO.setProjectId(vo.getProjectId());
            ctrlVO.setDetailList(new ArrayList<>(map.values()));
            return ctrlVO;
        }else{
            return null;
        }
    }


    /**
     * 获取含本期累计结算金额
     *
     * @param contractId 合同id
     * @param taxMny     本期结算金额
     * @return 含本期累计结算金额
     */
    @Override
    public BigDecimal getLastTaxMny(Long contractId, BigDecimal taxMny, Boolean flag) {
        Assert.notNull(contractId, "合同id不能为空");
        Assert.notNull(taxMny, "本期结算金额不能为空");

        ArrayList<Integer> billState = new ArrayList<>();
        billState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billState.add(BillStateEnum.PASSED_STATE.getBillStateCode());

        QueryWrapper<SettleEntity> qw = new QueryWrapper<>();
        qw.eq("contract_id", contractId);
        qw.in("bill_state", billState);
        List<SettleEntity> settles = super.list(qw);

        if (CollectionUtils.isEmpty(settles)) {
            return taxMny;
        }

        // 查看预警标识
        if (Boolean.TRUE.equals(flag)) {
            taxMny = BigDecimal.ZERO;
        }
        return settles.stream().map(SettleEntity::getTaxMny).reduce(taxMny, BigDecimal::add);
    }

    /**
     * 获取超结金额
     *
     * @param totalTaxMny    含本期累计结算金额
     * @param contractTaxMny 合同金额
     * @return 超结金额
     */
    @Override
    public BigDecimal getOverTaxMny(BigDecimal totalTaxMny, BigDecimal contractTaxMny) {
        // 判空断言
        Assert.notNull(totalTaxMny, "含本期累计结算金额不能为空");
        Assert.notNull(contractTaxMny, "合同金额不能为空");

        return totalTaxMny.subtract(contractTaxMny);
    }

    /**
     * 计算合同金额
     *
     * @param contractTaxMny 合同金额
     * @param roleValue      控制规则值
     * @return 合同金额
     */
    @Override
    public BigDecimal getContractTaxMny(BigDecimal contractTaxMny, BigDecimal roleValue) {
        // 判空断言
        Assert.notNull(contractTaxMny, "合同金额不能为空");
        Assert.notNull(roleValue, "控制规则值不能为空");

        return contractTaxMny.multiply(roleValue.divide(BigDecimal.valueOf(100), 2, RoundingMode.HALF_UP));
    }

    @Override
    public void costPush(SettleEntity settleEntity) {
        logger.info("开始costPush");
        String newRelationFlag = associatedFlag(settleEntity);
        logger.info("开始costPush newRelationFlag:"+newRelationFlag);
        //更新是否关联
        LambdaUpdateWrapper<SettleEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(SettleEntity::getId, settleEntity.getId());
        updateWrapper.set(SettleEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);
        //判断之前的单据是否关联
        String oldRelationFlag = settleEntity.getRelationFlag();
        //先删后增
        saveCost(settleEntity,1);//生效状态 0-未生效，1-生效
    }
    @Override
    public void costDeletePush(SettleEntity settleEntity) {
        logger.info("弃审推送成本---");
        logger.info("删除成本中心之前的数据-结算单Id---{}",settleEntity.getId());
        CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(settleEntity.getId());
        logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
        if(!stringCommonResponse.isSuccess()){
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        //更新是否关联
        LambdaUpdateWrapper<SettleEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(SettleEntity::getId, settleEntity.getId());
        updateWrapper.set(SettleEntity::getRelationFlag, "0");//(1:是，0：否)
        super.update(updateWrapper);
    }

    @Override
    public CommonResponse<SettleVO> pushCost(SettleVO settleVO) {
        SettleEntity settleEntity = baseMapper.selectById(settleVO.getId());
        if (CollectionUtils.isNotEmpty(settleVO.getDetailList())) {
            List<SettleDetailEntity> storeSubEntityList = BeanMapper.mapList(settleVO.getDetailList(), SettleDetailEntity.class);
            settleEntity.setDetailList(storeSubEntityList);
        }

        if (CollectionUtils.isNotEmpty(settleVO.getOtherList())) {
            List<SettleOtherEntity> otherEntities = BeanMapper.mapList(settleVO.getOtherList(), SettleOtherEntity.class);
            settleEntity.setOtherList(otherEntities);
        }
        super.saveOrUpdate(settleEntity, false);
        //推送数据
        costPush(settleEntity);
        return CommonResponse.success(BeanMapper.map(settleEntity, SettleVO.class));
    }

    @Override
    public SettleVO saveOrUpdateSettle(SettleVO saveOrUpdateVO) {
        SettleEntity entity = BeanMapper.map(saveOrUpdateVO, SettleEntity.class);
        SettleEntity oldSettleEntity = null;

        if (entity.getId() == null) {
            //如果编码为空，就新增编码
            if(StringUtils.isBlank(entity.getBillCode())){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }else {
                //验证编码是否唯一
                if (checkSameBillCode(BeanMapper.map(entity, ContractVO.class))){
                    throw new BusinessException("编码重复，不允许保存!");
                }
            }
            entity.setFilingStatus(FilingStatusEnum.未归档.getTypeCode());
            entity.setRelationFlag("0");
            entity.setProportionFlag("0");
            //设置结算次数
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
            queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, saveOrUpdateVO.getContractId()));
            List<SettleEntity> settleEntityList = super.queryList(queryParam);
            if (CollectionUtils.isNotEmpty(settleEntityList)){
                entity.setSettleTimes(settleEntityList.size());
            }else {
                entity.setSettleTimes(0);
            }

        }else {
            oldSettleEntity = super.selectById(entity.getId());
            if (StringUtils.isBlank(entity.getBillCode())){
                entity.setBillCode(oldSettleEntity.getBillCode());
            }else {
                //验证编码是否唯一
                if (checkSameBillCode(BeanMapper.map(entity, ContractVO.class))){
                    throw new BusinessException("编码重复，不允许保存!");
                }
            }
        }

        super.saveOrUpdate(entity, false);
        // 推送 实际成本
        saveCost(entity,0);
        if((saveOrUpdateVO.getId() == null && saveOrUpdateVO.getSettleType() == 1) || (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getSettleType().equals(oldSettleEntity.getSettleType()))) {
            //如果最终结算，则更新合同、合同池
            contractService.changeContractPerformanceState(saveOrUpdateVO.getSettleType().equals(1) ? ContractPerformanceStateEnum.已终止.getStateCode() : ContractPerformanceStateEnum.履约中.getStateCode(), entity.getContractId());
        }
        this.pushSettleToCost(BeanMapper.map(entity, SettleVO.class));
        return BeanMapper.map(entity, SettleVO.class);
    }

    @Override
    public String delBatch(List<SettleVO> vos) {
        QueryWrapper<SettleEntity> query = new QueryWrapper();
        query.in("id", vos.stream().map(SettleVO::getId).collect(Collectors.toList()));
        List<SettleEntity> settleList = super.list(query);
        StringBuilder sp = new StringBuilder();
        List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
        if (ListUtil.isNotEmpty(settleList)) {
            for (SettleEntity vo : settleList) {
                ExecutionVO executionVO = settleService.settleCost(BeanMapper.map(vo, SettleVO.class),"");
                totalExecutionVOList.add(executionVO.getTotalVO());
                logger.info("目标成本删除数据" + JSON.toJSONString(executionVO));
                if(vo.getSettleType().equals(1)) {
                    boolean result = contractService.changeContractPerformanceState(vo.getSettleType().equals(1) ? ContractPerformanceStateEnum.已终止.getStateCode() : ContractPerformanceStateEnum.履约中.getStateCode(), vo.getContractId());
                    if(result) {
                        super.removeById(vo.getId());
                    } else {
                        sp.append(vo.getContractName()).append("、[").append(vo.getContractCode()).append("]");
                    }
                } else {
                    super.removeById(vo.getId());
                }
                //删除实际成本
                CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(vo.getId());
                logger.info("删除实际成本结果"+ JSONObject.toJSONString(stringCommonResponse));
                if(!stringCommonResponse.isSuccess()){
                    throw new BusinessException(stringCommonResponse.getMsg());
                }
            }
            if (ListUtil.isNotEmpty(totalExecutionVOList)) {
                CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
                logger.info("目标成本删除数据结果---:{}", JSONObject.toJSONString(response));
                if (!response.isSuccess()){
                    throw new BusinessException("目标成本删除失败,"+response.getMsg());
                }
            }
        }
        if(sp.toString().length() > 0) {
            return sp.substring(1);
        }
        return null;
    }

    @Override
    public CommonResponse<String> pushSettleToCost(SettleVO settleVO) {
        SettleEntity settleEntity = settleService.selectById(settleVO.getId());
        SettleVO vo = BeanMapper.map(settleEntity, SettleVO.class);
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = BaseHost;
        }
        String linkUrl = frontendBaseHost+"ejc-proother-frontend/#/settle/card?id="+settleEntity.getId();
        ExecutionVO executionVO = settleService.settleCost(vo,linkUrl);
        logger.info("手动推送 其他支出合同结算目标成本推送数据" + JSON.toJSONString(executionVO));
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        logger.info("手动推送 其他支出合同结算目标成本推送结果---:{}", JSONObject.toJSONString(response));
        return response;
    }

    @Override
    public ExecutionVO settleCost(SettleVO settleVO, String linkUrl) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(settleVO.getId());
        totalVO.setTenantId(settleVO.getTenantId());
        totalVO.setBillCode(settleVO.getBillCode());
        totalVO.setOrgId(settleVO.getOrgId());
        totalVO.setProjectId(settleVO.getProjectId());
        totalVO.setContractId(settleVO.getContractId());
        totalVO.setBillDate(DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO_ON_DATE,settleVO.getSettleDate()));
        totalVO.setMoney(settleVO.getMny());
        totalVO.setTaxMoney(settleVO.getTaxMny());
        totalVO.setBillType(ProotherBillTypeEnum.其他支出合同结算.getBillTypeCode());
        totalVO.setBussinessType(BussinessTypeEnum.其他支出合同结算.getCode());
        totalVO.setBillCategory(BillCategoryEnum.结算.getCode());

        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    /**
     * 检查单据是否存在相同编码
     * @param contractVO
     * @return
     */
    private Boolean checkSameBillCode(ContractVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<SettleEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(SettleEntity::getBillCode, contractVO.getBillCode());
        lambda.eq(SettleEntity::getTenantId, tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0) {
            lambda.ne(SettleEntity::getId, contractVO.getId());
        }
        return super.list(lambda).size() > 0;
    }

    /**
     * 是否可以关联实际成本
     *
     * @param settleEntity 结算实体
     * @return
     */
    private String associatedFlag(SettleEntity settleEntity) {
        List<SettleDetailEntity> detailList = settleEntity.getDetailList();
        List<SettleOtherEntity> otherList = settleEntity.getOtherList();
        String newRelationFlag = "1";
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (SettleDetailEntity detailEntity : detailList) {
                if (null == detailEntity.getDetailWbsId() || null == detailEntity.getDetailSubjectId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (CollectionUtils.isNotEmpty(otherList)) {
            for (SettleOtherEntity otherEntity : otherList) {
                if (null == otherEntity.getOtherWbsId() || null == otherEntity.getOtherSubjectId()) {
                    newRelationFlag = "0";
                    break;
                }

            }
        }
        if (CollectionUtils.isEmpty(otherList) &&
                com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(detailList)
        ) {
            newRelationFlag = "0";
        }
        return newRelationFlag;
    }


    private void saveCost(SettleEntity settleEntity,Integer effectiveStatus) {
        logger.info("推送结算实体："+JSONObject.toJSONString(settleEntity));
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<SettleDetailEntity> detailList = settleEntity.getDetailList();
        List<SettleOtherEntity> otherList = settleEntity.getOtherList();
        if (CollectionUtils.isNotEmpty(detailList)){
            for (SettleDetailEntity detailEntity:detailList){
                if (detailEntity.getSettleNum()!=null){
                    CostDetailVO costDetailVO = new CostDetailVO();
                    costDetailVO.setSubjectId(detailEntity.getDetailSubjectId());
                    costDetailVO.setSubjectCode(detailEntity.getDetailSubjectCode());
                    costDetailVO.setSubjectName(detailEntity.getDetailSubjectName());
                    costDetailVO.setWbsId(detailEntity.getDetailWbsId());
                    costDetailVO.setWbsCode(detailEntity.getDetailWbsCode());
                    costDetailVO.setWbsName(detailEntity.getDetailWbsName());
                    costDetailVO.setSourceId(detailEntity.getSettleId());
                    costDetailVO.setSourceDetailId(detailEntity.getId());


                    costDetailVO.setHappenTaxMny(detailEntity.getSettleTaxMny());
                    costDetailVO.setHappenMny(detailEntity.getSettleMny());
                    costDetailVO.setSourceTabType("SET_OTHER_DETAIL");
                    if (settleEntity.getSettleType()==1){
                        costDetailVO.setSourceType("FIN_OTHER_DE");
                    }
                    if (settleEntity.getSettleType()==0){
                        costDetailVO.setSourceType("PRO_OTHER_DE");
                    }
                    costDetailVO.setHappenDate(detailEntity.getSettleDate());
                    costDetailVO.setCreateUserName(detailEntity.getCreateUserCode());
                    costDetailVO.setProjectId(settleEntity.getProjectId());
                    costDetailVO.setSourceBillUrl("/ejc-proother-frontend/#/settleList/costCard?id="+settleEntity.getId());//需要跳转路径与参数组成的全路径
                    costDetailVO.setSourceBillCode(settleEntity.getBillCode()); //填充自己的单据编号
                    costDetailVO.setSourceBillName( SourceTypeEnum.其他支出合同结算.getTypeName());//填充枚举里  自己的单据名称
                    costDetailVO.setEffectiveStatus(effectiveStatus);//生效状态 0-未生效，1-生效
                    costDetailVOList.add(costDetailVO);
                }

            }
        }
        if (CollectionUtils.isNotEmpty(otherList)){
            for (SettleOtherEntity otherEntity:otherList){
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(otherEntity.getOtherSubjectId());
                costDetailVO.setSubjectCode(otherEntity.getOtherSubjectCode());
                costDetailVO.setSubjectName(otherEntity.getOtherSubjectName());
                costDetailVO.setWbsId(otherEntity.getOtherWbsId());
                costDetailVO.setWbsCode(otherEntity.getOtherWbsCode());
                costDetailVO.setWbsName(otherEntity.getOtherWbsName());
                costDetailVO.setSourceId(otherEntity.getSettleId());
                costDetailVO.setSourceDetailId(otherEntity.getId());
                costDetailVO.setHappenTaxMny(otherEntity.getTaxMny());
                costDetailVO.setHappenMny(otherEntity.getMny());
                costDetailVO.setHappenDate(otherEntity.getCreateTime());
                costDetailVO.setCreateUserName(otherEntity.getCreateUserCode());
                if (settleEntity.getSettleType()==1){
                    costDetailVO.setSourceType("FIN_OTHER_OT");
                }
                if (settleEntity.getSettleType()==0){
                    costDetailVO.setSourceType("PRO_OTHER_OT");
                }
                costDetailVO.setSourceBillUrl("/ejc-proother-frontend/#/settleList/costCard?id="+settleEntity.getId());//需要跳转路径与参数组成的全路径
                costDetailVO.setSourceBillCode(settleEntity.getBillCode()); //填充自己的单据编号
                costDetailVO.setSourceBillName( SourceTypeEnum.其他支出合同结算.getTypeName());//填充枚举里  自己的单据名称
                costDetailVO.setSourceTabType("SET_OTHER_OTHER");
                costDetailVO.setProjectId(settleEntity.getProjectId());
                costDetailVO.setEffectiveStatus(effectiveStatus);//生效状态 0-未生效，1-生效
                costDetailVOList.add(costDetailVO);
            }
        }
        //成本中心
        if (CollectionUtils.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------：{}",JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------: {}",JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()) {
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
}
