/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proother.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.profinance.vo.ContractPaymentResultVO;
import com.ejianc.business.proother.contract.bean.ChangeEntity;
import com.ejianc.business.proother.contract.bean.ContractDetailEntity;
import com.ejianc.business.proother.contract.bean.ContractEntity;
import com.ejianc.business.proother.contract.service.IChangeService;
import com.ejianc.business.proother.contract.service.IContractAsyncService;
import com.ejianc.business.proother.contract.service.IContractDetailService;
import com.ejianc.business.proother.contract.service.IContractOtherCostService;
import com.ejianc.business.proother.contract.service.IContractService;
import com.ejianc.business.proother.contract.vo.ContractDetailVO;
import com.ejianc.business.proother.contract.vo.ContractOtherCostVO;
import com.ejianc.business.proother.contract.vo.ContractPaymentVO;
import com.ejianc.business.proother.contract.vo.ContractVO;
import com.ejianc.business.proother.enums.BillPushStatusEnum;
import com.ejianc.business.proother.enums.ProotherBillTypeEnum;
import com.ejianc.business.proother.enums.SignatureStatusEnum;
import com.ejianc.business.proother.relieve.service.IContractRelieveService;
import com.ejianc.business.proother.util.ParamCtrlUtil;
import com.ejianc.business.proother.utils.TreeNodeBUtil;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springside.modules.nosql.redis.JedisTemplate;

@Controller
@RequestMapping(value={"contract"})
public class ContractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IContractService service;
    @Autowired
    private IContractDetailService detailService;
    @Autowired
    private IContractOtherCostService otherCostService;
    @Autowired
    private IContractPoolApi contractPoolApi;
    private final String OTHER_CONTRACT_Bill_CODE = "BT220308000000001";
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;
    @Autowired
    private IContractRelieveService contractRelieveService;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private CacheManager cacheManager;
    private final String PUSH_POOL_PREFIX = "pushContract::";
    @Autowired
    private ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IContractAsyncService contractAsyncService;
    @Autowired
    private IChangeService changeService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdate(@RequestBody ContractVO contractVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        ContractVO vo = this.service.insertOrUpdate(contractVO, authority, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"/getContractFileMgrInfo"})
    @ResponseBody
    public CommonResponse<JSONObject> getContractFileMgrInfo(@RequestParam(value="contractId") Long contractId) {
        JSONObject resp = new JSONObject();
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById(contractId));
        CommonResponse categoryResp = this.templateCategoryApi.queryTmplCategoryById(contractEntity.getContractCategoryId());
        if (!categoryResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u5408\u540c\u7c7b\u522bI\u7684-{}\u67e5\u8be2\u5bf9\u5e94\u5408\u540c\u7c7b\u522b\u4fe1\u606f\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)contractEntity.getContractCategoryId(), (Object)categoryResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5408\u540c\u7c7b\u522b\u4fe1\u606f\u5931\u8d25");
        }
        TemplateCategoryVO category = (TemplateCategoryVO)categoryResp.getData();
        resp.put("contactId", (Object)contractEntity.getId());
        resp.put("contractBillTypeCode", (Object)"BT220308000000001");
        resp.put("contractCategoryId", (Object)category.getId());
        resp.put("boBillType", (Object)category.getBillTypeCode());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractVO> queryDetail(Long id) {
        ContractVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractVO> vos) {
        return this.service.deleteByIds(vos);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        HashMap beans = new HashMap();
        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = this.pageList(param);
        List contractVOList = new ArrayList();
        if (null != commonResponse.getData() && null != (contractVOList = (List)((JSONObject)commonResponse.getData()).get((Object)"records")) && contractVOList.size() > 0) {
            contractVOList.forEach(c -> {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)c.getPerformanceStatus())) {
                    c.setPerformanceStatus(ContractPerformanceStateEnum.\u672a\u7b7e\u8ba2.getStateName());
                } else {
                    c.setPerformanceStatus(ContractPerformanceStateEnum.getByStateCode((String)c.getPerformanceStatus()).getStateName());
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)c.getSignatureStatus())) {
                    c.setSignatureStatus(SignatureStatusEnum.\u5f85\u7b7e\u7ae0.getDescription());
                } else {
                    c.setSignatureStatus(SignatureStatusEnum.getEnumByCode(c.getSignatureStatus()).getDescription());
                }
                c.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)c.getBillState()).getDescription());
            });
        }
        beans.put("records", contractVOList);
        ExcelExport.getInstance().export("contract-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        LinkedHashMap orderMap = new LinkedHashMap();
        if (param.getOrderMap().containsKey("createTime") && null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.put("create_time", "desc");
        String filingTypeConfig = this.service.getFilingTypeConfig();
        param.setOrderMap(orderMap);
        IPage pageData = this.service.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        page.put("filingTypeConfig", (Object)filingTypeConfig);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @ResponseBody
    @RequestMapping(value={"/prosubContractRef"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> prosubContractRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        String filingTypeConfig;
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        if (null == condition || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("orgId") && null == conditionMap.get("projectId")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u9879\u76eeid \u6216 \u7ec4\u7ec7id\u4e3a\u7a7a\uff01");
        }
        if (null != conditionMap.get("orgId") && null == conditionMap.get("orgType")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u7a7a\uff01");
        }
        if (null != conditionMap.get("categoryId")) {
            CommonResponse categoryVOResp = this.templateCategoryApi.querySelfAndChildById(Long.valueOf(conditionMap.get("categoryId").toString()));
            if (!categoryVOResp.isSuccess()) {
                return CommonResponse.error((String)"\u83b7\u53d6\u5408\u540c\u7c7b\u522b\u4fe1\u606f\u5931\u8d25\uff01");
            }
            List categoryIds = ((List)categoryVOResp.getData()).stream().map(item -> item.getId()).collect(Collectors.toList());
            switch (categoryIds.size()) {
                case 0: {
                    JSONObject page = new JSONObject();
                    page.put("records", new ArrayList());
                    page.put("total", (Object)0);
                    page.put("current", (Object)queryParam.getPageIndex());
                    page.put("size", (Object)queryParam.getPageSize());
                    page.put("pages", (Object)0);
                    return CommonResponse.success((String)"\u67e5\u8be2\u5206\u5305\u5408\u540c\u6570\u636e\u6210\u529f\uff01", (Object)page);
                }
                case 1: {
                    queryParam.getParams().put("contractCategoryId", new Parameter("eq", categoryIds.get(0)));
                    break;
                }
                default: {
                    queryParam.getParams().put("contractCategoryId", new Parameter("in", categoryIds));
                }
            }
        }
        if (!"0".equals(filingTypeConfig = this.service.getFilingTypeConfig())) {
            queryParam.getParams().put("filingStatus", new Parameter("eq", (Object)1));
        }
        if (null != conditionMap.get("projectId")) {
            Long projectId = Long.parseLong(conditionMap.get("projectId").toString());
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        } else {
            Long orgId = Long.parseLong(conditionMap.get("orgId").toString());
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(conditionMap.get("orgType").toString()))) {
                queryParam.getParams().put("orgId", new Parameter("eq", (Object)orgId));
            } else {
                CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if (!orgResp.isSuccess()) {
                    this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                    return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                queryParam.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        queryParam.getParams().put("performance_status", new Parameter("eq", (Object)ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode()));
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        LinkedHashMap orderMap = new LinkedHashMap();
        if (null != queryParam.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", queryParam.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.put("create_time", "desc");
        queryParam.setOrderMap(orderMap);
        this.logger.info("\u5206\u5305\u5408\u540c\u67e5\u8be2\u53c2\u7167-\u67e5\u8be2\u6761\u4ef6---------->" + JSONObject.toJSONString((Object)queryParam.getParams()));
        IPage pageData = this.service.queryPage(queryParam, false);
        this.logger.info("\u5206\u5305\u5408\u540c\u67e5\u8be2\u53c2\u7167-\u67e5\u8be2\u7ed3\u679c\u6761\u6570---------->" + pageData.getRecords().size());
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5206\u5305\u5408\u540c\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @ResponseBody
    @RequestMapping(value={"/proOtherContractDetailRef"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> proOtherContractDetailRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        if (null == condition || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("contractId")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u5408\u540cid\u4e3a\u7a7a\uff01");
        }
        queryParam.getParams().put("contract_id", new Parameter("eq", conditionMap.get("contractId")));
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("detail_price", new Parameter("ne", null));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("create_time", "desc");
        queryParam.setOrderMap(orderMap);
        this.logger.info("\u5206\u5305\u5408\u540c\u660e\u7ec6\u67e5\u8be2\u53c2\u7167-\u67e5\u8be2\u6761\u4ef6---------->" + JSONObject.toJSONString((Object)queryParam.getParams()));
        IPage pageData = this.detailService.queryPage(queryParam, false);
        this.logger.info("\u5206\u5305\u5408\u540c\u660e\u7ec6\u67e5\u8be2\u53c2\u7167-\u67e5\u8be2\u7ed3\u679c\u6761\u6570---------->" + pageData.getRecords().size());
        JSONObject page = new JSONObject();
        List records = BeanMapper.mapList((Iterable)pageData.getRecords(), JSONObject.class);
        ArrayList detailIds = new ArrayList();
        HashMap detailHasParentMap = new HashMap();
        records.stream().forEach(item -> {
            detailIds.add(item.getLong("id"));
            if (null != item.get((Object)"parentId")) {
                if (null == detailHasParentMap.get(item.getLong("parentId"))) {
                    detailHasParentMap.put(item.getLong("parentId"), new ArrayList());
                }
                ((List)detailHasParentMap.get(item.getLong("parentId"))).add(item);
            }
        });
        if (!detailHasParentMap.isEmpty()) {
            List parents = (List)this.detailService.listByIds(new ArrayList(detailHasParentMap.keySet()));
            for (ContractDetailEntity parent : parents) {
                ((List)detailHasParentMap.get(parent.getId())).forEach(child -> child.put("pTag", (Object)(parent.getDetailCode() + "-" + parent.getDetailName())));
            }
        }
        page.put("records", (Object)records);
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5206\u5305\u5408\u540c\u660e\u7ec6\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @ResponseBody
    @RequestMapping(value={"/contractDetailRef"}, method={RequestMethod.GET})
    public CommonResponse<List<ContractDetailVO>> contractDetailRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        List contractDetailList;
        List resList = new ArrayList();
        if (null == condition || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("contractId")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u5408\u540cid\u4e3a\u7a7a\uff01");
        }
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById((Serializable)conditionMap.get("contractId")));
        if (null != contractEntity && CollectionUtils.isNotEmpty(contractEntity.getDetailList()) && CollectionUtils.isNotEmpty((Collection)(contractDetailList = BeanMapper.mapList(contractEntity.getDetailList(), ContractDetailVO.class)))) {
            for (ContractDetailVO detail : contractDetailList) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            resList = TreeNodeBUtil.buildTree((List)contractDetailList);
        }
        this.logger.info("\u8fd4\u56de\u5408\u540c\u660e\u7ec6\u6570\u636e\u6210\u529f\uff1a", (Object)JSONObject.toJSONString(resList));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", resList);
    }

    @ResponseBody
    @RequestMapping(value={"/queryPayment"}, method={RequestMethod.GET})
    public CommonResponse<List<ContractPaymentVO>> queryPayment(@RequestParam(value="contractId") String contractId) {
        List contractPayments = new ArrayList();
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById((Serializable)((Object)contractId)));
        if (null != contractEntity && CollectionUtils.isNotEmpty(contractEntity.getDetailList())) {
            contractPayments = BeanMapper.mapList(contractEntity.getPaymentList(), ContractPaymentVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", contractPayments);
    }

    @ResponseBody
    @RequestMapping(value={"/contractPaymentRef"}, method={RequestMethod.GET})
    public CommonResponse<List<ContractPaymentVO>> contractPaymentRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        List contractPayments = new ArrayList();
        if (null == condition || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("contractId")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u5408\u540cid\u4e3a\u7a7a\uff01");
        }
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById((Serializable)conditionMap.get("contractId")));
        if (null != contractEntity && CollectionUtils.isNotEmpty(contractEntity.getDetailList())) {
            contractPayments = BeanMapper.mapList(contractEntity.getPaymentList(), ContractPaymentVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", contractPayments);
    }

    @RequestMapping(value={"/querySupplementRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractVO> querySupplementRecord(Long id) {
        ContractVO vo = this.service.querySupplementRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveOrUpdateSupplement"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdateSupplement(@RequestBody ContractVO supplement) {
        if (supplement.getMainContractId() == null) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4e3b\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdateSupplement(supplement, false));
    }

    @RequestMapping(value={"/addConvertByConId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractVO> addConvertByConId(Long contractId) {
        ContractVO vo = this.service.addConvertByConId(contractId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/addSupplementFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> addSupplementFlag(Long id) {
        Boolean flag = this.service.addSupplementFlag(id);
        if (flag.booleanValue()) {
            return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7\uff0c\u8be5\u5408\u540c\u53ef\u4ee5\u65b0\u589e\u8865\u5145\u534f\u8bae\uff01");
        }
        return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae\uff0c\u4e0d\u80fd\u65b0\u589e\uff01");
    }

    @RequestMapping(value={"/addRelieveFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> addRelieveFlag(Long id) {
        Boolean flag = this.contractRelieveService.isCanRelieve(id);
        return CommonResponse.success((String)"\u6821\u9a8c\u8be5\u5408\u540c\u65b0\u589e\u5408\u540c\u89e3\u9664\u5355\u636e\u6210\u529f\uff01", (Object)flag);
    }

    @RequestMapping(value={"/signatureProcess"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> signatureProcess(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById(id));
        if (contractEntity != null) {
            contractEntity.setFilingStatus(FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode());
            contractEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
            contractEntity.setPerformanceStatus(ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode());
            contractEntity.setEffectiveDate(new Date());
            this.service.saveOrUpdate((Object)contractEntity);
        }
        return CommonResponse.success();
    }

    @ResponseBody
    @RequestMapping(value={"/prosubContractOtherCostRef"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> prosubContractOtherCostRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        if (null == condition || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("contractId")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u5408\u540cid\u4e3a\u7a7a\uff01");
        }
        queryParam.getParams().put("contract_id", new Parameter("eq", conditionMap.get("contractId")));
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("create_time", "desc");
        queryParam.setOrderMap(orderMap);
        this.logger.info("\u5206\u5305\u5408\u540c\u5176\u4ed6\u8d39\u7528\u67e5\u8be2\u53c2\u7167-\u67e5\u8be2\u6761\u4ef6---------->" + JSONObject.toJSONString((Object)queryParam.getParams()));
        IPage pageData = this.otherCostService.queryPage(queryParam, false);
        this.logger.info("\u5206\u5305\u5408\u540c\u5176\u4ed6\u8d39\u7528\u67e5\u8be2\u53c2\u7167-\u67e5\u8be2\u7ed3\u679c\u6761\u6570---------->" + pageData.getRecords().size());
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ContractOtherCostVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5206\u5305\u5408\u540c\u5176\u4ed6\u8d39\u7528\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @PostMapping(value={"/testPushContract"})
    @ResponseBody
    public CommonResponse<ContractPoolVO> testPushContract(@RequestBody ContractVO contractVO) {
        ContractEntity contract = (ContractEntity)((Object)this.service.selectById(contractVO.getId()));
        boolean pushContractResult = this.service.pushContract((ContractVO)BeanMapper.map((Object)((Object)contract), ContractVO.class));
        if (pushContractResult) {
            return CommonResponse.success((String)"\u5408\u540c\u6570\u636e\u63a8\u9001\u5408\u540c\u6c60\u6210\u529f\uff01");
        }
        return CommonResponse.error((String)"\u5408\u540c\u6570\u636e\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01");
    }

    @PostMapping(value={"/deleteContractFile"})
    @ResponseBody
    public CommonResponse<Integer> deleteContractFile(@RequestBody ContractVO contractVO) {
        Integer contractVersion = this.service.deleteContractFileById(contractVO.getId());
        if (null != contractVersion && contractVersion.equals(-1)) {
            return CommonResponse.error((String)"\u5408\u540c\u5220\u9664\u5408\u540c\u9644\u4ef6\u5931\u8d25\uff01");
        }
        return CommonResponse.success((String)"\u5408\u540c\u5220\u9664\u5408\u540c\u9644\u4ef6\u6210\u529f\uff01", (Object)contractVersion);
    }

    @RequestMapping(value={"/targetCostCtrl"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody ContractVO contractVO, HttpServletRequest req) {
        ContractVO cv;
        if (null != contractVO.getSupplementFlag() && 1 == contractVO.getSupplementFlag()) {
            cv = this.service.saveOrUpdateSupplement(contractVO, true);
        } else {
            String authority = req.getHeader("authority");
            cv = this.service.insertOrUpdate(contractVO, authority, true);
        }
        String linkUrl = this.service.getLinkUrl(cv);
        ExecutionVO executionVO = this.service.targetCost(cv, linkUrl, cv.getContractType());
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u63a7\u5236\uff1a{}", (Object)JSONObject.toJSONString((Object)executionVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        if (!response.isSuccess()) {
            this.logger.error("\u76ee\u6807\u6210\u672c\u53c2\u6570\u63a7\u5236\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f-{}", (Object)response.getMsg());
            return response;
        }
        ParamsCheckVO responseData = this.paramCheck(contractVO, (CommonResponse<ParamsCheckVO>)response, false);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)responseData);
    }

    @GetMapping(value={"/viewTargetCostCtrlInfo"})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value="id") Long id) {
        ContractVO cv = this.service.queryDetail(id);
        String linkUrl = this.service.getLinkUrl(cv);
        ExecutionVO executionVO = this.service.targetCost(cv, linkUrl, cv.getContractType());
        this.logger.error("\u76ee\u6807\u6210\u672c\u63a8\u9001\u63a7\u5236\uff1a{}", (Object)JSONObject.toJSONString((Object)executionVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        this.logger.error("\u76ee\u6807\u6210\u672c\u63a8\u9001\u63a7\u5236\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        if (!response.isSuccess()) {
            this.logger.error("\u76ee\u6807\u6210\u672c\u53c2\u6570\u63a7\u5236\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f-{}", (Object)response.getMsg());
            return response;
        }
        ParamsCheckVO responseData = this.paramCheck(cv, (CommonResponse<ParamsCheckVO>)response, true);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)responseData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/pushContractToPool"})
    @ResponseBody
    public CommonResponse<ContractVO> pushContractToPool(@RequestBody ContractVO contractVO) {
        CommonResponse transDataResp;
        ContractVO vo;
        JedisTemplate jedisTemplate;
        ContractEntity dbEntity;
        block10: {
            dbEntity = null;
            if (null != contractVO.getId()) {
                dbEntity = (ContractEntity)((Object)this.service.selectById(contractVO.getId()));
            }
            if (dbEntity == null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)contractVO.getBillCode())) {
                QueryWrapper query = new QueryWrapper();
                query.eq((Object)"billCode", (Object)contractVO.getBillCode());
                query.eq((Object)"tenantId", (Object)InvocationInfoProxy.getTenantid());
                dbEntity = (ContractEntity)((Object)this.service.getOne((Wrapper)query));
            }
            if (dbEntity == null) {
                return CommonResponse.error((String)"\u5408\u540c\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c\u672a\u627e\u5230\u5339\u914d\u7684\u5408\u540c\uff01");
            }
            jedisTemplate = this.cacheManager.getJedisTemplate();
            String contractIdStr = jedisTemplate.get("pushContract::" + dbEntity.getId().toString());
            if (StringUtils.isNotBlank((String)contractIdStr)) {
                return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u6570\u636e\u5df2\u5904\u4e8e\u540c\u6b65\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
            }
            jedisTemplate.set("pushContract::" + dbEntity.getId().toString(), dbEntity.getId().toString());
            vo = (ContractVO)BeanMapper.map((Object)((Object)dbEntity), ContractVO.class);
            ContractPoolVO data = new ContractPoolVO();
            BeanConvertorUtil.convert((Object)vo, (Object)data);
            data.setSourceType(ContractTypeEnum.\u5176\u4ed6\u652f\u51fa.getTypeCode());
            String cardType = vo.getAddType() == 1 ? "otherSubCard" : "otherSubDirectCard";
            data.setContractProperty(ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode());
            data.setPcCardUrl("/ejc-proother-frontend/#/otherSubList/contractMultiCards?id=" + vo.getId() + "&supplementFlag=" + vo.getSupplementFlag() + "&cardType=" + cardType + "&performanceStatus=" + vo.getPerformanceStatus());
            data.setAddType(Integer.valueOf(1));
            data.setSourceTypeName(ContractTypeEnum.\u5176\u4ed6\u652f\u51fa.getTypeName());
            transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            if (!transDataResp.isSuccess()) break block10;
            if (BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus().equals(dbEntity.getBillPushFlag())) {
                dbEntity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
                this.service.saveOrUpdate((Object)dbEntity);
            }
            CommonResponse commonResponse = CommonResponse.success((String)"\u5408\u540c\u63a8\u9001\u5408\u540c\u6c60\u6210\u529f", (Object)vo);
            jedisTemplate.del(new String[]{"pushContract::" + dbEntity.getId().toString()});
            return commonResponse;
        }
        try {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString((Object)contractVO), (Object)transDataResp.getMsg());
        }
        catch (Exception e) {
            try {
                this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)JSONObject.toJSONString((Object)contractVO), (Object)e);
            }
            catch (Throwable throwable) {
                jedisTemplate.del(new String[]{"pushContract::" + dbEntity.getId().toString()});
                throw throwable;
            }
            jedisTemplate.del(new String[]{"pushContract::" + dbEntity.getId().toString()});
        }
        jedisTemplate.del(new String[]{"pushContract::" + dbEntity.getId().toString()});
        return CommonResponse.error((String)"\u5408\u540c\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25", (Object)vo);
    }

    private ParamsCheckVO paramCheck(ContractVO contractVO, CommonResponse<ParamsCheckVO> response, boolean flag) {
        ParamsCheckVO responseData = (ParamsCheckVO)response.getData();
        ParamsCheckVO resp = new ParamsCheckVO();
        if (null != contractVO.getSupplementFlag() && 1 == contractVO.getSupplementFlag()) {
            List<ParamsCheckVO> checkVOList = this.service.supplementMnyCtrl(contractVO, flag);
            Map<String, List<ParamsCheckVO>> checkListMap = checkVOList.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));
            List<Object> result = new ArrayList();
            if (null != checkListMap.get("alert")) {
                result = checkListMap.get("alert");
                resp.setWarnType("alert");
            } else if (null != checkListMap.get("warn")) {
                result = checkListMap.get("warn");
                resp.setWarnType("warn");
            } else {
                resp.setWarnType("none");
            }
            if (null == responseData.getWarnType() || ParamCtrlUtil.getWarnTypeInt(responseData.getWarnType(), 1) < ParamCtrlUtil.getWarnTypeInt(resp.getWarnType(), 1)) {
                for (ParamsCheckVO paramsCheckVO : result) {
                    resp.getDataSource().addAll(paramsCheckVO.getDataSource());
                }
            } else if (ParamCtrlUtil.getWarnTypeInt(responseData.getWarnType(), 1) == ParamCtrlUtil.getWarnTypeInt(resp.getWarnType(), 1)) {
                if (CollectionUtils.isNotEmpty((Collection)responseData.getDataSource())) {
                    resp.getDataSource().addAll(responseData.getDataSource());
                }
                for (ParamsCheckVO paramsCheckVO : result) {
                    resp.getDataSource().addAll(paramsCheckVO.getDataSource());
                }
            } else {
                return responseData;
            }
        }
        return resp;
    }

    @RequestMapping(value={"/queryPaymentApplyList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractPaymentResultVO> query(Long id) {
        CommonResponse<ContractPaymentResultVO> response = this.service.queryPaymentApplyList(id);
        return response;
    }

    @RequestMapping(value={"/downloadEqualExcel"})
    @ResponseBody
    public void downloadEqualExcel(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"contract-detail-import.xlsx", (String)"\u5408\u540c\u6e05\u5355\u660e\u7ec6\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/uploadEqualTemplate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> uploadEqualTemplate(HttpServletRequest request, HttpServletResponse response) {
        JSONObject result = this.service.excelImportInfo(request, response);
        if (result.getBoolean("success").booleanValue()) {
            return CommonResponse.success((Object)result);
        }
        return CommonResponse.error((String)result.getString("errMsg"));
    }

    @RequestMapping(value={"/downloadOtherExcel"})
    @ResponseBody
    public void downloadOtherExcel(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"other-cost-import.xlsx", (String)"\u5176\u4ed6\u8d39\u7528\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/uploadOtherTemplate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> uploadOtherTemplate(HttpServletRequest request, HttpServletResponse response) {
        JSONObject result = this.service.excelImportOtherInfo(request, response);
        if (result.getBoolean("success").booleanValue()) {
            return CommonResponse.success((Object)result);
        }
        return CommonResponse.error((String)result.getString("errMsg"));
    }

    @PostMapping(value={"/pushTargetCost"})
    @ResponseBody
    public CommonResponse<String> pushTargetCost(@RequestBody ContractVO contractVO) {
        return this.service.pushTargetCost(contractVO);
    }

    @GetMapping(value={"/allContractPushTargetCost"})
    @ResponseBody
    public CommonResponse<String> allContractPushTargetCost(@RequestParam(value="projectId", required=false) Long projectId) {
        List contractList;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"id"});
        if (null != projectId) {
            queryWrapper.eq((Object)"project_id", (Object)projectId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(contractList = this.service.list((Wrapper)queryWrapper)))) {
            for (ContractVO contractVO : BeanMapper.mapList((Iterable)contractList, ContractVO.class)) {
                this.service.pushTargetCost(contractVO);
            }
        }
        this.logger.info("\u5168\u5408\u540c\u63a8\u9001\u76ee\u6807\u6210\u672c\u6570\u636e{}\u6761", (Object)contractList.size());
        return CommonResponse.success((String)"\u5168\u5408\u540c\u3001\u53d8\u66f4\u3001\u89e3\u9664\u63a8\u9001\u76ee\u6807\u6210\u672c\u6570\u636e\u6210\u529f\uff01");
    }

    @PostMapping(value={"/asyncWatermarkById"})
    @ResponseBody
    public void asyncWatermarkById(Long id, @RequestParam(value="contractType", required=false) String contractType) {
        WatermarkVO watermarkVO;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)contractType) && contractType.equals("change")) {
            ChangeEntity changeEntity = (ChangeEntity)((Object)this.changeService.selectById(id));
            watermarkVO = this.signatureCommonApi.fetchWatermarkConfig(changeEntity.getChangeFileId(), changeEntity.getId(), changeEntity.getBillCode(), ProotherBillTypeEnum.\u5176\u4ed6\u5408\u540c\u53d8\u66f4.getBillTypeCode(), "proOtherContractChange");
        } else {
            ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById(id));
            watermarkVO = this.signatureCommonApi.fetchWatermarkConfig(contractEntity.getContractFileId(), contractEntity.getId(), contractEntity.getBillCode(), "BT220308000000001", "proOtherContract");
        }
        Assert.notNull((Object)watermarkVO, (String)"\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u5931\u8d25!");
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("authority", request.getHeader("authority"));
        headers.put("ejc-token", request.getHeader("ejc-token"));
        this.contractAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
    }
}

