/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.ownrmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.store.api.IAmAllotApi;
import com.ejianc.business.pro.ownrmat.bean.AllotOutEntity;
import com.ejianc.business.pro.ownrmat.service.AllotInMessageService;
import com.ejianc.business.pro.ownrmat.service.IAllotInService;
import com.ejianc.business.pro.ownrmat.service.IAllotOutService;
import com.ejianc.business.pro.ownrmat.service.IValidateService;
import com.ejianc.business.pro.ownrmat.vo.AllotOutVO;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.AllocationState;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="allotOut")
public class AllotOutBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAllotOutService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAllotInService allotInService;
    private static final String BILL_CODE = "PRO_RMAT_ALLOT_IN";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private IValidateService validateService;
    @Autowired
    private AllotInMessageService allotInMessageService;
    @Autowired
    private IAmAllotApi amAllotApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        AllotOutEntity allotOutEntity = (AllotOutEntity)((Object)this.service.selectById(billId));
        AllotOutVO allotOutVO = (AllotOutVO)BeanMapper.map((Object)((Object)allotOutEntity), AllotOutVO.class);
        this.validateService.validateAllotOut(allotOutVO);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        Jedis jedis = this.jedisPool.getResource();
        boolean locked = false;
        locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(billId), (String)"generateAllotIn", (int)1000);
        if (locked) {
            RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(billId), (String)"generateAllotIn");
        }
        locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(billId), (String)"generateAllotIn", (int)1000);
        this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
        if (!locked) return CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        try {
            AllotOutEntity allotOutEntity = (AllotOutEntity)((Object)this.service.selectById(billId));
            AllotOutVO allotOutVO = (AllotOutVO)BeanMapper.map((Object)((Object)allotOutEntity), AllotOutVO.class);
            StoreManageVO storeManageVO = allotOutVO.getStoreManageVO(allotOutVO);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            CommonResponse response = this.storeManageApi.inOutStore(storeManageVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
            }
            if (Objects.isNull((Object)allotOutEntity)) return CommonResponse.success();
            LambdaUpdateWrapper allotOutWrapper = new LambdaUpdateWrapper();
            allotOutWrapper.eq(BaseEntity::getId, (Object)billId);
            allotOutWrapper.set(AllotOutEntity::getReceiveState, (Object)Integer.parseInt(AllocationState.TO_RECEIVING.getCode()));
            allotOutWrapper.set(AllotOutEntity::getReturnReason, null);
            allotOutWrapper.set(AllotOutEntity::getReceiverPersonId, null);
            allotOutWrapper.set(AllotOutEntity::getReceiverPerson, null);
            this.service.update((Wrapper)allotOutWrapper);
            if ("1".equals(allotOutEntity.getInAllocaScope())) {
                com.ejianc.business.assist.store.vo.AllotOutVO vo = (com.ejianc.business.assist.store.vo.AllotOutVO)BeanMapper.map((Object)((Object)allotOutEntity), com.ejianc.business.assist.store.vo.AllotOutVO.class);
                CommonResponse resp = this.amAllotApi.amCreateAllotIn(vo);
                if (!resp.isSuccess() && resp.getData() != null) {
                    throw new BusinessException("\u5468\u8f6c\u6750\u79df\u8d41\u751f\u6210\u8c03\u51fa\u5355\u5931\u8d25\uff01");
                }
            } else {
                AllotOutVO vo = (AllotOutVO)BeanMapper.map((Object)((Object)allotOutEntity), AllotOutVO.class);
                String msg = this.service.rmatCreateAllotIn(vo);
                if (null != msg) {
                    throw new BusinessException(msg);
                }
            }
            this.logger.info("\u63a8\u9001\u6210\u672c---");
            this.service.costPush(allotOutEntity);
            return CommonResponse.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.success();
        }
        finally {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(billId), (String)"generateAllotIn");
            }
            jedis.close();
        }
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)res.getMsg());
        }
        AllotOutEntity entity = (AllotOutEntity)((Object)this.service.selectById(billId));
        if (BillStateEnum.COMMITED_STATE.getBillStateCode() == entity.getBillState() || BillStateEnum.PASSED_STATE.getBillStateCode() == entity.getBillState()) {
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u5df2\u63a8\u9001\u7ed9\u8c03\u5165\u65b9\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5220\u9664\u6210\u672c---");
        this.service.pullCost(billId);
        return CommonResponse.success();
    }
}

