/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.ownrmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.pro.ownrmat.bean.AllotInDetailEntity;
import com.ejianc.business.pro.ownrmat.bean.AllotInEntity;
import com.ejianc.business.pro.ownrmat.bean.AllotOutDetailEntity;
import com.ejianc.business.pro.ownrmat.bean.AllotOutEntity;
import com.ejianc.business.pro.ownrmat.consts.NoticeEnum;
import com.ejianc.business.pro.ownrmat.mapper.AllotOutMapper;
import com.ejianc.business.pro.ownrmat.service.AllotInMessageService;
import com.ejianc.business.pro.ownrmat.service.IAllotInService;
import com.ejianc.business.pro.ownrmat.service.IAllotOutService;
import com.ejianc.business.pro.ownrmat.vo.AllotInVO;
import com.ejianc.business.pro.ownrmat.vo.AllotOutDetailVO;
import com.ejianc.business.pro.ownrmat.vo.AllotOutExportVO;
import com.ejianc.business.pro.ownrmat.vo.AllotOutVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.AllocatEnum;
import com.ejianc.business.store.consts.AllocationState;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.store.vo.UseMaterialPriceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="allotOutService")
public class AllotOutServiceImpl
extends BaseServiceImpl<AllotOutMapper, AllotOutEntity>
implements IAllotOutService {
    public static String NOT_CHANGE = "\u6750\u6599\u51fa\u5e93\u660e\u7ec6\u6570\u91cf\u6ca1\u6709\u53d8\u5316,\u4ed3\u5e93\u65e0\u9700\u5904\u7406!";
    @Autowired
    private IAllotOutService service;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "PRO_RMAT_ALLOT_OUT";
    private static final String BILL_NAME = "\u5468\u8f6c\u6750\u8c03\u51fa";
    private static final String IN_BILL_CODE = "PRO_RMAT_ALLOT_IN";
    @Autowired
    private IAllotInService allotInService;
    @Autowired
    private AllotInMessageService allotInMessageService;

    @Override
    public CommonResponse<UseMaterialPriceVO> turnSurplusMaterialPrice(AllotOutVO saveOrUpdateVO) {
        AllotOutDetailVO allotOutDetailVO = (AllotOutDetailVO)saveOrUpdateVO.getAllotOutDetailList().get(0);
        FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u5468\u8f6c\u6750\u8c03\u62e8\u51fa\u5e93, (Integer)StoreCommonConsts.NO);
        flowVO.setRowState(allotOutDetailVO.getRowState());
        flowVO.setProjectId(saveOrUpdateVO.getProjectId());
        flowVO.setProjectName(saveOrUpdateVO.getProjectName());
        flowVO.setParentOrgId(saveOrUpdateVO.getParentOrgId());
        flowVO.setParentOrgCode(saveOrUpdateVO.getParentOrgCode());
        flowVO.setParentOrgName(saveOrUpdateVO.getParentOrgName());
        flowVO.setOrgId(saveOrUpdateVO.getOrgId());
        flowVO.setOrgName(saveOrUpdateVO.getOrgName());
        flowVO.setStoreId(saveOrUpdateVO.getStoreId());
        flowVO.setStoreName(saveOrUpdateVO.getStoreName());
        flowVO.setMaterialId(allotOutDetailVO.getMaterialId());
        flowVO.setMaterialName(allotOutDetailVO.getMaterialName());
        flowVO.setMaterialCategoryId(allotOutDetailVO.getMaterialCategoryId());
        flowVO.setMaterialCategoryName(allotOutDetailVO.getMaterialCategoryName());
        flowVO.setMaterialSpec(allotOutDetailVO.getMaterialSpec());
        flowVO.setMaterialUnitId(allotOutDetailVO.getMaterialUnitId());
        flowVO.setMaterialUnitName(allotOutDetailVO.getMaterialUnit());
        flowVO.setNum(allotOutDetailVO.getAllocatNum());
        StoreManageVO storeManageVO = new StoreManageVO();
        storeManageVO.setStoreId(saveOrUpdateVO.getStoreId());
        storeManageVO.setSourceId(saveOrUpdateVO.getId());
        ArrayList<FlowVO> flowVOList = new ArrayList<FlowVO>();
        flowVOList.add(flowVO);
        storeManageVO.setFlowVOList(flowVOList);
        CommonResponse commonResponse = this.storeManageApi.turnSurplusMaterialPrice(storeManageVO);
        if (commonResponse.isSuccess() && commonResponse.getData() != null) {
            return CommonResponse.success((String)"\u539f\u503c\u5355\u4ef7\u3001\u51c0\u503c\u91d1\u989d\u83b7\u53d6\u6210\u529f", ((StoreManageVO)commonResponse.getData()).getUseMaterialPriceVOList().get(0));
        }
        if (NOT_CHANGE.equals(commonResponse.getMsg())) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)commonResponse.getMsg());
    }

    @Override
    public CommonResponse<AllotOutVO> allotOutSaveOrUpdate(AllotOutVO saveOrUpdateVO) {
        AllotOutEntity entity = (AllotOutEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AllotOutEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setRelationFlag("0");
        entity.setProportionFlag("0");
        boolean b = this.service.saveOrUpdate((Object)entity, false);
        if (b && CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getAllotOutDetailList())) {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(saveOrUpdateVO.getStoreId());
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u5468\u8f6c\u6750\u8c03\u62e8\u51fa\u5e93);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(false));
            ArrayList flowVOS = new ArrayList();
            saveOrUpdateVO.getAllotOutDetailList().forEach(t -> {
                if ("del".equals(t.getRowState())) {
                    FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u5468\u8f6c\u6750\u8c03\u62e8\u51fa\u5e93, (Integer)0);
                    flowVO.setStoreId(entity.getStoreId());
                    flowVO.setStoreName(entity.getStoreName());
                    flowVO.setProjectId(entity.getProjectId());
                    flowVO.setProjectName(entity.getProjectName());
                    flowVO.setOrgId(entity.getOrgId());
                    flowVO.setOrgName(entity.getOrgName());
                    flowVO.setParentOrgId(entity.getParentOrgId());
                    flowVO.setParentOrgName(entity.getParentOrgName());
                    flowVO.setEmployeeId(entity.getEmployeeId());
                    flowVO.setEmployeeName(entity.getEmployeeName());
                    flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                    flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                    flowVO.setMaterialId(t.getMaterialId());
                    flowVO.setMaterialName(t.getMaterialName());
                    flowVO.setMaterialSpec(t.getMaterialSpec());
                    flowVO.setMaterialUnitId(t.getMaterialUnitId());
                    flowVO.setMaterialUnitName(t.getMaterialName());
                    flowVO.setSourceBillDetailRemark(t.getMemo());
                    flowVO.setTaxPrice(t.getAllocatTaxPrice());
                    flowVO.setPrice(t.getAllocatPrice());
                    flowVO.setNum(t.getAllocatNum());
                    flowVO.setTaxMny(t.getAllocatTaxMny());
                    flowVO.setMny(t.getAllocatMny());
                    flowVO.setTax(t.getAllocatTax());
                    flowVO.setSourceId(entity.getId());
                    flowVO.setSourceDetailId(t.getId());
                    flowVO.setSourceBillCode(entity.getBillCode());
                    flowVO.setSourceBillDate(entity.getOutDate());
                    flowVO.setRowState(t.getRowState());
                    flowVO.setSourceBillRemark(entity.getMemo());
                    flowVO.setPurchasePrice(t.getOriginalValuePrice());
                    flowVO.setPurchaseTaxPrice(t.getOriginalValueTaxPrice());
                    flowVOS.add(flowVO);
                }
            });
            entity.getAllotOutDetailList().forEach(t -> {
                FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u5468\u8f6c\u6750\u8c03\u62e8\u51fa\u5e93, (Integer)0);
                flowVO.setStoreId(entity.getStoreId());
                flowVO.setStoreName(entity.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                flowVO.setMaterialId(t.getMaterialId());
                flowVO.setMaterialName(t.getMaterialName());
                flowVO.setMaterialSpec(t.getMaterialSpec());
                flowVO.setMaterialUnitId(t.getMaterialUnitId());
                flowVO.setMaterialUnitName(t.getMaterialName());
                flowVO.setSourceBillDetailRemark(t.getMemo());
                flowVO.setTaxPrice(t.getAllocatTaxPrice());
                flowVO.setPrice(t.getAllocatPrice());
                flowVO.setNum(t.getAllocatNum());
                flowVO.setTaxMny(t.getAllocatTaxMny());
                flowVO.setMny(t.getAllocatMny());
                flowVO.setTax(t.getAllocatTax());
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(t.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getOutDate());
                flowVO.setRowState(t.getRowState());
                flowVO.setSourceBillRemark(entity.getMemo());
                flowVO.setPurchasePrice(t.getOriginalValuePrice());
                flowVO.setPurchaseTaxPrice(t.getOriginalValueTaxPrice());
                flowVOS.add(flowVO);
            });
            storeManageVO.setFlowVOList(flowVOS);
            CommonResponse response = this.storeManageApi.inOutStore(storeManageVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
            }
        }
        AllotOutVO vo = (AllotOutVO)BeanMapper.map((Object)((Object)entity), AllotOutVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u4fee\u6539\u6210\u529f", (Object)vo);
    }

    @Override
    public CommonResponse<String> allotOutDelete(List<AllotOutVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AllotOutVO vo : vos) {
                AllotOutEntity allotOutEntity = (AllotOutEntity)((Object)this.service.selectById(vo.getId()));
                if (!CollectionUtils.isNotEmpty(allotOutEntity.getAllotOutDetailList())) continue;
                StoreManageVO storeManageVO = new StoreManageVO();
                storeManageVO.setStoreId(allotOutEntity.getStoreId());
                storeManageVO.setSourceId(allotOutEntity.getId());
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u5468\u8f6c\u6750\u8c03\u62e8\u51fa\u5e93);
                storeManageVO.setOutEffectiveON(Boolean.valueOf(false));
                ArrayList<Long> longs = new ArrayList<Long>();
                longs.add(allotOutEntity.getId());
                storeManageVO.setSourceIdsForRollBack(longs);
                CommonResponse response = this.storeManageApi.inOutStoreRollback(storeManageVO);
                if (response.isSuccess()) continue;
                throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
            }
        }
        boolean b = this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public void excelExport(QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialNames");
        fuzzyFields.add("inProjectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("receiverPerson");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List allotOutVos = BeanMapper.mapList((Iterable)list, AllotOutExportVO.class);
        allotOutVos.forEach(vo -> {
            if (vo.getOutDate() != null) {
                vo.setAllocatDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getOutDate()));
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            if (vo.getReceiveState() != null) {
                if (Integer.valueOf(AllocationState.TO_RECEIVING.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.TO_RECEIVING.getDescription());
                } else if (Integer.valueOf(AllocationState.RECEIVED.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.RECEIVED.getDescription());
                } else if (Integer.valueOf(AllocationState.REJECT.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.REJECT.getDescription());
                }
            }
            if (vo.getAllocatType() != null) {
                if (Integer.valueOf(AllocatEnum.ASSETS.getCode()).equals(vo.getAllocatType())) {
                    vo.setAllocatTypeName(AllocatEnum.ASSETS.getDescription());
                } else {
                    vo.setAllocatTypeName(AllocatEnum.HOMEMADE.getDescription());
                }
            }
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", allotOutVos);
        ExcelExport.getInstance().export("allocationOutExport.xlsx", beans, response);
    }

    @Override
    public CommonResponse<AllotOutVO> pushCost(AllotOutVO vo) {
        AllotOutEntity entity = (AllotOutEntity)((Object)((AllotOutMapper)this.baseMapper).selectById(vo.getId()));
        if (CollectionUtils.isNotEmpty((Collection)vo.getAllotOutDetailList())) {
            List allotOutList = BeanMapper.mapList((Iterable)vo.getAllotOutDetailList(), AllotOutDetailEntity.class);
            entity.setAllotOutDetailList(allotOutList);
        }
        super.saveOrUpdate((Object)entity, false);
        this.costPush(entity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), AllotOutVO.class));
    }

    @Override
    public void costPush(AllotOutEntity entity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<AllotOutDetailEntity> allotOutList = entity.getAllotOutDetailList();
        String relationFlag = "1";
        if (CollectionUtils.isNotEmpty(allotOutList)) {
            for (AllotOutDetailEntity detail : allotOutList) {
                if (null != detail.getSubjectId() && null != detail.getWbsId()) continue;
                relationFlag = "0";
                break;
            }
        }
        if (CollectionUtils.isEmpty(allotOutList)) {
            relationFlag = "0";
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        updateWrapper.set(AllotOutEntity::getRelationFlag, (Object)relationFlag);
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = entity.getRelationFlag();
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(relationFlag)) {
                this.saveCost(entity);
            }
            if (!"1".equals(relationFlag)) {
                this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-{}Id---{}", (Object)BILL_NAME, (Object)entity.getId());
                CommonResponse commonResponse = this.costDetailApi.deleteSubject(entity.getId());
                this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)commonResponse));
                if (!commonResponse.isSuccess()) {
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        if ("0".equals(oldRelationFlag) && "1".equals(relationFlag)) {
            this.saveCost(entity);
        }
    }

    private void saveCost(AllotOutEntity entity) {
        ArrayList<CostDetailVO> costVOList = new ArrayList<CostDetailVO>();
        List<AllotOutDetailEntity> allotOutList = entity.getAllotOutDetailList();
        if (CollectionUtils.isNotEmpty(allotOutList)) {
            for (AllotOutDetailEntity detail : allotOutList) {
                CostDetailVO costVO = new CostDetailVO();
                costVO.setSubjectId(detail.getSubjectId());
                costVO.setSubjectCode(detail.getSubjectCode());
                costVO.setSubjectName(detail.getSubjectName());
                costVO.setWbsId(detail.getWbsId());
                costVO.setWbsCode(detail.getWbsCode());
                costVO.setWbsName(detail.getWbsName());
                costVO.setSourceId(detail.getAllocatId());
                costVO.setSourceDetailId(detail.getId());
                costVO.setHappenTaxMny(detail.getAllocatBlanceTaxMny());
                costVO.setHappenMny(detail.getAllocatBlanceMny());
                costVO.setHappenDate(entity.getOutDate());
                costVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costVO.setSourceType("PRO_RMAT_AllotOut");
                costVO.setSourceTabType("PRO_RMAT_AllotOut_DETAIL");
                costVO.setProjectId(entity.getProjectId());
                costVO.setSourceBillCode(entity.getBillCode());
                costVO.setSourceBillName(BILL_NAME);
                costVO.setSourceBillUrl("/ejc-prormat-frontend/#/allotOut/card?id=" + entity.getId());
                costVOList.add(costVO);
            }
        }
        if (ListUtil.isNotEmpty(costVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costVOList));
            CommonResponse response = this.costDetailApi.saveSubject(costVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)response));
            if (!response.isSuccess()) {
                throw new BusinessException(response.getMsg());
            }
        }
    }

    @Override
    public void pullCost(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)id);
        updateWrapper.set(AllotOutEntity::getRelationFlag, (Object)"0");
        super.update((Wrapper)updateWrapper);
        this.logger.info("\u5f03\u5ba1\u63a8\u9001\u6210\u672c---");
        this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u5468\u8f6c\u6750\u8c03\u62e8\u51fa\u5e93Id---{}", (Object)id);
        CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(id);
        this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
    }

    @Override
    public String rmatCreateAllotIn(AllotOutVO allotOutVO) {
        AllotInEntity allot;
        this.logger.info("prormat\u6839\u636e\u8c03\u62e8\u51fa\u5e93\u4fe1\u606f\u751f\u6210\u8c03\u62e8\u5165\u5e93\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)allotOutVO));
        AllotOutEntity allotOutEntity = (AllotOutEntity)((Object)BeanMapper.map((Object)allotOutVO, AllotOutEntity.class));
        AllotInEntity allotInEntity = new AllotInEntity();
        allotInEntity.setInUnitName(allotOutEntity.getInUnitName());
        allotInEntity.setOutAllocaScope(allotOutEntity.getOutAllocaScope());
        allotInEntity.setOutProjectId(allotOutEntity.getProjectId());
        allotInEntity.setOutProjectName(allotOutEntity.getProjectName());
        allotInEntity.setOutOrgId(allotOutEntity.getOrgId());
        allotInEntity.setOutOrgName(allotOutEntity.getOrgName());
        allotInEntity.setOutTaxMny(allotOutEntity.getOutTaxMny());
        allotInEntity.setInAllocaScope(allotOutEntity.getInAllocaScope());
        allotInEntity.setStoreId(allotOutEntity.getInStoreId());
        allotInEntity.setStoreName(allotOutEntity.getInStoreName());
        allotInEntity.setProjectId(allotOutEntity.getInProjectId());
        allotInEntity.setProjectName(allotOutEntity.getInProjectName());
        allotInEntity.setParentOrgId(allotOutEntity.getInParentOrgId());
        allotInEntity.setParentOrgName(allotOutEntity.getInParentOrgName());
        allotInEntity.setParentOrgCode(allotOutEntity.getInParentOrgCode());
        allotInEntity.setOrgId(allotOutEntity.getInOrgId());
        allotInEntity.setOrgName(allotOutEntity.getInOrgName());
        allotInEntity.setAllotOutId(allotOutEntity.getId());
        allotInEntity.setOutMny(allotOutEntity.getOutMny());
        allotInEntity.setOutDate(allotOutEntity.getOutDate());
        allotInEntity.setEmployeeId(allotOutEntity.getEmployeeId());
        allotInEntity.setEmployeeName(allotOutEntity.getEmployeeName());
        allotInEntity.setDepartmentId(allotOutEntity.getDepartmentId());
        allotInEntity.setDepartmentName(allotOutEntity.getDepartmentName());
        allotInEntity.setOutStoreId(allotOutEntity.getStoreId());
        allotInEntity.setOutStoreName(allotOutEntity.getStoreName());
        allotInEntity.setNotifyReceiverId(allotOutEntity.getReceiverId());
        allotInEntity.setReceiverName(allotOutEntity.getReceiverName());
        allotInEntity.setAllocatType(allotOutEntity.getAllocatType());
        allotInEntity.setMemo(allotOutEntity.getMemo());
        allotInEntity.setMaterialNames(allotOutEntity.getMaterialNames());
        allotInEntity.setReceiveState(Integer.valueOf(AllocationState.TO_RECEIVING.getCode()));
        List allotInDetailEntitys = BeanMapper.mapList(allotOutEntity.getAllotOutDetailList(), AllotInDetailEntity.class);
        long id = IdWorker.getId();
        allotInDetailEntitys.forEach(item -> {
            item.setId(null);
            item.setAllocatId(id);
        });
        allotInEntity.setAllotInDetailList(allotInDetailEntitys);
        AllotInVO vo = (AllotInVO)BeanMapper.map((Object)((Object)allotInEntity), AllotInVO.class);
        BillCodeParam billCodeParam = BillCodeParam.build((String)IN_BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)vo);
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            return "\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5";
        }
        allotInEntity.setBillCode((String)billCode.getData());
        this.logger.info("\u5b50\u8868\u4fe1\u606f\uff1a" + allotInDetailEntitys.toString());
        allotInEntity.setId(id);
        boolean b = this.allotInService.saveOrUpdate((Object)allotInEntity, false);
        if (b && (allot = (AllotInEntity)((Object)this.allotInService.selectById(Long.valueOf(id)))) != null && allot.getNotifyReceiverId() != null) {
            String[] notifyReceive = new String[]{String.valueOf(allot.getNotifyReceiverId())};
            this.allotInMessageService.sendMsg(allot, notifyReceive, NoticeEnum.ALLOTIN_ENROLL);
        }
        return null;
    }
}

