/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.rmat.bean.SettleEntity;
import com.ejianc.business.pro.rmat.enums.BillPushStatusEnum;
import com.ejianc.business.pro.rmat.enums.BillTypeEnum;
import com.ejianc.business.pro.rmat.enums.SupplierSignStatusEnum;
import com.ejianc.business.pro.rmat.service.ISettleService;
import com.ejianc.business.pro.rmat.vo.LoseVO;
import com.ejianc.business.pro.rmat.vo.RentCalculateVO;
import com.ejianc.business.pro.rmat.vo.RestituteVO;
import com.ejianc.business.pro.rmat.vo.SettleVO;
import com.ejianc.business.pro.rmat.vo.record.SettleRecordVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"settle"})
public class SettleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISettleService service;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/prormat/settle/card";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SettleVO> saveOrUpdate(@RequestBody SettleVO saveOrUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(saveOrUpdateVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleVO> queryDetail(Long id) {
        SettleEntity entity = (SettleEntity)((Object)this.service.selectById(id));
        SettleVO vo = (SettleVO)BeanMapper.map((Object)((Object)entity), SettleVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettleVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SettleVO settleVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SettleVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        Parameter settleDate = (Parameter)param.getParams().get("settleDate");
        if (!Objects.equals(settleDate, null)) {
            String value = settleDate.getValue().toString();
            String[] split = value.split(",");
            String startSetlleDate = split[0] + " 00:00:00";
            String endSetlleDate = split[1] + " 23:59:59";
            param.getParams().remove("settleDate");
            param.getParams().put("settleDate", new Parameter("between", (Object)(startSetlleDate + "," + endSetlleDate)));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List list = this.service.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, SettleVO.class);
        for (SettleVO vo : voList) {
            if (vo.getSupplierSignStatus().equals(0)) {
                vo.setSupplierSignStatusName("\u672a\u7b7e\u5b57");
            } else if (vo.getSupplierSignStatus().equals(1)) {
                vo.setSupplierSignStatusName("\u5df2\u7b7e\u5b57");
            } else {
                vo.setSupplierSignStatusName("\u672a\u7b7e\u5b57");
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("settle-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/validateContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> validateContract(@RequestParam(value="contractId") Long contractId, @RequestParam(value="billId", required=false) Long billId) {
        String msg = this.service.validateContract(contractId, billId);
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01", (Object)msg);
    }

    @RequestMapping(value={"/queryCalculateData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<RentCalculateVO>> queryCalculateData(@RequestParam(value="contractId") Long contractId, @RequestParam(value="lastSettleDate", required=false) String lastSettleDate, @RequestParam(value="settleDate", required=false) String settleDate) {
        return CommonResponse.success((String)"\u67e5\u8be2\u9000\u8d54\u5355\u6210\u529f\uff01", this.service.queryCalculateData(contractId, lastSettleDate, settleDate));
    }

    @RequestMapping(value={"/queryRestituteData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<RestituteVO>> queryRestituteData(@RequestParam(value="contractId") Long contractId, @RequestParam(value="lastSettleDate", required=false) String lastSettleDate, @RequestParam(value="settleDate", required=false) String settleDate) {
        return CommonResponse.success((String)"\u67e5\u8be2\u9000\u8d54\u5355\u6210\u529f\uff01", this.service.queryRestituteData(contractId, lastSettleDate, settleDate));
    }

    @RequestMapping(value={"/queryLoseData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<LoseVO>> queryLoseData(@RequestParam(value="contractId") Long contractId, @RequestParam(value="lastSettleDate", required=false) String lastSettleDate, @RequestParam(value="settleDate", required=false) String settleDate) {
        return CommonResponse.success((String)"\u67e5\u8be2\u9057\u5931\u5355\u6210\u529f\uff01", this.service.queryLoseData(contractId, lastSettleDate, settleDate));
    }

    @RequestMapping(value={"/queryLastSettleTaxMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleVO> queryLastSettleTaxMny(@RequestParam(value="contractId") Long contractId, @RequestParam(value="billId", required=false) Long billId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u9057\u5931\u5355\u6210\u529f\uff01", (Object)this.service.queryLastSettleTaxMny(contractId, billId));
    }

    @RequestMapping(value={"/querySettleRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleRecordVO> querySettleRecord(@RequestParam Long id) {
        SettleRecordVO vo = this.service.querySettleRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"/supSignSync"})
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = this.service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u7b7e\u5b57\u72b6\u6001\u56de\u5199\u6210\u529f\uff01");
    }

    @GetMapping(value={"/getBillShareLink"})
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(Long id) {
        SettleEntity entity = (SettleEntity)((Object)this.service.selectById(id));
        if (SupplierSignStatusEnum.\u4e59\u65b9\u672a\u7b7e\u5b57.getCode().equals(entity.getSupplierSignStatus()) && BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus().equals(entity.getBillPushFlag())) {
            boolean pushResult = this.service.pushBillToSupCenter(entity);
            if (!pushResult) {
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
            this.service.saveOrUpdate((Object)entity, false);
        }
        return this.shareCooperateApi.getShareLink(id, BillTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c\u7ed3\u7b97\u5355.getCode(), entity.getSupplierId().toString(), "/ejc-supbusiness-mobile/#/prormat/settle/card", null);
    }

    @RequestMapping(value={"/checkParams"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestParam(value="purchaseType") Integer purchaseType, @RequestParam(value="contractTaxMny") BigDecimal contractTaxMny, @RequestParam(value="settleTaxMny") BigDecimal settleTaxMny, @RequestParam(value="totalSettleTaxMny") BigDecimal totalSettleTaxMny, @RequestParam(value="orgId") Long orgId, @RequestParam(value="settleType") Integer settleType) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.checkParams(purchaseType, contractTaxMny, settleTaxMny, totalSettleTaxMny, orgId, settleType));
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SettleVO> pushCost(@RequestBody SettleVO vo) {
        return this.service.pushCost(vo);
    }

    @GetMapping(value={"/syncPushSettlePool"})
    @ResponseBody
    public CommonResponse<Boolean> syncPushSettlePool(@RequestParam(value="id") Long id) {
        SettleEntity settleEntity = (SettleEntity)((Object)this.service.selectById(id));
        SettleVO vo = (SettleVO)BeanMapper.map((Object)((Object)settleEntity), SettleVO.class);
        return CommonResponse.success((String)"\u540c\u6b65\u7ed3\u7b97\u6c60\u6210\u529f\uff01", (Object)this.service.pushSettleToPool(vo));
    }

    @GetMapping(value={"/syncPushExecution"})
    @ResponseBody
    public CommonResponse<Boolean> syncPushExecution(@RequestParam(value="id") Long id) {
        return CommonResponse.success((String)"\u540c\u6b65\u76ee\u6807\u6210\u672c\u6210\u529f\uff01", (Object)this.service.syncPushExecution(id));
    }
}

