/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.rmat.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.rmat.mapper.CheckMapper;
import com.ejianc.business.pro.rmat.service.IRentCalculateService;
import com.ejianc.business.pro.rmat.vo.SourceBliVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/rentCalculateApi/"})
public class RentCalculateApi {
    @Autowired
    private IRentCalculateService service;
    @Autowired
    private CheckMapper checkMapper;
    @Autowired
    private IOrgApi iOrgApi;

    @GetMapping(value={"/queryRentMny"})
    public CommonResponse<BigDecimal> queryRentMny(@RequestParam(value="contractId") Long contractId) {
        BigDecimal totalRentTaxMny = new BigDecimal("0.00");
        HashMap<String, BigDecimal> totalMny = new HashMap<String, BigDecimal>();
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"IFNULL(SUM(rent_tax_mny), 0) AS totalRentTaxMny"});
        query.eq((Object)"contract_id", (Object)contractId);
        query.eq((Object)"dr", (Object)0);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        Map map = this.service.getMap((Wrapper)query);
        totalMny.put("totalRentTaxMny", null != map && null != map.get("totalRentTaxMny") ? new BigDecimal(map.get("totalRentTaxMny").toString()) : BigDecimal.ZERO);
        totalRentTaxMny = ((BigDecimal)totalMny.get("totalRentTaxMny")).compareTo(new BigDecimal(0.0)) == 0 ? new BigDecimal(0) : (BigDecimal)totalMny.get("totalRentTaxMny");
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)totalRentTaxMny);
    }

    @GetMapping(value={"getSourceBliVO"})
    CommonResponse<SourceBliVO> getSourceBliVO(@RequestParam(value="supplierId") Long supplierId, @RequestParam(value="dateIn", required=false) String dateIn) {
        List<Long> orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        SourceBliVO vo = this.checkMapper.getSourceBliVO(supplierId, orgIds, dateIn);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }
}

