/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.rmat.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.pro.rmat.bean.ChangeEntity;
import com.ejianc.business.pro.rmat.bean.ContractEntity;
import com.ejianc.business.pro.rmat.bean.ContractFreezeEntity;
import com.ejianc.business.pro.rmat.bean.ContractRelieveEntity;
import com.ejianc.business.pro.rmat.bean.RecordEntity;
import com.ejianc.business.pro.rmat.enums.BillPushStatusEnum;
import com.ejianc.business.pro.rmat.enums.BillTypeEnum;
import com.ejianc.business.pro.rmat.enums.ChangeStatusEnum;
import com.ejianc.business.pro.rmat.enums.ContractSyncTypeEnum;
import com.ejianc.business.pro.rmat.enums.DraftTypeEnum;
import com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum;
import com.ejianc.business.pro.rmat.enums.SignatureStatusEnum;
import com.ejianc.business.pro.rmat.service.IChangeService;
import com.ejianc.business.pro.rmat.service.IContractFreezeService;
import com.ejianc.business.pro.rmat.service.IContractRelieveService;
import com.ejianc.business.pro.rmat.service.IContractService;
import com.ejianc.business.pro.rmat.service.IRecordService;
import com.ejianc.business.pro.rmat.service.impl.ChangeServiceImpl;
import com.ejianc.business.pro.rmat.service.impl.ContractFreezeServiceImpl;
import com.ejianc.business.pro.rmat.service.impl.ContractRelieveServiceImpl;
import com.ejianc.business.pro.rmat.service.impl.ContractServiceImpl;
import com.ejianc.business.pro.rmat.utils.EntityUtil;
import com.ejianc.business.pro.rmat.vo.ChangeVO;
import com.ejianc.business.pro.rmat.vo.ContractVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/prormat/"})
public class contractApi {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService service;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private ChangeServiceImpl changeImpl;
    @Autowired
    private IContractRelieveService relieveService;
    @Autowired
    private IContractFreezeService freezeService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private ContractServiceImpl contractService;
    @Autowired
    private IRecordService recordService;

    @ApiOperation(value="\u6839\u636e\u5b9a\u6807\u53c2\u7167id\u67e5\u8be2\u5bf9\u5e94\u7684\u5408\u540c")
    @GetMapping(value={"/queryContractByTargetResultId"})
    @ResponseBody
    public CommonResponse<List<SignContractVo>> queryContractByTargetResultId(@RequestParam(value="targetResultIdList") List<String> targetResultIdList) {
        this.logger.info("\u6839\u636e\u5b9a\u6807\u7ed3\u679cid\u67e5\u8be2\u5408\u540c\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(targetResultIdList));
        List<SignContractVo> list = this.service.queryContractByTargetResultId(targetResultIdList);
        this.logger.info("\u6839\u636e\u5b9a\u6807\u7ed3\u679cid\u67e5\u8be2\u5408\u540c\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(list));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", list);
    }

    @PostMapping(value={"/contractSync"})
    public CommonResponse<String> contractSync(@RequestBody JSONObject json, @RequestParam(value="type") String type) {
        String msg = "\u5355\u636e\u5df2\u7ecf\u8fdb\u884c\u8fc7\u540c\u6b65\u64cd\u4f5c\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01";
        switch (ContractSyncTypeEnum.getEnumByName((String)type)) {
            case \u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c: {
                ContractEntity entity = (ContractEntity)((Object)JSON.parseObject((String)json.toJSONString(), ContractEntity.class));
                ContractEntity data = (ContractEntity)((Object)EntityUtil.selectOneService((String)"id", (Object)entity.getId(), ContractServiceImpl.class));
                if (null != data) {
                    this.service.delById(data.getId());
                }
                entity.setAddType(1);
                entity.setSignatureStatus(entity.getSignatureStatus() - 1);
                Boolean pushResult2 = this.service.pushContract((ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class));
                if (pushResult2.booleanValue()) {
                    entity.setPushPoolFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
                } else {
                    entity.setPushPoolFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
                }
                CommonResponse response = this.executionApi.aggPush(this.contractService.targetCost((ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class)));
                if (!response.isSuccess()) {
                    this.logger.error("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5931\u8d25: , {}", (Object)response.getMsg());
                    throw new BusinessException(response.getMsg());
                }
                this.service.saveOrUpdate((Object)entity, false);
                break;
            }
            case \u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c\u53d8\u66f4: {
                ChangeEntity changeEntity = (ChangeEntity)((Object)JSON.parseObject((String)json.toJSONString(), ChangeEntity.class));
                ChangeEntity changeData = (ChangeEntity)((Object)EntityUtil.selectOneService((String)"id", (Object)changeEntity.getId(), ChangeServiceImpl.class));
                if (null != changeData) {
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    wrapper.eq(RecordEntity::getChangeId, (Object)changeEntity.getId());
                    List list = this.recordService.list((Wrapper)wrapper);
                    this.service.delChangeById(changeEntity.getId());
                    if (ListUtil.isNotEmpty((List)list)) {
                        this.service.delRecordById(((RecordEntity)((Object)list.get(0))).getId());
                    }
                }
                this.saveChange(changeEntity);
                break;
            }
            case \u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c\u89e3\u9664: {
                ContractRelieveEntity relieveEntity = (ContractRelieveEntity)((Object)JSON.parseObject((String)json.toJSONString(), ContractRelieveEntity.class));
                ContractRelieveEntity relieveData = (ContractRelieveEntity)((Object)EntityUtil.selectOneService((String)"id", (Object)relieveEntity.getId(), ContractRelieveServiceImpl.class));
                if (null != relieveData) {
                    return CommonResponse.error((String)msg);
                }
                if (relieveEntity.getDraftType() == 2) {
                    QueryParam param = new QueryParam();
                    param.getParams().put("id", new Parameter("eq", (Object)relieveEntity.getContractId()));
                    List contractEntities = this.service.queryList(param, false);
                    if (ListUtil.isNotEmpty((List)contractEntities)) {
                        ContractEntity contractEntity = (ContractEntity)((Object)contractEntities.get(0));
                        contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode());
                        this.logger.info("======\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03,\u5df2\u7b7e\u7ae0======,{}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
                        this.service.saveOrUpdate((Object)contractEntity, false);
                        CommonResponse response1 = this.executionApi.aggPush(this.relieveService.targetCost(relieveEntity));
                        this.logger.info("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)this.relieveService.targetCost(relieveEntity)));
                        if (!response1.isSuccess()) {
                            this.logger.error("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5931\u8d25: , {}", (Object)response1.getMsg());
                            throw new BusinessException(response1.getMsg());
                        }
                        ContractPoolVO contractPoolVO = new ContractPoolVO();
                        contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode());
                        contractPoolVO.setSourceId(relieveEntity.getContractId());
                        this.contractPoolApi.updatePerformanceStatusByContractId(contractPoolVO);
                        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                        wrapper.eq(BaseEntity::getId, (Object)relieveEntity.getContractId());
                        wrapper.set(ContractEntity::getPerformanceStatus, (Object)PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode());
                        this.service.update((Wrapper)wrapper);
                    }
                }
                this.relieveService.saveOrUpdate((Object)relieveEntity, false);
                break;
            }
            case \u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c\u51bb\u7ed3: {
                ContractFreezeEntity freezeEntity = (ContractFreezeEntity)((Object)JSON.parseObject((String)json.toJSONString(), ContractFreezeEntity.class));
                ContractFreezeEntity freezeData = (ContractFreezeEntity)((Object)EntityUtil.selectOneService((String)"id", (Object)freezeEntity.getId(), ContractFreezeServiceImpl.class));
                if (null != freezeData) {
                    return CommonResponse.error((String)msg);
                }
                this.freezeService.saveOrUpdate((Object)freezeEntity, false);
                ContractPoolVO contractPoolVO = new ContractPoolVO();
                ContractEntity contractEntity = (ContractEntity)((Object)this.service.getById(freezeEntity.getContractId()));
                if (contractEntity.getPerformanceStatus().equals(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode())) {
                    contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode());
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode());
                } else if (contractEntity.getPerformanceStatus().equals(PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode())) {
                    contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                }
                contractPoolVO.setSourceId(freezeEntity.getContractId());
                this.contractPoolApi.updatePerformanceStatusByContractId(contractPoolVO);
                this.service.saveOrUpdate((Object)contractEntity, false);
                break;
            }
            default: {
                ChangeEntity cEntity = (ChangeEntity)((Object)JSON.parseObject((String)json.toJSONString(), ChangeEntity.class));
                cEntity.setSignatureStatus(cEntity.getSignatureStatus() - 1);
                if (cEntity.getSignatureStatus().equals(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())) {
                    this.changeService.effectiveSaveWriteContract(cEntity.getId(), cEntity.getBillCode(), false);
                    break;
                }
                this.changeService.saveOrUpdate((Object)cEntity);
                this.logger.info("\u53d8\u66f4\u5408\u540c\u7b7e\u7ae0\u72b6\u6001\u5df2\u4fee\u6539---------------->");
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)cEntity.getContractId());
                updateWrapper.set(ContractEntity::getChangeContractSignatureStatus, (Object)cEntity.getSignatureStatus());
                updateWrapper.set(ContractEntity::getChangeStatus, (Object)ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
                this.service.update(this.service.selectById(cEntity.getContractId()), (Wrapper)updateWrapper, false);
                this.logger.info("\u7b7e\u7ae0\u72b6\u6001\u4e3a\u5df2\u7b7e\u7ae0\uff0c\u56de\u5199\u4e3b\u5408\u540c\u7b7e\u7ae0\u72b6\u6001---------------->");
            }
        }
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f\uff01");
    }

    @PostMapping(value={"/delContract"})
    public CommonResponse<String> delContract(@RequestParam(value="id") Long id, @RequestParam(value="type") String type) {
        String msg = "\u64cd\u4f5c\u5931\u8d25,\u672a\u67e5\u5230\u5355\u636e!";
        switch (ContractSyncTypeEnum.getEnumByName((String)type)) {
            case \u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c: {
                ContractEntity data = (ContractEntity)((Object)EntityUtil.selectOneService((String)"id", (Object)id, ContractServiceImpl.class));
                if (data == null) {
                    return CommonResponse.error((String)msg);
                }
                boolean delResult = this.service.delContractFromPool(data.getId());
                if (!delResult) {
                    return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e\u4ece\u5408\u540c\u6c60\u5220\u9664\u5931\u8d25\uff01");
                }
                data.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
                ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
                ExecutionVO executionVO = this.contractService.targetCost((ContractVO)BeanMapper.map((Object)((Object)data), ContractVO.class));
                totalExecutionVOList.add(executionVO.getTotalVO());
                CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u5220\u9664\u5931\u8d25\uff01");
                }
                this.service.delById(id);
                break;
            }
            case \u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c\u53d8\u66f4: {
                ChangeEntity changeData = (ChangeEntity)((Object)EntityUtil.selectOneService((String)"id", (Object)id, ChangeServiceImpl.class));
                if (changeData == null) {
                    return CommonResponse.error((String)msg);
                }
                this.changeImpl.deleteTargetCost(this.changeImpl.targetCost((ChangeVO)BeanMapper.map((Object)((Object)changeData), ChangeVO.class)));
                ChangeEntity oldEntity = this.changeImpl.queryChangeList(changeData);
                ExecutionVO executionVO1 = null;
                if (oldEntity == null) {
                    ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById(changeData.getContractId()));
                    executionVO1 = this.service.targetCost((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class));
                } else {
                    executionVO1 = this.changeImpl.targetCost((ChangeVO)BeanMapper.map((Object)((Object)oldEntity), ChangeVO.class));
                }
                CommonResponse response2 = this.executionApi.aggPush(executionVO1);
                if (!response2.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25\uff01");
                }
                LambdaUpdateWrapper lambdaUpdate = new LambdaUpdateWrapper();
                if (changeData.getChangeVersion() == 1) {
                    lambdaUpdate.set(ContractEntity::getChangeStatus, (Object)1);
                } else {
                    lambdaUpdate.set(ContractEntity::getChangeStatus, (Object)3);
                }
                lambdaUpdate.eq(BaseEntity::getId, (Object)changeData.getContractId());
                this.service.update((Wrapper)lambdaUpdate);
                this.service.delChangeById(id);
                break;
            }
            default: {
                ContractRelieveEntity relieveData = (ContractRelieveEntity)((Object)EntityUtil.selectOneService((String)"id", (Object)id, ContractRelieveServiceImpl.class));
                if (relieveData == null) {
                    return CommonResponse.error((String)msg);
                }
                ContractPoolVO contractPoolVO = new ContractPoolVO();
                contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                contractPoolVO.setSourceId(relieveData.getContractId());
                this.contractPoolApi.updatePerformanceStatusByContractId(contractPoolVO);
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.eq(BaseEntity::getId, (Object)relieveData.getContractId());
                wrapper.set(ContractEntity::getPerformanceStatus, (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                this.service.update((Wrapper)wrapper);
                this.relieveService.delById(id);
            }
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    private String saveChange(ChangeEntity entity) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById(entity.getMainContractId()));
        ChangeEntity oldEntity = this.changeImpl.queryChangeList(entity);
        ExecutionVO executionVO = null;
        executionVO = oldEntity == null ? this.service.targetCost((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class)) : this.changeImpl.targetCost((ChangeVO)BeanMapper.map((Object)((Object)oldEntity), ChangeVO.class));
        this.changeImpl.deleteTargetCost(executionVO);
        entity.setSignatureStatus(entity.getSignatureStatus() - 1);
        CommonResponse response = this.executionApi.aggPush(this.changeImpl.targetCost((ChangeVO)BeanMapper.map((Object)((Object)entity), ChangeVO.class)));
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25\uff01");
        }
        if (!BillStateEnum.COMMITED_STATE.getBillStateCode().equals(entity.getBillState()) && !BillStateEnum.PASSED_STATE.getBillStateCode().equals(entity.getBillState())) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(ContractEntity::getChangeId, (Object)entity.getId());
            updateWrapper.set(ContractEntity::getChangingMny, (Object)entity.getContractMny());
            updateWrapper.set(ContractEntity::getChangingTaxMny, (Object)entity.getContractTaxMny());
            updateWrapper.set(ContractEntity::getChangeCode, (Object)entity.getBillCode());
            updateWrapper.set(ContractEntity::getChangeVersion, (Object)entity.getChangeVersion());
            updateWrapper.set(ContractEntity::getChangeDate, (Object)entity.getChangeDate());
            updateWrapper.set(ContractEntity::getChangeDraftType, (Object)entity.getChangeDraftType());
            updateWrapper.set(ContractEntity::getChangeContractSignatureStatus, (Object)entity.getSignatureStatus());
            updateWrapper.set(ContractEntity::getChangeFileId, (Object)entity.getChangeFileId());
            updateWrapper.set(ContractEntity::getChangeContractName, (Object)entity.getContractName());
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getMainContractId());
            updateWrapper.set(ContractEntity::getChangeStatus, (Object)ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
            this.service.update((Wrapper)updateWrapper);
        } else if (DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().equals(entity.getChangeDraftType())) {
            this.changeService.effectiveSaveWriteContract(entity.getId(), BillTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c\u53d8\u66f4.getCode(), false);
        } else {
            entity.setCommitDate(new Date());
            this.changeService.saveOrUpdate((Object)entity, false);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(ContractEntity::getChangeStatus, (Object)ChangeStatusEnum.\u53d8\u66f4\u5355\u636e\u5ba1\u6279\u901a\u8fc7.getCode());
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getContractId());
            this.service.update((Wrapper)updateWrapper);
        }
        this.changeService.saveOrUpdate((Object)entity, false);
        return "\u4fdd\u5b58\u6210\u529f!";
    }
}

