/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.pro.rmat.bean.ContractEntity;
import com.ejianc.business.pro.rmat.enums.BillPushStatusEnum;
import com.ejianc.business.pro.rmat.enums.BillTypeEnum;
import com.ejianc.business.pro.rmat.enums.DraftTypeEnum;
import com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum;
import com.ejianc.business.pro.rmat.enums.SignatureStatusEnum;
import com.ejianc.business.pro.rmat.service.IContractAsyncService;
import com.ejianc.business.pro.rmat.service.IContractService;
import com.ejianc.business.pro.rmat.vo.ContractVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="contract")
public class ContractBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IContractService service;
    @Autowired
    private IContractAsyncService contractAsyncService;
    @Autowired
    ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IAttachmentApi attachmentApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ContractEntity entity = (ContractEntity)((Object)this.service.selectById(billId));
        if (entity != null && DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().equals(entity.getDraftType()) && null == entity.getContractFileId()) {
            return CommonResponse.error((String)"\u8bf7\u7f16\u8f91\u5408\u540c\u6587\u4ef6\u5e76\u4fdd\u5b58\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ContractEntity e = (ContractEntity)((Object)this.service.selectById(billId));
        if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().equals(e.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().equals(e.getDraftType())) {
            if (null == e.getContractFileId()) {
                return CommonResponse.error((String)"\u8bf7\u7f16\u8f91\u5408\u540c\u6587\u4ef6\u5e76\u4fdd\u5b58\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
            }
            if (!e.getContractFileSyncFlag().booleanValue()) {
                return CommonResponse.error((String)"\u8bf7\u91cd\u65b0\u8fdb\u884c\u5408\u540c\u7f16\u8f91\uff0c\u540c\u6b65\u5355\u636e\u4fe1\u606f\u5230\u5408\u540c\u6587\u4ef6\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        ContractEntity e = (ContractEntity)((Object)this.service.selectById(billId));
        this.logger.info("\u5ba1\u6279\u8282\u70b9\u5ba1\u6279\u4e2d\u65f6\u8282\u70b9\u5ba1\u6279\u524d\u56de\u8c03:  \u5f53\u524d\u6570\u636e-{}", (Object)JSONObject.toJSONString((Object)((Object)e)));
        if ((DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().equals(e.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().equals(e.getDraftType())) && !e.getContractFileSyncFlag().booleanValue()) {
            return CommonResponse.error((String)"\u8bf7\u91cd\u65b0\u8fdb\u884c\u5408\u540c\u7f16\u8f91\uff0c\u540c\u6b65\u5355\u636e\u4fe1\u606f\u5230\u5408\u540c\u6587\u4ef6\uff01");
        }
        return CommonResponse.success((String)"\u5ba1\u6279\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        Boolean pushResult;
        ContractEntity entity = (ContractEntity)((Object)this.service.selectById(billId));
        if (entity != null) {
            if (DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().equals(entity.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().equals(entity.getDraftType())) {
                entity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
                entity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
            }
            if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().equals(entity.getDraftType()) && null == entity.getContractFileId()) {
                return CommonResponse.error((String)"\u8bf7\u7f16\u8f91\u5408\u540c\u6587\u4ef6\u5e76\u4fdd\u5b58\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
            }
            if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().equals(entity.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().equals(entity.getDraftType())) {
                if (null == entity.getContractFileId()) {
                    return CommonResponse.error((String)"\u8bf7\u7f16\u8f91\u5408\u540c\u6587\u4ef6\u5e76\u4fdd\u5b58\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
                }
                if (!entity.getContractFileSyncFlag().booleanValue()) {
                    return CommonResponse.error((String)"\u8bf7\u91cd\u65b0\u8fdb\u884c\u5408\u540c\u7f16\u8f91\uff0c\u540c\u6b65\u5355\u636e\u4fe1\u606f\u5230\u5408\u540c\u6587\u4ef6\uff01");
                }
            }
        }
        if ((pushResult = this.service.pushBillToSupCenter(entity)).booleanValue()) {
            entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        } else {
            this.logger.error("\u5355\u636e-{}id-{}\u63a8\u9001\u4f9b\u5e94\u5546\u670d\u52a1\u5931\u8d25", (Object)BillTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getName(), (Object)billId);
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        Boolean pushResult2 = this.service.pushContract((ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class));
        if (pushResult2.booleanValue()) {
            entity.setPushPoolFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        } else {
            entity.setPushPoolFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        CommonResponse response = this.paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        Assert.hasText((String)valueData, (String)"\u83b7\u53d6\u7684\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        if ("0".equals(valueData)) {
            WatermarkVO watermarkVO = this.signatureCommonApi.fetchWatermarkConfig(entity.getContractFileId(), entity.getId(), entity.getBillCode(), BillTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getCode(), "prormatContract");
            Assert.notNull((Object)watermarkVO, (String)"\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u5931\u8d25!");
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));
            this.contractAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
        }
        this.checkContractFile(entity);
        this.service.saveOrUpdate((Object)entity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        boolean delWatermarkflag;
        boolean pushResult;
        ContractEntity contractEntitiy = (ContractEntity)((Object)this.service.selectById(billId));
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u9000\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u64a4\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u8fc7\u671f.getCode());
        if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().equals(contractEntitiy.getDraftType()) || DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().equals(contractEntitiy.getDraftType())) {
            if (!statusList.contains(contractEntitiy.getSignatureStatus())) {
                return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u6709\u7b7e\u7ae0\u6d41\u7a0b\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
            }
        } else if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractEntitiy.getSignatureStatus())) {
            contractEntitiy.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        }
        if (PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().equals(contractEntitiy.getPerformanceStatus())) {
            contractEntitiy.setPerformanceStatus(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode());
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(contractEntitiy.getBillPushFlag()) && !(pushResult = this.service.delPushBill(contractEntitiy).booleanValue())) {
            return CommonResponse.error((String)"\u5f03\u5ba1\u56de\u8c03\u5931\u8d25\uff0c\u5355\u636e\u4f5c\u5e9f\u534f\u540c\u670d\u52a1\u5931\u8d25\uff01");
        }
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntitiy.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntitiy.getBillState())) {
            boolean delResult = this.service.delContractFromPool(contractEntitiy.getId());
            if (!delResult) {
                this.logger.error("\u5355\u636e-\u3010{}\u3011\u4ece\u5408\u540c\u6c60\u5220\u9664\u5931\u8d25\uff01", (Object)JSONObject.toJSONString((Object)((Object)contractEntitiy)));
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e\u4ece\u5408\u540c\u6c60\u5220\u9664\u5931\u8d25\uff01");
            }
            contractEntitiy.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().equals(contractEntitiy.getDraftType()) || DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.equals((Object)contractEntitiy.getDraftType())) {
                contractEntitiy.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
            }
        }
        if (contractEntitiy.getWatermarkContractFileId() != null && (delWatermarkflag = this.service.delWatermarkContractFile(contractEntitiy.getWatermarkContractFileId()))) {
            contractEntitiy.setWatermarkContractFileId(null);
        }
        this.service.saveOrUpdate((Object)contractEntitiy, false);
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }

    private void checkContractFile(ContractEntity contractEntity) {
        CommonResponse attachResp = this.attachmentApi.queryDetail(contractEntity.getContractFileId().toString());
        if (!attachResp.isSuccess() || null == attachResp.getData()) {
            this.logger.info("\u5408\u540c\u5b58\u50a8\u6587\u4ef6Id-{}\u5728\u6587\u4ef6\u4e2d\u5fc3\u4e0d\u5b58\u5728\uff0c\u6839\u636e\u53c2\u6570sourceId-{}, sourceType-{}, billType-{} \u67e5\u8be2\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f", new Object[]{contractEntity.getContractFileId(), contractEntity.getId(), "2".equals(contractEntity.getDraftType()) || "3".equals(contractEntity.getDraftType()) ? "rmatContractFile" : "contractFile", BillTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getCode()});
            CommonResponse attachListResp = this.attachmentApi.queryListBySourceId(contractEntity.getId(), BillTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getCode(), "2".equals(contractEntity.getDraftType()) || "3".equals(contractEntity.getDraftType()) ? "rmatContractFile" : "contractFile", "desc");
            this.logger.info("\u6839\u636e\u53c2\u6570sourceId-{}, sourceType-{}, billType-{} \u67e5\u8be2\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u7ed3\u679c\uff1a{}", new Object[]{contractEntity.getId(), "2".equals(contractEntity.getDraftType()) || "3".equals(contractEntity.getDraftType()) ? "rmatContractFile" : "contractFile", BillTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getCode(), JSONObject.toJSONString((Object)attachListResp)});
            if (attachListResp.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)attachListResp.getData()))) {
                AttachmentVO attachmentVO = (AttachmentVO)((List)attachListResp.getData()).get(0);
                this.logger.info("\u5c06\u5408\u540cid-{}\u5bf9\u5e94\u5408\u540c\u6587\u4ef6Id-{}\u6539\u4e3a{}", new Object[]{contractEntity.getId(), contractEntity.getContractFileId(), attachmentVO.getId()});
                contractEntity.setContractFileId(attachmentVO.getId());
                contractEntity.setContractFilePath(attachmentVO.getTruePath());
            } else {
                throw new BusinessException("\u5ba1\u6279\u5931\u8d25\uff0c\u83b7\u53d6\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u5931\u8d25, \u8bf7\u68c0\u67e5\u5408\u540c\u6587\u4ef6\uff01");
            }
        }
    }
}

