package com.ejianc.business.common;

import java.util.HashMap;
import java.util.Map;

public class CommonConstant {

    public static final String ORDER_RECEIVE_WAIT = "0"; //待接收
    public static final String ORDER_RECEIVE_ALL = "1"; //全部接收
    public static final String ORDER_RECEIVE_PART = "2"; //部分接收
    public static final String ORDER_RECEIVE_NOT = "3"; //不予接收
    
    public static final Integer UN_OCCUPY_STATE = 0; // 定标结果未占用状态
    public static final Integer OCCUPY_STATE = 1; // 定标结果占用状态

    public static final String NO = "0";
    public static final String YES = "1";

    public static final Map<String,String> ORDER_RECEIVE_STATE = new HashMap(); //接收状态（0-待接收，1-全部接收，2-部分接受，3-不予接收）

    static {
        ORDER_RECEIVE_STATE.put(ORDER_RECEIVE_WAIT,"待接收");
        ORDER_RECEIVE_STATE.put(ORDER_RECEIVE_ALL,"全部接收");
        ORDER_RECEIVE_STATE.put(ORDER_RECEIVE_PART,"部分接受");
        ORDER_RECEIVE_STATE.put(ORDER_RECEIVE_NOT,"不予接收");
    }


    public static final String ORDER_DELIVER_WAIT = "1"; //待送货
    public static final String ORDER_DELIVER_ALL = "2"; //全部送货
    public static final String ORDER_DELIVER_PART = "3"; //部分送货

    public static final Map<String,String> ORDER_DELIVER_STATE = new HashMap(); //送货状态（1-待送货，2-全部送货，3-部分送货）

    static {
        ORDER_DELIVER_STATE.put(ORDER_DELIVER_WAIT,"待送货");
        ORDER_DELIVER_STATE.put(ORDER_DELIVER_ALL,"全部送货");
        ORDER_DELIVER_STATE.put(ORDER_DELIVER_PART,"部分送货");
    }

    public static final String ORDER_DISABLE_YES = "1"; //是
    public static final String ORDER_DISABLE_NO = "0"; //否

    public static final Map<String,String> ORDER_DISABLE_STATE = new HashMap(); //关闭状态（1-是，0-否）

    static {
        ORDER_DISABLE_STATE.put(ORDER_DISABLE_YES,"是");
        ORDER_DISABLE_STATE.put(ORDER_DISABLE_NO,"否");
    }


    public static final String CONTRACT_RENT_CALCULATION_TYPE_DAILY = "0"; //日租
    public static final String CONTRACT_RENT_CALCULATION_TYPE_MONTH = "1"; //月租
    public static final String CONTRACT_RENT_CALCULATION_TYPE_NUM = "2"; //工程量租

    public static final Map<String,String> CONTRACT_RENT_CALCULATION_TYPE = new HashMap(); //合同租赁方式(0-日租，1-月租，2-工程量租)

    static {
        CONTRACT_RENT_CALCULATION_TYPE.put(CONTRACT_RENT_CALCULATION_TYPE_DAILY,"日租");
        CONTRACT_RENT_CALCULATION_TYPE.put(CONTRACT_RENT_CALCULATION_TYPE_MONTH,"月租");
        CONTRACT_RENT_CALCULATION_TYPE.put(CONTRACT_RENT_CALCULATION_TYPE_NUM,"工程量租");
    }

    public static final String DELIVERY_ACCEPTANCE_WAIT = "0"; //待验收
    public static final String DELIVERY_ACCEPTANCE_PART = "1"; //部分验收
    public static final String DELIVERY_ACCEPTANCE_ALL = "2"; //全部验收

    public static final Map<String,String> DELIVERY_ACCEPTANCE_MAP = new HashMap(); //送货单验收状态(0-待验收，1-部分验收，2-全部验收)

    static {
        DELIVERY_ACCEPTANCE_MAP.put(DELIVERY_ACCEPTANCE_WAIT,"待验收");
        DELIVERY_ACCEPTANCE_MAP.put(DELIVERY_ACCEPTANCE_PART,"部分验收");
        DELIVERY_ACCEPTANCE_MAP.put(DELIVERY_ACCEPTANCE_ALL,"全部验收");
    }


    public static final String CHECK_SOURCE_ZZ = "0"; //自制
    public static final String CHECK_SOURCE_YS = "1"; //验收


}
