package com.ejianc.business.pro.ownrmat.controller;

import java.io.Serializable;

import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.store.vo.UseMaterialPriceVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.ownrmat.bean.HandleEntity;
import com.ejianc.business.pro.ownrmat.service.IHandleService;
import com.ejianc.business.pro.ownrmat.vo.HandleVO;

/**
 * 周转材处置
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("handle")
public class HandleController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;


    @Autowired
    private IHandleService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IStoreManageApi storeManageApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<HandleVO> saveOrUpdate(@RequestBody HandleVO saveOrUpdateVO) {
        return service.saveOrUpdate(saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<HandleVO> queryDetail(Long id) {
        HandleEntity entity = service.selectById(id);
        HandleVO vo = BeanMapper.map(entity, HandleVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<HandleVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (HandleVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.myRemoveByIds(vos.stream().map(HandleVO::getId).collect(Collectors.toList()));
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<HandleVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        param.setFuzzyFields(Arrays.asList("billCode", "storeName", "projectName","materialTypes"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        //查询本下范围内日的合同
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(orgId);
        if(!orgResp.isSuccess()) {
            logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
            return CommonResponse.error("查询失败，获取组织信息失败！");
        }
        List<Long> orgIdList = orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdList));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<HandleEntity> page = service.queryPage(param,false);
        IPage<HandleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), HandleVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.setFuzzyFields(Arrays.asList("billCode", "storeName", "projectName","materialTypes"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        //查询本下范围内日的合同
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(orgId);
        if(!orgResp.isSuccess()) {
            logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
        }
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<HandleEntity> list = service.queryList(param);
        List<HandleVO> handleVOS = BeanMapper.mapList(list, HandleVO.class);
        handleVOS.forEach(item->{
            item.setBillStateName(BillStateEnum.getEnumByStateCode(item.getBillState()).getDescription());
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", handleVOS);
        ExcelExport.getInstance().export("handleExport.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refHandleData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<HandleVO>> refHandleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<HandleEntity> page = service.queryPage(param,false);
        IPage<HandleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), HandleVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

     //获取原值/净值
    @RequestMapping(value = "/getMaterialPrice", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<UseMaterialPriceVO>> getMaterialPrice(@RequestBody HandleVO vo){
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<FlowVO> flowVOS = new ArrayList<>();
        storeManageVO.setStoreId(vo.getProjectId());
        if (vo.getId() != null){
            storeManageVO.setSourceId(vo.getId());
        }
        vo.getHandleSubList().forEach(e->{
            FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.周转材材料处置, 0);
            flowVO.setStoreId(vo.getProjectId());
            flowVO.setStoreName(vo.getProjectName());
            flowVO.setProjectId(vo.getProjectId());
            flowVO.setProjectName(vo.getProjectName());
            flowVO.setOrgId(vo.getOrgId());
            flowVO.setOrgName(vo.getOrgName());
            flowVO.setParentOrgId(vo.getParentOrgId());
            flowVO.setParentOrgName(vo.getParentOrgName());
            flowVO.setEmployeeId(vo.getEmployeeId());
            flowVO.setEmployeeName(vo.getEmployeeName());
            flowVO.setMaterialCategoryId(e.getMaterialCategoryId());
            flowVO.setMaterialCategoryName(e.getMaterialCategoryName());
            flowVO.setMaterialId(e.getMaterialId());
            flowVO.setMaterialName(e.getMaterialName());
            flowVO.setMaterialSpec(e.getSpec());
            flowVO.setMaterialUnitId(e.getUnit());
            flowVO.setMaterialUnitName(e.getUnitName());
            flowVO.setNum(e.getHandleNum());
            flowVO.setSourceId(vo.getId());
            flowVO.setSourceDetailId(e.getId());
            flowVO.setSourceBillCode(vo.getBillCode());
            flowVO.setSourceBillDate(vo.getHandleDate());
            flowVO.setRowState(e.getRowState());
            flowVOS.add(flowVO);
        });
        storeManageVO.setFlowVOList(flowVOS);
        List<UseMaterialPriceVO> list = new ArrayList<>();
        CommonResponse<StoreManageVO> response = storeManageApi.turnSurplusMaterialPrice(storeManageVO);
        if (response.getData() != null){
            list = response.getData().getUseMaterialPriceVOList();
            return CommonResponse.success("原值单价/净值获取成功",list);
        }
        return CommonResponse.success(response.getMsg());
    }

    /**
     * 成本改造
     * 关联保存接口
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<HandleVO> pushCost(@RequestBody HandleVO vo) {
        return service.pushCost(vo);
    }
}
