package com.ejianc.business.pro.ownrmat.controller;

import java.io.Serializable;

import com.ejianc.business.pro.ownrmat.vo.OwnDetailVO;
import com.ejianc.business.pro.rmat.utils.PageUtil;
import com.ejianc.business.pro.rmat.vo.TotalPlanDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.ownrmat.bean.OwnEntity;
import com.ejianc.business.pro.ownrmat.service.IOwnService;
import com.ejianc.business.pro.ownrmat.vo.OwnVO;

/**
 * 自有材料摊销
 *
 * @author generator
 */
@Controller
@RequestMapping("own")
public class OwnController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IOwnService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OwnVO> saveOrUpdate(@RequestBody OwnVO saveOrUpdateVO) {
        OwnVO vo = service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OwnVO> queryDetail(Long id) {
        OwnVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OwnVO> vos) {
        service.removeByIds(vos.stream().map(OwnVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OwnVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<OwnEntity> page = service.queryPage(param, false);
        IPage<OwnVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OwnVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        List<OwnEntity> entityList = service.queryList(param);
        List<OwnVO> list = BeanMapper.mapList(entityList, OwnVO.class);
        list.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Own-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refOwnData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OwnVO>> refOwnData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                   String condition,
                                                   String searchObject,
                                                   String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OwnEntity> page = service.queryPage(param, false);
        IPage<OwnVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OwnVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @Description 查材料明细
     * @Return void
     */
    @RequestMapping(value = "/refAmortizationList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<OwnDetailVO>> refAmortizationList(@RequestParam(value = "projectId") Long projectId,
                                                                 @RequestParam(value = "orgId") Long orgId,
                                                                 @RequestParam(value = "amortizationCycle") String amortizationCycle) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        return CommonResponse.success("自有材料摊销清单查询成功！", service.refAmortizationList(param, orgId,amortizationCycle));
    }

    /**
     * @Description 查材料明细参照
     * @Return void
     */
    @RequestMapping(value = "/refAmortizationPage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OwnDetailVO>> refAmortizationPage(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                                  @RequestParam(defaultValue = "10") Integer pageSize,
                                                                  @RequestParam(value = "searchText", required = false) String searchText,
                                                                  @RequestParam(value = "condition", required = false) String condition) {
        IPage<OwnDetailVO> page = new Page<>();
        List<OwnDetailVO> records = new ArrayList<>();
        QueryParam param = new QueryParam();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        param.setSearchText(searchText);

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            } else {
                page.setTotal(0);
            }

            if (null != conditionMap.get("amortizationCycle") && null != conditionMap.get("orgId")) {
                String amortizationCycle = conditionMap.get("amortizationCycle").toString();
                Long orgId = Long.valueOf(conditionMap.get("orgId").toString());
                List<OwnDetailVO> ownDetailVOS = service.refAmortizationList(param, orgId,amortizationCycle);
                records = PageUtil.listToPage(ownDetailVOS, pageNumber, pageSize);
                page.setTotal(ownDetailVOS.size());
            } else {
                page.setTotal(0);
            }

        } else {
            page.setTotal(0);
        }
        page.setRecords(records);
        page.setCurrent(pageNumber);
        page.setSize(pageSize);

        return CommonResponse.success("查询参照数据成功！", page);
    }
    /**
     * 查上次摊销周期
     */
    @RequestMapping(value = "/getLastAmortizationCycle", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> getLastAmortizationCycle(Long projectId) {
        String lastAmortizationCycle = service.getLastAmortizationCycle(projectId,null);
        return CommonResponse.success("查询上次摊销周期成功！", lastAmortizationCycle);
    }
    /**
     * 成本改造
     * 关联保存接口
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OwnVO> pushCost(@RequestBody OwnVO vo) {
        return CommonResponse.success("关联保存成功！",service.pushCost(vo));
    }

}
