package com.ejianc.business.pro.ownrmat.controller.api;

import com.ejianc.business.pro.ownrmat.bean.AmortizationEntity;
import com.ejianc.business.pro.ownrmat.service.IAmortizationService;
import com.ejianc.business.pro.ownrmat.vo.AmortizationVO;
import com.ejianc.business.pro.ownrmat.vo.ResidualVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/api/amortization/")
@Api(value = "周转材摊销比例设置API接口", tags = {"周转材摊销比例设置API接口"})
public class AmortizationApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAmortizationService service;

    @ApiOperation("周转材摊销比例设置查询")
    @RequestMapping(value = "/getResidualRate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<Long,AmortizationVO>> getResidualRate(@RequestBody ResidualVO vo) {
        Map<Long,AmortizationEntity> rateMap = service.getResidualRate(vo);
        Map<Long, AmortizationVO> map = new HashMap<>();
        for(Long mid : rateMap.keySet()){
            AmortizationEntity entity = rateMap.get(mid);
            map.put(mid,BeanMapper.map(entity,AmortizationVO.class));
        }
        return CommonResponse.success("残值率查询成功！",map);
    }
}
