package com.ejianc.business.pro.ownrmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.assist.store.api.IAmAllotApi;
import com.ejianc.business.pro.ownrmat.api.IRmatAllotApi;
import com.ejianc.business.pro.ownrmat.bean.AllotInDetailEntity;
import com.ejianc.business.pro.ownrmat.bean.AllotInEntity;
import com.ejianc.business.pro.ownrmat.bean.AllotOutEntity;
import com.ejianc.business.pro.ownrmat.consts.NoticeEnum;
import com.ejianc.business.pro.ownrmat.service.AllotInMessageService;
import com.ejianc.business.pro.ownrmat.service.IAllotInService;
import com.ejianc.business.pro.ownrmat.service.IAllotOutService;
import com.ejianc.business.pro.ownrmat.service.IValidateService;
import com.ejianc.business.pro.ownrmat.vo.AllotInVO;
import com.ejianc.business.pro.ownrmat.vo.AllotOutVO;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.AllocationState;

import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Service("allotOut") 
public class AllotOutBpmServiceImpl implements ICommonBusinessService {


	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IAllotOutService service;
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IAllotInService allotInService;

	private static final String BILL_CODE = "PRO_RMAT_ALLOT_IN";//此处需要根据实际修改
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private JedisPool jedisPool;
	@Autowired
	private IStoreManageApi storeManageApi;

	@Autowired
	private IValidateService validateService;


	@Autowired
	private AllotInMessageService allotInMessageService;

	@Autowired
	private IAmAllotApi amAllotApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		AllotOutEntity allotOutEntity = service.selectById(billId);
		AllotOutVO allotOutVO = BeanMapper.map(allotOutEntity, AllotOutVO.class);
		validateService.validateAllotOut(allotOutVO);
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//加锁防止生成多个调拨入库
		Jedis jedis = jedisPool.getResource();
		boolean locked = false;
		locked = RedisTool.tryLock(jedis, String.valueOf(billId), "generateAllotIn", 1000);
		if(locked) {
			RedisTool.releaseLock(jedis, String.valueOf(billId), "generateAllotIn");
		}
		locked = RedisTool.tryLock(jedis, String.valueOf(billId), "generateAllotIn", 1000);
		logger.info("判断单据单据锁结果------"+locked);
		if (locked){
			try{
				//更新流水
				AllotOutEntity allotOutEntity = service.selectById(billId);
				AllotOutVO allotOutVO = BeanMapper.map(allotOutEntity, AllotOutVO.class);
				StoreManageVO storeManageVO = allotOutVO.getStoreManageVO(allotOutVO);
				storeManageVO.setOutEffectiveON(true);
				CommonResponse<StoreManageVO> response = storeManageApi.inOutStore(storeManageVO);
				if(!response.isSuccess()) {
					throw new BusinessException("调用库存管理失败,错误信息：" + response.getMsg());
				}

				if (!Objects.isNull(allotOutEntity)){
					//提交 收料状态设置带收清空退回原因
					LambdaUpdateWrapper<AllotOutEntity> allotOutWrapper = new LambdaUpdateWrapper<>();
					allotOutWrapper.eq(AllotOutEntity::getId, billId);
					allotOutWrapper.set(AllotOutEntity::getReceiveState, Integer.parseInt(AllocationState.TO_RECEIVING.getCode()));
					allotOutWrapper.set(AllotOutEntity::getReturnReason,null);
					allotOutWrapper.set(AllotOutEntity::getReceiverPersonId,null);
					allotOutWrapper.set(AllotOutEntity::getReceiverPerson,null);
					service.update(allotOutWrapper);

					if ("1".equals(allotOutEntity.getInAllocaScope())){
						com.ejianc.business.assist.store.vo.AllotOutVO vo = BeanMapper.map(allotOutEntity, com.ejianc.business.assist.store.vo.AllotOutVO.class);
						CommonResponse<String> resp = amAllotApi.amCreateAllotIn(vo);
						if (!resp.isSuccess()&&resp.getData()!=null){
							throw new BusinessException("周转材租赁生成调出单失败！");
						}
					}else{
						AllotOutVO vo = BeanMapper.map(allotOutEntity, AllotOutVO.class);
						String msg = service.rmatCreateAllotIn(vo);
						if (null != msg){
							throw new BusinessException(msg);
						}
					}

					logger.info("推送成本---");
					service.costPush(allotOutEntity);
				}
			}catch (Exception e){
				e.printStackTrace();
			} finally {
				if(locked) {
					RedisTool.releaseLock(jedis, String.valueOf(billId), "generateAllotIn");
				}
				jedis.close();
			}
		} else{
			return CommonResponse.error("出现并发操作,请稍后重试！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(!res.isSuccess()) {//单据未被下游单据引用
			return CommonResponse.error(res.getMsg());
		}
		AllotOutEntity entity = service.selectById(billId);
		if (BillStateEnum.COMMITED_STATE.getBillStateCode() == entity.getBillState()|| BillStateEnum.PASSED_STATE.getBillStateCode() == entity.getBillState()){
			return CommonResponse.error("该单据已推送给调入方，不允许撤回！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("删除成本---");
		service.pullCost(billId);
		return CommonResponse.success();
	}

}
