package com.ejianc.business.pro.ownrmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.pro.ownrmat.bean.AllotInDetailEntity;
import com.ejianc.business.pro.ownrmat.bean.AllotInEntity;
import com.ejianc.business.pro.ownrmat.bean.AllotOutDetailEntity;
import com.ejianc.business.pro.ownrmat.bean.AllotOutEntity;
import com.ejianc.business.pro.ownrmat.consts.NoticeEnum;
import com.ejianc.business.pro.ownrmat.service.AllotInMessageService;
import com.ejianc.business.pro.ownrmat.service.IAllotInService;
import com.ejianc.business.pro.ownrmat.utils.MaterialConstant;
import com.ejianc.business.pro.ownrmat.vo.AllotInVO;
import com.ejianc.business.pro.ownrmat.vo.AllotOutDetailVO;
import com.ejianc.business.pro.ownrmat.vo.AllotOutExportVO;
import com.ejianc.business.pro.ownrmat.vo.AllotOutVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.AllocatEnum;
import com.ejianc.business.store.consts.AllocationState;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.store.vo.UseMaterialPriceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.google.gson.JsonObject;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.ownrmat.mapper.AllotOutMapper;
import com.ejianc.business.pro.ownrmat.service.IAllotOutService;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 周转材调出
 * 
 * @author generator
 * 
 */
@Service("allotOutService")
public class AllotOutServiceImpl extends BaseServiceImpl<AllotOutMapper, AllotOutEntity> implements IAllotOutService{

    public static String NOT_CHANGE = "材料出库明细数量没有变化,仓库无需处理!";

    @Autowired
    private IAllotOutService service;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IStoreManageApi storeManageApi;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ICostDetailApi costDetailApi;

    @Autowired
    private SessionManager sessionManager;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    private static final String BILL_CODE = "PRO_RMAT_ALLOT_OUT";//此处需要根据实际修改
    private static final String BILL_NAME = MaterialConstant.周转材调出;




    private static final String IN_BILL_CODE = "PRO_RMAT_ALLOT_IN";//此处需要根据实际修改
    @Autowired
    private IAllotInService allotInService;
    @Autowired
    private AllotInMessageService allotInMessageService;


    @Override
    public CommonResponse<UseMaterialPriceVO> turnSurplusMaterialPrice(AllotOutVO saveOrUpdateVO) {

        AllotOutDetailVO allotOutDetailVO = saveOrUpdateVO.getAllotOutDetailList().get(0);
        FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.周转材调拨出库, StoreCommonConsts.NO);


        flowVO.setRowState(allotOutDetailVO.getRowState());
        flowVO.setProjectId(saveOrUpdateVO.getProjectId());
        flowVO.setProjectName(saveOrUpdateVO.getProjectName());
        flowVO.setParentOrgId(saveOrUpdateVO.getParentOrgId());
        flowVO.setParentOrgCode(saveOrUpdateVO.getParentOrgCode());
        flowVO.setParentOrgName(saveOrUpdateVO.getParentOrgName());
        flowVO.setOrgId(saveOrUpdateVO.getOrgId());
        flowVO.setOrgName(saveOrUpdateVO.getOrgName());
        flowVO.setStoreId(saveOrUpdateVO.getStoreId());
        flowVO.setStoreName(saveOrUpdateVO.getStoreName());
        flowVO.setMaterialId(allotOutDetailVO.getMaterialId());
        flowVO.setMaterialName(allotOutDetailVO.getMaterialName());
        flowVO.setMaterialCategoryId(allotOutDetailVO.getMaterialCategoryId());
        flowVO.setMaterialCategoryName(allotOutDetailVO.getMaterialCategoryName());
        flowVO.setMaterialSpec(allotOutDetailVO.getMaterialSpec());
        flowVO.setMaterialUnitId(allotOutDetailVO.getMaterialUnitId());
        flowVO.setMaterialUnitName(allotOutDetailVO.getMaterialUnit());
        flowVO.setNum(allotOutDetailVO.getAllocatNum());

        StoreManageVO storeManageVO = new StoreManageVO();
        storeManageVO.setStoreId(saveOrUpdateVO.getStoreId());
        storeManageVO.setSourceId(saveOrUpdateVO.getId());
        List<FlowVO> flowVOList = new ArrayList<>();
        flowVOList.add(flowVO);
        storeManageVO.setFlowVOList(flowVOList);

        CommonResponse<StoreManageVO> commonResponse = storeManageApi.turnSurplusMaterialPrice(storeManageVO);
        if (commonResponse.isSuccess()&&commonResponse.getData()!=null){
            return CommonResponse.success("原值单价、净值金额获取成功",commonResponse.getData().getUseMaterialPriceVOList().get(0));
        }
        if (NOT_CHANGE.equals(commonResponse.getMsg())){
            return CommonResponse.success();
        }
        return CommonResponse.error(commonResponse.getMsg());
    }



    @Override
    public CommonResponse<AllotOutVO> allotOutSaveOrUpdate(AllotOutVO saveOrUpdateVO) {

        //validateService.validateProject(saveOrUpdateVO.getProjectId(), MaterialConstant.周转材调出,saveOrUpdateVO.getId(),MaterialConstant.保存);

        //validateService.validateAllotOut(saveOrUpdateVO);

        //保存修改
        AllotOutEntity entity = BeanMapper.map(saveOrUpdateVO, AllotOutEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setRelationFlag("0");// 关联状态初始化
        entity.setProportionFlag("0");// 分摊状态初始化
        boolean b = service.saveOrUpdate(entity, false);


        //生成出库流水 生成
        if (b){
            if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getAllotOutDetailList())) {
                //调用库存
                StoreManageVO storeManageVO = new StoreManageVO();
                storeManageVO.setStoreId(saveOrUpdateVO.getStoreId());
                storeManageVO.setSourceId(entity.getId());
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.周转材调拨出库);
                storeManageVO.setOutEffectiveON(false);
                ArrayList<FlowVO> flowVOS = new ArrayList<>();
                //删除的数据
                saveOrUpdateVO.getAllotOutDetailList().forEach(t->{
                    if("del".equals(t.getRowState())){
                        FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.周转材调拨出库, 0);
                        flowVO.setStoreId(entity.getStoreId());
                        flowVO.setStoreName(entity.getStoreName());
                        flowVO.setProjectId(entity.getProjectId());
                        flowVO.setProjectName(entity.getProjectName());
                        flowVO.setOrgId(entity.getOrgId());
                        flowVO.setOrgName(entity.getOrgName());
                        flowVO.setParentOrgId(entity.getParentOrgId());
                        flowVO.setParentOrgName(entity.getParentOrgName());
                        flowVO.setEmployeeId(entity.getEmployeeId());
                        flowVO.setEmployeeName(entity.getEmployeeName());
                        flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                        flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                        flowVO.setMaterialId(t.getMaterialId());
                        flowVO.setMaterialName(t.getMaterialName());
                        flowVO.setMaterialSpec(t.getMaterialSpec());
                        flowVO.setMaterialUnitId(t.getMaterialUnitId());
                        flowVO.setMaterialUnitName(t.getMaterialName());
                        flowVO.setSourceBillDetailRemark(t.getMemo());
                        flowVO.setTaxPrice(t.getAllocatTaxPrice());
                        flowVO.setPrice(t.getAllocatPrice());
                        flowVO.setNum(t.getAllocatNum());
                        flowVO.setTaxMny(t.getAllocatTaxMny());
                        flowVO.setMny(t.getAllocatMny());
                        flowVO.setTax(t.getAllocatTax());

                        flowVO.setSourceId(entity.getId());
                        flowVO.setSourceDetailId(t.getId());
                        flowVO.setSourceBillCode(entity.getBillCode());
                        flowVO.setSourceBillDate(entity.getOutDate());
                        flowVO.setRowState(t.getRowState());
                        flowVO.setSourceBillRemark(entity.getMemo());
                        flowVO.setPurchasePrice(t.getOriginalValuePrice());
                        flowVO.setPurchaseTaxPrice(t.getOriginalValueTaxPrice());
                        flowVOS.add(flowVO);
                    }
                });
                //新增修改的数据
                entity.getAllotOutDetailList().forEach(t->{
                    FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.周转材调拨出库,0);
                    flowVO.setStoreId(entity.getStoreId());
                    flowVO.setStoreName(entity.getStoreName());
                    flowVO.setProjectId(entity.getProjectId());
                    flowVO.setProjectName(entity.getProjectName());
                    flowVO.setOrgId(entity.getOrgId());
                    flowVO.setOrgName(entity.getOrgName());
                    flowVO.setParentOrgId(entity.getParentOrgId());
                    flowVO.setParentOrgName(entity.getParentOrgName());
                    flowVO.setEmployeeId(entity.getEmployeeId());
                    flowVO.setEmployeeName(entity.getEmployeeName());
                    flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                    flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                    flowVO.setMaterialId(t.getMaterialId());
                    flowVO.setMaterialName(t.getMaterialName());
                    flowVO.setMaterialSpec(t.getMaterialSpec());
                    flowVO.setMaterialUnitId(t.getMaterialUnitId());
                    flowVO.setMaterialUnitName(t.getMaterialName());
                    flowVO.setSourceBillDetailRemark(t.getMemo());
                    flowVO.setTaxPrice(t.getAllocatTaxPrice());
                    flowVO.setPrice(t.getAllocatPrice());
                    flowVO.setNum(t.getAllocatNum());
                    flowVO.setTaxMny(t.getAllocatTaxMny());
                    flowVO.setMny(t.getAllocatMny());
                    flowVO.setTax(t.getAllocatTax());

                    flowVO.setSourceId(entity.getId());
                    flowVO.setSourceDetailId(t.getId());
                    flowVO.setSourceBillCode(entity.getBillCode());
                    flowVO.setSourceBillDate(entity.getOutDate());
                    flowVO.setRowState(t.getRowState());
                    flowVO.setSourceBillRemark(entity.getMemo());
                    flowVO.setPurchasePrice(t.getOriginalValuePrice());
                    flowVO.setPurchaseTaxPrice(t.getOriginalValueTaxPrice());
                    flowVOS.add(flowVO);
                });
                storeManageVO.setFlowVOList(flowVOS);

                CommonResponse<StoreManageVO> response = storeManageApi.inOutStore(storeManageVO);
                if(!response.isSuccess()) {
                    throw new BusinessException("调用库存管理失败,错误信息："+response.getMsg());
                }
            }

        }
        AllotOutVO vo = BeanMapper.map(entity, AllotOutVO.class);
        return CommonResponse.success("保存修改成功", vo);
    }

    @Override
    public CommonResponse<String> allotOutDelete(List<AllotOutVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AllotOutVO vo : vos) {
                AllotOutEntity allotOutEntity = service.selectById(vo.getId());
                if (CollectionUtils.isNotEmpty(allotOutEntity.getAllotOutDetailList())){
                    StoreManageVO storeManageVO = new StoreManageVO();
                    storeManageVO.setStoreId(allotOutEntity.getStoreId());
                    storeManageVO.setSourceId(allotOutEntity.getId());
                    storeManageVO.setInOutTypeEnum(InOutTypeEnum.周转材调拨出库);
                    storeManageVO.setOutEffectiveON(false);
                    ArrayList<Long> longs = new ArrayList<>();
                    longs.add(allotOutEntity.getId());
                    storeManageVO.setSourceIdsForRollBack(longs);
                    CommonResponse<StoreManageVO> response = storeManageApi.inOutStoreRollback(storeManageVO);
                    if(!response.isSuccess()) {
                        throw new BusinessException("调用库存管理失败,错误信息："+response.getMsg());
                    }
                }
            }
        }

        boolean b = service.removeByIds(vos.stream().map(AllotOutVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public void excelExport(QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialNames");
        fuzzyFields.add("inProjectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("receiverPerson");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<AllotOutEntity> list = service.queryList(param);
        List<AllotOutExportVO> allotOutVos = BeanMapper.mapList(list, AllotOutExportVO.class);
        allotOutVos.forEach(vo -> {
            if (vo.getOutDate() != null) {
                vo.setAllocatDate(DateFormatUtil.formatDate("yyyy-MM-dd", vo.getOutDate()));
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            if (vo.getReceiveState() != null) {
                if (Integer.valueOf(AllocationState.TO_RECEIVING.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.TO_RECEIVING.getDescription());
                } else if (Integer.valueOf(AllocationState.RECEIVED.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.RECEIVED.getDescription());
                } else if (Integer.valueOf(AllocationState.REJECT.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.REJECT.getDescription());
                }
            }
            if (vo.getAllocatType() != null) {
                if (Integer.valueOf(AllocatEnum.ASSETS.getCode()).equals(vo.getAllocatType())) {
                    vo.setAllocatTypeName(AllocatEnum.ASSETS.getDescription());
                } else {
                    vo.setAllocatTypeName(AllocatEnum.HOMEMADE.getDescription());
                }
            }
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", allotOutVos);
        ExcelExport.getInstance().export("allocationOutExport.xlsx", beans, response);
    }

    @Override
    public CommonResponse<AllotOutVO> pushCost(AllotOutVO vo) {
        AllotOutEntity entity = baseMapper.selectById(vo.getId());
        if (CollectionUtils.isNotEmpty(vo.getAllotOutDetailList())) {
            List<AllotOutDetailEntity> allotOutList = BeanMapper.mapList(vo.getAllotOutDetailList(), AllotOutDetailEntity.class);
            entity.setAllotOutDetailList(allotOutList);
        }
        super.saveOrUpdate(entity, false);
        //推送数据
        this.costPush(entity);
        return CommonResponse.success(BeanMapper.map(entity, AllotOutVO.class));
    }

    @Override
    public void costPush(AllotOutEntity entity) {
        logger.info("开始costPush");
        List<AllotOutDetailEntity> allotOutList = entity.getAllotOutDetailList();
        String relationFlag = "1";
        if(CollectionUtils.isNotEmpty(allotOutList)){
            for(AllotOutDetailEntity detail : allotOutList){
                if(null == detail.getSubjectId() || null == detail.getWbsId()){
                    relationFlag = "0";
                    break;
                }
            }
        }
        if(CollectionUtils.isEmpty(allotOutList)){
            relationFlag = "0";
        }
        //更新是否关联
        LambdaUpdateWrapper<AllotOutEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(AllotOutEntity::getId, entity.getId());
        updateWrapper.set(AllotOutEntity::getRelationFlag, relationFlag);//(1:是，0：否)
        super.update(updateWrapper);

        //判断之前的单据是否关联
        String oldRelationFlag = entity.getRelationFlag();
        //之前已关联
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(relationFlag)) {
                saveCost(entity);
            }
            if (!"1".equals(relationFlag)) {
                //删除成本中心之前的数据
                logger.info("删除成本中心之前的数据-{}Id---{}", BILL_NAME, entity.getId());
                CommonResponse<String> commonResponse = costDetailApi.deleteSubject(entity.getId());
                logger.info("结果"+JSONObject.toJSONString(commonResponse));
                if(!commonResponse.isSuccess()){
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        //之前未关联
        if ("0".equals(oldRelationFlag)) {
            if ("1".equals(relationFlag)) {
                saveCost(entity);
            }
        }
    }

    private void saveCost(AllotOutEntity entity) {
        //明细
        List<CostDetailVO> costVOList = new ArrayList<>();
        List<AllotOutDetailEntity> allotOutList = entity.getAllotOutDetailList();
        if (CollectionUtils.isNotEmpty(allotOutList)) {
            for (AllotOutDetailEntity detail : allotOutList) {
                CostDetailVO costVO = new CostDetailVO();
                costVO.setSubjectId(detail.getSubjectId());
                costVO.setSubjectCode(detail.getSubjectCode());
                costVO.setSubjectName(detail.getSubjectName());
                costVO.setWbsId(detail.getWbsId());
                costVO.setWbsCode(detail.getWbsCode());
                costVO.setWbsName(detail.getWbsName());
                costVO.setSourceId(detail.getAllocatId());
                costVO.setSourceDetailId(detail.getId());
                costVO.setHappenTaxMny(detail.getAllocatBlanceTaxMny());
                costVO.setHappenMny(detail.getAllocatBlanceMny());
                costVO.setHappenDate(entity.getOutDate());
                costVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costVO.setSourceType("PRO_RMAT_AllotOut");
                costVO.setSourceTabType("PRO_RMAT_AllotOut_DETAIL");
                costVO.setProjectId(entity.getProjectId());
                costVO.setSourceBillCode(entity.getBillCode()); //填充自己的单据编号
                costVO.setSourceBillName(BILL_NAME);//自己的单据名称
                costVO.setSourceBillUrl("/ejc-prormat-frontend/#/allotOut/card?id="+ entity.getId());//需要跳转路径与参数组成的全路径
                costVOList.add(costVO);
            }
        }
        //成本中心
        if (ListUtil.isNotEmpty(costVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costVOList));
            CommonResponse<String> response = costDetailApi.saveSubject(costVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(response));
            if (response.isSuccess()) {
            } else {
                throw new BusinessException(response.getMsg());
            }
        }
    }
    @Override
    public void pullCost(Long id) {
        //更新是否关联
        LambdaUpdateWrapper<AllotOutEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(AllotOutEntity::getId, id);
        updateWrapper.set(AllotOutEntity::getRelationFlag, "0");//(1:是，0：否)
        super.update(updateWrapper);
        logger.info("弃审推送成本---");
        logger.info("删除成本中心之前的数据-周转材调拨出库Id---{}",id);
        CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(id);
        logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
        if(!stringCommonResponse.isSuccess()){
            throw new BusinessException(stringCommonResponse.getMsg());
        }
    }

    @Override
    public String rmatCreateAllotIn(AllotOutVO allotOutVO){

        logger.info("prormat根据调拨出库信息生成调拨入库信息："+JSONObject.toJSONString(allotOutVO));

        AllotOutEntity allotOutEntity = BeanMapper.map(allotOutVO,AllotOutEntity.class);

        //生成调拨入库
        AllotInEntity allotInEntity = new AllotInEntity();
        allotInEntity.setInUnitName(allotOutEntity.getInUnitName()); //调入单位名称呼
        //出库信息
        allotInEntity.setOutAllocaScope(allotOutEntity.getOutAllocaScope());
        allotInEntity.setOutProjectId(allotOutEntity.getProjectId());
        allotInEntity.setOutProjectName(allotOutEntity.getProjectName());
        allotInEntity.setOutOrgId(allotOutEntity.getOrgId());
        allotInEntity.setOutOrgName(allotOutEntity.getOrgName());
        //入库信息
        allotInEntity.setOutTaxMny(allotOutEntity.getOutTaxMny());
        allotInEntity.setInAllocaScope(allotOutEntity.getInAllocaScope());
        allotInEntity.setStoreId(allotOutEntity.getInStoreId());
        allotInEntity.setStoreName(allotOutEntity.getInStoreName());
        allotInEntity.setProjectId(allotOutEntity.getInProjectId());
        allotInEntity.setProjectName(allotOutEntity.getInProjectName());
        allotInEntity.setParentOrgId(allotOutEntity.getInParentOrgId());
        allotInEntity.setParentOrgName(allotOutEntity.getInParentOrgName());
        allotInEntity.setParentOrgCode(allotOutEntity.getInParentOrgCode());
        allotInEntity.setOrgId(allotOutEntity.getInOrgId());
        allotInEntity.setOrgName(allotOutEntity.getInOrgName());
        allotInEntity.setAllotOutId(allotOutEntity.getId());
        allotInEntity.setOutMny(allotOutEntity.getOutMny());
        allotInEntity.setOutDate(allotOutEntity.getOutDate());
        allotInEntity.setEmployeeId(allotOutEntity.getEmployeeId());
        allotInEntity.setEmployeeName(allotOutEntity.getEmployeeName());
        allotInEntity.setDepartmentId(allotOutEntity.getDepartmentId());
        allotInEntity.setDepartmentName(allotOutEntity.getDepartmentName());
        allotInEntity.setOutStoreId(allotOutEntity.getStoreId());
        allotInEntity.setOutStoreName(allotOutEntity.getStoreName());
        allotInEntity.setNotifyReceiverId(allotOutEntity.getReceiverId());
        allotInEntity.setReceiverName(allotOutEntity.getReceiverName());
        allotInEntity.setAllocatType(allotOutEntity.getAllocatType());
        allotInEntity.setMemo(allotOutEntity.getMemo());
        allotInEntity.setMaterialNames(allotOutEntity.getMaterialNames());
        allotInEntity.setReceiveState(Integer.valueOf(AllocationState.TO_RECEIVING.getCode()));
        List<AllotInDetailEntity> allotInDetailEntitys = BeanMapper.mapList(allotOutEntity.getAllotOutDetailList(), AllotInDetailEntity.class);
        long id = IdWorker.getId();
        allotInDetailEntitys.forEach(item->{
            item.setId(null);
            item.setAllocatId(id);
        });
        allotInEntity.setAllotInDetailList(allotInDetailEntitys);
        AllotInVO vo = BeanMapper.map(allotInEntity, AllotInVO.class);
        BillCodeParam billCodeParam = BillCodeParam.build(IN_BILL_CODE, InvocationInfoProxy.getTenantid(),vo);
        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        if(billCode.isSuccess()) {
            allotInEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
        }else{
            return "网络异常， 编码生成失败， 请稍后再试";
        }
        logger.info("子表信息："+allotInDetailEntitys.toString());
        allotInEntity.setId(id);
        boolean b = allotInService.saveOrUpdate(allotInEntity,false);
        if (b){
            AllotInEntity allot = allotInService.selectById(id);
            if ((allot!=null) && (allot.getNotifyReceiverId()!=null)){
                //通知收料人收料
                String[] notifyReceive = {String.valueOf(allot.getNotifyReceiverId())};

                allotInMessageService.sendMsg(allot,notifyReceive, NoticeEnum.ALLOTIN_ENROLL);
            }
        }

        return null;
    }

}
