package com.ejianc.business.pro.ownrmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.ownrmat.bean.HandleDetailEntity;
import com.ejianc.business.pro.ownrmat.service.IValidateService;
import com.ejianc.business.pro.ownrmat.vo.HandleVO;
import com.ejianc.business.pro.ownrmat.utils.MaterialConstant;
import com.ejianc.business.pro.rmat.enums.BillTypeEnum;
import com.ejianc.business.pro.rmat.utils.DateUtil;
import com.ejianc.business.pro.rmat.utils.ValidateUtil;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.ownrmat.mapper.HandleMapper;
import com.ejianc.business.pro.ownrmat.bean.HandleEntity;
import com.ejianc.business.pro.ownrmat.service.IHandleService;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 周转材处置
 * 
 * @author generator
 * 
 */
@Service("handleService")
public class HandleServiceImpl extends BaseServiceImpl<HandleMapper, HandleEntity> implements IHandleService{

    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private IStoreManageApi storeManageApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICostDetailApi costDetailApi;

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "PRO_RMAT_HANDLE";//此处需要根据实际修改

    @Autowired
    private IValidateService validateService;

    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_NAME = MaterialConstant.周转材处置;


    @Override
    public CommonResponse<HandleVO> saveOrUpdate(HandleVO handleVO) {
        // 同一个合同只能存在一个自由态或审批中的单据
        validateService.validateProject(handleVO.getProjectId(), MaterialConstant.周转材处置, handleVO.getId(), MaterialConstant.保存);
        // 校验必须大于最大单据日期
        validateTime(handleVO, MaterialConstant.保存);
        HandleEntity entity = BeanMapper.map(handleVO, HandleEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),handleVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<HandleDetailEntity> subList = new ArrayList<>();
        List<HandleDetailEntity> handleSubList = entity.getHandleSubList();
        // 设置主表分类名称
        String names = "";
        for (HandleDetailEntity detailEntity:handleSubList
        ) {
            if(detailEntity.getHandleNum() != null && detailEntity.getHandleNum().compareTo(BigDecimal.ZERO) > 0){
                subList.add(detailEntity);
            }
            names = names+detailEntity.getMaterialCategoryName()+",";
        }
        if(handleSubList.size() > 0){
            names = names.substring(0,names.length()-1);
        }
        entity.setMaterialTypes(names);
        entity.setRelationFlag("0");// 关联状态初始化
        entity.setProportionFlag("0");// 分摊状态初始化
        entity.setStoreId(entity.getProjectId());
        super.saveOrUpdate(entity,false);
        if(handleVO.getHandleSubList().size()>0){
            //调用库存
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(handleVO.getProjectId());
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.周转材材料处置);
            storeManageVO.setOutEffectiveON(false);
            ArrayList<FlowVO> flowVOS = new ArrayList<>();
            //删除的数据
            handleVO.getHandleSubList().forEach(t->{
                if("del".equals(t.getRowState())){
                    FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.周转材材料处置, 0);
                    flowVO.setStoreId(handleVO.getStoreId());
                    flowVO.setStoreName(handleVO.getStoreName());
                    flowVO.setProjectId(entity.getProjectId());
                    flowVO.setProjectName(entity.getProjectName());
                    flowVO.setOrgId(entity.getOrgId());
                    flowVO.setOrgName(entity.getOrgName());
                    flowVO.setParentOrgId(entity.getParentOrgId());
                    flowVO.setParentOrgName(entity.getParentOrgName());
                    flowVO.setEmployeeId(handleVO.getEmployeeId());
                    flowVO.setEmployeeName(handleVO.getEmployeeName());
                    flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                    flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                    flowVO.setMaterialId(t.getMaterialId());
                    flowVO.setMaterialName(t.getMaterialName());
                    flowVO.setMaterialSpec(t.getSpec());
                    flowVO.setMaterialUnitId(t.getUnit());
                    flowVO.setMaterialUnitName(t.getUnitName());
                    flowVO.setSourceBillDetailRemark(t.getMemo());
                    flowVO.setTaxPrice(t.getHandleTaxPrice());
                    flowVO.setPrice(t.getHandlePrice());
                    flowVO.setNum(t.getHandleNum());
                    flowVO.setTaxMny(t.getHandleTaxMny());
                    flowVO.setMny(t.getHandleMny());
                    flowVO.setTax(t.getTax());

                    flowVO.setSourceId(entity.getId());
                    flowVO.setSourceDetailId(t.getId());
                    flowVO.setSourceBillCode(entity.getBillCode());
                    flowVO.setSourceBillDate(entity.getHandleDate());
                    flowVO.setRowState(t.getRowState());
                    flowVO.setSourceBillRemark(entity.getHandleReason());
                    flowVO.setPurchasePrice(t.getOriginalValuePrice());
                    flowVO.setPurchaseTaxPrice(t.getOriginalValueTaxPrice());
                    flowVOS.add(flowVO);
                }
            });
            //新增修改的数据
            entity.getHandleSubList().forEach(t->{
                FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.周转材材料处置,0);
                flowVO.setStoreId(entity.getStoreId());
                flowVO.setStoreName(entity.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                flowVO.setMaterialId(t.getMaterialId());
                flowVO.setMaterialName(t.getMaterialName());
                flowVO.setMaterialSpec(t.getSpec());
                flowVO.setMaterialUnitId(t.getUnit());
                flowVO.setMaterialUnitName(t.getUnitName());
                flowVO.setSourceBillDetailRemark(t.getMemo());
                flowVO.setTaxPrice(t.getHandleTaxPrice());
                flowVO.setPrice(t.getHandlePrice());
                flowVO.setNum(t.getHandleNum());
                flowVO.setTaxMny(t.getHandleTaxMny());
                flowVO.setMny(t.getHandleMny());
                flowVO.setTax(t.getTax());

                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(t.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getHandleDate());
                flowVO.setRowState(t.getRowState());
                flowVO.setSourceBillRemark(entity.getHandleReason());
                flowVO.setPurchasePrice(t.getOriginalValuePrice());
                flowVO.setPurchaseTaxPrice(t.getOriginalValueTaxPrice());
                flowVOS.add(flowVO);
            });
            storeManageVO.setFlowVOList(flowVOS);
            logger.debug("参数：————"+ JSONObject.toJSONString(storeManageVO));
            CommonResponse<StoreManageVO> response = storeManageApi.inOutStore(storeManageVO);
            if(!response.isSuccess()) {
                throw new BusinessException("调用库存管理失败,错误信息："+response.getMsg());
            }
        }
        HandleVO vo = BeanMapper.map(entity, HandleVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * 校验必须大于最大单据日期
     * @param  handleVO
     * @return
     */
    public String validateTime(HandleVO handleVO, String type) {
        Map<String, Object> params = new HashMap<>();
        params.put("projectId", handleVO.getProjectId());
        if(handleVO.getId() != null){
            params.put("billType", com.ejianc.business.pro.rmat.utils.MaterialConstant.遗失单);
            params.put("billId", handleVO.getId());
        }
        Date lastDate = validateService.getLastDate(params);
        Map<Date, Date> maxTimeMap = validateService.getMaxTime(params);
        if (lastDate == null) return "未获取最大单据日期！";
        if(ValidateUtil.compareDate(handleVO.getHandleDate(), lastDate, maxTimeMap,handleVO.getCreateTime())){
            throw new BusinessException(DateUtil.formatDate(handleVO.getHandleDate())
                    + "小于最大单据日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
        }
        return "校验通过！";
    }

    @Override
    public CommonResponse myRemoveByIds(List<Long> ids) {
        CommonResponse commonResponse = handleInOut(ids,false);
        if(!commonResponse.isSuccess()){
            return commonResponse;
        }
        super.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public CommonResponse handleInOut(List<Long> ids,Boolean outEffectiveON){
        StoreManageVO storeManageVO = new StoreManageVO();
        List<Long> SourceIds = new ArrayList<>();
        for (Long item:ids
        ) {
            HandleEntity entity = super.selectById(item);
            List<HandleDetailEntity> handleSubList = entity.getHandleSubList();
            Boolean checkFlag = false;
            for (HandleDetailEntity t:handleSubList
            ) {
                if(t.getHandleNum().compareTo(BigDecimal.ZERO) > 0){
                    checkFlag = true;
                    break;
                }
            }
            if(checkFlag){
                SourceIds.clear();
                SourceIds.add(item);
                storeManageVO.setSourceId(item);
                storeManageVO.setStoreId(entity.getStoreId());
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.周转材材料处置);
                storeManageVO.setSourceIdsForRollBack(SourceIds);
                storeManageVO.setOutEffectiveON(outEffectiveON);
                CommonResponse<StoreManageVO> response = storeManageApi.inOutStoreRollback(storeManageVO);
                if(!response.isSuccess()) {
                    throw new BusinessException("调用库存管理失败,错误信息："+response.getMsg());
                }
            }
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<HandleVO> pushCost(HandleVO vo) {
        HandleEntity entity = baseMapper.selectById(vo.getId());
        if (CollectionUtils.isNotEmpty(vo.getHandleSubList())) {
            List<HandleDetailEntity> dailyList = BeanMapper.mapList(vo.getHandleSubList(), HandleDetailEntity.class);
            entity.setHandleSubList(dailyList);
        }
        super.saveOrUpdate(entity, false);
        //推送数据
        this.costPush(entity);
        return CommonResponse.success(BeanMapper.map(entity, HandleVO.class));
    }

    @Override
    public void costPush(HandleEntity entity) {
        logger.info("开始costPush");
        List<HandleDetailEntity> dailyList = entity.getHandleSubList();
        String relationFlag = "1";
        if(CollectionUtils.isNotEmpty(dailyList)){
            for(HandleDetailEntity detail : dailyList){
                if(null == detail.getSubjectId() || null == detail.getWbsId()){
                    relationFlag = "0";
                    break;
                }
            }
        }
        if(CollectionUtils.isEmpty(dailyList)){
            relationFlag = "0";
        }
        //更新是否关联
        LambdaUpdateWrapper<HandleEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(HandleEntity::getId, entity.getId());
        updateWrapper.set(HandleEntity::getRelationFlag, relationFlag);//(1:是，0：否)
        super.update(updateWrapper);

        //判断之前的单据是否关联
        String oldRelationFlag = entity.getRelationFlag();
        //之前已关联
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(relationFlag)) {
                saveCost(entity);
            }
            if (!"1".equals(relationFlag)) {
                //删除成本中心之前的数据
                logger.info("删除成本中心之前的数据-{}Id---{}", BILL_NAME, entity.getId());
                CommonResponse<String> commonResponse = costDetailApi.deleteSubject(entity.getId());
                logger.info("结果"+JSONObject.toJSONString(commonResponse));
                if(!commonResponse.isSuccess()){
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        //之前未关联
        if ("0".equals(oldRelationFlag)) {
            if ("1".equals(relationFlag)) {
                saveCost(entity);
            }
        }
    }

    private void saveCost(HandleEntity entity) {
        //明细
        List<CostDetailVO> costVOList = new ArrayList<>();
        List<HandleDetailEntity> dailyList = entity.getHandleSubList();
        if (CollectionUtils.isNotEmpty(dailyList)) {
            for (HandleDetailEntity detail : dailyList) {
                CostDetailVO costVO = new CostDetailVO();
                costVO.setSubjectId(detail.getSubjectId());
                costVO.setSubjectCode(detail.getSubjectCode());
                costVO.setSubjectName(detail.getSubjectName());
                costVO.setWbsId(detail.getWbsId());
                costVO.setWbsCode(detail.getWbsCode());
                costVO.setWbsName(detail.getWbsName());
                costVO.setSourceId(detail.getHandleId());
                costVO.setSourceDetailId(detail.getId());
                costVO.setHappenTaxMny(detail.getHandleSubTaxMny());
                costVO.setHappenMny(detail.getHandleSubMny());
                costVO.setHappenDate(entity.getHandleDate());
                costVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costVO.setSourceType("PRO_RMAT_HANDLE");
                costVO.setSourceTabType("PRO_RMAT_HANDLE_DETAIL");
                costVO.setProjectId(entity.getProjectId());
                costVO.setSourceBillCode(entity.getBillCode()); //填充自己的单据编号
                costVO.setSourceBillName(BILL_NAME);//自己的单据名称
                costVO.setSourceBillUrl("/ejc-prormat-frontend/#/storeHandle/card?id="+ entity.getId());//需要跳转路径与参数组成的全路径
                costVOList.add(costVO);
            }
        }
        //成本中心
        if (ListUtil.isNotEmpty(costVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costVOList));
            CommonResponse<String> response = costDetailApi.saveSubject(costVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(response));
            if (response.isSuccess()) {
            } else {
                throw new BusinessException(response.getMsg());
            }
        }
    }
    @Override
    public void pullCost(Long id) {
        //更新是否关联
        LambdaUpdateWrapper<HandleEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(HandleEntity::getId, id);
        updateWrapper.set(HandleEntity::getRelationFlag, "0");//(1:是，0：否)
        super.update(updateWrapper);
        costDetailApi.deleteSubject(id);
    }
}
