package com.ejianc.business.pro.rmat.service;

import com.ejianc.business.pro.rmat.bean.ChangeEntity;
import com.ejianc.business.pro.rmat.vo.ChangeVO;
import com.ejianc.business.pro.rmat.vo.ContractVO;
import com.ejianc.business.pro.rmat.vo.RecordVO;
import com.ejianc.business.pro.rmat.vo.record.ChangeRecordVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.springframework.web.bind.annotation.RequestBody;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 周转材租赁合同变更表
 * 
 * @author generator
 * 
 */
public interface IChangeService extends IBaseService<ChangeEntity> {

    ChangeVO saveOrUpdate(@RequestBody ChangeVO saveOrUpdateVO,Boolean isControl);

    ChangeRecordVO queryChangeRecord(Long id);

    RecordVO queryContractRecordDetail(Long id);
    
    CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState);


    void deleteByIds(List<ChangeVO> vos);

    Map<String, Object> queryChangeCompare(Long id);

    Boolean pushContract(ContractVO vo, String updateLevel);

    ParamsCheckVO targetCostCtrl(ChangeVO changeVO);

    ParamsCheckVO viewTargetCostCtrlInfo(Long id);

    ParamsCheckVO changeCheckParams(Long id, Long mainContractId, BigDecimal changeMny);

    ExecutionVO targetCost(ChangeVO changeVO);

}
