package com.ejianc.business.pro.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.pro.rmat.bean.ContractEntity;
import com.ejianc.business.pro.rmat.bean.ContractFreezeEntity;
import com.ejianc.business.pro.rmat.mapper.ContractFreezeMapper;
import com.ejianc.business.pro.rmat.service.IContractFreezeService;
import com.ejianc.business.pro.rmat.service.IContractService;
import com.ejianc.business.pro.rmat.utils.MaterialConstant;
import com.ejianc.business.pro.rmat.vo.ContractFreezeVO;
import com.ejianc.business.pro.rmat.vo.record.FreezeRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

/**
 * 合同冻结
 * 
 * @author generator
 * 
 */
@Service("contractFreezeService")
public class ContractFreezeServiceImpl extends BaseServiceImpl<ContractFreezeMapper, ContractFreezeEntity> implements IContractFreezeService{

    @Autowired
    private IBillTypeApi billTypeApi;
    
    @Autowired
    private IBillCodeApi billCodeApi;
    
    @Autowired
    private IOrgApi iOrgApi;

    private static final String PRORMAT_CONTRACT_FREEZE = "PRORMAT_CONTRACT_FREEZE";//此处需要根据实际修改
    
    
    @Autowired
    private IContractService contractService;
    
    @Override
    public ContractFreezeVO saveOrUpdate(ContractFreezeVO saveOrUpdateVO) {
        ContractFreezeEntity entity = BeanMapper.map(saveOrUpdateVO, ContractFreezeEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            addFreezeFlag(saveOrUpdateVO.getContractId());
            
            BillCodeParam billCodeParam = BillCodeParam.build(PRORMAT_CONTRACT_FREEZE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        contractService.validateContract(saveOrUpdateVO.getContractId(), MaterialConstant.冻结单, saveOrUpdateVO.getId(), MaterialConstant.保存);
        
        this.saveOrUpdate(entity, false);
        
        return BeanMapper.map(entity, ContractFreezeVO.class);
    }

    @Override
    public Boolean addFreezeFlag(Long id) {
        LambdaQueryWrapper<ContractFreezeEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractFreezeEntity::getContractId, id);
        wrapper.notIn(ContractFreezeEntity::getBillState, Arrays.asList(1, 3));

        List<ContractFreezeEntity> list = this.list(wrapper);
        if (ListUtil.isNotEmpty(list)) {
            throw new BusinessException("当前合同下有未生效的冻结/解冻单不能再次发起冻结/解冻请求！");
        }
        
        return true;
    }

    @Override
    public FreezeRecordVO queryFreezeRecord(Long id) {
        ContractEntity entity = contractService.selectById(id);
        FreezeRecordVO vo = new FreezeRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        vo.setRentType(entity.getRentType());

        // 查询冻结单
        LambdaQueryWrapper<ContractFreezeEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractFreezeEntity::getContractId, id);
        wrapper.orderByDesc(ContractFreezeEntity::getCreateTime);

        List<ContractFreezeEntity> list = this.list(wrapper);
        
        vo.setDetailList(BeanMapper.mapList(list, ContractFreezeVO.class));
        
        
        return vo;
    }
}
