package com.ejianc.business.pro.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.rmat.bean.*;
import com.ejianc.business.pro.rmat.enums.BillTypeEnum;
import com.ejianc.business.pro.rmat.enums.ContractFilingTypeEnum;
import com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum;
import com.ejianc.business.pro.rmat.enums.SettleEnum;
import com.ejianc.business.pro.rmat.mapper.SettleMapper;
import com.ejianc.business.pro.rmat.service.*;
import com.ejianc.business.pro.rmat.utils.DateUtil;
import com.ejianc.business.pro.rmat.utils.PushSupUtil;
import com.ejianc.business.pro.rmat.vo.*;
import com.ejianc.business.pro.rmat.vo.record.SettleRecordVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.*;

/**
 * 周转材租赁结算单
 * 
 * @author generator
 * 
 */
@Service("settleService")
public class SettleServiceImpl extends BaseServiceImpl<SettleMapper, SettleEntity> implements ISettleService{

    private static final String PRO_RMAT_SETTLE = "PRO_RMAT_SETTLE";//此处需要根据实际修改

    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    
    private static final String OPERATE = "SETTLE_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.周转材租赁合同结算单.getCode();
    private static final String BILL_NAME = BillTypeEnum.周转材租赁合同结算单.getName();

    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/prormat/settle/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/prormat/settle/billDel";
    private static final String CHECK_PARAM_CODE_GC = "P-8916ww47";//过程结算
    private static final String CHECK_PARAM_CODE_ZZ = "P-75u0y60160";//最终结算

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IRentCalculateService calculateService;
    
    @Autowired
    private IRestituteService restituteService;

    @Autowired
    private ILoseService loseService;

    @Autowired
    private IContractService contractService;

    @Autowired
    private ISettlePoolApi settlePoolApi;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private IContractPoolApi contractPoolApi;

    @Autowired
    private PushSupUtil pushSupUtil;

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private ICostDetailApi costDetailApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IExecutionApi executionApi;

    @Override
    public SettleVO saveOrUpdate(SettleVO saveOrUpdateVO) {
        SettleEntity entity = BeanMapper.map(saveOrUpdateVO, SettleEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(PRO_RMAT_SETTLE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            
            // 签字状态
            entity.setSupplierSignStatus(0);
        }
        entity.setRelationFlag("0");// 关联状态初始化
        entity.setProportionFlag("0");// 分摊状态初始化
        
        // 校验合同
        validateContract(entity.getContractId(), entity.getId());
        // 校验结算日期
        SettleVO lastVo = queryLastSettleTaxMny(entity.getContractId(), entity.getId());
        if (lastVo.getId() != null) {
            int compareDate = DateUtil.compareDate(lastVo.getSettleDate(), entity.getSettleDate());
            if (compareDate > 0) {
                throw new BusinessException("本次结算日期" + DateUtil.formatDate(entity.getSettleDate()) + "不能小于上次结算日期" + DateUtil.formatDate(lastVo.getSettleDate()));
            }
        }

        // 计算成本归集的发生成本金额
        entity.setCostTaxMny(ComputeUtil.safeSub(entity.getSettleTaxMny(), entity.getRentTaxMny()));
        entity.setCostMny(ComputeUtil.safeSub(entity.getSettleMny(), entity.getRentMny()));
        entity.setCostTax(ComputeUtil.safeSub(entity.getCostTaxMny(), entity.getCostMny()));

        this.saveOrUpdate(entity, false);
        
        return BeanMapper.map(selectById(entity.getId()), SettleVO.class);
    }

    @Override
    public String validateContract(Long contractId, Long billId) {
        // 同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        if(billId != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }
        List<SettleEntity> list = super.queryList(queryParam, false);
        if (ListUtil.isNotEmpty(list)) {
            throw new BusinessException("当前合同存在非审批通过态的结算单，不允许新增!");
        }
        return "校验通过！";
    }

    @Override
    public List<RentCalculateVO> queryCalculateData(Long contractId, String lastSettleDate, String settleDate) {
        LambdaQueryWrapper<RentCalculateEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(RentCalculateEntity::getContractId, contractId);
        wrapper.eq(RentCalculateEntity::getSettleFlag, 0);
        wrapper.in(RentCalculateEntity::getBillState, Arrays.asList(1, 3));
        wrapper.orderByDesc(RentCalculateEntity::getCreateTime);
        if (StringUtils.isBlank(lastSettleDate)) {
            wrapper.le(RentCalculateEntity::getRentDate, settleDate);
        }else {
            wrapper.between(RentCalculateEntity::getRentDate, lastSettleDate, settleDate);
        }

        List<RentCalculateEntity> list = calculateService.list(wrapper);

        if (ListUtil.isEmpty(list)) {
            return new ArrayList<>();
        }else {
            return BeanMapper.mapList(list, RentCalculateVO.class);
        }
    }

    @Override
    public List<RestituteVO> queryRestituteData(Long contractId, String lastSettleDate, String settleDate) {
        LambdaQueryWrapper<RestituteEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(RestituteEntity::getContractId, contractId);
        wrapper.eq(RestituteEntity::getSettleFlag, 0);
        wrapper.in(RestituteEntity::getBillState, Arrays.asList(1, 3));
        wrapper.orderByDesc(RestituteEntity::getCreateTime);
        if (StringUtils.isBlank(lastSettleDate)) {
            wrapper.le(RestituteEntity::getRestituteDate, settleDate);
        }else {
            wrapper.between(RestituteEntity::getRestituteDate, lastSettleDate, settleDate);
        }

        List<RestituteEntity> list = restituteService.list(wrapper);

        if (ListUtil.isEmpty(list)) {
            return new ArrayList<>();
        }else {
            return BeanMapper.mapList(list, RestituteVO.class);
        }
    }

    @Override
    public List<LoseVO> queryLoseData(Long contractId, String lastSettleDate, String settleDate) {
        LambdaQueryWrapper<LoseEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(LoseEntity::getContractId, contractId);
        wrapper.eq(LoseEntity::getSettleFlag, 0);
        wrapper.in(LoseEntity::getBillState, Arrays.asList(1, 3));
        wrapper.orderByDesc(LoseEntity::getCreateTime);
        if (StringUtils.isBlank(lastSettleDate)) {
            wrapper.le(LoseEntity::getBillDate, settleDate);
        }else {
            wrapper.between(LoseEntity::getBillDate, lastSettleDate, settleDate);
        }
        
        List<LoseEntity> list = loseService.list(wrapper);

        if (ListUtil.isEmpty(list)) {
            return new ArrayList<>();
        }else {
            return BeanMapper.mapList(list, LoseVO.class);
        }
        
    }

    @Override
    public SettleVO queryLastSettleTaxMny(Long contractId, Long billId) {
        LambdaQueryWrapper<SettleEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SettleEntity::getContractId, contractId);
        wrapper.in(SettleEntity::getBillState, Arrays.asList(1, 3));
        if(billId != null){
            wrapper.ne(SettleEntity::getId, billId);
        }
        wrapper.orderByDesc(SettleEntity::getCreateTime);
        
        List<SettleEntity> list = this.list(wrapper);

        if (ListUtil.isEmpty(list)) {
            return new SettleVO();
        }else {
            return BeanMapper.map(list.get(0), SettleVO.class);
        }
        
    }

    @Override
    public SettleRecordVO querySettleRecord(Long id) {
        ContractEntity entity = contractService.selectById(id);

        SettleRecordVO vo = new SettleRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractMny(entity.getContractMny());
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        vo.setRentType(entity.getRentType());

        // 查询变更记录
        LambdaQueryWrapper<SettleEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SettleEntity::getContractId, id);
        wrapper.orderByDesc(SettleEntity::getCreateTime);
        List<SettleEntity> settleList = super.list(wrapper);
        
        if (ListUtil.isNotEmpty(settleList)) {
            vo.setTotalSettleTaxMny(settleList.get(0).getTotalSettleTaxMny());
            vo.setTotalSettleMny(settleList.get(0).getTotalSettleMny());
            vo.setSettleRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(vo.getTotalSettleTaxMny(), vo.getTotalSettleMny()), new BigDecimal("100")));
        }
        vo.setDetailList(BeanMapper.mapList(settleList, SettleVO.class));
        //检测是否可以创建新的结算单
        Boolean contractFilingFlag = contractService.checkFilingType(id, ContractFilingTypeEnum.租赁合同结算.getTypeCode());
        if (contractFilingFlag){
            vo.setCanAddNewSettleFlag(true);
        }else {
            vo.setCanAddNewSettleFlag(false);
        }
        return vo;
    }

    /**
     * 推送结算池
     * @param vo
     * @return
     */
    @Override
    public Boolean pushSettleToPool(SettleVO vo) {
        SettlePoolVO poolVO = new SettlePoolVO();
        try {
            logger.info("结算单对象 -> 结算池对象自动转换开始");
            // 对象自动转换
            BeanConvertorUtil.convert(vo, poolVO);
            
            // 个别字段需要手动封装
            poolVO.setSourceId(vo.getId());
            poolVO.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            poolVO.setSourceType(SettleSourceTypeEnum.周转材租入结算.getCode());
            poolVO.setSourceTypeName(SettleSourceTypeEnum.周转材租入结算.getName());
            poolVO.setSettleProperty(Integer.valueOf(SettleEnum.支出.getCode()));
            poolVO.setSettlePropertyName(SettleEnum.支出.getName());
            poolVO.setUltimateFlag(Integer.valueOf(vo.getSettleType()));
            
            // 查询合同
            ContractEntity contractEntity = contractService.selectById(vo.getContractId());
            poolVO.setSupplementFlag(contractEntity.getSupplementFlag());
            poolVO.setMaiContractId(contractEntity.getId());
            poolVO.setMaiContractCode(contractEntity.getBillCode());
            poolVO.setMaiContractName(contractEntity.getContractName());
            poolVO.setSignDate(contractEntity.getSignDate());
            poolVO.setContractType(ContractTypeEnum.周转材合同.getTypeCode());
            poolVO.setContractTypeName(ContractTypeEnum.周转材合同.getTypeName());
            poolVO.setContractFlag(1);//合同标识
            
            poolVO.setCreateTime(vo.getCreateTime());
            poolVO.setCreateUserCode(vo.getCreateUserCode());
            poolVO.setUpdateTime(vo.getUpdateTime());
            poolVO.setUpdateUserCode(vo.getUpdateUserCode());
            
            poolVO.setBillCodeUrl("/ejc-prormat-frontend/#/settle/card?id=" + vo.getId());
            
            CommonResponse<SettlePoolVO> res = settlePoolApi.saveOrUpdateSettle(poolVO);
            if(res.isSuccess()) {
                logger.info("结算单推送至结算池成功！结算单id-{}", vo.getId());
                return true;
            } else {
                logger.error("结算单推送结算池失败！结算单id-{}，{}", vo.getId(), res.getMsg());
            }
        } catch (Exception e) {
            logger.error("结算单推送结算池失败！结算单id-{}", vo.getId(), e);
        }
        return false;
        
    }

    /**
     * 删除结算池数据
     * @param id
     * @return
     */
    @Override
    public Boolean delSettleFromPool(Long id) {
        SettlePoolVO poolVO = new SettlePoolVO();
        poolVO.setSourceId(id);

        CommonResponse<SettlePoolVO> res = settlePoolApi.deleteSettle(poolVO);
        if (res.isSuccess()) {
            logger.info("将结算单从结算池中删除成功！结算单id-{}", id);
            return true;
        }

        logger.error("将结算单从结算池中删除失败！结算单id-{}，{}", id, res.getMsg());
        return false;
    }
    
    /**
     * 转换目标成本VO
     * @param entity
     * @return
     */
    @Override
    public ExecutionVO targetCost(SettleEntity entity) {
        // 查询结算单
        LambdaQueryWrapper<SettleEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SettleEntity::getContractId, entity.getContractId());
        wrapper.in(SettleEntity::getBillState, Arrays.asList(1,3));
        List<SettleEntity> list = this.list(wrapper);

        // 计算所有结算累计结算金额 
        BigDecimal totalSettleTaxMny = list.stream().filter(e -> e.getSettleTaxMny() != null).map(SettleEntity::getSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSettleMny = list.stream().filter(e -> e.getSettleMny() != null).map(SettleEntity::getSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        // 查询合同
        ContractEntity contractEntity = contractService.getById(entity.getContractId());

        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(entity.getId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setBillCode(entity.getBillCode());
        totalVO.setBillType(BillTypeEnum.周转材租赁合同结算单.getCode());
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.周转材租赁合同.getCode());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setOrgId(entity.getOrgId());
        totalVO.setMoney(ComputeUtil.safeSub(totalSettleMny, contractEntity.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub(totalSettleTaxMny, contractEntity.getContractTaxMny()));
        totalVO.setLinkUrl(baseHost + "ejc-prormat-frontend/#/settle/card?id=" + entity.getId());

        executionVO.setTotalVO(totalVO);

        return executionVO;

    }

    @Override
    public Boolean pushContract(SettleVO vo, String updateLevel,Boolean type) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            data.setUpdateLevel(UpdateLevelEnum.更新非空字段.getLevelCode());
            data.setSourceId(vo.getContractId());
            if (Boolean.TRUE.equals(type)){
                data.setTotalSettleTaxMny(vo.getTotalSettleTaxMny());
                data.setTotalSettleMny(vo.getTotalSettleMny());
                data.setTotalSettleTax(vo.getTotalSettleTax());
            }else {
                data.setTotalSettleTaxMny(ComputeUtil.safeSub(vo.getTotalSettleTaxMny(), vo.getLastSettleTaxMny()));
                data.setTotalSettleMny(ComputeUtil.safeSub(vo.getTotalSettleMny(), vo.getLastSettleMny()));
                data.setTotalSettleTax(ComputeUtil.safeSub(data.getTotalSettleTaxMny(), data.getTotalSettleMny()));
            }
            if ("1".equals(vo.getSettleType())) {
                if (Boolean.TRUE.equals(type)){
                    data.setFinishSettleDate(vo.getCommitDate());
                    data.setPerformanceStatus(PerformanceStatusEnum.已终止.getCode());
                }else{
                    data.setFinishSettleDate(null);
                    data.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
                }
            }
            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);
            if(transDataResp.isSuccess()) {
                return true;
            } else {
                logger.error("合同id-{}推送合同池失败，{}",vo.getId(), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", vo.getId(), e);
        }

        return null;
    }

    /**
     * 单据推送到供方协同服务
     * @param entity
     * @return
     */
    @Override
    public Boolean pushBillToSupCenter(SettleEntity entity) {
        Boolean syncFlag = pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON(entity), OPERATE,
                BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
        return syncFlag;

    }

    /**
     * 将推送至供方的单据作废
     * @param entity
     * @return
     */
    @Override
    public Boolean delPushBill(SettleEntity entity) {
        Boolean delSuc = pushSupUtil.delPushBill((JSONObject) JSONObject.toJSON(entity), OPERATE,
                BILL_TYPE, BILL_NAME, DEL_SUP_BILL_SERVER_URL);
        return delSuc;

    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String billId = request.getParameter("billId");
        SettleEntity entity = super.selectById(billId);
        String msg = pushSupUtil.updateBillSupSignSyncInfo(request, (JSONObject) JSONObject.toJSON(entity),
                SettleEntity.class, OPERATE, BILL_TYPE, BILL_NAME);
        logger.info("返回消息msg" + msg);
        return msg;
    }

    /**
     * 单据管控-累计结算金额大于合同金额
     * @param purchaseType
     * @param contractTaxMny
     * @param settleTaxMny
     * @param totalSettleTaxMny
     * @return
     */
    @Override
    public ParamsCheckVO checkParams(Integer purchaseType, BigDecimal contractTaxMny, BigDecimal settleTaxMny, BigDecimal totalSettleTaxMny,Long orgId,Integer settleType) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        paramsCheckVOS.addAll(checkParamsMny(purchaseType,contractTaxMny,settleTaxMny,totalSettleTaxMny,orgId,settleType));//金额控制
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(org.apache.commons.collections.CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    /**
     * 单据管控-累计变更金额大于合同金额
     * @return
     */
    private List<ParamsCheckVO> checkParamsMny(Integer purchaseType, BigDecimal contractTaxMny, BigDecimal settleTaxMny, BigDecimal totalSettleTaxMny,Long orgId,Integer settleType) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        String CHECK_PARAM_CODE = "";
        if(settleType==0){//类型（0-过程结算，1-最终结算）
            CHECK_PARAM_CODE = CHECK_PARAM_CODE_GC;
        }else {
            CHECK_PARAM_CODE = CHECK_PARAM_CODE_ZZ;
        }
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE,orgId);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    if (2 == purchaseType) {
                        // 集采合同直接赋值为不控制
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        return paramsCheckVOList;
                    } else {
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    }
                    settleTaxMny = settleTaxMny != null ? settleTaxMny.setScale(2,BigDecimal.ROUND_HALF_UP) : BigDecimal.ZERO;
                    totalSettleTaxMny = totalSettleTaxMny != null ? totalSettleTaxMny.setScale(2,BigDecimal.ROUND_HALF_UP) : BigDecimal.ZERO;
                    if (totalSettleTaxMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("合同超结");
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnName("累计结算金额大于合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次结算金额：").append(settleTaxMny)
                                .append("元，含本次累计结算金额：").append(totalSettleTaxMny)
                                .append("元，合同金额*").append(roleValue).append("% = ").append(comMny)
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalSettleTaxMny, comMny)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }
    /**
     * 关联保存
     * @param vo
     * @return
     */
    @Override
    public CommonResponse<SettleVO> pushCost(SettleVO vo) {
        SettleEntity entity = baseMapper.selectById(vo.getId());
        if (ListUtil.isNotEmpty(vo.getDailyRentList())) {
            List<SettleDailyRentEntity> dailyList = BeanMapper.mapList(vo.getDailyRentList(), SettleDailyRentEntity.class);
            entity.setDailyRentList(dailyList);
        }
        if (ListUtil.isNotEmpty(vo.getMonthRentList())) {
            List<SettleMonthRentEntity> monthList = BeanMapper.mapList(vo.getMonthRentList(), SettleMonthRentEntity.class);
            entity.setMonthRentList(monthList);
        }
        if (ListUtil.isNotEmpty(vo.getNumRentList())) {
            List<SettleNumRentEntity> numList = BeanMapper.mapList(vo.getNumRentList(), SettleNumRentEntity.class);
            entity.setNumRentList(numList);
        }
        if (ListUtil.isNotEmpty(vo.getRepairList())) {
            List<SettleRepairEntity> repairList = BeanMapper.mapList(vo.getRepairList(), SettleRepairEntity.class);
            entity.setRepairList(repairList);
        }
        if (ListUtil.isNotEmpty(vo.getScrapList())) {
            List<SettleScrapEntity> scrapList = BeanMapper.mapList(vo.getScrapList(), SettleScrapEntity.class);
            entity.setScrapList(scrapList);
        }
        if (ListUtil.isNotEmpty(vo.getLoseList())) {
            List<SettleLoseEntity> loseList = BeanMapper.mapList(vo.getLoseList(), SettleLoseEntity.class);
            entity.setLoseList(loseList);
        }
        if (ListUtil.isNotEmpty(vo.getOtherList())) {
            List<SettleOtherEntity> otherList = BeanMapper.mapList(vo.getOtherList(), SettleOtherEntity.class);
            entity.setOtherList(otherList);
        }
        super.saveOrUpdate(entity, false);
        //推送数据
        this.costPush(entity);
        return CommonResponse.success(BeanMapper.map(entity, SettleVO.class));
        
    }

    /**
     * 推送目标成本(成本科目、核酸对象)
     * @param entity
     */
    @Override
    public void costPush(SettleEntity entity) {
        logger.info("开始costPush");
        List<SettleDailyRentEntity> dailyList = entity.getDailyRentList();
        List<SettleMonthRentEntity> monthList = entity.getMonthRentList();
        List<SettleNumRentEntity> numList = entity.getNumRentList();
        List<SettleRepairEntity> repairList = entity.getRepairList();
        List<SettleScrapEntity> scrapList = entity.getScrapList();
        List<SettleLoseEntity> loseList = entity.getLoseList();
        List<SettleOtherEntity> otherList = entity.getOtherList();
        
        String relationFlag = "1";

        if(ListUtil.isNotEmpty(dailyList)){
            for(SettleDailyRentEntity detail : dailyList){
                if(null == detail.getSubjectId() || null == detail.getWbsId()){
                    relationFlag = "0";
                    break;
                }
            }
        }
        if(ListUtil.isNotEmpty(monthList)){
            for(SettleMonthRentEntity detail : monthList){
                if(null == detail.getSubjectId() || null == detail.getWbsId()){
                    relationFlag = "0";
                    break;
                }
            }
        }
        if(ListUtil.isNotEmpty(numList)){
            for(SettleNumRentEntity detail : numList){
                if(null == detail.getSubjectId() || null == detail.getWbsId()){
                    relationFlag = "0";
                    break;
                }
            }
        }
        if(ListUtil.isNotEmpty(repairList)){
            for(SettleRepairEntity detail : repairList){
                if(null == detail.getSubjectId() || null == detail.getWbsId()){
                    relationFlag = "0";
                    break;
                }
            }
        }
        if(ListUtil.isNotEmpty(scrapList)){
            for(SettleScrapEntity detail : scrapList){
                if(null == detail.getSubjectId() || null == detail.getWbsId()){
                    relationFlag = "0";
                    break;
                }
            }
        }
        if(ListUtil.isNotEmpty(loseList)){
            for(SettleLoseEntity detail : loseList){
                if(null == detail.getSubjectId() || null == detail.getWbsId()){
                    relationFlag = "0";
                    break;
                }
            }
        }
        if(ListUtil.isNotEmpty(otherList)){
            for(SettleOtherEntity detail : otherList){
                if(null == detail.getSubjectId() || null == detail.getWbsId()){
                    relationFlag = "0";
                    break;
                }
            }
        }
        if(ListUtil.isEmpty(dailyList) && ListUtil.isEmpty(monthList) && ListUtil.isEmpty(numList)
                && ListUtil.isEmpty(repairList) && ListUtil.isEmpty(scrapList) && ListUtil.isEmpty(loseList)
                && ListUtil.isEmpty(otherList)) {
            relationFlag = "0";
        }

        // 更新是否关联
        LambdaUpdateWrapper<SettleEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(SettleEntity::getId, entity.getId());
        updateWrapper.set(SettleEntity::getRelationFlag, relationFlag);//(1:是，0：否)
        super.update(updateWrapper);

        // 判断之前的单据是否关联
        String oldRelationFlag = entity.getRelationFlag();
        // 之前已关联
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(relationFlag)) {
                saveCost(entity);
            }
            if (!"1".equals(relationFlag)) {
                //删除成本中心之前的数据
                logger.info("删除成本中心之前的数据-{}Id---{}", BILL_NAME, entity.getId());
                CommonResponse<String> commonResponse = costDetailApi.deleteSubject(entity.getId());
                logger.info("结果"+JSONObject.toJSONString(commonResponse));
                if(!commonResponse.isSuccess()){
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        // 之前未关联
        if ("0".equals(oldRelationFlag)) {
            if ("1".equals(relationFlag)) {
                saveCost(entity);
            }
        }
    }
    
    private void saveCost(SettleEntity entity) {
        // 日租
        List<CostDetailVO> costVOList = new ArrayList<>();
        List<SettleDailyRentEntity> dailyList = entity.getDailyRentList();
        if (ListUtil.isNotEmpty(dailyList)) {
            for (SettleDailyRentEntity detail : dailyList) {
                CostDetailVO costVO = new CostDetailVO();
                costVO.setSubjectId(detail.getSubjectId());
                costVO.setSubjectCode(detail.getSubjectCode());
                costVO.setSubjectName(detail.getSubjectName());
                costVO.setWbsId(detail.getWbsId());
                costVO.setWbsCode(detail.getWbsCode());
                costVO.setWbsName(detail.getWbsName());
                costVO.setSourceId(detail.getSettleId());
                costVO.setSourceDetailId(detail.getId());
                costVO.setHappenTaxMny(detail.getDailyRentTaxMny());
                costVO.setHappenMny(detail.getDailyRentMny());
                costVO.setHappenDate(entity.getSettleDate());
                costVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costVO.setSourceType("PRO_RMAT_SETTLE");
                costVO.setSourceTabType("PRO_RMAT_SETTLE_DAILY");
                costVO.setProjectId(entity.getProjectId());
                costVO.setSourceBillCode(entity.getBillCode());
                costVO.setSourceBillName(SourceTypeEnum.周转材租赁结算.getTypeName());
                costVO.setSourceBillUrl("/ejc-prormat-frontend/#/settle/card?id=" + entity.getId());
                costVOList.add(costVO);
            }
        }
        // 月租
        List<SettleMonthRentEntity> monthList = entity.getMonthRentList();
        if (ListUtil.isNotEmpty(monthList)) {
            for (SettleMonthRentEntity detail : monthList) {
                CostDetailVO costVO = new CostDetailVO();
                costVO.setSubjectId(detail.getSubjectId());
                costVO.setSubjectCode(detail.getSubjectCode());
                costVO.setSubjectName(detail.getSubjectName());
                costVO.setWbsId(detail.getWbsId());
                costVO.setWbsCode(detail.getWbsCode());
                costVO.setWbsName(detail.getWbsName());
                costVO.setSourceId(detail.getSettleId());
                costVO.setSourceDetailId(detail.getId());
                costVO.setHappenTaxMny(detail.getMonthRentTaxMny());
                costVO.setHappenMny(detail.getMonthRentMny());
                costVO.setHappenDate(entity.getSettleDate());
                costVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costVO.setSourceType("PRO_RMAT_SETTLE");
                costVO.setSourceTabType("PRO_RMAT_SETTLE_MONTH");
                costVO.setProjectId(entity.getProjectId());
                costVO.setSourceBillCode(entity.getBillCode());
                costVO.setSourceBillName(SourceTypeEnum.周转材租赁结算.getTypeName());
                costVO.setSourceBillUrl("/ejc-prormat-frontend/#/settle/card?id=" + entity.getId());
                costVOList.add(costVO);
            }
        }
        // 工程量租
        List<SettleNumRentEntity> numList = entity.getNumRentList();
        if (ListUtil.isNotEmpty(numList)) {
            for (SettleNumRentEntity detail : numList) {
                CostDetailVO costVO = new CostDetailVO();
                costVO.setSubjectId(detail.getSubjectId());
                costVO.setSubjectCode(detail.getSubjectCode());
                costVO.setSubjectName(detail.getSubjectName());
                costVO.setWbsId(detail.getWbsId());
                costVO.setWbsCode(detail.getWbsCode());
                costVO.setWbsName(detail.getWbsName());
                costVO.setSourceId(detail.getSettleId());
                costVO.setSourceDetailId(detail.getId());
                costVO.setHappenTaxMny(detail.getNumRentTaxMny());
                costVO.setHappenMny(detail.getNumRentMny());
                costVO.setHappenDate(entity.getSettleDate());
                costVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costVO.setSourceType("PRO_RMAT_SETTLE");
                costVO.setSourceTabType("PRO_RMAT_SETTLE_NUM");
                costVO.setProjectId(entity.getProjectId());
                costVO.setSourceBillCode(entity.getBillCode());
                costVO.setSourceBillName(SourceTypeEnum.周转材租赁结算.getTypeName());
                costVO.setSourceBillUrl("/ejc-prormat-frontend/#/settle/card?id=" + entity.getId());
                costVOList.add(costVO);
            }
        }

        // 维修
        List<SettleRepairEntity> repairList = entity.getRepairList();
        if (ListUtil.isNotEmpty(repairList)) {
            for (SettleRepairEntity detail : repairList) {
                CostDetailVO costVO = new CostDetailVO();
                costVO.setSubjectId(detail.getSubjectId());
                costVO.setSubjectCode(detail.getSubjectCode());
                costVO.setSubjectName(detail.getSubjectName());
                costVO.setWbsId(detail.getWbsId());
                costVO.setWbsCode(detail.getWbsCode());
                costVO.setWbsName(detail.getWbsName());
                costVO.setSourceId(detail.getSettleId());
                costVO.setSourceDetailId(detail.getId());
                costVO.setHappenTaxMny(detail.getRepairTaxMny());
                costVO.setHappenMny(detail.getRepairMny());
                costVO.setHappenDate(entity.getSettleDate());
                costVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costVO.setSourceType("PRO_RMAT_SETTLE");
                costVO.setSourceTabType("PRO_RMAT_SETTLE_REPAIR");
                costVO.setProjectId(entity.getProjectId());
                costVO.setSourceBillCode(entity.getBillCode());
                costVO.setSourceBillName(SourceTypeEnum.周转材租赁结算.getTypeName());
                costVO.setSourceBillUrl("/ejc-prormat-frontend/#/settle/card?id=" + entity.getId());
                costVOList.add(costVO);
            }
        }
        
        // 报废
        List<SettleScrapEntity> scrapList = entity.getScrapList();
        if (CollectionUtils.isNotEmpty(scrapList)) {
            for (SettleScrapEntity detail : scrapList) {
                CostDetailVO costVO = new CostDetailVO();
                costVO.setSubjectId(detail.getSubjectId());
                costVO.setSubjectCode(detail.getSubjectCode());
                costVO.setSubjectName(detail.getSubjectName());
                costVO.setWbsId(detail.getWbsId());
                costVO.setWbsCode(detail.getWbsCode());
                costVO.setWbsName(detail.getWbsName());
                costVO.setSourceId(detail.getSettleId());
                costVO.setSourceDetailId(detail.getId());
                costVO.setHappenTaxMny(detail.getCompensateTaxMny());
                costVO.setHappenMny(detail.getCompensateMny());
                costVO.setHappenDate(entity.getSettleDate());
                costVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costVO.setSourceType("PRO_RMAT_SETTLE");
                costVO.setSourceTabType("PRO_RMAT_SETTLE_SCRAP");
                costVO.setProjectId(entity.getProjectId());
                costVO.setSourceBillCode(entity.getBillCode());
                costVO.setSourceBillName(SourceTypeEnum.周转材租赁结算.getTypeName());
                costVO.setSourceBillUrl("/ejc-prormat-frontend/#/settle/card?id=" + entity.getId());
                costVOList.add(costVO);
            }
        }
        
        // 遗失
        List<SettleLoseEntity> loseList = entity.getLoseList();
        if (CollectionUtils.isNotEmpty(loseList)) {
            for (SettleLoseEntity detail : loseList) {
                CostDetailVO costVO = new CostDetailVO();
                costVO.setSubjectId(detail.getSubjectId());
                costVO.setSubjectCode(detail.getSubjectCode());
                costVO.setSubjectName(detail.getSubjectName());
                costVO.setWbsId(detail.getWbsId());
                costVO.setWbsCode(detail.getWbsCode());
                costVO.setWbsName(detail.getWbsName());
                costVO.setSourceId(detail.getSettleId());
                costVO.setSourceDetailId(detail.getId());
                costVO.setHappenTaxMny(detail.getCompensateTaxMny());
                costVO.setHappenMny(detail.getCompensateMny());
                costVO.setHappenDate(entity.getSettleDate());
                costVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costVO.setSourceType("PRO_RMAT_SETTLE");
                costVO.setSourceTabType("PRO_RMAT_SETTLE_LOSE");
                costVO.setProjectId(entity.getProjectId());
                costVO.setSourceBillCode(entity.getBillCode());
                costVO.setSourceBillName(SourceTypeEnum.周转材租赁结算.getTypeName());
                costVO.setSourceBillUrl("/ejc-prormat-frontend/#/settle/card?id=" + entity.getId());
                costVOList.add(costVO);
            }
        }
        
        
        // 其他
        List<SettleOtherEntity> otherList = entity.getOtherList();
        if (CollectionUtils.isNotEmpty(otherList)) {
            for (SettleOtherEntity detail : otherList) {
                CostDetailVO costVO = new CostDetailVO();
                costVO.setSubjectId(detail.getSubjectId());
                costVO.setSubjectCode(detail.getSubjectCode());
                costVO.setSubjectName(detail.getSubjectName());
                costVO.setWbsId(detail.getWbsId());
                costVO.setWbsCode(detail.getWbsCode());
                costVO.setWbsName(detail.getWbsName());
                costVO.setSourceId(detail.getSettleId());
                costVO.setSourceDetailId(detail.getId());
                costVO.setHappenTaxMny(detail.getSettleTaxMny());
                costVO.setHappenMny(detail.getSettleMny());
                costVO.setHappenDate(entity.getSettleDate());
                costVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costVO.setSourceType("PRO_RMAT_SETTLE");
                costVO.setSourceTabType("PRO_RMAT_SETTLE_OTHER");
                costVO.setProjectId(entity.getProjectId());
                costVO.setSourceBillCode(entity.getBillCode());
                costVO.setSourceBillName(SourceTypeEnum.周转材租赁结算.getTypeName());
                costVO.setSourceBillUrl("/ejc-prormat-frontend/#/settle/card?id=" + entity.getId());
                costVOList.add(costVO);
            }
        }
        
        //成本中心
        if (ListUtil.isNotEmpty(costVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costVOList));
            CommonResponse<String> response = costDetailApi.saveSubject(costVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(response));
            if (response.isSuccess()) {
            } else {
                throw new BusinessException(response.getMsg());
            }
        }
    }

    /**
     * 删除成本科目、核酸对象
     * @param id
     */
    @Override
    public void pullCost(Long id) {
        //更新是否关联
        LambdaUpdateWrapper<SettleEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SettleEntity::getId, id);
        updateWrapper.set(SettleEntity::getRelationFlag, "0");//(1:是，0：否)
        super.update(updateWrapper);

        costDetailApi.deleteSubject(id);
    }

    @Override
    public Boolean syncPushExecution(Long id) {
        ExecutionVO executionVO = this.targetCost(this.selectById(id));

        CommonResponse<String> response = executionApi.aggPush(executionVO);
        logger.info("推送目标成本入参：" + JSONObject.toJSONString(executionVO));
        if (!response.isSuccess()){
            logger.error("推送目标成本失败: , {}", response.getMsg());
            throw new BusinessException(response.getMsg());
        }

        return true;
    }

    @Override
    public void delById(Long id) {
        Boolean flag = baseMapper.delById(id);
        if (Boolean.FALSE.equals(flag)) {
            throw new BusinessException("删除失败!");
        }
    }

}
