package com.ejianc.business.pro.pricelib.service;

import com.ejianc.business.pro.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.pro.pricelib.bean.PriceHistoryEntity;

import java.util.List;
import java.util.Map;

/**
 * 周转材合同历史价格数据
 * 
 * @author generator
 * 
 */
public interface IPriceHistoryService extends IBaseService<PriceHistoryEntity> {
    void initPriceHistory();
    MaterialPriceHistoryApiVO getMaterialPriceHistoryApiVO(Long materialId,String rentCalculationType);
    List<MaterialPriceHistoryApiVO> getMaterialPriceHistoryApiVOS(List<Long> materialIds,String rentCalculationType);
    Boolean historyPriceShow(Integer priceCheckType);
    ParamsCheckVO priceCheckParams(MaterialPriceHistoryApiVO materialPriceHistoryApiVO);
    Map<Long,MaterialPriceHistoryApiVO> getMaterialPriceHistoryApiVOMap(List<Long> materialIds,String rentCalculationType);
}
