package com.ejianc.business.pro.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.pro.pricelib.service.IPriceHistoryService;
import com.ejianc.business.pro.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.pro.pricelib.vo.PriceHistoryVO;
import com.ejianc.business.pro.rmat.bean.BatchPlanDetailEntity;
import com.ejianc.business.pro.rmat.bean.BatchPlanEntity;
import com.ejianc.business.pro.rmat.bean.BatchPlanRepairEntity;
import com.ejianc.business.pro.rmat.bean.BatchPlanScrapEntity;
import com.ejianc.business.pro.rmat.service.IBatchPlanDetailService;
import com.ejianc.business.pro.rmat.service.IBatchPlanRepairService;
import com.ejianc.business.pro.rmat.service.IBatchPlanScrapService;
import com.ejianc.business.pro.rmat.service.IBatchPlanService;
import com.ejianc.business.pro.rmat.vo.BatchPlanDetailVO;
import com.ejianc.business.pro.rmat.vo.BatchPlanRepairVO;
import com.ejianc.business.pro.rmat.vo.BatchPlanScrapVO;
import com.ejianc.business.pro.rmat.vo.BatchPlanVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 周转材批次计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("batchPlan")
public class BatchPlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IBatchPlanService service;

    @Autowired
    private IBatchPlanDetailService batchPlanDetailService;
    @Autowired
    private IBatchPlanRepairService batchPlanRepairService;
    @Autowired
    private IBatchPlanScrapService batchPlanScrapService;

    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IPriceHistoryService priceHistoryService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BatchPlanVO> saveOrUpdate(@RequestBody BatchPlanVO saveOrUpdateVO) {
        BatchPlanVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BatchPlanVO> queryDetail(Long id) {
        BatchPlanVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BatchPlanVO> vos) {
        service.removeByIds(vos.stream().map(BatchPlanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BatchPlanVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("parentOrgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<BatchPlanEntity> page = service.queryPage(param,false);
        IPage<BatchPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BatchPlanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("parentOrgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        List<BatchPlanEntity> entityList = service.queryList(param);
        List<BatchPlanVO> list = BeanMapper.mapList(entityList, BatchPlanVO.class);
        list.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BatchPlan-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refBatchPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BatchPlanVO>> refBatchPlanData(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                               @RequestParam(defaultValue = "10") Integer pageSize,
                                                               @RequestParam(value = "searchText", required = false) String searchText,
                                                               @RequestParam(value = "condition", required = false) String condition) {
        QueryParam param = new QueryParam();
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("parentOrgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatus.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStatus));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
        }
        IPage<BatchPlanEntity> page = service.queryPage(param,false);
        IPage<BatchPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BatchPlanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
     }
    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refBatchPlanTree", method = RequestMethod.GET)
    @ResponseBody
    public List<BatchPlanEntity> refBatchPlanTree(@RequestParam(defaultValue = "1") Integer pageNumber,
                                              @RequestParam(defaultValue = "10") Integer pageSize,
                                               @RequestParam(value = "searchText", required = false) String searchText,
                                               @RequestParam(value = "condition", required = false) String condition) {
        QueryParam param = new QueryParam();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("parentOrgName");
        param.setSearchText(searchText);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatus.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStatus));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
        }
        List<BatchPlanEntity> list = service.queryList(param,false);
        for(BatchPlanEntity entity : list){
            entity.setCode(entity.getBillCode());
            entity.setName(entity.getBillCode() + "_" + entity.getProjectName());
        }
        return list;
     }

    /**
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/refBatchPlanAll", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BatchPlanVO>> refBatchPlanAll(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                              @RequestParam(defaultValue = "10") Integer pageSize,
                                                              @RequestParam(value = "searchText", required = false) String searchText,
                                                              @RequestParam(value = "condition", required = false) String condition) {

        QueryParam param = new QueryParam();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("parentOrgName");
        param.setSearchText(searchText);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatus.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStatus));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                CommonResponse<List<Long>> projectResponse = projectPoolApi.queryProjectIdsByParentProjectId(projectId);
                if (!projectResponse.isSuccess()) {
                    throw new BusinessException("查询项目信息失败！");
                }
                param.getParams().put("projectId", new Parameter(QueryParam.IN, projectResponse.getData()));
            }
            if (null != conditionMap.get("tenderStatus")) {
                Integer tenderStatus = Integer.parseInt(conditionMap.get("tenderStatus").toString());
                param.getParams().put("tenderStatus", new Parameter(QueryParam.EQ, tenderStatus));
            }
            if (null != conditionMap.get("orgId")) {
                Long orgId = Long.valueOf(conditionMap.get("orgId").toString());
                List<Long> orgIds = iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
                param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));
            }
            if (null != conditionMap.get("employeeId")) {
                Long employeeId = Long.valueOf(conditionMap.get("employeeId").toString());
                param.getParams().put("employeeId", new Parameter(QueryParam.EQ, employeeId));
            }
            if (null != conditionMap.get("rentType")) {
                Integer rentType = Integer.parseInt(conditionMap.get("rentType").toString());
                param.getParams().put("rentType", new Parameter(QueryParam.EQ, rentType));
            }
        }
        IPage<BatchPlanEntity> page = service.queryPage(param, false);
        IPage<BatchPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<BatchPlanVO> batchPlanVOS = BeanMapper.mapList(page.getRecords(), BatchPlanVO.class);
        for(BatchPlanVO vo : batchPlanVOS){
            LambdaQueryWrapper<BatchPlanDetailEntity> lambd = new LambdaQueryWrapper<>();
            lambd.eq(BatchPlanDetailEntity::getDr,0);
            lambd.eq(BatchPlanDetailEntity::getBatchId,vo.getId());
            List<BatchPlanDetailEntity> list = batchPlanDetailService.list(lambd);
            List<BatchPlanDetailVO> batchPlanDetailVOS = BeanMapper.mapList(list, BatchPlanDetailVO.class);



            vo.setDetailList(batchPlanDetailVOS);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("batchId", new Parameter(QueryParam.EQ, vo.getId()));
            List<BatchPlanRepairEntity> list2 = batchPlanRepairService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty(list2)){
                vo.setRepairList(BeanMapper.mapList(list2, BatchPlanRepairVO.class));
            }
            List<BatchPlanScrapEntity> list3 = batchPlanScrapService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty(list3)){
                vo.setScrapList(BeanMapper.mapList(list3, BatchPlanScrapVO.class));
            }
            if (null != vo.getRentType()){
                //租赁方式(0-日租,1-月租,2-工程量租)
                vo.setRentTypeName(CommonConstant.CONTRACT_RENT_CALCULATION_TYPE.get(vo.getRentType().toString()));
            }
            vo.setRentalTypeName(null != vo.getRentalType() ? CommonConstant.BATCH_PLAN_RESPONSIBLE_TYPE.get(vo.getRentalType().toString()) : null);
            vo.setBackTypeName(null != vo.getBackType() ? CommonConstant.BATCH_PLAN_RESPONSIBLE_TYPE.get(vo.getBackType().toString()) : null);
            vo.setRentalStackingName(null != vo.getRentalStacking() ? CommonConstant.BATCH_PLAN_RESPONSIBLE_TYPE.get(vo.getRentalStacking().toString()) : null);
            vo.setBackStackingName(null != vo.getBackStacking() ? CommonConstant.BATCH_PLAN_RESPONSIBLE_TYPE.get(vo.getBackStacking().toString()) : null);
        }

        pageData.setRecords(batchPlanVOS);

        return CommonResponse.success("查询参照数据成功！",pageData);
    }





    /**
     * 单据管控
     * @return
     */
    @RequestMapping(value = "/checkParams", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody BatchPlanVO vo) {
        ParamsCheckVO paramsCheckVO = service.checkParams(vo);
        return CommonResponse.success("参数校验成功！",paramsCheckVO );
    }
}
