package com.ejianc.business.pro.rmat.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.outrmat.api.IOutRmatApi;
import com.ejianc.business.outrmat.contract.enums.StatusTypeEnum;
import com.ejianc.business.outrmat.delivery.vo.OutRmatDeliveryVO;
import com.ejianc.business.outrmat.order.vo.OutRmatOrderDetailVO;
import com.ejianc.business.outrmat.order.vo.OutRmatOrderVO;
import com.ejianc.business.pro.rmat.bean.*;
import com.ejianc.business.pro.rmat.enums.BillPushStatusEnum;
import com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum;
import com.ejianc.business.pro.rmat.enums.ReceiptsEnum;
import com.ejianc.business.pro.rmat.enums.SupplierSignStatusEnum;
import com.ejianc.business.pro.rmat.mapper.OrderMapper;
import com.ejianc.business.pro.rmat.service.*;
import com.ejianc.business.pro.rmat.service.impl.*;
import com.ejianc.business.pro.rmat.utils.EntityUtil;
import com.ejianc.business.pro.rmat.vo.SettleVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/prormat/")
public class ReceiptsApi {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IContractService service;

    @Autowired
    private ICheckService checkService;

    @Autowired
    private IStartService startService;

    @Autowired
    private IStopService stopService;

    @Autowired
    private IRestituteService restituteService;

    @Autowired
    private ILoseService loseService;

    @Autowired
    private ISettleService settleService;

    @Autowired
    private SettleBpmServiceImpl settleBpmService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IOrderService orderService;

    @Autowired
    private IExecutionApi executionApi;

    @Autowired
    private OrderMapper mapper;

    @Autowired
    private IOutRmatApi outRmatApi;

    @Autowired
    private IUserApi userApi;

    @Autowired
    private IAttachmentApi attachmentApi;


    @Autowired
    private IRentCalculateService rentCalculateService;

    /**
     * 辅料中心推送同步生成内租合同
     * @param json,type
     * @return
     */
    @PostMapping(value = "/receiptsSync")
    public CommonResponse<String> receiptsSync(@RequestBody JSONObject json,@RequestParam("type") String type){
        String msg = "单据已经进行过同步操作，请勿重复操作！";
        switch (ReceiptsEnum.getEnumByName(type)) {
            case 租赁订单:
                orderSync(json);
                break;
            case 验收单:
                OutRmatDeliveryVO orderVO = JSON.parseObject(json.toJSONString(),OutRmatDeliveryVO.class);
                CheckEntity checkEntity = BeanMapper.map(orderVO,CheckEntity.class);
                checkEntity.setCheckDetailList(BeanMapper.mapList(orderVO.getOutRmatDeliveryDetailList(), CheckDetailEntity.class));
                CheckEntity data = EntityUtil.selectOneService("id", checkEntity.getId(), CheckServiceImpl.class);
                if(null != data) {
                    logger.info("已有数据！");
                    checkService.delById(checkEntity.getId());
                }
                checkEntity.setRmatDate(orderVO.getRentDate());
                checkEntity.setEmployeeId(orderVO.getProxyEmployeeId());
                checkEntity.setEmployeeName(orderVO.getProxyEmployeeName());
                checkEntity.setCheckDate(orderVO.getOutstoreDate());
                checkEntity.setSupplementRecord("0");
                checkEntity.setCheckSource("2");
                checkEntity.setCheckSourceName("辅料中心");
                checkEntity.getCheckDetailList().forEach(e->{
                    orderVO.getOutRmatDeliveryDetailList().forEach(t->{
                        if(e.getId().equals(t.getId())){
                            e.setUnitId(t.getRentUnitId());
                            e.setUnitName(t.getRentUnitName());
                            e.setCheckId(t.getDeliveryId());
                            e.setDeliverNumsSum(t.getRentNum());
                            e.setCheckNumsSum(t.getRentNum());
                            e.setRmatDate(t.getRentDetailDate());
                        }
                    });
                });
                checkService.saveOrUpdate(checkEntity,false);
                break;
            case 启用单:
                StartEntity startEntity = JSON.parseObject(json.toJSONString(), StartEntity.class);
                StartEntity startData = EntityUtil.selectOneService("id", startEntity.getId(), StartServiceImpl.class);
                if(null != startData) {
                    logger.info("已有数据！");
                    startService.delById(startEntity.getId());
                }
                startService.saveOrUpdate(startEntity,false);
                break;
            case 停用单:
                StopEntity stopEntity = JSON.parseObject(json.toJSONString(), StopEntity.class);
                StopEntity stopData = EntityUtil.selectOneService("id", stopEntity.getId(), StopServiceImpl.class);
                if(null != stopData) {
                    logger.info("已有数据！");
                    stopService.delById(stopEntity.getId());
                }
                stopService.saveOrUpdate(stopEntity,false);
                break;
            case 退赔单:
                RestituteEntity restituteEntity = JSON.parseObject(json.toJSONString(), RestituteEntity.class);
                RestituteEntity resdata = EntityUtil.selectOneService("id", restituteEntity.getId(), RestituteServiceImpl.class);
                if(null != resdata) {
                    logger.info("已有数据！");
                    restituteService.delById(restituteEntity.getId());
                }
                restituteService.saveOrUpdate(restituteEntity,false);
                break;
            case 遗失单:
                LoseEntity loseEntity = JSON.parseObject(json.toJSONString(),LoseEntity.class);
                LoseEntity loseData = EntityUtil.selectOneService("id", loseEntity.getId(), LoseServiceImpl.class);
                if(null != loseData) {
                    logger.info("已有数据！");
                    loseService.delById(loseEntity.getId());
                }
                loseService.saveOrUpdate(loseEntity,false);
                break;
            case 租金计算单:
                RentCalculateEntity rentCalculateEntity= JSON.parseObject(json.toJSONString(), RentCalculateEntity.class);
                logger.info("接收到租金计算单：{}", JSONObject.toJSONString(rentCalculateEntity));
                RentCalculateEntity rentCalculateData = EntityUtil.selectOneService("id", rentCalculateEntity.getId(), RentCalculateServiceImpl.class);
                if(null != rentCalculateData) {
                    logger.info("已有数据！");
                    rentCalculateService.delById(rentCalculateEntity.getId());
                    return CommonResponse.error(msg);
                }
                rentCalculateService.saveOrUpdate(rentCalculateEntity,false);
                logger.info("租金计算推送实际成本---");
                rentCalculateService.costPush(rentCalculateEntity);
                break;
            default:
                SettleEntity settleEntity= JSON.parseObject(json.toJSONString(), SettleEntity.class);
                SettleEntity settleData = EntityUtil.selectOneService("id", settleEntity.getId(), SettleServiceImpl.class);
                if(null != settleData) {
                    logger.info("已有数据！");
                    settleService.delById(settleEntity.getId());
                }
                UserContext userContext = sessionManager.getUserContext();
                settleEntity.setCommitDate(new Date());
                settleEntity.setCommitUserCode(userContext.getUserCode());
                settleEntity.setCommitUserName(userContext.getUserName());
                // 计算成本归集的发生成本金额
                settleEntity.setCostTaxMny(ComputeUtil.safeSub(settleEntity.getSettleTaxMny(), settleEntity.getRentTaxMny()));
                settleEntity.setCostMny(ComputeUtil.safeSub(settleEntity.getSettleMny(), settleEntity.getRentMny()));
                settleEntity.setCostTax(ComputeUtil.safeSub(settleEntity.getCostTaxMny(), settleEntity.getCostMny()));
                settleEntity.setProportionFlag("0");// 分摊状态初始化
                // 推送结算池
                Boolean poolRes = settleService.pushSettleToPool(BeanMapper.map(settleEntity, SettleVO.class));
                if (Boolean.TRUE.equals(poolRes)){
                    settleEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                }else {
                    settleEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
                }
                // 更新合同池操作
                Boolean poolPushResult = settleService.pushContract(BeanMapper.map(settleEntity, SettleVO.class), UpdateLevelEnum.更新非空字段.getLevelCode(),true);
                if(Boolean.TRUE.equals(poolPushResult)) {
                    settleEntity.setPushPoolFlag(BillPushStatusEnum.推送成功.getStatus());
                } else {
                    settleEntity.setPushPoolFlag(BillPushStatusEnum.未成功推送.getStatus());
                }
                settleService.saveOrUpdate(settleEntity,false);
                // 回写合同状态
                if (Objects.equals(settleEntity.getSettleType(), "1")) {
                    LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.set(ContractEntity::getPerformanceStatus, PerformanceStatusEnum.已终止.getCode());
                    updateWrapper.eq(ContractEntity::getId, settleEntity.getContractId());
                    service.update(updateWrapper);
                    // 最终结算推送目标成本
                    ExecutionVO executionVO = settleService.targetCost(settleEntity);
                    CommonResponse<String> response = executionApi.aggPush(executionVO);
                    if (!response.isSuccess()){
                        logger.error("推送目标成本失败: , {}", response.getMsg());
                        throw new BusinessException(response.getMsg());
                    }
                }
                logger.info("推送实际成本---");
                settleService.costPush(settleEntity);
                //回写引用单据结算状态
                settleBpmService.writeSettleFlag(settleEntity, 1);
                break;
        }
        return CommonResponse.success("同步成功！");
    }

    /**
     * 单据撤回删除
     *
     * @param id,type
     * @return
     */
    @PostMapping(value = "/delReceipts")
    public CommonResponse<String> delReceipts(@RequestParam("id") Long id,@RequestParam("type") String type){
        String msg = "操作失败,未查到单据!";
        switch (ReceiptsEnum.getEnumByName(type)) {
            case 验收单:
                CheckEntity data = EntityUtil.selectOneService("id", id, CheckServiceImpl.class);
                if(null == data) {
                    break;
                }
                checkService.delById(id);
                break;
            case 启用单:
                StartEntity startData = EntityUtil.selectOneService("id",id, StartServiceImpl.class);
                if(null == startData) {
                    break;
                }
                startService.delById(id);
                break;
            case 停用单:
                StopEntity stopData = EntityUtil.selectOneService("id", id, StopServiceImpl.class);
                if(null == stopData) {
                    break;
                }
                stopService.delById(id);
                break;
            case 退赔单:
                RestituteEntity resData = EntityUtil.selectOneService("id", id, RestituteServiceImpl.class);
                if(null == resData) {
                    break;
                }
                restituteService.delById(id);
                break;
            case 遗失单:
                LoseEntity loseData = EntityUtil.selectOneService("id", id, LoseServiceImpl.class);
                if(null == loseData) {
                    break;
                }
                loseService.delById(id);
                break;
            case 租金计算单:
                RentCalculateEntity rentCalculateData = EntityUtil.selectOneService("id", id, RentCalculateServiceImpl.class);
                if(null == rentCalculateData) {
                    break;
                }
                // 删除实际成本
                rentCalculateService.pullCost(id);
                logger.info("删除租金计算单---");
                rentCalculateService.delById(id);
                break;
            default:
                SettleEntity settleData = EntityUtil.selectOneService("id", id, SettleServiceImpl.class);
                if(null == settleData) {
                    break;
                }
                // 从结算池中删除数据
                Boolean unPushRes = settleService.delSettleFromPool(settleData.getId());
                if (Boolean.TRUE.equals(unPushRes)) {
                    settleData.setPushPoolFlag(BillPushStatusEnum.未成功推送.getStatus());
                } else {
                    throw new BusinessException("结算单从结算池删除失败!");
                }
                // 回写合同状态
                LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.set(ContractEntity::getPerformanceStatus, PerformanceStatusEnum.履约中.getCode());
                updateWrapper.eq(ContractEntity::getId, settleData.getContractId());
                service.update(updateWrapper);
                // 更新合同池操作
                Boolean poolPushResult = settleService.pushContract(BeanMapper.map(settleData, SettleVO.class), UpdateLevelEnum.更新非空字段.getLevelCode(),false);
                if(Boolean.FALSE.equals(poolPushResult)) {
                    throw new BusinessException("结算单更新合同池失败!");
                }
                // 回写引用单据结算状态
                settleBpmService.writeSettleFlag(settleData, 0);
                // 删除目标成本
                List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
                ExecutionVO executionVO = settleService.targetCost(settleData);
                totalExecutionVOList.add(executionVO.getTotalVO());
                CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
                if (!response.isSuccess()){
                    throw new BusinessException("目标成本删除失败！");
                }
                logger.info("删除实际成本---");
                settleService.pullCost(settleData.getId());
                settleService.delById(id);
                break;
        }
        return CommonResponse.success("删除成功!");
    }

    private void orderSync(JSONObject json){
        OrderEntity orderEntity = JSON.parseObject(json.toJSONString(),OrderEntity.class);
        OrderEntity orderData = EntityUtil.selectOneService("id", orderEntity.getId(), OrderServiceImpl.class);
        if(null != orderData) {
            //orderService.delById(orderEntity.getId());
            List<OrderDetailEntity> list = orderEntity.getOrderDetailList();
            //全部接收或部分接收
            if ("1".equals(orderEntity.getReceiveState()) || "2".equals(orderEntity.getReceiveState())){
                orderData.setReceiveState(orderEntity.getReceiveState());
                if (CollectionUtils.isNotEmpty(orderData.getOrderDetailList())){
                    //接收数量
                    Map<Long, OrderDetailEntity> collect = list.stream().collect(Collectors.toMap(OrderDetailEntity::getId, Function.identity(), (k1, k2) -> k2));
                    for (OrderDetailEntity detailEntity:orderData.getOrderDetailList()){
                        if (collect.get(detailEntity.getId())!=null){
                            OrderDetailEntity detail = collect.get(detailEntity.getId());
                            detailEntity.setReceiveNumsSum(detail.getReceiveNumsSum());
                        }
                    }
                }
            } else {
                //不予接收
                orderData.setDenialReason(orderEntity.getDenialReason());
                orderData.setReceiveState(orderEntity.getReceiveState());
            }
            orderService.saveOrUpdate(orderData,false);
        }
    }

    /**
     * 订单变更送货状态
     * @param jsonArray
     * @return
     */
    @PostMapping(value = "/orderChangeStatus")
    public CommonResponse<String> orderChangeStatus(@RequestBody JSONArray jsonArray) {
        List<OutRmatOrderVO> list = jsonArray.toJavaList(OutRmatOrderVO.class);
        //更新送货状态
        mapper.updateBatch(list);
        List<OutRmatOrderDetailVO> outList = new ArrayList<>();
        for (OutRmatOrderVO orderVO : list) {
            outList.addAll(orderVO.getOrderDetailList());
        }
        //更新子表送货量
        mapper.updateBatchByDetail(outList);
        return CommonResponse.success("回写成功");
    }

    /**
     * 回写辅料中心签字状态
     * @param id,type
     * @return
     */
    @GetMapping(value = "/writeBackSign")
    public CommonResponse<String> writeBackSign(@RequestParam(value = "id") String id,@RequestParam(value = "type") String type) {
        CommonResponse<UserVO> userResp = userApi.findUserByUserId(InvocationInfoProxy.getUserid());
        if(!userResp.isSuccess()) {
            logger.error("查询当前用户id-{},信息失败， {}", InvocationInfoProxy.getUserid(), userResp.getMsg());
            throw new BusinessException("查询当前用户信息失败!");
        }
        UserVO user = userResp.getData();
        Map<String,String> map = new HashMap<>();
        map.put("billId", id);
        map.put("supOperatorName", user.getUserName());
        map.put("supOperatorPhone", user.getUserMobile());
        map.put("supOperatorUserCode", user.getUserCode());
        map.put("supOperateTime", Long.toString(System.currentTimeMillis()));
        Boolean flag = outRmatApi.updateBillSupSignSyncInfo(map,type).isSuccess();
        if (Boolean.FALSE.equals(flag)){
            return CommonResponse.error("回写失败!");
        }else {
            switch (ReceiptsEnum.getEnumBySourceName(type)) {
                case 验收单:
                    CheckEntity entity = checkService.selectById(id);
                    entity.setSupOperateTime(new Date());
                    entity.setSupOperatorPhone(user.getUserMobile());
                    entity.setSupOperatorName(user.getUserName());
                    entity.setSupOperatorUserCode(user.getUserCode());
                    entity.setSupplierSignStatus(SupplierSignStatusEnum.乙方已签字.getCode());
                    checkService.saveOrUpdate(entity,false);
                    break;
                case 启用单:
                    StartEntity startEntity = startService.selectById(id);
                    startEntity.setSupOperateTime(new Date());
                    startEntity.setSupOperatorPhone(user.getUserMobile());
                    startEntity.setSupOperatorName(user.getUserName());
                    startEntity.setSupOperatorUserCode(user.getUserCode());
                    startEntity.setSupplierSignStatus(SupplierSignStatusEnum.乙方已签字.getCode());
                    startService.saveOrUpdate(startEntity,false);
                    break;
                case 停用单:
                    StopEntity stopEntity = stopService.selectById(id);
                    stopEntity.setSupOperateTime(new Date());
                    stopEntity.setSupOperatorPhone(user.getUserMobile());
                    stopEntity.setSupOperatorName(user.getUserName());
                    stopEntity.setSupOperatorUserCode(user.getUserCode());
                    stopEntity.setSupplierSignStatus(SupplierSignStatusEnum.乙方已签字.getCode());
                    stopService.saveOrUpdate(stopEntity,false);
                    break;
                case 退赔单:
                    RestituteEntity restituteEntity = restituteService.selectById(id);
                    restituteEntity.setSupOperateTime(new Date());
                    restituteEntity.setSupOperatorPhone(user.getUserMobile());
                    restituteEntity.setSupOperatorName(user.getUserName());
                    restituteEntity.setSupOperatorUserCode(user.getUserCode());
                    restituteEntity.setSupplierSignStatus(SupplierSignStatusEnum.乙方已签字.getCode());
                    restituteService.saveOrUpdate(restituteEntity,false);
                    break;
                case 遗失单:
                    LoseEntity loseEntity = loseService.selectById(id);
                    loseEntity.setSupOperateTime(new Date());
                    loseEntity.setSupOperatorPhone(user.getUserMobile());
                    loseEntity.setSupOperatorName(user.getUserName());
                    loseEntity.setSupOperatorUserCode(user.getUserCode());
                    loseEntity.setSupplierSignStatus(SupplierSignStatusEnum.乙方已签字.getCode());
                    loseService.saveOrUpdate(loseEntity,false);
                    break;
                default:
                    SettleEntity settleEntity = settleService.selectById(id);
                    settleEntity.setSupOperateTime(new Date());
                    settleEntity.setSupOperatorPhone(user.getUserMobile());
                    settleEntity.setSupOperatorName(user.getUserName());
                    settleEntity.setSupOperatorUserCode(user.getUserCode());
                    settleEntity.setSupplierSignStatus(SupplierSignStatusEnum.乙方已签字.getCode());
                    settleService.saveOrUpdate(settleEntity,false);
                    break;
            }
            signSync(id,ReceiptsEnum.getEnumBySourceName(type).getCode(),ReceiptsEnum.getEnumBySourceName(type).getFileType(),StatusTypeEnum.getEnumByName(type).getCode(),StatusTypeEnum.getEnumByName(type).getFileType());
        }
        return CommonResponse.success("回写成功!");
    }


    private void signSync(String id,String sourceBillType,String sourceBillSourceType,String targetBillType,String targetBillSourceType){
        CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                id, sourceBillType, sourceBillSourceType,
                id, targetBillType, targetBillSourceType);
        if(!response.isSuccess()) {
            throw new BusinessException("同步单据附件失败！");
        }
    }

}
