package com.ejianc.business.pro.rmat.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.common.util.MathUtil;
import com.ejianc.business.contractbase.api.ICommonSNAPI;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.CommonSNVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.rmat.bean.*;
import com.ejianc.business.pro.rmat.enums.*;
import com.ejianc.business.pro.rmat.mapper.ContractMapper;
import com.ejianc.business.pro.rmat.service.*;
import com.ejianc.business.pro.rmat.utils.ListCallable;
import com.ejianc.business.pro.rmat.utils.MaterialConstant;
import com.ejianc.business.pro.rmat.utils.PushSupUtil;
import com.ejianc.business.pro.rmat.vo.*;
import com.ejianc.business.pro.rmat.vo.record.ContractPaymentRecordVO;
import com.ejianc.business.pro.rmat.vo.record.SupplementRecordVO;
import com.ejianc.business.pro.warn.SqlParam;
import com.ejianc.business.profinance.api.IPaymentApplyApi;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.business.promaterial.contract.vo.ContractDetailVO;
import com.ejianc.business.promaterial.pricelib.vo.MaterialCostPriceApiVO;
import com.ejianc.business.promaterial.pricelib.vo.MaterialCostPriceCheckTypeEnum;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.enums.RentTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.business.tender.api.ITenderRmatApi;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import com.ejianc.framework.core.util.HttpTookit;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

/**
 * 周转材租赁合同
 * 
 * @author generator
 * 
 */
@Service("contractService")
public class ContractServiceImpl extends BaseServiceImpl<ContractMapper, ContractEntity> implements IContractService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    private static final String PRO_RMAT_CONTRACT = "PRO_RMAT_CONTRACT"; // 通用单据编码
    private static final String PURCHASE_CONTRACT_YNJT = "RENT_CONTRACT_MATERIAL_YNJT"; // 云南建投私有化单据编码
    private static final String OPERATE = "CONTRACT_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.周转材租赁合同.getCode();
    private static final String BILL_NAME = BillTypeEnum.周转材租赁合同.getName();

    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/prormat/contract/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/prormat/contract/billDel";

    private static final String CHECK_PARAM_CODE = "P-12u3Sd61";
    private static final String SUPPLEMENT_CHECK_PARAM_CODE = "P-AU52M166";
    private static final String TARGET_COST_CHECK_PARAM_CODE = "P-rzH7060210";//[目标成本材料租赁价格】控【周转材租赁合同]

    // 租赁合同-签订、变更、补充协议  【设备租赁清单历史最高价】 控【设备租赁合同价格】
    private final String HISTORY_MAX_PRICE_CTRL_CON_PRICE = "P-Y23zv60262";
    // 租赁合同-签订、变更、补充协议  【设备租赁清单历史最低价】 控【设备租赁合同价格】
    private final String HISTORY_MIN_PRICE_CTRL_CON_PRICE = "P-I57E2G0261";

    @Autowired
    private IBillCodeApi billCodeApi;
    
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ITenderRmatApi tenderRmatApi;

    @Autowired
    private IParamCheckApi paramCheckApi;

    @Autowired
    private IExecutionApi executionApi;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Autowired
    private PushSupUtil pushSupUtil;

    @Autowired
    private IContractPoolApi contractPoolApi;

    @Autowired
    private IProjectSetApi projectSetApi;

    @Autowired
    private IContractService service;

    @Autowired
    private IChangeService changeService;

    @Autowired
    private IContractRelieveService relieveService;

    @Autowired
    private IContractFreezeService freezeService;

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;

    @Autowired
    private ITotalPlanService totalPlanService;

    @Autowired
    private ISettleService settleService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IPaymentApplyApi paymentApplyApi;

    @Value("${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;

    @Autowired
    private ICommonSNAPI commonSNAPI;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IDutyApi dutyApi;

    // 归档参数控制
    private final String FILLING_TYPE_STATE = "P-eg7rBO0134";

    @Override
    public ContractVO saveOrUpdate(ContractVO saveOrUpdateVO,String authority,Boolean isControl) {
        ContractEntity entity = BeanMapper.map(saveOrUpdateVO, ContractEntity.class);

        if(entity.getId() == null || entity.getId() == 0){
            if (StringUtils.isBlank(entity.getBillCode()) && !isControl) {
//                BillCodeParam billCodeParam = BillCodeParam.build(PRO_RMAT_CONTRACT,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
//                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//                if(billCode.isSuccess()) {
//                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//                }else{
//                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//                }

                entity.setBillCode(getContractBillCode(saveOrUpdateVO));

            }
            entity.setId(IdWorker.getId());

            // 设置合同初始状态
            entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
            if (null != entity.getSupplementFlag() && entity.getSupplementFlag() == 0) {
                entity.setMainContractCreateDate(new Date());
            }

            // 设置归档状态
            if (entity.getFilingStatus() == null) {
                entity.setFilingStatus(FilingStatusEnum.未归档.getTypeCode());
            } else if (entity.getFilingStatus().equals(FilingStatusEnum.已归档.getTypeCode())) {
                entity.setFilingRef(0);
            }

            if (!isControl){
                // 回写定标结果占据状态
                if (entity.getTargetResultId() != null) {
//                    tenderRmatApi.updateById(entity.getTargetResultId(), CommonConstant.OCCUPY_STATE);
                    // 校验 本合同金额+定标已签合同金额 是否大于 定标金额
                    validateTargetMny(entity);
                    updateTargetResult(entity, CommonConstant.OCCUPY_STATE);
                }
            }
        }else {
            // 若定标结果更换则回写原来定标结果为未占用状态，新定标结果为占用状态
            ContractEntity oldContractEntity = super.selectById(entity.getId());
//            if (null != entity.getTargetResultId() && !entity.getTargetResultId().equals(oldContractEntity.getTargetResultId()) && !isControl){
//                tenderRmatApi.updateById(oldContractEntity.getTargetResultId(), CommonConstant.UN_OCCUPY_STATE);
//                tenderRmatApi.updateById(entity.getTargetResultId(), CommonConstant.OCCUPY_STATE);
//
//                // 删除定标带出的数据
//                List<Long> dailyIdsList = oldContractEntity.getDailyRentList().stream().map(BaseEntity::getId).collect(Collectors.toList());
//                for (ContractDailyRentEntity dailyRentEntity : entity.getDailyRentList()) {
//                    if (dailyIdsList.contains(dailyRentEntity.getId())) {
//                        dailyRentEntity.setRowState("del");
//                    }
//                }
//
//                List<Long> monthIdsList = oldContractEntity.getMonthRentList().stream().map(BaseEntity::getId).collect(Collectors.toList());
//                for (ContractMonthRentEntity monthRentEntity : entity.getMonthRentList()) {
//                    if (monthIdsList.contains(monthRentEntity.getId())) {
//                        monthRentEntity.setRowState("del");
//                    }
//                }
//
//                List<Long> numIdsList = oldContractEntity.getNumRentList().stream().map(BaseEntity::getId).collect(Collectors.toList());
//                for (ContractNumRentEntity numRentEntity : entity.getNumRentList()) {
//                    if (numIdsList.contains(numRentEntity.getId())) {
//                        numRentEntity.setRowState("del");
//                    }
//                }
//            }

            if (!isControl) {
                if (entity.getTargetResultId() != null) {
                    // 校验 本合同金额+定标已签合同金额 是否大于 定标金额
                    validateTargetMny(entity);

                    updateTargetResult(oldContractEntity, CommonConstant.UN_OCCUPY_STATE);
                    updateTargetResult(entity, CommonConstant.OCCUPY_STATE);
                }
            }
        }

        if (entity.getSupplementFlag() !=null && entity.getSupplementFlag() == 1) {
            validateContract(saveOrUpdateVO.getMainContractId(), MaterialConstant.补充协议, saveOrUpdateVO.getId(), MaterialConstant.保存);
        }

        if (Objects.equals(FilingStatusEnum.已归档.getTypeCode(), entity.getFilingStatus())) {
            entity.setFilingRef(0);
        }

        // 设置初始金额、变更前金额
        entity.setBaseTaxMny(entity.getContractTaxMny()); // 初始版本金额(含税)
        entity.setBaseMny(entity.getContractMny()); // 初始版本金额(不含税)
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny()); // 变更前金额(含税)
        entity.setBeforeChangeMny(entity.getContractMny()); // 变更前金额(不含税)
        if (entity.getContractFileId() != null){
            //合同旧数据
            ContractEntity contract = service.getById(entity.getId());
            if (contract != null
                    && (
                    //如果当前合同是线上起草，而且合同分类做了变更，那么删除附件
                    !contract.getContractCategoryId().equals(entity.getContractCategoryId()) ||
                            //如果改合同上次修改的起草方式不是线上起草  且 这次改为线上起草，则删除附件
                            !(DraftTypeEnum.线上起草.getCode().toString().equals(contract.getDraftType()) ||
                                    DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(contract.getDraftType()))
            )
                    && (
                    DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType()) ||
                            DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(entity.getDraftType())
            )
            ) {
                if (Boolean.FALSE.equals(isControl) && null != contract.getContractFileId()){
                    delContractFile(contract.getContractFileId(), authority);
                }

                entity.setContractFileId(null);
                entity.setContractFilePath(null);
            }
        }
        
        // 设置日租、月租、工程量租剩余数量
        for (ContractDailyRentEntity dailyRentEntity : entity.getDailyRentList()) {
            dailyRentEntity.setSurplusCount(dailyRentEntity.getCount());
        }
        for (ContractMonthRentEntity monthRentEntity : entity.getMonthRentList()) {
            monthRentEntity.setSurplusCount(monthRentEntity.getCount());
        }
        for (ContractNumRentEntity numRentEntity : entity.getNumRentList()) {
            numRentEntity.setSurplusCount(numRentEntity.getCount());
        }

        ContractVO contractVO = null;
        if(!isControl) {
            //起草方式为使用合同模板时，将合同文件同步标识置为未同步
            if(DraftTypeEnum.线上起草.getCode().equals(entity.getDraftType()) || DraftTypeEnum.线上起草不使用电子签章.getCode().equals(entity.getDraftType())) {
                entity.setContractFileSyncFlag(false);
            }

            this.saveOrUpdate(entity, false);
            contractVO = queryDetail(entity.getId());
        }else{
            List<ContractDailyRentEntity> dailyRentList = entity.getDailyRentList();
            List<ContractMonthRentEntity> monthRentList = entity.getMonthRentList();
            List<ContractNumRentEntity> numRentList = entity.getNumRentList();
            List<ContractDailyRentEntity> newDailyRentList = new ArrayList<>();
            List<ContractMonthRentEntity> newMonthRentList = new ArrayList<>();
            List<ContractNumRentEntity> newNumRentList = new ArrayList<>();
            for (ContractDailyRentEntity dailyRentEntity : dailyRentList){
                if(null == dailyRentEntity.getId()){
                    dailyRentEntity.setId(IdWorker.getId());
                }
                if (!"del".equals(dailyRentEntity.getRowState())) {
                    newDailyRentList.add(dailyRentEntity);
                }
            }
            for (ContractMonthRentEntity monthRentEntity : monthRentList){
                if(null == monthRentEntity.getId()){
                    monthRentEntity.setId(IdWorker.getId());
                }
                if (!"del".equals(monthRentEntity.getRowState())) {
                    newMonthRentList.add(monthRentEntity);
                }
            }
            for (ContractNumRentEntity numRentEntity : numRentList){
                if(null == numRentEntity.getId()){
                    numRentEntity.setId(IdWorker.getId());
                }
                if (!"del".equals(numRentEntity.getRowState())) {
                    newNumRentList.add(numRentEntity);
                }
            }
            contractVO = BeanMapper.map(entity, ContractVO.class);
            contractVO.setDailyRentList(BeanMapper.mapList(newDailyRentList, ContractDailyRentVO.class));
            contractVO.setMonthRentList(BeanMapper.mapList(newMonthRentList, ContractMonthRentVO.class));
            contractVO.setNumRentList(BeanMapper.mapList(newNumRentList, ContractNumRentVO.class));
        }

        if(!isControl){
            // 推送目标成本
            CommonResponse<String> response = executionApi.aggPush(targetCost(contractVO));
            logger.info("推送目标成本入参：" + JSONObject.toJSONString(targetCost(contractVO)));
            if (!response.isSuccess()){
                logger.error("推送目标成本失败: , {}", response.getMsg());
                throw new BusinessException(response.getMsg());
            }
        }
        return contractVO;
    }

    //2、增加删除合同附件方法
    public Boolean delContractFile(Long fileId, String authority) {
        Map<String, Object> params = new HashMap<>();
        Map<String, String> header = new HashMap<>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);

        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get(baseHost + "ejc-file-web/attachment/delete", params, header, 10000, 10000);
        } catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse<String> delResp = JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null){
            logger.info("在线起草，删除上传合同返回信息：" + delResp.getMsg());
        }
        return true;
    }

    @Override
    public ContractVO queryDetail(Long id) {
        ContractEntity entity = this.selectById(id);
        ContractVO vo = BeanMapper.map(entity, ContractVO.class);
        
        setRowState(vo);
        
        return vo;
    }

    @Override
    public String delete(List<ContractVO> vos) {
        List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
        if(ListUtil.isNotEmpty(vos)){
            for (ContractVO vo : vos) {
                ContractEntity entity = this.selectById(vo.getId());

                ExecutionVO executionVO = this.targetCost(BeanMapper.map(entity, ContractVO.class));
                totalExecutionVOList.add(executionVO.getTotalVO());
                
                // 删除定标占用状态
                if (null != entity.getTargetResultId()){
//                    CommonResponse<String>  tender = tenderRmatApi.updateById(contractEntity.getTargetResultId(), CommonConstant.UN_OCCUPY_STATE);
//                    logger.info("定标结果占用状态修改为未占用状态信息：" + tender.getMsg());

                    updateTargetResult(entity, CommonConstant.UN_OCCUPY_STATE);
                }
            }
        }
        
        CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()){
            throw new BusinessException("目标成本删除失败！");
        }
        
        this.removeByIds(vos.stream().map(ContractVO::getId).collect(Collectors.toList()),true);
        
        
        return "删除成功！";
    }

    @Override
    public JSONObject pageList(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        // 项合同编号、目名称、合同名称、经办人
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("firstPartyEmployeeName");
        
        
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        param.getParams().put("supplement_flag", new Parameter("eq", 0));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        if(null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);
        String filingTypeConfig = service.getFilingTypeConfig();
        param.setOrderMap(orderMap);
        IPage<ContractEntity> pageData = this.queryPage(param,false);

        // 页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = this.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("filingTypeConfig", filingTypeConfig);
        page.put("contractCount", contractAmountMap);

        return page;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("round(sum(base_tax_mny),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount");
        resp = super.getMap(wrapper);
        return resp;
        
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        // 一个主合同仅有一个未生效得补充协议、单据生效： 当单据审批通过，且签章状态为已签章
        LambdaQueryWrapper<ContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ContractEntity::getMainContractId, id);
        lambda.eq(ContractEntity::getSupplementFlag, ContractVO.CONTRACT_TYPE_SUPPLEMENT);
        lambda.and(l -> l.ne(ContractEntity::getSignatureStatus, String.valueOf(SignatureStatusEnum.已签章.getCode()))
                .or(c -> c.notIn(ContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()))
                .or(c -> c.eq(ContractEntity::getPerformanceStatus, String.valueOf(PerformanceStatusEnum.已作废.getCode()))));
        List<ContractEntity> supplementList = super.list(lambda);
        return supplementList.size() == 0;
        
    }

    @Override
    public SupplementRecordVO querySupplementRecord(Long id) {
        ContractEntity entity = this.selectById(id);
        SupplementRecordVO vo = new SupplementRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setContractMny(entity.getContractMny());
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        vo.setRentType(entity.getRentType());
        
        // 查询补充协议
        LambdaQueryWrapper<ContractEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractEntity::getMainContractId, id);
        wrapper.orderByDesc(ContractEntity::getSignDate);
        List<ContractEntity> supplementList = super.list(wrapper);

        vo.setSupplementToalTaxMny(supplementList.stream().filter(e -> e.getContractTaxMny() != null).map(ContractEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setSupplementToalMny(supplementList.stream().filter(e -> e.getContractMny() != null).map(ContractEntity::getContractMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setSupplementNum(supplementList.size());
        vo.setSupplementMnyRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(vo.getSupplementToalTaxMny(), vo.getContractTaxMny()), new BigDecimal("100")));
        
        vo.setDetailList(BeanMapper.mapList(supplementList, ContractVO.class));
        //归档参数控制校验
        Boolean filingTypeFlag = checkFilingType(id, ContractFilingTypeEnum.租赁合同补充协议.getTypeCode());
        if (filingTypeFlag){
            vo.setEditFlag(true);
        }else {
            vo.setEditFlag(false);
        }
        return vo;
    }
    
    public void setRowState(ContractVO vo) {
        // 日租
        if(ListUtil.isNotEmpty(vo.getDailyRentList())){
            vo.getDailyRentList().forEach(e -> e.setRowState("edit"));
        }
        // 月租
        if(ListUtil.isNotEmpty(vo.getMonthRentList())){
            vo.getMonthRentList().forEach(e -> e.setRowState("edit"));
        }
        // 工程量租
        if(ListUtil.isNotEmpty(vo.getNumRentList())){
            vo.getNumRentList().forEach(e -> e.setRowState("edit"));
        }
        // 维修
        if(ListUtil.isNotEmpty(vo.getRepairList())){
            vo.getRepairList().forEach(e -> e.setRowState("edit"));
        }
        // 报废
        if(ListUtil.isNotEmpty(vo.getScrapList())){
            vo.getScrapList().forEach(e -> e.setRowState("edit"));
        }
        // 其他费用
        if(ListUtil.isNotEmpty(vo.getOtherList())){
            vo.getOtherList().forEach(e -> e.setRowState("edit"));
        }
        // 付款计划
        if(ListUtil.isNotEmpty(vo.getPaymentList())){
            vo.getPaymentList().forEach(e -> e.setRowState("edit"));
        }
        // 合同条款
        if(ListUtil.isNotEmpty(vo.getClauseList())){
            vo.getClauseList().forEach(e -> e.setRowState("edit"));
        }
        
    }

    public ExecutionVO targetCost(ContractVO contractVO) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setContractId(contractVO.getId());

        totalVO.setSourceId(contractVO.getId());
        totalVO.setBillDate(DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO_ON_DATE,contractVO.getSignDate()));
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        totalVO.setMemo(contractVO.getMemo());
        totalVO.setBillType("BT220210000000004");
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.周转材租赁合同.getCode());
        totalVO.setProjectId(contractVO.getProjectId());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setMoney(contractVO.getContractMny());
        totalVO.setTaxMoney(contractVO.getContractTaxMny());
        //目标成本推送改造
        //合同id
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = baseHost;
        }
        String cardType = contractVO.getAddType() == 0 ? "targetCard" : "addCard";
        String url = null;
        if (contractVO.getSupplementFlag() == 0) {
            url = "/ejc-prormat-frontend/#/contract/card?id=" + contractVO.getId() + "&supplementFlag=" + contractVO.getSupplementFlag() +
                    "&cardType=" + cardType + "&performanceStatus=" + contractVO.getPerformanceStatus();
        }else {
            url = "/ejc-prormat-frontend/#/contract/supplementCard?id=" + contractVO.getId() + "&supplementFlag=" + contractVO.getSupplementFlag() +
                    "&cardType=" + cardType + "&performanceStatus=" + contractVO.getPerformanceStatus();
        }

        totalVO.setLinkUrl(frontendBaseHost + url);

        List<ContractDailyRentVO> dailyRentList = contractVO.getDailyRentList();//日租明细
        if (dailyRentList!=null){
            for (ContractDailyRentVO dailyRent:dailyRentList) {
                if ("del".equals(dailyRent.getRowState())){
                    continue;
                }
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(dailyRent.getId() == null ? IdWorker.getId() : dailyRent.getId());
                detailExecutionVO.setSourceBillId(contractVO.getId());
                detailExecutionVO.setCategoryId(dailyRent.getMaterialTypeId());
                detailExecutionVO.setCategoryName(dailyRent.getMaterialTypeName());
                //判断是否是分类
                if (dailyRent.getMaterialId()==null){
                    detailExecutionVO.setCategoryFlag(true);
                    detailExecutionVO.setDocId(dailyRent.getMaterialTypeId());
                }else {
                    detailExecutionVO.setCategoryFlag(false);
                    detailExecutionVO.setDocId(dailyRent.getMaterialId());
                }
                detailExecutionVO.setCode(dailyRent.getMaterialCode());
                detailExecutionVO.setCategoryContainFlag(false);
                //根据分类ID查询物料分类信息
                MaterialCategoryVO categoryVO = materialApi.queryCategoryById(dailyRent.getMaterialTypeId()).getData();
                if (categoryVO==null){
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                }else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());//设置周转材
                detailExecutionVO.setName(dailyRent.getMaterialName());
                detailExecutionVO.setUnitId(dailyRent.getUnitId());
                detailExecutionVO.setUnitName(dailyRent.getUnitName());
                detailExecutionVO.setNum(dailyRent.getCount());
                detailExecutionVO.setMoney(dailyRent.getRentMny());
                detailExecutionVO.setSpec(dailyRent.getSpec());
                detailExecutionVO.setTaxMoney(dailyRent.getRentTaxMny());
                detailExecutionVO.setPrice(dailyRent.getUnitPrice());
                detailExecutionVO.setTaxPrice(dailyRent.getUnitTaxPrice());
                detailExecutionVO.setTaxRate(dailyRent.getTax());
                //TODO 设置合同id 租赁天数 计租方式 组织(主表)、项目名称(主表)
                detailExecutionVO.setContractId(contractVO.getId());
                detailExecutionVO.setRentDayNum(dailyRent.getRentDays()==null?BigDecimal.ZERO:new BigDecimal(dailyRent.getRentDays().toString()));
                detailExecutionVO.setRentType(RentTypeEnum.日租.getCode());
                detailExecutionVO.setMemo(dailyRent.getMemo());
                detailExecutionVO.setContractDetailId(dailyRent.getId());
                detailList.add(detailExecutionVO);

            }
        }
        List<ContractMonthRentVO> monthRentList = contractVO.getMonthRentList();//月租明细

        if (monthRentList!=null){
            for (ContractMonthRentVO monthRentVO:monthRentList) {
                if ("del".equals(monthRentVO.getRowState())){
                    continue;
                }
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();

                detailExecutionVO.setSourceId(monthRentVO.getId() == null ? IdWorker.getId() : monthRentVO.getId());
                detailExecutionVO.setSourceBillId(contractVO.getId());
                detailExecutionVO.setCategoryId(monthRentVO.getMaterialTypeId());
                detailExecutionVO.setCategoryName(monthRentVO.getMaterialTypeName());
                //判断是否是分类
                if (monthRentVO.getMaterialId()==null){
                    detailExecutionVO.setCategoryFlag(true);
                    detailExecutionVO.setDocId(monthRentVO.getMaterialTypeId());
                }else {
                    detailExecutionVO.setCategoryFlag(false);
                    detailExecutionVO.setDocId(monthRentVO.getMaterialId());
                }
                detailExecutionVO.setCode(monthRentVO.getMaterialCode());
                detailExecutionVO.setCategoryContainFlag(false);
                //根据分类ID查询物料分类信息
                MaterialCategoryVO categoryVO = materialApi.queryCategoryById(monthRentVO.getMaterialTypeId()).getData();
                if (categoryVO==null){
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                }else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());//设置周转材
                detailExecutionVO.setName(monthRentVO.getMaterialName());
                detailExecutionVO.setUnitId(monthRentVO.getUnitId());
                detailExecutionVO.setUnitName(monthRentVO.getUnitName());
                detailExecutionVO.setNum(monthRentVO.getCount());
                detailExecutionVO.setMoney(monthRentVO.getRentMny());
                detailExecutionVO.setSpec(monthRentVO.getSpec());
                detailExecutionVO.setTaxMoney(monthRentVO.getRentTaxMny());
                detailExecutionVO.setPrice(monthRentVO.getUnitPrice());
                detailExecutionVO.setTaxPrice(monthRentVO.getUnitTaxPrice());
                detailExecutionVO.setTaxRate(monthRentVO.getTax());
                detailExecutionVO.setContractId(contractVO.getId());
                detailExecutionVO.setRentDayNum(monthRentVO.getRentDays()==null?BigDecimal.ZERO:new BigDecimal(monthRentVO.getRentDays().toString()));
                detailExecutionVO.setRentMonthNum(monthRentVO.getRentMonths()==null?BigDecimal.ZERO:new BigDecimal(monthRentVO.getRentMonths().toString()));
                detailExecutionVO.setRentType(RentTypeEnum.月租.getCode());
                detailExecutionVO.setMemo(monthRentVO.getMemo());
                detailExecutionVO.setContractDetailId(monthRentVO.getId());
                detailList.add(detailExecutionVO);

            }
        }

        List<ContractNumRentVO> numRentList = contractVO.getNumRentList();//工程量租明细
        if (monthRentList!=null){
            for (ContractNumRentVO numRentVO:numRentList) {
                if ("del".equals(numRentVO.getRowState())){
                    continue;
                }
                //TODO 设置合同id 租赁工程量  计租方式 组织(主表)、项目名称(主表)
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(numRentVO.getId() == null ? IdWorker.getId() : numRentVO.getId());
                detailExecutionVO.setSourceBillId(contractVO.getId());
                detailExecutionVO.setCategoryId(numRentVO.getMaterialTypeId());
                detailExecutionVO.setCategoryName(numRentVO.getMaterialTypeName());
                //判断是否是分类
                if (numRentVO.getMaterialId()==null){
                    detailExecutionVO.setCategoryFlag(true);
                    detailExecutionVO.setDocId(numRentVO.getMaterialTypeId());
                }else {
                    detailExecutionVO.setCategoryFlag(false);
                    detailExecutionVO.setDocId(numRentVO.getMaterialId());
                }
                detailExecutionVO.setCode(numRentVO.getMaterialCode());
                detailExecutionVO.setCategoryContainFlag(false);
                //根据分类ID查询物料分类信息
                MaterialCategoryVO categoryVO = materialApi.queryCategoryById(numRentVO.getMaterialTypeId()).getData();
                if (categoryVO==null){
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                }else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());//设置周转材
                detailExecutionVO.setName(numRentVO.getMaterialName());
                detailExecutionVO.setUnitId(numRentVO.getUnitId());
                detailExecutionVO.setUnitName(numRentVO.getUnitName());
                detailExecutionVO.setNum(numRentVO.getCount());
                detailExecutionVO.setMoney(numRentVO.getRentMny());
                detailExecutionVO.setSpec(numRentVO.getSpec());
                detailExecutionVO.setTaxMoney(numRentVO.getRentTaxMny());
                detailExecutionVO.setPrice(numRentVO.getUnitPrice());
                detailExecutionVO.setTaxPrice(numRentVO.getUnitTaxPrice());
                detailExecutionVO.setTaxRate(numRentVO.getTax());
                //TODO 设置合同id 租赁天数 计租方式 组织(主表)、项目名称(主表)
                detailExecutionVO.setContractId(contractVO.getId());
                detailExecutionVO.setRentType(RentTypeEnum.工程量租.getCode());
                detailExecutionVO.setQuantityNum(numRentVO.getQuantities());
                detailExecutionVO.setMemo(numRentVO.getMemo());
                detailExecutionVO.setContractDetailId(numRentVO.getId());
                detailList.add(detailExecutionVO);

            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    /**
     * 单据推送到供方协同服务
     * @param entity
     * @return
     */
    @Override
    public Boolean pushBillToSupCenter(ContractEntity entity) {
        Boolean syncFlag = pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON(entity), OPERATE,
                BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
        return syncFlag;
    }

    /**
     * 将推送至供方的单据作废
     * @param entity
     * @return
     */
    @Override
    public Boolean delPushBill(ContractEntity entity) {
        Boolean delSuc = pushSupUtil.delPushBill((JSONObject) JSONObject.toJSON(entity), OPERATE,
                BILL_TYPE, BILL_NAME, DEL_SUP_BILL_SERVER_URL);
        return delSuc;
        
    }

    /**
     * 推送合同池
     * @param vo
     * @return
     */
    @Override
    public Boolean pushContract(ContractVO vo) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert(vo, data);
            data.setSourceType(ContractTypeEnum.周转材合同.getTypeCode());
            data.setContractProperty(Integer.valueOf(SettleEnum.支出.getCode()));
            
            String cardType = vo.getAddType() == 0 ? "targetCard" : "addCard";
            String url = null;
            if (vo.getSupplementFlag() == 0) {
                url = "/ejc-prormat-frontend/#/contract/contractMultiCards?id=" + vo.getId() + "&supplementFlag=" + vo.getSupplementFlag() +
                        "&cardType=" + cardType + "&performanceStatus=" + vo.getPerformanceStatus();
            }else {
                url = "/ejc-prormat-frontend/#/contract/supplementCard?id=" + vo.getId() + "&supplementFlag=" + vo.getSupplementFlag() +
                        "&cardType=" + cardType + "&performanceStatus=" + vo.getPerformanceStatus();
            }
            data.setPcCardUrl(url);
            
            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);

            if(transDataResp.isSuccess()) {
                return true;
            } else {
                logger.error("合同id-{}推送合同池失败，{}",vo.getId(), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", vo.getId(), e);
        }
        
        
        
        return null;
    }

    @Override
    public String validateContract(Long contractId, String billType, Long billId, String type) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        c1.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("bill_state", new Parameter(QueryParam.IN, "1,3"));
        c2.getParams().put("signature_status", new Parameter(QueryParam.NE, SignatureStatusEnum.已签章.getCode()));
        c1.getComplexParams().add(c2);
        
        // 同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("main_contract_id", new Parameter(QueryParam.EQ, contractId));
        queryParam.getComplexParams().add(c1);
        
        
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam2.getComplexParams().add(c1);
        
        
        QueryParam queryParam3 = new QueryParam();
        queryParam3.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam3.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        QueryParam param = BeanMapper.map(queryParam, QueryParam.class);
        QueryParam param2 = BeanMapper.map(queryParam2, QueryParam.class);
        QueryParam param3 = Utils.deepCopy(queryParam3);// 深拷贝
        if(billId != null){
            param.getParams().put("id", new Parameter(QueryParam.NE, billId));
            param2.getParams().put("id", new Parameter(QueryParam.NE, billId));
            param3.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }
        
        Future<JSONArray> future1 = ListCallable.excute(threadPool, MaterialConstant.补充协议.equals(billType) ? param : queryParam, service); // 补充协议
        Future<JSONArray> future2 = ListCallable.excute(threadPool, MaterialConstant.变更单.equals(billType) ? param2 : queryParam2, changeService); // 变更单
        Future<JSONArray> future3 = ListCallable.excute(threadPool, MaterialConstant.解除单.equals(billType) ? param2 : queryParam2, relieveService); // 解除单
        Future<JSONArray> future4 = ListCallable.excute(threadPool, MaterialConstant.冻结单.equals(billType) ? param3 : queryParam3, freezeService); // 冻结单
        
        List<ContractEntity> supplementList = new ArrayList<>(); // 补充协议
        List<ChangeEntity> changeList = new ArrayList<>(); // 变更单
        List<ContractRelieveEntity> relieveList = new ArrayList<>(); // 解除单
        List<ContractFreezeEntity> freezeList = new ArrayList<>(); // 冻结单
        
        try {
            supplementList = JSONObject.parseArray(future1.get().toJSONString(), ContractEntity.class);
            changeList = JSONObject.parseArray(future2.get().toJSONString(), ChangeEntity.class);
            relieveList = JSONObject.parseArray(future3.get().toJSONString(), ContractRelieveEntity.class);
            freezeList = JSONObject.parseArray(future4.get().toJSONString(), ContractFreezeEntity.class);
        } catch (Exception e) {
            logger.error("查询数据异常", e);
        } finally {
            threadPool.shutdown();
        }
        if(ListUtil.isNotEmpty(supplementList)){
            throw new BusinessException("当前合同存在非审批通过态或未签章的补充协议，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(changeList)){
            throw new BusinessException("当前合同存在非审批通过态或未签章的变更单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(freezeList)){
            throw new BusinessException("当前合同存在非审批通过态的冻结单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(relieveList)){
            throw new BusinessException("当前合同存在非审批通过态或未签章的解除单，不允许" + type + "!");
        }
        
        return "校验通过！";
    }

    /**
     * 删除合同池数据
     * @param id
     * @return
     */
    @Override
    public Boolean delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);

        logger.info("将合同-{}从合同池中删除！", id);
        CommonResponse<String> delDataResp = contractPoolApi.deleteContract(c);
        if(delDataResp.isSuccess()) {
            return true;
        }

        logger.error("将合同-{}从合同池中删除失败, {}！", id, delDataResp.getMsg());
        return false;
    }

    @Override
    public ParamsCheckVO targetCostCtrl(ContractVO contractVO,String authority) {
        ContractVO vo = saveOrUpdate(contractVO,authority, true);
        //目标成本推送
        ExecutionVO executionVO = targetCost(vo);
        logger.error("ss" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        return response.getData();
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        ContractVO contractVO = queryDetail(id);
        //目标成本推送
        ExecutionVO executionVO = targetCost(contractVO);
        logger.error("ss" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        return response.getData();
    }

    /**
     * 单据管控 合同金额大于总计划金额*X%
     * @return
     */
    @Override
    public ParamsCheckVO checkParams(ContractVO contractVO) {
        ContractVO vo = saveOrUpdate(contractVO,null, true);
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒) Integer purchaseType, Long id, Long projectId, BigDecimal contractTaxMny,Long orgId
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        Long orgId = vo.getOrgId();
        if (vo.getOrgId() == null){
            CommonResponse<ProjectPoolSetVO> project = projectSetApi.getProjectId(vo.getProjectId());
            if (project.isSuccess() && project.getData() != null) {
                vo.setOrgId(project.getData().getProjectDepartmentId());
            }
        }
        // 【施工合同】控【支出合同金额】 接口
        CommonResponse<List<ParamsCheckVO>> ctrlOutConMnyRes = paramCheckApi.paramsCheck(vo.getProjectId(), vo.getId(),vo.getContractTaxMny(),orgId);
        if (ctrlOutConMnyRes.isSuccess() && ctrlOutConMnyRes.getData() != null) {
            paramsCheckVOS.addAll(ctrlOutConMnyRes.getData());
        }
        paramsCheckVOS.addAll(checkParamsMny(1,vo.getId(),vo.getProjectId(),vo.getContractTaxMny(),orgId));//金额控制

        //目标成本价格控制
        ParamsCheckVO costParams = this.costPriceCheckParams(vo);
        if(costParams!=null){
            paramsCheckVOS.add(costParams);
        }

        // 历史价控 合同价
        paramsCheckVOS.addAll(service.historyPriceCtrlContractPrice(vo));

        ExecutionVO executionVO = targetCost(vo);
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        if (response.isSuccess() && response.getData() != null) {
            paramsCheckVOS.add(response.getData());
        }
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(org.apache.commons.collections.CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }



    public ParamsCheckVO costPriceCheckParams(ContractVO vo) {
        MaterialCostPriceApiVO materialPriceHistoryApiVO = new MaterialCostPriceApiVO();
        ArrayList<MaterialCostPriceApiVO> materialPriceHistoryApiVOS = new ArrayList<>();
        if(CollectionUtil.isNotEmpty(vo.getDailyRentList())){
            for (ContractDailyRentVO detailVO : vo.getDailyRentList()) {
                if(!"del".equals(detailVO.getRowState()) && detailVO.getMaterialId()!=null){
                    MaterialCostPriceApiVO priceHistoryApiVO = new MaterialCostPriceApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                    priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getUnitPrice());
                    priceHistoryApiVO.setTaxPrice(detailVO.getUnitTaxPrice());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        if(CollectionUtil.isNotEmpty(vo.getMonthRentList())){
            for (ContractMonthRentVO detailVO : vo.getMonthRentList()) {
                if(!"del".equals(detailVO.getRowState()) && detailVO.getMaterialId()!=null){
                    MaterialCostPriceApiVO priceHistoryApiVO = new MaterialCostPriceApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                    priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getUnitPrice());
                    priceHistoryApiVO.setTaxPrice(detailVO.getUnitTaxPrice());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        if(CollectionUtil.isNotEmpty(vo.getNumRentList())){
            for (ContractNumRentVO detailVO : vo.getNumRentList()) {
                if(!"del".equals(detailVO.getRowState()) && detailVO.getMaterialId()!=null){
                    MaterialCostPriceApiVO priceHistoryApiVO = new MaterialCostPriceApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                    priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getUnitPrice());
                    priceHistoryApiVO.setTaxPrice(detailVO.getUnitTaxPrice());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        materialPriceHistoryApiVO.setProjectId(vo.getProjectId());
        materialPriceHistoryApiVO.setMaterialCostPriceApiVOList(materialPriceHistoryApiVOS);
        ParamsCheckVO paramsCheckVO = this.costPriceParams(materialPriceHistoryApiVO,"P-rzH7060210","合同");
        return  paramsCheckVO;

    }
    private List<ParamsCheckVO> checkParamsMny(Integer purchaseType, Long id, Long projectId, BigDecimal contractTaxMny,Long orgId) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE,orgId);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    List<TotalPlanEntity> totalPlanList = totalPlanService.listTotalPlanByProjectId(projectId);
                    if (CollectionUtils.isEmpty(totalPlanList)){
                        // 该项目无总计划直接赋值为不控制
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        paramsCheckVOList.add(paramsCheckVO);
                        return paramsCheckVOList;
                    }
                    if (2 == purchaseType) {
                        // 集采合同直接赋值为不控制
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        continue;
                    }
                    BigDecimal sumEstimatedMny = totalPlanList.stream().map(TotalPlanEntity::getEstimatedMny).reduce(BigDecimal::add).get();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(sumEstimatedMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    BigDecimal sumContractTaxMny = BigDecimal.ZERO;
                    List<ContractEntity> contractEntities = this.listContractByProjectId(id,projectId);
                    List<ContractEntity> contractListA = contractEntities.stream().filter(e ->
                            PerformanceStatusEnum.未签订.getCode().equals(e.getPerformanceStatus()) ||
                                    PerformanceStatusEnum.履约中.getCode().equals(e.getPerformanceStatus()) ||
                                    PerformanceStatusEnum.已冻结.getCode().equals(e.getPerformanceStatus())
                    ).collect(Collectors.toList());

                    for(ContractEntity entity : contractListA){
                        if (ChangeStatusEnum.变更中.getCode().equals(entity.getChangeStatus())){
                            LambdaQueryWrapper<ChangeEntity> queryWrapper = new LambdaQueryWrapper<>();
                            queryWrapper.eq(ChangeEntity::getContractId, entity.getId());
                            queryWrapper.eq(ChangeEntity::getDr,0);
                            queryWrapper.notIn(ChangeEntity::getBillState,1,3);
                            queryWrapper.eq(ChangeEntity::getTenantId,InvocationInfoProxy.getTenantid());
                            List<ChangeEntity> changeList = changeService.list(queryWrapper);

                            BigDecimal afterChangeTaxMny = changeList.stream().map(ChangeEntity::getContractTaxMny).reduce(BigDecimal::add).get();

                            sumContractTaxMny = MathUtil.safeAdd(sumContractTaxMny,afterChangeTaxMny);
                        }else{
                            sumContractTaxMny = MathUtil.safeAdd(sumContractTaxMny,entity.getContractTaxMny());
                        }
                    }

                    List<ContractEntity> contractListB = contractEntities.stream().filter(e ->
                            PerformanceStatusEnum.已终止.getCode().equals(e.getPerformanceStatus()) ||
                                    PerformanceStatusEnum.已作废.getCode().equals(e.getPerformanceStatus()) ||
                                    PerformanceStatusEnum.已结束.getCode().equals(e.getPerformanceStatus())
                    ).collect(Collectors.toList());
                    BigDecimal sumSettleTaxMny = BigDecimal.ZERO;
                    if (CollectionUtils.isNotEmpty(contractListB)){
                        List<Long> contractIds = contractListB.stream().map(ContractEntity::getId).collect(Collectors.toList());
                        LambdaQueryWrapper<SettleEntity> queryWrapper = new LambdaQueryWrapper<>();
                        queryWrapper.eq(SettleEntity::getDr,0);
                        queryWrapper.in(SettleEntity::getContractId,contractIds);
                        List<SettleEntity> settleList = settleService.list(queryWrapper);
                        if (CollectionUtils.isNotEmpty(settleList)){
                            sumSettleTaxMny = settleList.stream().map(SettleEntity::getSettleTaxMny).reduce(BigDecimal::add).get();
                        }
                        sumContractTaxMny = MathUtil.safeAdd(sumContractTaxMny,sumSettleTaxMny);
                    }
                    sumContractTaxMny = MathUtil.safeAdd(sumContractTaxMny,contractTaxMny).setScale(2,BigDecimal.ROUND_HALF_UP);
                    contractTaxMny = contractTaxMny != null ? contractTaxMny.setScale(2,BigDecimal.ROUND_HALF_UP) : BigDecimal.ZERO;
                    if (sumContractTaxMny.compareTo(comMny) > 0) {
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("租赁金额超总计划金额");
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnName("累计合同金额大于总计划金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次合同金额：").append(contractTaxMny)
                                .append("元，含本次累计合同金额：").append(sumContractTaxMny)
                                .append("元，总计划金额*").append(roleValue).append("% = ").append(comMny)
                                .append("元。超结金额：").append(ComputeUtil.safeSub(sumContractTaxMny, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }else{
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        paramsCheckVOList.add(paramsCheckVO);
                        return paramsCheckVOList;
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }


    /**
     * 历史价控合同价
     * @param contractVO
     * @return
     */
    public List<ParamsCheckVO> historyPriceCtrlContractPrice(ContractVO contractVO) {
        logger.info("proequipment---RentContractServiceImpl---historyPriceCtrlContractPrice()--- 历史价控合同价入参：{}", JSONObject.toJSONString(contractVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        CommonResponse<List<BillParamVO>> maxParamByCode = new CommonResponse<>();
        CommonResponse<List<BillParamVO>> minParamByCode = new CommonResponse<>();
        List<ContractDailyRentVO> dayDetailList = contractVO.getDailyRentList();
        List<ContractMonthRentVO> monthDetailList = contractVO.getMonthRentList();
        List<ContractNumRentVO> quantitiesDetailList = contractVO.getNumRentList();

        maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(HISTORY_MAX_PRICE_CTRL_CON_PRICE, contractVO.getOrgId());
        minParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(HISTORY_MIN_PRICE_CTRL_CON_PRICE, contractVO.getOrgId());

        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        if (!minParamByCode.isSuccess() || null == minParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", minParamByCode.getMsg());
            return paramsCheckVOList;
        }
        logger.info("单据控制参数查询结果：{}", JSONObject.toJSONString(maxParamByCode));


        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果
        List<BillParamVO> minParamVOS = minParamByCode.getData();
        logger.info("周转材租赁合同历史高价控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        logger.info("周转材租赁合同历史低价控制信息返回："+JSONObject.toJSONString(minParamVOS));
        //todo 取优先级
        boolean flag = true;
        logger.info("传入参数--{}",JSONObject.toJSONString(PrinceDepotEnum.周转材价格库.getCode()));
        CommonResponse<List<PriceDepotParamSetDTO>> commonResponse = priceDepotParamSetApi.queryPriceDepotParamSetList(PrinceDepotEnum.周转材价格库.getCode());
        if(!commonResponse.isSuccess()){
            throw new BusinessException(commonResponse.getMsg());
        }
        List<PriceDepotParamSetDTO> data = commonResponse.getData();
        Integer priorityFlag = data.get(0).getPriorityFlag();
        if(null!=priorityFlag&&2==priorityFlag){
            //指导价优先
            flag = false;
        }
        if(CollectionUtils.isNotEmpty(maxParamVOS)){//遍历高价
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();//高价校验比例
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) {
                    continue;
                }
                //日租
                for (ContractDailyRentVO  detailVO: dayDetailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("明细：{}--高价：{}---低价：{}",detailVO.getMaterialName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getUnitPrice()==null ? BigDecimal.ZERO : detailVO.getUnitPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//日租单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                            paramsCheckDsVO.setWarnName("日租单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("日租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                //月租
                for (ContractMonthRentVO  detailVO: monthDetailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}",detailVO.getMaterialName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getUnitPrice()==null ? BigDecimal.ZERO : detailVO.getUnitPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//月租单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                            paramsCheckDsVO.setWarnName("月租单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("月租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                //工程量租
                for (ContractNumRentVO  detailVO: quantitiesDetailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}",detailVO.getMaterialName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getUnitPrice()==null ? BigDecimal.ZERO : detailVO.getUnitPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//工程量租单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                            paramsCheckDsVO.setWarnName("工程量租单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("工程量租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        if(CollectionUtils.isNotEmpty(minParamVOS)){//遍历低价
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();//低价
                List<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();//低价校验比例
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);//低价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[minParamVO.getControlType()])) {
                    continue;
                }
                //日租
                for (ContractDailyRentVO  detailVO: dayDetailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}",detailVO.getMaterialName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getUnitPrice()==null ? BigDecimal.ZERO : detailVO.getUnitPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//日租单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(minPriceParam) < 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                            paramsCheckDsVO.setWarnName("日租单价小于于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("日租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam,price).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                //月租
                for (ContractMonthRentVO  detailVO: monthDetailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}",detailVO.getMaterialName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getUnitPrice()==null ? BigDecimal.ZERO : detailVO.getUnitPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//月租单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(minPriceParam) < 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                            paramsCheckDsVO.setWarnName("月租单价小于于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("月租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam,price).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                //工程量租
                for (ContractNumRentVO  detailVO: quantitiesDetailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}",detailVO.getMaterialName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getUnitPrice()==null ? BigDecimal.ZERO : detailVO.getUnitPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//工程量租单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(minPriceParam) < 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                            paramsCheckDsVO.setWarnName("工程量租单价小于于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("工程量租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam,price).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOList.add(paramsCheckVOMin);
            }
        }

        return paramsCheckVOList;
    }


    /**
     * 单据管控 补充协议金额大于合同金额金额*X%
     * @param id
     * @param mainContractId
     * @param supplementContractTaxMny
     * @return
     */
    @Override
    public ParamsCheckVO supplementCheckParams(Long id, Long mainContractId, BigDecimal supplementContractTaxMny){
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        paramsCheckVOS.addAll(checkParamsSupplementMny(id,mainContractId,supplementContractTaxMny));//金额控制
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(org.apache.commons.collections.CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }
    private List<ParamsCheckVO> checkParamsSupplementMny(Long id, Long mainContractId, BigDecimal supplementContractTaxMny) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        ContractEntity mainContractEntity = super.selectById(mainContractId);
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(SUPPLEMENT_CHECK_PARAM_CODE,mainContractEntity.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
//                    ContractEntity mainContractEntity = super.selectById(mainContractId);
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(mainContractEntity.getContractTaxMny(), roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    LambdaQueryWrapper<ContractEntity> queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(ContractEntity::getMainContractId,mainContractId);
                    queryWrapper.in(ContractEntity::getBillState,1,3);
                    queryWrapper.eq(ContractEntity::getDr,0);
                    queryWrapper.eq(ContractEntity::getTenantId,InvocationInfoProxy.getTenantid());
                    List<ContractEntity> supplementContractList = super.list(queryWrapper);
                    BigDecimal sumSupplementContractTaxMny = BigDecimal.ZERO;
                    if (CollectionUtils.isNotEmpty(supplementContractList)){
                        sumSupplementContractTaxMny = supplementContractList.stream().map(ContractEntity::getContractTaxMny).reduce(BigDecimal::add).get();
                    }
                    sumSupplementContractTaxMny = ComputeUtil.safeAdd(sumSupplementContractTaxMny,supplementContractTaxMny).setScale(2,BigDecimal.ROUND_HALF_UP);
                    supplementContractTaxMny = supplementContractTaxMny != null ? supplementContractTaxMny.setScale(2,BigDecimal.ROUND_HALF_UP) : BigDecimal.ZERO;
                    if (sumSupplementContractTaxMny.compareTo(comMny) > 0) {
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("补充协议超合同金额");
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnName("累计补充协议金额大于合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次补充协议金额：").append(supplementContractTaxMny)
                                .append("元，含本次补充协议金额：").append(sumSupplementContractTaxMny)
                                .append("元，合同金额*").append(roleValue).append("% = ").append(comMny)
                                .append("元。超出金额：").append(ComputeUtil.safeSub(sumSupplementContractTaxMny, comMny).setScale(2,BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }else{
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        paramsCheckVOList.add(paramsCheckVO);
                        return paramsCheckVOList;
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }

    /**
     * 单据管控-累计结算金额大于合同金额
     * @param sqlParamList
     * @return
     */
    @Override
    public List<Map<String, Object>> querySettleWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.querySettleWarnContract(sqlParamList);
    }

    @Override
    public Boolean syncPushExecution(Long id) {
        ContractVO contractVO = queryDetail(id);

        if (PerformanceStatusEnum.已作废.getCode().equals(contractVO.getPerformanceStatus())) {
            // 推送作废的合同信息
            LambdaQueryWrapper<ContractRelieveEntity> relieveWrapper = new LambdaQueryWrapper<>();
            relieveWrapper.eq(ContractRelieveEntity::getContractId, contractVO.getId());
            List<ContractRelieveEntity> relieveList = relieveService.list(relieveWrapper);
            ExecutionVO executionVO2 = relieveService.targetCost(relieveList.get(0));

            // 推送目标成本
            CommonResponse<String> response = executionApi.aggPush(executionVO2);
            logger.info("合同解除推送目标成本入参：" + JSONObject.toJSONString(executionVO2));
            if (!response.isSuccess()){
                logger.error("合同解除推送目标成本失败: , {}", response.getMsg());
                throw new BusinessException(response.getMsg());
            }
        }

        ExecutionVO executionVO = null;
        // 查询变更信息
        LambdaQueryWrapper<ChangeEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ChangeEntity::getContractId, id);
        wrapper.orderByDesc(ChangeEntity::getCreateTime);
        List<ChangeEntity> list = changeService.list(wrapper);

        if (ListUtil.isEmpty(list)) {
            executionVO = targetCost(contractVO);
        }else {
            ChangeEntity changeEntity = list.get(0);
            executionVO = changeService.targetCost(BeanMapper.map(changeEntity, ChangeVO.class));
        }

        // 推送目标成本
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        logger.info("合同推送目标成本入参：" + JSONObject.toJSONString(executionVO));
        if (!response.isSuccess()){
            logger.error("合同推送目标成本失败: , {}", response.getMsg());
            throw new BusinessException(response.getMsg());
        }
        return true;
    }

    @Override
    public Integer queryTotalSettleNum(Long id) {
        LambdaQueryWrapper<SettleEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SettleEntity::getContractId, id);
        wrapper.in(SettleEntity::getBillState, Arrays.asList(1, 3));

        List<SettleEntity> list = settleService.list(wrapper);
        if (ListUtil.isNotEmpty(list)) {
            return list.size();
        }
        return 0;
    }

    @Override
    public List<ContractEntity> listContractByProjectId(Long id,Long projectId){
        LambdaQueryWrapper<ContractEntity> queryWrapper = new LambdaQueryWrapper<>();
        if (null != id){
            queryWrapper.ne(ContractEntity::getId,id);
        }
        queryWrapper.eq(ContractEntity::getProjectId,projectId);
        queryWrapper.eq(ContractEntity::getTenantId,InvocationInfoProxy.getTenantid());
        queryWrapper.eq(ContractEntity::getDr,0);
        //queryWrapper.in(ContractEntity::getBillState,1,3);
        return super.list(queryWrapper);
    }

    /**
     * 删除文件中心水印文件
     *
     * @param watermarkFileId 水印合同附件id
     * @return boolean 是否删除标识
     */
    public boolean delWatermarkContractFile(Long watermarkFileId) {
        Assert.notNull(watermarkFileId, "水印合同附件不能为空！");
        CommonResponse<String> res = attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            logger.error("删除文件中心水印文件失败，原因：{}，水印文件id：{}", res.getMsg(), watermarkFileId);
            throw new BusinessException("删除文件中心水印文件失败，原因：" + res.getMsg() + "，水印文件id：" + watermarkFileId);
        }
        return true;
    }

    @Override
    public ContractPaymentRecordVO queryPaymentApplyList(Long id) {
        ContractPaymentRecordVO resultVO = new ContractPaymentRecordVO();

        // 查询合同
        ContractEntity contractEntity = service.selectById(id);
        resultVO.setContractId(id);
        resultVO.setContractTaxMny(contractEntity.getContractTaxMny());
        resultVO.setContractMny(contractEntity.getContractMny());
        resultVO.setPerformanceStatus(contractEntity.getPerformanceStatus());
        resultVO.setSignatureStatus(contractEntity.getSignatureStatus());
        resultVO.setChangeStatus(contractEntity.getChangeStatus());
        resultVO.setRentType(contractEntity.getRentType());
        // 查询付款申请单
        CommonResponse<List<PaymentApplyVO>> resultData = paymentApplyApi.queryListByContractId(id);
        if (!resultData.isSuccess()) {
            throw new BusinessException("查询合同付款失败");
        }
        List<PaymentApplyVO> paymentApplyVOList = resultData.getData();
        if (ListUtil.isNotEmpty(paymentApplyVOList)){
            resultVO.setTotalApplyMny(paymentApplyVOList.stream().map(PaymentApplyVO::getApplyMny).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
            resultVO.setTotalActualMny(paymentApplyVOList.stream().map(PaymentApplyVO::getActualMny).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
            resultVO.setTotalApprovalMny(paymentApplyVOList.stream().map(PaymentApplyVO::getApprovalMny).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
            paymentApplyVOList.forEach(item -> {
                item.setApplyMny(item.getApplyMny() != null ? item.getApplyMny() : BigDecimal.ZERO);
                item.setActualMny(item.getActualMny() != null ? item.getActualMny() : BigDecimal.ZERO);
                item.setApprovalMny(item.getApprovalMny() != null ? item.getApprovalMny() : BigDecimal.ZERO);
            });
            resultVO.setPaymentApplyList(paymentApplyVOList);
        }else {
            resultVO.setTotalApplyMny(BigDecimal.ZERO);
            resultVO.setTotalActualMny(BigDecimal.ZERO);
            resultVO.setTotalApprovalMny(BigDecimal.ZERO);
        }

        if (resultVO.getTotalActualMny() != null) {
            resultVO.setPaymentRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(resultVO.getTotalActualMny(), resultVO.getContractTaxMny()), new BigDecimal("100")));
        }else {
            resultVO.setPaymentRate(BigDecimal.ZERO);
        }

        CommonResponse<String> addFlagData = paymentApplyApi.queryAddFlagContractId(id);
        if (addFlagData != null && addFlagData.getData() != null){
            if (addFlagData.getData().equals("1")){
                resultVO.setAddFlag(true);
            }
        }
        //检测是否可以创建新的合同付款
        Boolean contractFilingFlag = service.checkFilingType(id, ContractFilingTypeEnum.合同付款申请.getTypeCode());
        if (contractFilingFlag){
            resultVO.setAddFlag(true);
        }else {
            resultVO.setAddFlag(false);
        }
        return resultVO;
    }

    @Override
    public Boolean validateTargetMny(ContractEntity entity) {
        LambdaQueryWrapper<ContractEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractEntity::getTargetResultId, entity.getTargetResultId());
        if (entity.getId() != null) {
            wrapper.ne(ContractEntity::getId, entity.getId());
        }
        List<ContractEntity> list = this.list(wrapper);

        BigDecimal sumContractTaxMny = list.stream().map(ContractEntity::getBaseTaxMny).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        sumContractTaxMny = ComputeUtil.safeAdd(sumContractTaxMny, entity.getContractTaxMny());

        if (sumContractTaxMny.compareTo(entity.getTargetTaxMny()!=null?entity.getTargetTaxMny():BigDecimal.ZERO) > 0) {
            throw new BusinessException("合同金额超过定标金额，不可保存！");
        }

        return true;
    }

    @Override
    public List<SignContractVo> queryContractByTargetResultId(List<String> targetResultIdList) {
        List<SignContractVo> rtnList = new ArrayList<>();
        if (ListUtil.isEmpty(targetResultIdList)) return rtnList;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("targetResultId", new Parameter(QueryParam.IN, targetResultIdList));
        queryParam.getOrderMap().put("signDate", QueryParam.DESC);
        List<ContractEntity> entityList = this.queryList(queryParam, false);
        if (ListUtil.isEmpty(entityList)) return rtnList;
        for (ContractEntity entity : entityList) {
            SignContractVo vo = new SignContractVo();
            vo.setBillCode(entity.getBillCode());
            vo.setContractId(entity.getId());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());
            vo.setSupplierName(entity.getSupplierName());
            vo.setContractMny(entity.getContractMny());
            vo.setContractTaxMny(entity.getContractTaxMny());
            vo.setSignDate(entity.getSignDate());
            vo.setBillState(entity.getBillState());
            vo.setLinkUrl(getContractLinkUrl(entity.getTargetResultId(), entity.getId(), entity.getSupplementFlag()
                    , entity.getPerformanceStatus(), entity.getAddType()));
            rtnList.add(vo);
        }

        return rtnList;
    }

    /**
     * 获取合同跳转路径（不包含baseHost）
     *
     * @param targetResultId    定标结果id
     * @param contractId        合同id
     * @param supplementFlag    是否补充协议
     * @param performanceStatus 履约状态
     * @return 合同路径
     */
    private String getContractLinkUrl(Long targetResultId, Long contractId, Integer supplementFlag, String performanceStatus
            , Integer addType) {
        String cardType = addType == 0 ? "targetCard" : "addCard";

        String url = null;
        if (supplementFlag == 0) {
            url = "/ejc-prormat-frontend/#/contract/contractMultiCards?id=" + contractId + "&supplementFlag=" + supplementFlag +
                    "&cardType=" + cardType + "&performanceStatus=" + performanceStatus;
        }else {
            url = "/ejc-prormat-frontend/#/contract/supplementCard?id=" + contractId + "&supplementFlag=" + supplementFlag +
                    "&cardType=" + cardType + "&performanceStatus=" + performanceStatus;
        }

        return url;
    }


    /**
     * 生成合同编码规则
     *
     * @param contractVo 合同vo
     * @return 生成结果
     */
    private String getContractBillCode(ContractVO contractVo) {
        String contractBillCode;
        logger.info("生成编码规则，GenerateBillCodeType=：{}", GenerateBillCodeType);

        if (Objects.equals(contractVo.getSupplementFlag(), ContractVO.CONTRACT_TYPE_SUPPLEMENT)) {
            // 查询补充协议
            LambdaQueryWrapper<ContractEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(ContractEntity::getMainContractId, contractVo.getMainContractId());
            wrapper.in(ContractEntity::getBillState, Arrays.asList(1, 3));
            List<ContractEntity> list = this.list(wrapper);

            String supplementNum = "";
            if (list.size() < 10) {
                supplementNum += "0" + (list.size() + 1);
            }else {
                supplementNum += (list.size() + 1);
            }

            contractBillCode = contractVo.getMainContractCode() + "-2-" + supplementNum;
        }else {
            switch (GenerateBillCodeType) {
                case "common":
                    BillCodeParam billCodeParam = BillCodeParam.build(PRO_RMAT_CONTRACT, InvocationInfoProxy.getTenantid(), contractVo);
                    CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                    if (billCode.isSuccess()) {
                        contractBillCode = billCode.getData();
                    } else {
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    break;
                case "ynjt":
                    BillCodeParam billCodeParamYnjt = BillCodeParam.build(PURCHASE_CONTRACT_YNJT, InvocationInfoProxy.getTenantid(), contractVo);
                    CommonResponse<String> billCodeFirstPart = billCodeApi.generateBillCode(billCodeParamYnjt);
                    if (!billCodeFirstPart.isSuccess()) {
                        logger.error("保存合同失败，自动生成合同合同失败: {}", billCodeFirstPart.getMsg());
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    // 根据合同基层单位后三位查询查询流水号
                    String orgSub = contractVo.getParentOrgCode().substring(contractVo.getParentOrgCode().length() - 3);
                    CommonSNVO commonSNVO = new CommonSNVO();
                    commonSNVO.setSnLength(4); // 流水号长度
                    commonSNVO.setTenantId(InvocationInfoProxy.getTenantid());  // 租户Id
                    commonSNVO.setDimension(orgSub); // 流水依据
                    commonSNVO.setSourceType("YNJTCLCG"); // 单据业务类型
                    CommonResponse<String> snResp = commonSNAPI.getNext(commonSNVO);
                    if (!snResp.isSuccess()) {
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    contractBillCode = billCodeFirstPart.getData() + orgSub + snResp.getData();
                    break;
                default:
                    throw new BusinessException("编码生成失败！");
            }
        }

        return contractBillCode;
    }

    public void updateTargetResult(ContractEntity entity, Integer type) {
        if (entity.getTargetResultId() == null) return;
        TenderPicketageVO vo = new TenderPicketageVO();
        vo.setId(entity.getTargetResultId()); // 定标参照id
        vo.setContractMoneyTax(entity.getContractTaxMny()); // 合同金额（含税）
        vo.setContractMoney(entity.getContractMny()); // 合同金额

        CommonResponse<String> response;
        if (1 == type) {
            // 占用
            response = tenderRmatApi.updateStatus(vo);
        } else {
            // 释放
            response = tenderRmatApi.delUpdateStatus(vo);
        }
        logger.info("修改定标结果：{}", JSONObject.toJSONString(response));
        if (!response.isSuccess()) {
            throw new BusinessException(1 == type ? "占用" : "释放" + "定标结果失败！失败原因：" + response.getMsg());
        }
    }

    @Override
    public String getFilingTypeConfig() {
        /*
            归档参数 filingTypeConfig 为
            o: 不做控制
            1: 合同未归档，不允变更、补充协议、结算、付款（结算、付款等业务过滤未归档合同）；
            2： 合同未归档，限制所有业务（所有合同参照都过滤未归档合同）
         */
        String filingTypeConfig = "0";
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(FILLING_TYPE_STATE);
        if (!response.isSuccess() || response.getData() == null) {
            logger.error("根据归档参数编码-{}，查询系统参数（合同归档控制）配置信息，失败原因：{}", FILLING_TYPE_STATE, response.getMsg());
        }else {
            if (null != response.getData().getValueData()){
                filingTypeConfig = response.getData().getValueData();
            }
        }
        return filingTypeConfig;
    }

    @Override
    public Boolean checkFilingType(Long contractId, String contractTypeCode) {
        /*
         *      0: 不做控制
         *      1: 合同未归档，不允变更、补充协议、结算、付款（结算、付款等业务过滤未归档合同）；
         *      2：合同未归档，限制所有业务（所有合同参照都过滤未归档合同）
         */
        Boolean addFlag = true;
        ContractEntity contractEntity = super.selectById(contractId);
        //未归档
        if (null != contractEntity && 1 != contractEntity.getFilingStatus()){
            String filingTypeConfig = this.getFilingTypeConfig();
            if ("1".equals(filingTypeConfig)){
                switch (ContractFilingTypeEnum.getEnumByCode(contractTypeCode)){
                    case 租赁合同变更:
                        addFlag = false;
                        break;
                    case 租赁合同补充协议:
                        addFlag = false;
                        break;
                    case 租赁合同结算:
                        addFlag = false;
                        break;
                    case 合同付款申请:
                        addFlag = false;
                        break;
                }
            }else if ("2".equals(filingTypeConfig)){
                addFlag = false;
            }else {
                addFlag = true;
            }
        }
        return addFlag;
    }

    @Override
    public void delById(Long id) {
        baseMapper.delById(id);
    }

    @Override
    public void delChangeById(Long id) {
        baseMapper.delChangeById(id);
    }

    @Override
    public void delRecordById(Long id) {
        baseMapper.delRecordById(id);
    }
    @Override
    public ParamsCheckVO costPriceParams(MaterialCostPriceApiVO materialPriceHistoryApiVO,String code,String type) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        List<MaterialCostPriceApiVO> detailList = materialPriceHistoryApiVO.getMaterialCostPriceApiVOList();
        if(CollectionUtils.isEmpty(detailList)){//传入集合为空直接返回结果
            logger.info("detailList为空直接返回结果");
            return paramsCheckVO;
        }
        List<Long> materialIds = detailList.stream().map(MaterialCostPriceApiVO::getMaterialId).collect(Collectors.toList());
        Long orgId = materialPriceHistoryApiVO.getOrgId();
        if(null==orgId){
            logger.info("orgId为空");
            return paramsCheckVO;
        }
        //查询比例
        CommonResponse<List<BillParamVO>> maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(code,orgId);
        if(!maxParamByCode.isSuccess() && null == maxParamByCode.getData()){
            logger.info(maxParamByCode.getMsg());
            return paramsCheckVO;
        }
        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果
        logger.info("价格控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        //获取目标成本价格
        CommonResponse<Map<Long, BigDecimal>> dutyRes = dutyApi.queryPriceByRentDocIds(materialPriceHistoryApiVO.getProjectId(),DocTypeEnum.物料档案.getCode(),materialIds);

        Map<Long, BigDecimal> dutyMap = dutyRes.getData();
        if(null==dutyRes){
            logger.info("获取目标成本价格为空");
            return paramsCheckVO;
        }
        if(null==dutyMap){
            logger.info("获取目标成本价格map为空");
            return paramsCheckVO;
        }
        if(CollectionUtils.isNotEmpty(maxParamVOS)){//遍历高价
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOCost = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();//高价校验比例
                paramsCheckVOCost.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型
                for (MaterialCostPriceApiVO  detailVO: detailList) {//遍历明细
                    BigDecimal maxPrice = dutyMap.get(detailVO.getMaterialId())==null?BigDecimal.ZERO:dutyMap.get(detailVO.getMaterialId()).setScale(4, BigDecimal.ROUND_HALF_UP);//获取目标成本价格
                    BigDecimal price = detailVO.getPrice()==null?BigDecimal.ZERO:detailVO.getPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//物资单价
                    BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                    if (price.compareTo(maxPriceParam) >0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                        paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                        paramsCheckDsVO.setWarnName(type+"单价大于目标成本单价");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(type+"单价：").append(price)
                                .append("，目标成本单价:(").append(maxPrice)
                                .append("),目标成本单价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                .append("元，超出：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOSMax.add(paramsCheckDsVO);
                    }
                }
                paramsCheckVOCost.setDataSource(checkDsVOSMax);
                paramsCheckVOS.add(paramsCheckVOCost);
            }
        }
        /*添加参数控制区域---*/
        String[] paramsArr = {"alert", "warn", "none"};
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArr) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else{
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;

    }
}
