package com.ejianc.business.pro.ownrmat.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.ownrmat.bean.AmortizationEntity;
import com.ejianc.business.pro.ownrmat.bean.IdleRecordEntity;
import com.ejianc.business.pro.ownrmat.service.IAmortizationService;
import com.ejianc.business.pro.ownrmat.service.IIdleRecordService;
import com.ejianc.business.pro.ownrmat.vo.FlowReportVO;
import com.ejianc.business.pro.ownrmat.vo.ResidualVO;
import com.ejianc.business.pro.rmat.utils.PageUtil;
import com.ejianc.business.store.api.IStoreFlowApi;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目采购周转材台账
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("report")
public class ReportController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAmortizationService residualService;

    @Autowired
    private IIdleRecordService idleRecordService;

    @Autowired
    private IStoreFlowApi storeFlowApi;

    @Autowired
    private IShareMaterialApi materialApi;

    @Autowired
    private IOrgApi iOrgApi;

    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FlowReportVO>> queryList(@RequestBody QueryParam param) {
        // 查询库存流水汇总
        List<FlowReportVO> resList = this.queryReportList(param);

        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        List<FlowReportVO> records = PageUtil.listToPage(resList, pageNumber, pageSize);
        IPage<FlowReportVO> page = new Page<>();
        page.setRecords(records);
        page.setCurrent(pageNumber);
        page.setSize(pageSize);
        page.setTotal(resList.size());
        return CommonResponse.success("查询自有周转材台账成功！", page);
    }

    /**
     * 查询库存流水汇总
     * @param param
     * @return
     */
    private List<FlowReportVO> queryReportList(@RequestBody QueryParam param) {
        if(!param.getParams().containsKey("projectId")){
            return new ArrayList<>();
        }
        // 查询库存流水所有明细
        List<FlowReportVO> list = this.queryFlowList(param);
        if(CollectionUtils.isEmpty(list)){
            return new ArrayList<>();
        }

        // 查询闲置数量
        List<String> orgProMateIds = list.stream().map(x->x.getOrgId() + "|" + x.getProjectId() + "|" + x.getMaterialId()).
                distinct().collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orgProMateIds", new Parameter(QueryParam.IN, orgProMateIds));
        List<IdleRecordEntity> idleList = idleRecordService.queryList(queryParam);
        Map<String, IdleRecordEntity> idleMap = idleList.stream().collect(Collectors.toMap(
                x->x.getOrgId() + "|" + x.getProjectId() + "|" + x.getMaterialId(), account -> account, (v1, v2) -> v2));

        // 根据采购单位+项目+物料汇总
        String key = null;
        Map<String, FlowReportVO> map = new HashMap<>();
        for(FlowReportVO vo : list){
            key = vo.getOrgId() + "|" + vo.getProjectId() + "|" + vo.getMaterialId();
            FlowReportVO data = BeanMapper.map(vo, FlowReportVO.class);
            if(map.containsKey(key)){
                data = map.get(key);
                data.setPresentNum(ComputeUtil.safeAdd(data.getPresentNum(), vo.getPresentNum()));// 在场数量
                data.setPurchaseMny(ComputeUtil.safeAdd(data.getPurchaseMny(), vo.getPurchaseMny()));// 原值金额
                data.setPurchaseTaxMny(ComputeUtil.safeAdd(data.getPurchaseTaxMny(), vo.getPurchaseTaxMny()));
                data.setResidualMny(ComputeUtil.safeAdd(data.getResidualMny(), vo.getResidualMny()));// 残值金额
                data.setResidualTaxMny(ComputeUtil.safeAdd(data.getResidualTaxMny(), vo.getResidualTaxMny()));
                data.setNetMny(ComputeUtil.safeAdd(data.getNetMny(), vo.getNetMny()));// 净值金额
                data.setNetTaxMny(ComputeUtil.safeAdd(data.getNetTaxMny(), vo.getNetTaxMny()));
                data.setShareMny(ComputeUtil.safeAdd(data.getShareMny(), vo.getShareMny()));// 累计摊销金额
                data.setShareTaxMny(ComputeUtil.safeAdd(data.getShareTaxMny(), vo.getShareTaxMny()));
            }
            if(idleMap.containsKey(key)){
                data.setIdleRecordId(idleMap.get(key).getId());// 限制数量记录主键
                data.setIdleNum(ComputeUtil.safeSub(data.getPresentNum(), idleMap.get(key).getUseNum()));// 闲置数量
            }
            data.setOrgProMateIds(key);// 采购单位+项目+物料联合主键
            data.setUseNum(ComputeUtil.safeSub(data.getPresentNum(), data.getIdleNum()));// 使用数量 = 在场数量 - 闲置数量
            List<FlowReportVO> detailList = data.getDetailList();
            if(detailList == null){
                detailList = new ArrayList<>(Arrays.asList(vo));
            } else {
                detailList.add(vo);
            }
            data.setDetailList(detailList);
            map.put(key, data);
        }
        // 过滤在场数量为0
        List<FlowReportVO> result = new ArrayList<>(map.values());
        result = result.stream().filter(x -> !ComputeUtil.isEmpty(x.getPresentNum())).collect(Collectors.toList());
        return result;
    }

//    @RequestMapping(value = "/queryDetailList", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<List<FlowReportVO>> queryDetailList(@RequestBody QueryParam param) {
//        // 查询库存流水明细
//        List<FlowReportVO> resList = this.queryFlowList(param);
//        return CommonResponse.success("查询自有周转材台账明细成功！", resList);
//    }

    /**
     * 查询库存流水明细
     * @param param
     * @return
     */
    private List<FlowReportVO> queryFlowList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("materialCategoryName");
        param.getFuzzyFields().add("materialName");
        param.getFuzzyFields().add("materialSpec");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
//        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
//            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
//        } else {
//            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
//                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        }
        param.getParams().put("inOutFlag", new Parameter(QueryParam.EQ, 1));// 入库
        param.getParams().put("inOutType", new Parameter(QueryParam.IN, "31,32"));// 收料入库、调拨入库

        // 查询库存流水
        CommonResponse<List<FlowVO>> resp = storeFlowApi.getFlowList(param);
        if(!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        List<FlowVO> flowList = resp.getData();
        List<FlowReportVO> list = BeanMapper.mapList(flowList, FlowReportVO.class);

        // 获取组织对应物料的残值率
        Map<Long, Set<Long>> orgMateMap = list.stream().collect(Collectors.groupingBy(FlowReportVO::getOrgId,
                Collectors.mapping(FlowReportVO::getMaterialId, Collectors.toSet())));
        Map<String, AmortizationEntity> residualMap = new HashMap<>();// key-orgId|(materialId/materialTypeId)
        for(Long orgId : orgMateMap.keySet()) {
            ResidualVO residualVO = new ResidualVO();
            residualVO.setOrgId(orgId);
            residualVO.setMaterialIds(new ArrayList<>(orgMateMap.get(orgId)));
            Map<Long, AmortizationEntity> map = residualService.getResidualRate(residualVO);
            // 获取残值率设置的组织可能和传入组织不同
            for(Long key : map.keySet()){
                residualMap.put(orgId + "|" + key, map.get(key));
            }
        }

        Set<Long> materialIds = list.stream().map(FlowReportVO::getMaterialId).collect(Collectors.toSet());
        CommonResponse<List<MaterialVO>> mateResp = materialApi.queryMaterialByIds(new ArrayList<>(materialIds));
        Map<Long, MaterialVO> mateMap = new HashMap<>();
        if(mateResp.isSuccess()){
            mateMap = mateResp.getData().stream().collect(Collectors.toMap(MaterialVO::getId, account -> account, (v1, v2) -> v2));
        }

        // 计算
        String key = null;
        for(FlowReportVO vo : list){
            // 在场数量 = 入库余量 + 出库占用数量
            vo.setPresentNum(ComputeUtil.safeAdd(vo.getSurplusNum(), vo.getOutLockNum()));
            // 原值 = 在场数量 * 原值单价
            vo.setPurchaseMny(ComputeUtil.safeMultiply(vo.getPresentNum(), vo.getPurchasePrice()));
            vo.setPurchaseTaxMny(ComputeUtil.safeMultiply(vo.getPresentNum(), vo.getPurchaseTaxPrice()));
            key = vo.getOrgId() + "|" + vo.getMaterialId();
            BigDecimal residualRate = null;
            if(residualMap.containsKey(key)){
                residualRate =  ComputeUtil.safeDiv(residualMap.get(key).getResidualValueRate(), new BigDecimal("100"));
            }
            // 残值金额 = 原值金额 * 残值率
            if(residualRate != null){
                vo.setResidualMny(ComputeUtil.safeMultiply(vo.getPurchaseMny(),residualRate));
                vo.setResidualTaxMny(ComputeUtil.safeMultiply(vo.getPurchaseTaxMny(),residualRate));
            }
            if(StringUtils.isEmpty(vo.getMaterialCode()) && mateMap.containsKey(vo.getMaterialId())){
                vo.setMaterialCode(mateMap.get(vo.getMaterialId()).getCode());
            }
        }
        // 过滤在场数量为0
        list = list.stream().filter(x -> !ComputeUtil.isEmpty(x.getPresentNum())).collect(Collectors.toList());
        return list;
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        // 查询库存流水汇总
        List<FlowReportVO> resList = this.queryReportList(param);

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resList);
        ExcelExport.getInstance().export("own-rmat-report-export.xlsx", beans, response);
    }
}
