package com.ejianc.business.pro.pricelib.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 周转材合同历史价格数据
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prormat_price_history")
public class PriceHistoryEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="material_id")
    private Long materialId; // 物料Id
    @TableField(value="material_code")
    private String materialCode; // 物资编码
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="material_type_id")
    private Long materialTypeId; // 物资分类Id
    @TableField(value="material_type_name")
    private String materialTypeName; // 物资分类名称
    @TableField(value="material_inner_code")
    private String materialInnerCode; // 分类内码
    @TableField(value="rent_calculation_type")
    private String rentCalculationType; // 计租方式：0-日租，1-月租，2-工程量租
    @TableField(value="spec")
    private String spec; // 规则/型号
    @TableField(value="unit_id")
    private Long unitId; // 计量单位主键
    @TableField(value="unit_name")
    private String unitName; // 计量单位
    @TableField(value="contract_price_area")
    private String contractPriceArea; // 合同价格区间（无税）
    @TableField(value="contract_tax_price_area")
    private String contractTaxPriceArea; // 合同价格区间（含税）
    @TableField(value="contract_num")
    private BigDecimal contractNum; // 合同数量
    @TableField(value="contract_tax_rate")
    private BigDecimal contractTaxRate; // 合同税率
    @TableField(value="contract_max_price")
    private BigDecimal contractMaxPrice; // 合同最高价(无税)
    @TableField(value="contract_max_tax_price")
    private BigDecimal contractMaxTaxPrice; // 合同最高价(含税)
    @TableField(value="contract_min_price")
    private BigDecimal contractMinPrice; // 合同最低价格(无税)
    @TableField(value="contract_min_tax_price")
    private BigDecimal contractMinTaxPrice; // 合同最低价格(含税)
    @TableField(value="contract_avg_tax_price")
    private BigDecimal contractAvgTaxPrice; // 合同均价(含税)
    @TableField(value="contract_avg_price")
    private BigDecimal contractAvgPrice; // 合同均价(无税)
    @TableField(value="market_price_area")
    private String marketPriceArea; // 市场价（无税）
    @TableField(value="guide_price_area")
    private String guidePriceArea; // 公司指导价（无税）
    @TableField(value="market_tax_price_area")
    private String marketTaxPriceArea; // 市场价（含税）
    @TableField(value="guide_tax_price_area")
    private String guideTaxPriceArea; // 公司指导价（含税）
    
    
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public String getMaterialInnerCode() {
        return materialInnerCode;
    }

    public void setMaterialInnerCode(String materialInnerCode) {
        this.materialInnerCode = materialInnerCode;
    }

    public String getRentCalculationType() {
        return rentCalculationType;
    }

    public void setRentCalculationType(String rentCalculationType) {
        this.rentCalculationType = rentCalculationType;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public String getContractPriceArea() {
        return contractPriceArea;
    }

    public void setContractPriceArea(String contractPriceArea) {
        this.contractPriceArea = contractPriceArea;
    }
    public String getContractTaxPriceArea() {
        return contractTaxPriceArea;
    }

    public void setContractTaxPriceArea(String contractTaxPriceArea) {
        this.contractTaxPriceArea = contractTaxPriceArea;
    }
    public BigDecimal getContractNum() {
        return contractNum;
    }

    public void setContractNum(BigDecimal contractNum) {
        this.contractNum = contractNum;
    }
    public BigDecimal getContractTaxRate() {
        return contractTaxRate;
    }

    public void setContractTaxRate(BigDecimal contractTaxRate) {
        this.contractTaxRate = contractTaxRate;
    }
    public BigDecimal getContractMaxPrice() {
        return contractMaxPrice;
    }

    public void setContractMaxPrice(BigDecimal contractMaxPrice) {
        this.contractMaxPrice = contractMaxPrice;
    }
    public BigDecimal getContractMaxTaxPrice() {
        return contractMaxTaxPrice;
    }

    public void setContractMaxTaxPrice(BigDecimal contractMaxTaxPrice) {
        this.contractMaxTaxPrice = contractMaxTaxPrice;
    }
    public BigDecimal getContractMinPrice() {
        return contractMinPrice;
    }

    public void setContractMinPrice(BigDecimal contractMinPrice) {
        this.contractMinPrice = contractMinPrice;
    }
    public BigDecimal getContractMinTaxPrice() {
        return contractMinTaxPrice;
    }

    public void setContractMinTaxPrice(BigDecimal contractMinTaxPrice) {
        this.contractMinTaxPrice = contractMinTaxPrice;
    }
    public BigDecimal getContractAvgTaxPrice() {
        return contractAvgTaxPrice;
    }

    public void setContractAvgTaxPrice(BigDecimal contractAvgTaxPrice) {
        this.contractAvgTaxPrice = contractAvgTaxPrice;
    }
    public BigDecimal getContractAvgPrice() {
        return contractAvgPrice;
    }

    public void setContractAvgPrice(BigDecimal contractAvgPrice) {
        this.contractAvgPrice = contractAvgPrice;
    }
    public String getMarketPriceArea() {
        return marketPriceArea;
    }

    public void setMarketPriceArea(String marketPriceArea) {
        this.marketPriceArea = marketPriceArea;
    }
    public String getGuidePriceArea() {
        return guidePriceArea;
    }

    public void setGuidePriceArea(String guidePriceArea) {
        this.guidePriceArea = guidePriceArea;
    }
    public String getMarketTaxPriceArea() {
        return marketTaxPriceArea;
    }

    public void setMarketTaxPriceArea(String marketTaxPriceArea) {
        this.marketTaxPriceArea = marketTaxPriceArea;
    }
    public String getGuideTaxPriceArea() {
        return guideTaxPriceArea;
    }

    public void setGuideTaxPriceArea(String guideTaxPriceArea) {
        this.guideTaxPriceArea = guideTaxPriceArea;
    }
    
}
