package com.ejianc.business.pro.rmat.service;

import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.pro.rmat.bean.OrderEntity;

import javax.servlet.http.HttpServletRequest;

/**
 * 租赁订单
 * 
 * @author generator
 * 
 */
public interface IOrderService extends IBaseService<OrderEntity> {

    /**
     * 单据推送到供方协同服务
     *
     * @param entity 待推送单据
     * @return
     */
    boolean pushBillToSupCenter(OrderEntity entity);

    /**
     * 同步单据供应商签字信息
     *
     * @param request
     */
    String updateBillSupSignSyncInfo(HttpServletRequest request);

    /**
     * 将推送至供方的单据作废
     *
     * @param entity
     * @return
     */
    boolean delPushBill(OrderEntity entity);

    /**
     * 校验订单是否可关闭
     * @param entity
     * @return
     */
    String validateClose(OrderEntity entity);

    /**
     * 改状态
     * @param entity
     * @return
     */
    String ChangeCloseState(OrderEntity entity);

    void delById(Long id);

}
