package com.ejianc.business.pro.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.rmat.enums.BillTypeEnum;
import com.ejianc.business.pro.rmat.service.IMaterialService;
import com.ejianc.business.pro.rmat.utils.DateUtil;
import com.ejianc.business.pro.rmat.utils.MaterialConstant;
import com.ejianc.business.pro.rmat.utils.PushSupUtil;
import com.ejianc.business.pro.rmat.utils.ValidateUtil;
import com.ejianc.business.pro.rmat.vo.LoseDetailVO;
import com.ejianc.business.pro.rmat.vo.LoseVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.rmat.mapper.LoseMapper;
import com.ejianc.business.pro.rmat.bean.LoseEntity;
import com.ejianc.business.pro.rmat.service.ILoseService;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 遗失单
 * 
 * @author generator
 * 
 */
@Service("loseService")
public class LoseServiceImpl extends BaseServiceImpl<LoseMapper, LoseEntity> implements ILoseService{
    @Autowired
    private IMaterialService materialService;

    @Autowired
    private PushSupUtil pushSupUtil;

    private static final String OPERATE = "START_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.遗失单.getCode();
    private static final String BILL_NAME = BillTypeEnum.遗失单.getName();

    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/prormat/lose/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/prormat/lose/billDel";

    @Override
    public String validateContract(Long contractId, Long billId) {
        // 同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        if(billId != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }
        List<LoseEntity> list = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("当前合同存在非审批通过态的遗失单，不允许新增!");
        }
        return "校验通过！";
    }

    /**
     * 校验必须大于最大单据日期
     * @param  loseVO
     * @return
     */
    @Override
    public String validateTime(LoseVO loseVO, String type) {
        Map<String, Object> params = new HashMap<>();
        params.put("contractId", loseVO.getContractId());
        if(loseVO.getId() != null){
            params.put("billType", MaterialConstant.遗失单);
            params.put("billId", loseVO.getId());
        }
        Date lastDate = materialService.getLastDate(params);
        Map<Date, Date> maxTimeMap = materialService.getMaxTime(params);
        if (lastDate == null) return "未获取最大单据日期！";
        if(ValidateUtil.compareDate(loseVO.getStopDate(), lastDate, maxTimeMap,loseVO.getCreateTime())){
            throw new BusinessException(DateUtil.formatDate(loseVO.getStopDate())
                    + "小于最大单据日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
        }
        for(LoseDetailVO vo : loseVO.getLoseDetailList()){
            if(ValidateUtil.compareDate(vo.getDate(), lastDate, maxTimeMap,vo.getCreateTime())){
                throw new BusinessException(DateUtil.formatDate(vo.getDate())
                        + "小于最大单据日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
            }
        }
        return "校验通过！";
    }

    @Override
    public boolean pushBillToSupCenter(LoseEntity entity) {
        Boolean syncFlag = pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON(entity), OPERATE,
                BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
        return syncFlag;
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String billId = request.getParameter("billId");
        LoseEntity entity = super.selectById(billId);
        String msg = pushSupUtil.updateBillSupSignSyncInfo(request, (JSONObject) JSONObject.toJSON(entity),
                LoseEntity.class, OPERATE, BILL_TYPE, BILL_NAME);
        return msg;
    }

    @Override
    public boolean delPushBill(LoseEntity entity) {
        Boolean delSuc = pushSupUtil.delPushBill((JSONObject) JSONObject.toJSON(entity), OPERATE,
                BILL_TYPE, BILL_NAME, DEL_SUP_BILL_SERVER_URL);
        return delSuc;
    }

    @Override
    public void delById(Long id) {
        Boolean flag = baseMapper.delById(id);
        if (Boolean.FALSE.equals(flag)) {
            throw new BusinessException("删除失败!");
        }
    }
}
