/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.pricelib.controller.api;

import com.ejianc.business.pro.pricelib.service.IPriceHistoryService;
import com.ejianc.business.pro.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/MaterialPriceHistoryApi/"})
public class RentPriceHistoryApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPriceHistoryService priceHistoryService;

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u7269\u8d44\u5386\u53f2\u4ef7\u683c")
    @GetMapping(value={"getMaterialPriceHistoryApiVO"})
    public CommonResponse<MaterialPriceHistoryApiVO> getMaterialPriceHistoryApiVO(@RequestParam(value="materialId") Long materialId, @RequestParam(value="rentCalculationType") String rentCalculationType) {
        this.logger.info("\u7269\u8d44id-{}", (Object)materialId);
        MaterialPriceHistoryApiVO priceHistoryApiVO = this.priceHistoryService.getMaterialPriceHistoryApiVO(materialId, rentCalculationType);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)priceHistoryApiVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u591a\u4e2a\u4e2a\u7269\u8d44\u5386\u53f2\u4ef7\u683c")
    @PostMapping(value={"getMaterialPriceHistoryApiVOS"})
    public CommonResponse<List<MaterialPriceHistoryApiVO>> getMaterialPriceHistoryApiVOS(@RequestBody List<Long> materialIds, @RequestParam(value="rentCalculationType") String rentCalculationType) {
        this.logger.info("\u7269\u8d44id\u96c6\u5408\u3010{}\u3011", materialIds);
        List<MaterialPriceHistoryApiVO> priceHistoryApiVOS = this.priceHistoryService.getMaterialPriceHistoryApiVOS(materialIds, rentCalculationType);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", priceHistoryApiVOS);
    }

    @ApiOperation(value="\u67e5\u8be2\u591a\u4e2a\u4e2a\u7269\u8d44\u5386\u53f2\u4ef7\u683c")
    @PostMapping(value={"getMaterialPriceHistoryApiVOMap"})
    public CommonResponse<Map<Long, MaterialPriceHistoryApiVO>> getMaterialPriceHistoryApiVOMap(@RequestBody List<Long> materialIds, @RequestParam(value="rentCalculationType") String rentCalculationType) {
        this.logger.info("\u7269\u8d44id\u96c6\u5408\u3010{}\u3011", materialIds);
        Map<Long, MaterialPriceHistoryApiVO> priceHistoryVOMap = this.priceHistoryService.getMaterialPriceHistoryApiVOMap(materialIds, rentCalculationType);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", priceHistoryVOMap);
    }
}

