package com.ejianc.business.pro.pricelib.mapper;

import com.ejianc.business.pro.rmat.bean.ContractDailyRentEntity;
import com.ejianc.business.pro.rmat.bean.ContractEntity;
import com.ejianc.business.pro.rmat.bean.ContractMonthRentEntity;
import com.ejianc.business.pro.rmat.bean.ContractNumRentEntity;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.pro.pricelib.bean.PriceContractEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;

/**
 * 周转材合同价格数据
 * 
 * @author generator
 * 
 */
@Mapper
public interface PriceContractMapper extends BaseCrudMapper<PriceContractEntity> {
    @Select("select * from ejc_prormat_contract where dr =0 and rent_type != 1 and create_time >= #{time} or update_time >= #{time}")
    List<ContractEntity> getContractListByTime(Date time);

    @Select({
            "<script>",
            "select * from ejc_prormat_contract_daily_rent where material_id is not null and contract_id in",
            "<foreach collection='contractIdList' item='contractId' open='(' separator=',' close=')'>",
            "#{contractId}",
            "</foreach>",
            "</script>"
    })
    List<ContractDailyRentEntity> getContractDayDetailListByContractId(@Param("contractIdList") List<Long> contractIdList);

    @Select({
            "<script>",
            "select * from ejc_prormat_contract_month_rent where material_id is not null and contract_id in",
            "<foreach collection='contractIdList' item='contractId' open='(' separator=',' close=')'>",
            "#{contractId}",
            "</foreach>",
            "</script>"
    })
    List<ContractMonthRentEntity> getContractMonDetailListByContractId(@Param("contractIdList") List<Long> contractIdList);

    @Select({
            "<script>",
            "select * from ejc_prormat_contract_num_rent where material_id is not null and contract_id in",
            "<foreach collection='contractIdList' item='contractId' open='(' separator=',' close=')'>",
            "#{contractId}",
            "</foreach>",
            "</script>"
    })
    List<ContractNumRentEntity> getContractNumDetailListByContractId(@Param("contractIdList") List<Long> contractIdList);
    
}
