package com.ejianc.business.pro.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.rmat.bean.SettleEntity;
import com.ejianc.business.pro.rmat.enums.BillPushStatusEnum;
import com.ejianc.business.pro.rmat.enums.BillTypeEnum;
import com.ejianc.business.pro.rmat.enums.SupplierSignStatusEnum;
import com.ejianc.business.pro.rmat.service.ISettleService;
import com.ejianc.business.pro.rmat.vo.LoseVO;
import com.ejianc.business.pro.rmat.vo.RentCalculateVO;
import com.ejianc.business.pro.rmat.vo.RestituteVO;
import com.ejianc.business.pro.rmat.vo.SettleVO;
import com.ejianc.business.pro.rmat.vo.record.SettleRecordVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 周转材租赁结算单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("settle")
public class SettleController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    
    @Autowired
    private IOrgApi iOrgApi;
    
    @Autowired
    private ISettleService service;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private IExecutionApi executionApi;
    /**
     * 单据分享移动端前端路由地址
     */
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/prormat/settle/card";


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettleVO> saveOrUpdate(@RequestBody SettleVO saveOrUpdateVO) {
        
    	return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(saveOrUpdateVO));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleVO> queryDetail(Long id) {
    	SettleEntity entity = service.selectById(id);
    	SettleVO vo = BeanMapper.map(entity, SettleVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettleVO> vos) {
        List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();

        if(ListUtil.isNotEmpty(vos)){
            for (SettleVO vo : vos) {
                SettleEntity entity = service.selectById(vo.getId());
                ExecutionVO executionVO = service.targetCost(entity);
                totalExecutionVOList.add(executionVO.getTotalVO());
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                //删除实际成本
                CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(vo.getId());
                logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
                if(!stringCommonResponse.isSuccess()){
                    throw new BusinessException(stringCommonResponse.getMsg());
                }
            }
        }
        CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()){
            throw new BusinessException("目标成本删除失败！");
        }
        service.removeByIds(vos.stream().map(SettleVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettleVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        Parameter settleDate = param.getParams().get("settleDate");
        if (!Objects.equals(settleDate, null)) {
            String value = settleDate.getValue().toString();
            String[] split = value.split(",");
            String startSetlleDate = split[0] + " 00:00:00";
            String endSetlleDate = split[1] + " 23:59:59";
            param.getParams().remove("settleDate");
            param.getParams().put("settleDate", new Parameter(QueryParam.BETWEEN, startSetlleDate + "," + endSetlleDate));
        }
        
        IPage<SettleEntity> page = service.queryPage(param,false);
        IPage<SettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettleVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    
    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        
        
        List<SettleEntity> list = service.queryList(param);
        //todo:字段翻译等等

        List<SettleVO> voList = BeanMapper.mapList(list, SettleVO.class);
        for (SettleVO vo : voList) {
            if (vo.getSupplierSignStatus().equals(0)) {
                vo.setSupplierSignStatusName("未签字");
            }else if (vo.getSupplierSignStatus().equals(1)) {
                vo.setSupplierSignStatusName("已签字");
            }else {
                vo.setSupplierSignStatusName("未签字");
            }

            // 单据状态名称
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("settle-export.xlsx", beans, response);
    }
    
    /**
     * 校验当前合同下是否存在未生效结算单
     * @param contractId
     * @param billId
     * @return
     */
    @RequestMapping(value = "/validateContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> validateContract(@RequestParam("contractId") Long contractId
            , @RequestParam(value = "billId", required = false) Long billId) {
        String msg = service.validateContract(contractId, billId);
        return CommonResponse.success("校验成功！", msg);
    }

    /**
     * 查询租金计算单
     * @param contractId
     * @param settleDate
     * @return
     */
    @RequestMapping(value = "/queryCalculateData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<RentCalculateVO>> queryCalculateData(@RequestParam("contractId") Long contractId
            , @RequestParam(value = "lastSettleDate", required = false) String lastSettleDate
            , @RequestParam(value = "settleDate", required = false) String settleDate) {

        return CommonResponse.success("查询退赔单成功！", service.queryCalculateData(contractId, lastSettleDate, settleDate));
    }
    
    /**
     * 查询退赔单
     * @param contractId
     * @param settleDate
     * @return
     */
    @RequestMapping(value = "/queryRestituteData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<RestituteVO>> queryRestituteData(@RequestParam("contractId") Long contractId
            , @RequestParam(value = "lastSettleDate", required = false) String lastSettleDate
            , @RequestParam(value = "settleDate", required = false) String settleDate) {
        
        return CommonResponse.success("查询退赔单成功！", service.queryRestituteData(contractId, lastSettleDate, settleDate));
    }


    /**
     * 查询遗失单
     * @param contractId
     * @param settleDate
     * @return
     */
    @RequestMapping(value = "/queryLoseData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<LoseVO>> queryLoseData(@RequestParam("contractId") Long contractId
            , @RequestParam(value = "lastSettleDate", required = false) String lastSettleDate
            , @RequestParam(value = "settleDate", required = false) String settleDate) {

        return CommonResponse.success("查询遗失单成功！", service.queryLoseData(contractId, lastSettleDate, settleDate));
    }

    /**
     * 查询不含本期已结算金额
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/queryLastSettleTaxMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleVO> queryLastSettleTaxMny(@RequestParam("contractId") Long contractId
            , @RequestParam(value = "billId", required = false) Long billId) {

        return CommonResponse.success("查询遗失单成功！", service.queryLastSettleTaxMny(contractId, billId));
    }

    /**
     * 合同补充协议历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/querySettleRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleRecordVO> querySettleRecord(@RequestParam Long id) {
        SettleRecordVO vo = service.querySettleRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/supSignSync")
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = service.updateBillSupSignSyncInfo(request);
        if(StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }


    @GetMapping(value = "/getBillShareLink")
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(Long id) {
        SettleEntity entity = service.selectById(id);
        if(SupplierSignStatusEnum.乙方未签字.getCode().equals(entity.getSupplierSignStatus())
                && BillPushStatusEnum.未成功推送.getStatus().equals(entity.getBillPushFlag())) {
            // 未曾成功推送单据，则先向供方推送单据
            boolean pushResult = service.pushBillToSupCenter(entity);
            if(!pushResult) {
                return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
            } else {
                entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                service.saveOrUpdate(entity, false);
            }
        }
        return shareCooperateApi.getShareLink(id, BillTypeEnum.周转材租赁合同结算单.getCode(), entity.getSupplierId().toString(),
                mobileBillShareFrontUrl, null);
    }
    
    /**
     * 单据管控-
     * @return
     */
    @RequestMapping(value = "/checkParams", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody SettleVO vo) {
        return CommonResponse.success("参数校验成功！", service.checkParams(vo));
    }

    /**
     * 成本改造-关联保存接口
     * @param vo
     * @return
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettleVO> pushCost(@RequestBody SettleVO vo) {
        return service.pushCost(vo);
    }

    @GetMapping(value = "/syncPushSettlePool")
    @ResponseBody
    public CommonResponse<Boolean> syncPushSettlePool(@RequestParam(value = "id") Long id) {
        SettleEntity settleEntity = service.selectById(id);
        SettleVO vo = BeanMapper.map(settleEntity, SettleVO.class);

        return CommonResponse.success("同步结算池成功！", service.pushSettleToPool(vo));
    }

    /**
     * 同步目标成本
     * @param id
     * @return
     */
    @GetMapping(value = "/syncPushExecution")
    @ResponseBody
    public CommonResponse<Boolean> syncPushExecution(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("同步目标成本成功！", service.syncPushExecution(id));
    }
    /**
     * 同步目标成本
     * @param id
     * @return
     */
    @GetMapping(value = "/targetFinishCost")
    @ResponseBody
    public CommonResponse<Boolean> targetFinishCost(@RequestParam(value = "id") Long id) {
        SettleEntity settleEntity = service.selectById(id);
        ExecutionVO executionVO = service.targetFinishCost(settleEntity);
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        logger.info("推送目标成本入参：" + JSONObject.toJSONString(executionVO));
        if (!response.isSuccess()){
            logger.error("推送目标成本失败: , {}", response.getMsg());
            throw new BusinessException(response.getMsg());
        }
        return CommonResponse.success("同步目标成本成功！");
    }

    /**
     * 全结算推送目标成本数据
     *
     * @param projectId 项目id
     *
     * @return CommonResponse
     */
    @GetMapping(value = "/allSettlePushTargetCost")
    @ResponseBody
    public CommonResponse<String> allSettlePushTargetCost(@RequestParam(value = "projectId", required = false) Long projectId) {
        QueryWrapper<SettleEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("id");
        if (null != projectId){
            queryWrapper.eq("project_id", projectId);
        }
        List<SettleEntity> settlementEntityList = service.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(settlementEntityList)){
            for (SettleEntity settleEntity : settlementEntityList) {
                service.syncPushExecution(settleEntity.getId());
            }
        }
        logger.info("结算推送目标成本数据{}条", settlementEntityList.size());
        return CommonResponse.success("全结算推送目标成本数据成功！");
    }



    /**
     * 全生效最终结算推送目标成本数据
     *
     * @param projectId 项目id
     *
     * @return CommonResponse
     */
    @GetMapping(value = "/allFinishRentSettlePushTargetCost")
    @ResponseBody
    public CommonResponse<String> allFinishRentSettlePushTargetCost(@RequestParam(value = "projectId", required = false) Long projectId) {
        QueryWrapper<SettleEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("id");
        if (null != projectId){
            queryWrapper.eq("project_id", projectId);
        }
        queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.eq("settle_type", 1);
        List<SettleEntity> settleEntityList = service.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(settleEntityList)){
            for (SettleEntity settle : settleEntityList) {
                SettleEntity settleEntity = service.selectById(settle.getId());
                ExecutionVO executionVO = service.targetFinishCost(settleEntity);
                CommonResponse<String> response = executionApi.aggPush(executionVO);
                logger.info("推送目标成本入参：" + JSONObject.toJSONString(executionVO));
                if (!response.isSuccess()){
                    logger.error("推送目标成本失败: , {}", response.getMsg());
                    throw new BusinessException(response.getMsg());
                }
            }
        }
        logger.info("全生效最终结算推送目标成本数据{}条", settleEntityList.size());
        return CommonResponse.success("全生效最终结算推送目标成本数据成功！");
    }


}
