/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.ownrmat.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.ownrmat.bean.AmortizationEntity;
import com.ejianc.business.pro.ownrmat.bean.IdleRecordEntity;
import com.ejianc.business.pro.ownrmat.service.IAmortizationService;
import com.ejianc.business.pro.ownrmat.service.IIdleRecordService;
import com.ejianc.business.pro.ownrmat.vo.FlowReportVO;
import com.ejianc.business.pro.ownrmat.vo.ResidualVO;
import com.ejianc.business.pro.rmat.utils.PageUtil;
import com.ejianc.business.store.api.IStoreFlowApi;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"report"})
public class ReportController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAmortizationService residualService;
    @Autowired
    private IIdleRecordService idleRecordService;
    @Autowired
    private IStoreFlowApi storeFlowApi;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IOrgApi iOrgApi;

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FlowReportVO>> queryList(@RequestBody QueryParam param) {
        List<FlowReportVO> resList = this.queryReportList(param);
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        List records = PageUtil.listToPage(resList, (int)pageNumber, (int)pageSize);
        Page page = new Page();
        page.setRecords(records);
        page.setCurrent((long)pageNumber);
        page.setSize((long)pageSize);
        page.setTotal((long)resList.size());
        return CommonResponse.success((String)"\u67e5\u8be2\u81ea\u6709\u5468\u8f6c\u6750\u53f0\u8d26\u6210\u529f\uff01", (Object)page);
    }

    private List<FlowReportVO> queryReportList(@RequestBody QueryParam param) {
        if (!param.getParams().containsKey("projectId")) {
            return new ArrayList<FlowReportVO>();
        }
        List<FlowReportVO> list = this.queryFlowList(param);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<FlowReportVO>();
        }
        List orgProMateIds = list.stream().map(x -> x.getOrgId() + "|" + x.getProjectId() + "|" + x.getMaterialId()).distinct().collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orgProMateIds", new Parameter("in", orgProMateIds));
        List idleList = this.idleRecordService.queryList(queryParam);
        Map<String, IdleRecordEntity> idleMap = idleList.stream().collect(Collectors.toMap(x -> x.getOrgId() + "|" + x.getProjectId() + "|" + x.getMaterialId(), account -> account, (v1, v2) -> v2));
        String key = null;
        HashMap<String, FlowReportVO> map = new HashMap<String, FlowReportVO>();
        for (FlowReportVO vo : list) {
            key = vo.getOrgId() + "|" + vo.getProjectId() + "|" + vo.getMaterialId();
            FlowReportVO data = (FlowReportVO)BeanMapper.map((Object)vo, FlowReportVO.class);
            if (map.containsKey(key)) {
                data = (FlowReportVO)map.get(key);
                data.setPresentNum(ComputeUtil.safeAdd((BigDecimal)data.getPresentNum(), (BigDecimal)vo.getPresentNum()));
                data.setPurchaseMny(ComputeUtil.safeAdd((BigDecimal)data.getPurchaseMny(), (BigDecimal)vo.getPurchaseMny()));
                data.setPurchaseTaxMny(ComputeUtil.safeAdd((BigDecimal)data.getPurchaseTaxMny(), (BigDecimal)vo.getPurchaseTaxMny()));
                data.setResidualMny(ComputeUtil.safeAdd((BigDecimal)data.getResidualMny(), (BigDecimal)vo.getResidualMny()));
                data.setResidualTaxMny(ComputeUtil.safeAdd((BigDecimal)data.getResidualTaxMny(), (BigDecimal)vo.getResidualTaxMny()));
                data.setNetMny(ComputeUtil.safeAdd((BigDecimal)data.getNetMny(), (BigDecimal)vo.getNetMny()));
                data.setNetTaxMny(ComputeUtil.safeAdd((BigDecimal)data.getNetTaxMny(), (BigDecimal)vo.getNetTaxMny()));
                data.setShareMny(ComputeUtil.safeAdd((BigDecimal)data.getShareMny(), (BigDecimal)vo.getShareMny()));
                data.setShareTaxMny(ComputeUtil.safeAdd((BigDecimal)data.getShareTaxMny(), (BigDecimal)vo.getShareTaxMny()));
            }
            if (idleMap.containsKey(key)) {
                data.setIdleRecordId(idleMap.get(key).getId());
                data.setIdleNum(ComputeUtil.safeSub((BigDecimal)data.getPresentNum(), (BigDecimal)idleMap.get(key).getUseNum()));
            }
            data.setOrgProMateIds(key);
            data.setUseNum(ComputeUtil.safeSub((BigDecimal)data.getPresentNum(), (BigDecimal)data.getIdleNum()));
            ArrayList<FlowReportVO> detailList = data.getDetailList();
            if (detailList == null) {
                detailList = new ArrayList<FlowReportVO>(Arrays.asList(vo));
            } else {
                detailList.add(vo);
            }
            data.setDetailList((List)detailList);
            map.put(key, data);
        }
        ArrayList<FlowReportVO> result = new ArrayList(map.values());
        result = result.stream().filter(x -> ComputeUtil.isEmpty((BigDecimal)x.getPresentNum()) == false).collect(Collectors.toList());
        return result;
    }

    private List<FlowReportVO> queryFlowList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("materialCategoryName");
        param.getFuzzyFields().add("materialName");
        param.getFuzzyFields().add("materialSpec");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("inOutFlag", new Parameter("eq", (Object)1));
        param.getParams().put("inOutType", new Parameter("in", (Object)"31,32"));
        CommonResponse resp = this.storeFlowApi.getFlowList(param);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        List flowList = (List)resp.getData();
        List<FlowReportVO> list = BeanMapper.mapList((Iterable)flowList, FlowReportVO.class);
        Map orgMateMap = list.stream().collect(Collectors.groupingBy(FlowVO::getOrgId, Collectors.mapping(FlowVO::getMaterialId, Collectors.toSet())));
        HashMap<String, AmortizationEntity> residualMap = new HashMap<String, AmortizationEntity>();
        for (Long orgId : orgMateMap.keySet()) {
            ResidualVO residualVO = new ResidualVO();
            residualVO.setOrgId(orgId);
            residualVO.setMaterialIds(new ArrayList(orgMateMap.get(orgId)));
            Map<Long, AmortizationEntity> map = this.residualService.getResidualRate(residualVO);
            for (Long key : map.keySet()) {
                residualMap.put(orgId + "|" + key, map.get(key));
            }
        }
        Set materialIds = list.stream().map(FlowVO::getMaterialId).collect(Collectors.toSet());
        CommonResponse mateResp = this.materialApi.queryMaterialByIds(new ArrayList(materialIds));
        Map<Object, Object> mateMap = new HashMap();
        if (mateResp.isSuccess()) {
            mateMap = ((List)mateResp.getData()).stream().collect(Collectors.toMap(MaterialVO::getId, account -> account, (v1, v2) -> v2));
        }
        String key = null;
        for (FlowReportVO vo : list) {
            vo.setPresentNum(ComputeUtil.safeAdd((BigDecimal)vo.getSurplusNum(), (BigDecimal)vo.getOutLockNum()));
            vo.setPurchaseMny(ComputeUtil.safeMultiply((BigDecimal)vo.getPresentNum(), (BigDecimal)vo.getPurchasePrice()));
            vo.setPurchaseTaxMny(ComputeUtil.safeMultiply((BigDecimal)vo.getPresentNum(), (BigDecimal)vo.getPurchaseTaxPrice()));
            key = vo.getOrgId() + "|" + vo.getMaterialId();
            BigDecimal residualRate = null;
            if (residualMap.containsKey(key)) {
                residualRate = ComputeUtil.safeDiv((BigDecimal)((AmortizationEntity)((Object)residualMap.get(key))).getResidualValueRate(), (BigDecimal)new BigDecimal("100"));
            }
            if (residualRate != null) {
                vo.setResidualMny(ComputeUtil.safeMultiply((BigDecimal)vo.getPurchaseMny(), residualRate));
                vo.setResidualTaxMny(ComputeUtil.safeMultiply((BigDecimal)vo.getPurchaseTaxMny(), (BigDecimal)residualRate));
            }
            if (!StringUtils.isEmpty((CharSequence)vo.getMaterialCode()) || !mateMap.containsKey(vo.getMaterialId())) continue;
            vo.setMaterialCode(((MaterialVO)mateMap.get(vo.getMaterialId())).getCode());
        }
        list = list.stream().filter(x -> ComputeUtil.isEmpty((BigDecimal)x.getPresentNum()) == false).collect(Collectors.toList());
        return list;
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<FlowReportVO> resList = this.queryReportList(param);
        HashMap<String, List<FlowReportVO>> beans = new HashMap<String, List<FlowReportVO>>();
        beans.put("records", resList);
        ExcelExport.getInstance().export("own-rmat-report-export.xlsx", beans, response);
    }
}

