/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.api.IClauseSettingApi;
import com.ejianc.business.contractbase.vo.ClauseSettingVO;
import com.ejianc.business.pro.rmat.bean.ContractClauseEntity;
import com.ejianc.business.pro.rmat.service.IContractClauseService;
import com.ejianc.business.pro.rmat.vo.ContractClauseVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/contractClause/"})
public class ContractClauseController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IContractClauseService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IClauseSettingApi clauseSettingApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractClauseVO> saveOrUpdate(@RequestBody ContractClauseVO saveOrUpdateVO) {
        BillCodeParam billCodeParam;
        CommonResponse billCode;
        ContractClauseEntity entity = (ContractClauseEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ContractClauseEntity.class));
        if (!(entity.getId() != null && entity.getId() != 0L || (billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess())) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.service.saveOrUpdate((Object)entity, false);
        ContractClauseVO vo = (ContractClauseVO)BeanMapper.map((Object)((Object)entity), ContractClauseVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractClauseVO> queryDetail(Long id) {
        ContractClauseEntity entity = (ContractClauseEntity)((Object)this.service.selectById(id));
        ContractClauseVO vo = (ContractClauseVO)BeanMapper.map((Object)((Object)entity), ContractClauseVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractClauseVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ContractClauseVO contractClauseVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ContractClauseVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractClauseVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"getContractClauses"})
    @ResponseBody
    public CommonResponse<JSONObject> getContractClauses() {
        JSONObject resp = new JSONObject();
        ArrayList<JSONObject> attrs = new ArrayList<JSONObject>();
        resp.put("bo_code", (Object)"ContractClause");
        resp.put("bo_name", (Object)"\u5408\u540c\u6761\u6b3e");
        resp.put("bo_attrs", attrs);
        CommonResponse clauseResp = this.clauseSettingApi.getListByCategoryProperty("rmat");
        if (!clauseResp.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u5408\u540c\u6761\u6b3e\u5217\u8868\u5931\u8d25, {} ", (Object)clauseResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5408\u540c\u6761\u6b3e\u5217\u8868\u5931\u8d25\uff01");
        }
        List clauseList = (List)clauseResp.getData();
        JSONObject tmp = null;
        for (ClauseSettingVO clause : clauseList) {
            tmp = new JSONObject();
            tmp.put("id", (Object)clause.getId());
            tmp.put("code", (Object)("::clauseNameId$clauseContent$" + clause.getId()));
            tmp.put("fieldname", (Object)("::clauseNameId$clauseContent$" + clause.getId()));
            tmp.put("clauseCode", (Object)clause.getCode());
            tmp.put("name", (Object)clause.getClauseName());
            tmp.put("type", (Object)"attr");
            tmp.put("fieldtype", (Object)"text");
            attrs.add(tmp);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }
}

