/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.rmat.bean.LoseEntity;
import com.ejianc.business.pro.rmat.enums.BillTypeEnum;
import com.ejianc.business.pro.rmat.mapper.LoseMapper;
import com.ejianc.business.pro.rmat.service.ILoseService;
import com.ejianc.business.pro.rmat.service.IMaterialService;
import com.ejianc.business.pro.rmat.utils.DateUtil;
import com.ejianc.business.pro.rmat.utils.PushSupUtil;
import com.ejianc.business.pro.rmat.utils.ValidateUtil;
import com.ejianc.business.pro.rmat.vo.LoseDetailVO;
import com.ejianc.business.pro.rmat.vo.LoseVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="loseService")
public class LoseServiceImpl
extends BaseServiceImpl<LoseMapper, LoseEntity>
implements ILoseService {
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private PushSupUtil pushSupUtil;
    private static final String OPERATE = "START_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.\u9057\u5931\u5355.getCode();
    private static final String BILL_NAME = BillTypeEnum.\u9057\u5931\u5355.getName();
    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/prormat/lose/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/prormat/lose/billDel";

    @Override
    public String validateContract(Long contractId, Long billId) {
        List list;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        if (billId != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)billId));
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.queryList(queryParam, false)))) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u9057\u5931\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public String validateTime(LoseVO loseVO, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contractId", loseVO.getContractId());
        if (loseVO.getId() != null) {
            params.put("billType", "\u9057\u5931\u5355");
            params.put("billId", loseVO.getId());
        }
        Date lastDate = this.materialService.getLastDate(params);
        Map<Date, Date> maxTimeMap = this.materialService.getMaxTime(params);
        if (lastDate == null) {
            return "\u672a\u83b7\u53d6\u6700\u5927\u5355\u636e\u65e5\u671f\uff01";
        }
        if (ValidateUtil.compareDate((Date)loseVO.getStopDate(), (Date)lastDate, maxTimeMap, (Date)loseVO.getCreateTime())) {
            throw new BusinessException(DateUtil.formatDate((Date)loseVO.getStopDate()) + "\u5c0f\u4e8e\u6700\u5927\u5355\u636e\u65e5\u671f\u3010" + DateUtil.formatDate((Date)lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        for (LoseDetailVO vo : loseVO.getLoseDetailList()) {
            if (!ValidateUtil.compareDate((Date)vo.getDate(), (Date)lastDate, maxTimeMap, (Date)vo.getCreateTime())) continue;
            throw new BusinessException(DateUtil.formatDate((Date)vo.getDate()) + "\u5c0f\u4e8e\u6700\u5927\u5355\u636e\u65e5\u671f\u3010" + DateUtil.formatDate((Date)lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public boolean pushBillToSupCenter(LoseEntity entity) {
        Boolean syncFlag = this.pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON((Object)((Object)entity)), OPERATE, BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
        return syncFlag;
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String billId = request.getParameter("billId");
        LoseEntity entity = (LoseEntity)((Object)super.selectById((Serializable)((Object)billId)));
        String msg = this.pushSupUtil.updateBillSupSignSyncInfo(request, (JSONObject)JSONObject.toJSON((Object)((Object)entity)), LoseEntity.class, OPERATE, BILL_TYPE, BILL_NAME);
        return msg;
    }

    @Override
    public boolean delPushBill(LoseEntity entity) {
        Boolean delSuc = this.pushSupUtil.delPushBill((JSONObject)JSONObject.toJSON((Object)((Object)entity)), OPERATE, BILL_TYPE, BILL_NAME, DEL_SUP_BILL_SERVER_URL);
        return delSuc;
    }

    @Override
    public void delById(Long id) {
        Boolean flag = ((LoseMapper)this.baseMapper).delById(id);
        if (Boolean.FALSE.equals(flag)) {
            throw new BusinessException("\u5220\u9664\u5931\u8d25!");
        }
    }
}

