/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.pro.rmat.bean.ChangeEntity;
import com.ejianc.business.pro.rmat.bean.ContractEntity;
import com.ejianc.business.pro.rmat.enums.BillPushStatusEnum;
import com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum;
import com.ejianc.business.pro.rmat.enums.SignatureStatusEnum;
import com.ejianc.business.pro.rmat.service.IChangeService;
import com.ejianc.business.pro.rmat.service.IContractFileService;
import com.ejianc.business.pro.rmat.service.IContractService;
import com.ejianc.business.pro.rmat.service.ISignatureService;
import com.ejianc.business.pro.rmat.vo.ContractVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="signatureService")
public class SignatureServiceImpl
implements ISignatureService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String CONTRACT_REFCODE = "prormat_contract";
    private final String CONTRACT_REFCODE_CHANGE = "prormat_contract_change";
    private final String CONTRACT_RECORD_REFCODE = "prormat_contract_record";
    private final String UPDATE_CON_SIGN_DATE_PARAM_NAME = "P-U9uddl0182";
    @Autowired
    private IContractService contractService;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IContractFileService contractFileService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommonResponse<String> changeStatus(Long id, int signatureStatus, String refCode) {
        this.logger.info("\u8fdb\u5165\u7b7e\u7ae0\u72b6\u6001\u4fee\u6539\u6d41\u7a0b------------->signatureStatus-{}", (Object)signatureStatus);
        if ("prormat_contract".equals(refCode)) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
            if (contractEntity == null) return CommonResponse.error((String)"\u627e\u4e0d\u5230\u5408\u540c\uff0c\u8bf7\u68c0\u67e5\u5408\u540c\u4e3b\u952e\uff01");
            if (signatureStatus == SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()) {
                contractEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
                contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                contractEntity.setFilingStatus(FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode());
                contractEntity.setFilingRef(0);
                Boolean pushResult = this.contractService.pushContract((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class));
                if (pushResult.booleanValue()) {
                    contractEntity.setPushPoolFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
                } else {
                    contractEntity.setPushPoolFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
                }
            } else {
                contractEntity.setSignatureStatus(signatureStatus);
            }
            if (signatureStatus == SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()) {
                CommonResponse response = this.paramConfigApi.getByCode("P-U9uddl0182");
                if (!response.isSuccess()) {
                    this.logger.error("\u67e5\u8be2\u7535\u4e2d\u7b7e\u7ae0\u5408\u540c-\u3010id-{}\u3011\u662f\u5426\u66f4\u65b0\u5408\u540c\u7b7e\u8ba2\u65e5\u671f\u53c2\u6570\u5931\u8d25\uff0c\u6682\u4e0d\u66f4\u65b0\u5408\u540c\u7b7e\u8ba2\u65e5\u671f: {}", (Object)id, (Object)JSONObject.toJSONString((Object)response));
                }
                if (null != response.getData() && "1".equals(((ParamRegisterSetVO)response.getData()).getValueData())) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    this.logger.info("\u5408\u540c\u3010id-{}\uff0c\u539f\u7b7e\u8ba2\u65e5\u671f\uff1a{}, \u6839\u636e\u7535\u5b50\u7b7e\u7ae0\u5408\u540c\u66f4\u65b0\u5408\u540c\u7b7e\u8ba2\u65e5\u671f\u53c2\u6570:{}\uff0c\u5c06\u5408\u540c\u7b7e\u8ba2\u65e5\u671f\u6539\u4e3a\u5f53\u524d\u7b7e\u7ae0\u5b8c\u6210\u65e5\u671f:{}\u3011", new Object[]{id, sdf.format(contractEntity.getSignDate()), JSONObject.toJSONString((Object)response.getData()), sdf.format(new Date())});
                    contractEntity.setSignDate(new Date());
                }
            }
            this.contractService.saveOrUpdate((Object)contractEntity, false);
            if (signatureStatus == SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()) {
                this.contractFileService.getSignedFileInfo(id, "contract");
            }
            this.logger.info("\u4e3b\u5408\u540c\u7b7e\u7ae0\u72b6\u6001\u5df2\u4fee\u6539---------------->");
            return CommonResponse.success((String)"\u7b7e\u7ae0\u72b6\u6001\u4fee\u6539\u6210\u529f\uff01");
        } else {
            if (!"prormat_contract_change".equals(refCode)) return CommonResponse.error((String)"\u8bf7\u68c0\u67e5refCode\u503c\u662f\u5426\u6b63\u786e\uff01");
            ChangeEntity changeEntity = (ChangeEntity)((Object)this.changeService.selectById(id));
            if (changeEntity == null) return CommonResponse.error((String)"\u627e\u4e0d\u5230\u5408\u540c\uff0c\u8bf7\u68c0\u67e5\u5408\u540c\u4e3b\u952e\uff01");
            if (signatureStatus == SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()) {
                return this.changeService.effectiveSaveWriteContract(id, changeEntity.getBillCode(), false);
            }
            changeEntity.setSignatureStatus(signatureStatus);
            this.changeService.saveOrUpdate((Object)changeEntity);
            this.logger.info("\u53d8\u66f4\u5408\u540c\u7b7e\u7ae0\u72b6\u6001\u5df2\u4fee\u6539---------------->");
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getContractId());
            updateWrapper.set(ContractEntity::getChangeContractSignatureStatus, (Object)changeEntity.getSignatureStatus());
            this.contractService.update(this.contractService.selectById(changeEntity.getContractId()), (Wrapper)updateWrapper, false);
            this.logger.info("\u7b7e\u7ae0\u72b6\u6001\u4e3a\u5df2\u7b7e\u7ae0\uff0c\u56de\u5199\u4e3b\u5408\u540c\u7b7e\u7ae0\u72b6\u6001---------------->");
        }
        return CommonResponse.success((String)"\u7b7e\u7ae0\u72b6\u6001\u4fee\u6539\u6210\u529f\uff01");
    }
}

