package com.ejianc.business.pro.rmat.service;

import com.ejianc.business.pro.rmat.bean.CheckDetailEntity;
import com.ejianc.business.pro.rmat.vo.CheckVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.pro.rmat.bean.CheckEntity;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 验收单
 * 
 * @author generator
 * 
 */
public interface ICheckService extends IBaseService<CheckEntity> {

    CheckVO saveOrUpdate(CheckVO saveOrUpdateVO);

    void delete(List<CheckVO> vos);



    /**
     * 单据推送到供方协同服务
     *
     * @param entity 待推送单据
     * @return
     */
    boolean pushBillToSupCenter(CheckEntity entity);

    /**
     * 同步单据供应商签字信息
     *
     * @param request
     */
    String updateBillSupSignSyncInfo(HttpServletRequest request);

    /**
     * 将推送至供方的单据作废
     *
     * @param entity
     * @return
     */
    boolean delPushBill(CheckEntity entity);


    String validateTime(CheckVO checkVO, String type);

    void submitChangeCheckNums(List<CheckDetailEntity> checkDetailList);

    void backChangeCheckNums(List<CheckDetailEntity> checkDetailList);

    void submitChangeCheckState(Long deliveryId, List<CheckDetailEntity> detailEntities);

    void backChangeCheckState(Long deliveryId, List<CheckDetailEntity> detailEntities);

    void delById(Long id);
}
