package com.ejianc.business.pro.rmat.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.rmat.bean.ContractEntity;
import com.ejianc.business.pro.rmat.vo.ContractVO;
import com.ejianc.business.pro.rmat.vo.record.ContractPaymentRecordVO;
import com.ejianc.business.pro.rmat.vo.record.SupplementRecordVO;
import com.ejianc.business.pro.warn.SqlParam;
import com.ejianc.business.promaterial.pricelib.vo.MaterialCostPriceApiVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 周转材租赁合同
 * 
 * @author generator
 * 
 */
public interface IContractService extends IBaseService<ContractEntity> {


    ContractVO saveOrUpdate(ContractVO saveOrUpdateVO, String authority, Boolean isControl);

    ContractVO queryDetail(Long id);

    String delete(List<ContractVO> vos);
    
    JSONObject pageList(QueryParam param);

    Map<String,Object> countContractAmount(QueryParam param);

    Boolean addSupplementFlag(Long id);

    SupplementRecordVO querySupplementRecord(Long id);

    Boolean pushBillToSupCenter(ContractEntity entity);

    Boolean delPushBill(ContractEntity entity);

    Boolean pushContract(ContractVO vo);

    String validateContract(Long contractId, String billType, Long billId, String type);

    Boolean delContractFromPool(Long id);

    ParamsCheckVO targetCostCtrl(ContractVO contractVO, String authority);

    ParamsCheckVO viewTargetCostCtrlInfo(Long id);

    ParamsCheckVO checkParams(ContractVO vo);

    ParamsCheckVO supplementCheckParams(Long id, Long mainContractId, BigDecimal supplementContractTaxMny);

    List<ContractEntity> listContractByProjectId(Long id, Long projectId);
    /**
     * 单据管控-累计结算金额大于合同金额
     * @param sqlParamList
     * @return
     */
    List<Map<String, Object>> querySettleWarnContract(List<SqlParam> sqlParamList);


    Boolean syncPushExecution(Long id);

    Integer queryTotalSettleNum(Long id);

    ExecutionVO targetCost(ContractVO contractVO);

    /**
     * 删除文件中心水印文件
     *
     * @param watermarkFileId 水印合同附件id
     * @return boolean 是否删除标识
     */
    boolean delWatermarkContractFile(Long watermarkFileId);

    ContractPaymentRecordVO queryPaymentApplyList(Long id);

    Boolean validateTargetMny(ContractEntity entity);

    List<SignContractVo> queryContractByTargetResultId(List<String> targetResultIdList);


    /**
     * 归档参数 filingTypeConfig 为
     *             o: 不做控制
     *             1: 合同未归档，不允变更、补充协议、结算、付款（结算、付款等业务过滤未归档合同）；
     *             2： 合同未归档，限制所有业务（所有合同参照都过滤未归档合同）
     * @return
     */
    String getFilingTypeConfig();

    /**
     * 通过归档参数校验是否能新增，
     * o: 不做控制
     * 1: 合同未归档，不允变更、补充协议、结算、付款（结算、付款等业务过滤未归档合同）；
     * 2： 合同未归档，限制所有业务（所有合同参照都过滤未归档合同）
     * @param contractId
     * @return
     */
    Boolean checkFilingType(Long contractId, String contractTypeCode);

    void delById(Long id);

    void delChangeById(Long id);

    void delRecordById(Long id);
    ParamsCheckVO costPriceParams(MaterialCostPriceApiVO materialPriceHistoryApiVO, String code, String type);

    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response);
}
