package com.ejianc.business.pro.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.rmat.bean.NeedPlanDetailEntity;
import com.ejianc.business.pro.rmat.vo.NeedPlanDetailRefVO;
import com.ejianc.business.pro.rmat.vo.NeedPlanVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.rmat.mapper.NeedPlanMapper;
import com.ejianc.business.pro.rmat.bean.NeedPlanEntity;
import com.ejianc.business.pro.rmat.service.INeedPlanService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 周转材需用计划主实体
 * 
 * @author generator
 * 
 */
@Service("needPlanService")
public class NeedPlanServiceImpl extends BaseServiceImpl<NeedPlanMapper, NeedPlanEntity> implements INeedPlanService{

    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "PRORMAT_NEED_PLAN_01";

    @Override
    public CommonResponse<NeedPlanVO> saveOrUpdate(NeedPlanVO saveOrUpdateVO) {
        NeedPlanEntity entity = BeanMapper.map(saveOrUpdateVO, NeedPlanEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<NeedPlanDetailEntity> planDetailList = entity.getPlanDetailList();
        String materialName = "";
        if(CollectionUtils.isNotEmpty(planDetailList)){
            ArrayList<NeedPlanDetailEntity> list = new ArrayList<>();
            for(NeedPlanDetailEntity planDetail :planDetailList ){
                //物资名称集合
                if(!("del".equals(planDetail.getRowState()))){//删除的物资不拼接名称
                    if(StringUtils.isNotBlank(planDetail.getMaterialName())){
                        if(StringUtils.isNotBlank(materialName)){
                            materialName = materialName+","+planDetail.getMaterialName();
                        }else {
                            materialName = planDetail.getMaterialName();
                        }
                    }
                    list.add(planDetail);
                }
                BigDecimal nums = planDetail.getNums() == null ? BigDecimal.ZERO : planDetail.getNums();
                BigDecimal occupyNums = planDetail.getOccupyNums() == null ? BigDecimal.ZERO : planDetail.getOccupyNums();
                BigDecimal surplusNums = nums.subtract(occupyNums);
                planDetail.setSurplusNums(surplusNums);//剩余
                planDetail.setOccupyNums(occupyNums);//占用
                planDetail.setNums(nums);//需用
            }
            Integer planFlag = entity.getPlanFlag()==null?1:entity.getPlanFlag();
            entity.setPlanFlag(planFlag);
            entity.setMaterialName(materialName);
            if(CollectionUtils.isEmpty(list)){
                throw new BusinessException("最少有一条计划明细！");
            }
        }else{
            throw new BusinessException("最少有一条计划明细！");
        }
        super.saveOrUpdate(entity, false);
        NeedPlanVO vo = BeanMapper.map(entity, NeedPlanVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public List<NeedPlanDetailRefVO> getPlanByMaterialId(List<Long> materialListId, QueryWrapper wrapper) {
        List<NeedPlanDetailRefVO> planVOList = baseMapper.getPlanByMaterialId(materialListId, wrapper);
        return planVOList;
    }
}
