/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.ownrmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMZZCRKDApi;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMZZCCZDVO;
import com.ejianc.business.pro.ownrmat.bean.HandleDetailEntity;
import com.ejianc.business.pro.ownrmat.bean.HandleEntity;
import com.ejianc.business.pro.ownrmat.service.IHandleService;
import com.ejianc.business.pro.ownrmat.service.IValidateService;
import com.ejianc.business.pro.ownrmat.service.impl.HandleServiceImpl;
import com.ejianc.business.pro.ownrmat.vo.HandleVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="handle")
public class HandleBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IHandleService service;
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private IValidateService validateService;
    @Autowired
    private HandleServiceImpl handleService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IPMZZCRKDApi ipmzzcrkdApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Value(value="${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        HandleEntity handleEntity = (HandleEntity)((Object)this.service.selectById(billId));
        HandleVO handleVO = (HandleVO)BeanMapper.map((Object)((Object)handleEntity), HandleVO.class);
        this.validateService.validateHandle(handleVO);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        List<HandleDetailEntity> handleDetailEntities;
        HandleEntity outStoreEntity = (HandleEntity)((Object)this.service.selectById(billId));
        StoreManageVO storeManageVO = new StoreManageVO();
        storeManageVO.setStoreId(outStoreEntity.getProjectId());
        storeManageVO.setSourceId(outStoreEntity.getId());
        storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u5468\u8f6c\u6750\u6750\u6599\u5904\u7f6e);
        storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
        ArrayList flowVOS = new ArrayList();
        outStoreEntity.getHandleSubList().forEach(t -> {
            FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u5468\u8f6c\u6750\u6750\u6599\u5904\u7f6e, (Integer)0);
            flowVO.setStoreId(outStoreEntity.getProjectId());
            flowVO.setStoreName(outStoreEntity.getProjectName());
            flowVO.setProjectId(outStoreEntity.getProjectId());
            flowVO.setProjectName(outStoreEntity.getProjectName());
            flowVO.setOrgId(outStoreEntity.getOrgId());
            flowVO.setOrgName(outStoreEntity.getOrgName());
            flowVO.setParentOrgId(outStoreEntity.getParentOrgId());
            flowVO.setParentOrgName(outStoreEntity.getParentOrgName());
            flowVO.setEmployeeId(outStoreEntity.getEmployeeId());
            flowVO.setEmployeeName(outStoreEntity.getEmployeeName());
            flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
            flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
            flowVO.setMaterialId(t.getMaterialId());
            flowVO.setMaterialName(t.getMaterialName());
            flowVO.setMaterialSpec(t.getSpec());
            flowVO.setMaterialUnitId(t.getUnit());
            flowVO.setMaterialUnitName(t.getUnitName());
            flowVO.setSourceBillDetailRemark(t.getMemo());
            flowVO.setTaxPrice(t.getHandleTaxPrice());
            flowVO.setPrice(t.getHandlePrice());
            flowVO.setNum(t.getHandleNum());
            flowVO.setTaxMny(t.getHandleTaxMny());
            flowVO.setMny(t.getHandleMny());
            flowVO.setTax(t.getTax());
            flowVO.setSourceId(outStoreEntity.getId());
            flowVO.setSourceDetailId(t.getId());
            flowVO.setSourceBillCode(outStoreEntity.getBillCode());
            flowVO.setSourceBillDate(outStoreEntity.getHandleDate());
            flowVO.setRowState(t.getRowState());
            flowVO.setSourceBillRemark(outStoreEntity.getHandleReason());
            flowVOS.add(flowVO);
        });
        storeManageVO.setFlowVOList(flowVOS);
        CommonResponse response = this.storeManageApi.inOutStore(storeManageVO);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg()));
        }
        this.logger.info("\u63a8\u9001\u6210\u672c---");
        this.service.costPush(outStoreEntity);
        if ("common".equals(this.GenerateBillCodeType) && CollectionUtils.isNotEmpty(handleDetailEntities = outStoreEntity.getHandleSubList())) {
            ArrayList list = new ArrayList();
            handleDetailEntities.forEach(e -> {
                PMZZCCZDVO czdvo = new PMZZCCZDVO();
                czdvo.setOrgName(outStoreEntity.getOrgName());
                czdvo.setMaterialId(e.getMaterialId() == null ? "" : e.getMaterialId().toString());
                czdvo.setMaterialName(e.getMaterialName());
                czdvo.setMaterialTypeName(e.getMaterialCategoryName());
                czdvo.setSpec(e.getSpec());
                czdvo.setUnitName(e.getUnitName());
                czdvo.setHandleNum(e.getHandleNum());
                czdvo.setHandleTaxPrice(e.getHandleTaxPrice());
                czdvo.setHandleTaxMny(e.getHandleTaxMny());
                czdvo.setNetWorthTaxMny(e.getNetWorthTaxMny());
                czdvo.setOriginalValueTaxMny(e.getOriginalValueTaxMny());
                czdvo.setHandleSubTaxMny(e.getHandleSubTaxMny());
                czdvo.setSourceId(e.getId().toString());
                list.add(czdvo);
            });
            this.logger.info("\u5468\u8f6c\u6750\u8c03\u7528\u8d22\u52a1\u53c2\u6570\uff1a" + JSONObject.toJSONString(list));
            this.ipmzzcrkdApi.saveCzd(list);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)res.getMsg());
        }
        HandleEntity outStoreEntity = (HandleEntity)((Object)this.service.selectById(billId));
        this.validateService.validateProject(outStoreEntity.getProjectId(), null, null, "\u5f03\u5ba1");
        this.handleService.validateTime((HandleVO)BeanMapper.map((Object)((Object)outStoreEntity), HandleVO.class), "\u5f03\u5ba1");
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(billId);
        StoreManageVO storeManageVO = new StoreManageVO();
        storeManageVO.setStoreId(outStoreEntity.getProjectId());
        storeManageVO.setSourceIdsForRollBack(ids);
        storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u5468\u8f6c\u6750\u6750\u6599\u5904\u7f6e);
        storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
        CommonResponse response = this.storeManageApi.inOutStoreRollback(storeManageVO);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg()));
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        List<HandleDetailEntity> handleDetailEntities;
        HandleEntity outStoreEntity = (HandleEntity)((Object)this.service.selectById(billId));
        this.logger.info("\u5220\u9664\u6210\u672c---");
        CommonResponse stringCommonResponse = this.costDetailApi.updateCostDetail(billId, Integer.valueOf(0));
        this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{billId});
        updateWrapper.set(HandleEntity::getRelationFlag, (Object)"0");
        this.service.update((Wrapper)updateWrapper);
        if ("common".equals(this.GenerateBillCodeType) && CollectionUtils.isNotEmpty(handleDetailEntities = outStoreEntity.getHandleSubList())) {
            ArrayList list = new ArrayList();
            handleDetailEntities.forEach(e -> list.add(e.getId().toString()));
            this.logger.info("\u5f03\u5ba1\u5468\u8f6c\u6750\u8c03\u7528\u8d22\u52a1\u53c2\u6570\uff1a" + JSONObject.toJSONString(list));
            this.ipmzzcrkdApi.deleteCzd(list);
        }
        return CommonResponse.success();
    }
}

