/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.rmat.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.common.util.MathUtil;
import com.ejianc.business.contractbase.api.ICommonSNAPI;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.CommonSNVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.rmat.bean.ChangeEntity;
import com.ejianc.business.pro.rmat.bean.ContractDailyRentEntity;
import com.ejianc.business.pro.rmat.bean.ContractEntity;
import com.ejianc.business.pro.rmat.bean.ContractFreezeEntity;
import com.ejianc.business.pro.rmat.bean.ContractMonthRentEntity;
import com.ejianc.business.pro.rmat.bean.ContractNumRentEntity;
import com.ejianc.business.pro.rmat.bean.ContractRelieveEntity;
import com.ejianc.business.pro.rmat.bean.SettleEntity;
import com.ejianc.business.pro.rmat.bean.TotalPlanEntity;
import com.ejianc.business.pro.rmat.enums.BillTypeEnum;
import com.ejianc.business.pro.rmat.enums.ChangeStatusEnum;
import com.ejianc.business.pro.rmat.enums.ContractFilingTypeEnum;
import com.ejianc.business.pro.rmat.enums.DraftTypeEnum;
import com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum;
import com.ejianc.business.pro.rmat.enums.SettleEnum;
import com.ejianc.business.pro.rmat.enums.SignatureStatusEnum;
import com.ejianc.business.pro.rmat.mapper.ContractMapper;
import com.ejianc.business.pro.rmat.service.IChangeService;
import com.ejianc.business.pro.rmat.service.IContractFreezeService;
import com.ejianc.business.pro.rmat.service.IContractRelieveService;
import com.ejianc.business.pro.rmat.service.IContractService;
import com.ejianc.business.pro.rmat.service.ISettleService;
import com.ejianc.business.pro.rmat.service.ITotalPlanService;
import com.ejianc.business.pro.rmat.utils.ListCallable;
import com.ejianc.business.pro.rmat.utils.PushSupUtil;
import com.ejianc.business.pro.rmat.vo.ChangeVO;
import com.ejianc.business.pro.rmat.vo.ContractDailyRentVO;
import com.ejianc.business.pro.rmat.vo.ContractMonthRentVO;
import com.ejianc.business.pro.rmat.vo.ContractNumRentVO;
import com.ejianc.business.pro.rmat.vo.ContractVO;
import com.ejianc.business.pro.rmat.vo.ImportContractVO;
import com.ejianc.business.pro.rmat.vo.record.ContractPaymentRecordVO;
import com.ejianc.business.pro.rmat.vo.record.SupplementRecordVO;
import com.ejianc.business.pro.supplier.api.IAbnormalApi;
import com.ejianc.business.pro.supplier.api.ICheckSupplierApi;
import com.ejianc.business.pro.warn.SqlParam;
import com.ejianc.business.profinance.api.IPaymentApplyApi;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.business.promaterial.pricelib.vo.MaterialCostPriceApiVO;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.enums.RentTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.tender.api.ITenderRmatApi;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="contractService")
public class ContractServiceImpl
extends BaseServiceImpl<ContractMapper, ContractEntity>
implements IContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PRO_RMAT_CONTRACT = "PRO_RMAT_CONTRACT";
    private static final String PURCHASE_CONTRACT_YNJT = "RENT_CONTRACT_MATERIAL_YNJT";
    private static final String OPERATE = "CONTRACT_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getCode();
    private static final String BILL_NAME = BillTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getName();
    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/prormat/contract/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/prormat/contract/billDel";
    private static final String CHECK_PARAM_CODE = "P-12u3Sd61";
    private static final String SUPPLEMENT_CHECK_PARAM_CODE = "P-AU52M166";
    private static final String TARGET_COST_CHECK_PARAM_CODE = "P-rzH7060210";
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ITenderRmatApi tenderRmatApi;
    @Autowired
    private IParamCheckApi paramCheckApi;
    @Autowired
    private IExecutionApi executionApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private PushSupUtil pushSupUtil;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IProjectSetApi projectSetApi;
    @Autowired
    private IContractService service;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private IContractRelieveService relieveService;
    @Autowired
    private IContractFreezeService freezeService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private ITotalPlanService totalPlanService;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IPaymentApplyApi paymentApplyApi;
    @Value(value="${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;
    @Autowired
    private ICommonSNAPI commonSNAPI;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IDutyApi dutyApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private ICheckSupplierApi checkSupplierApi;
    @Autowired
    private IAbnormalApi abnormalApi;
    private final String FILLING_TYPE_STATE = "P-eg7rBO0134";

    @Override
    public ContractVO saveOrUpdate(ContractVO saveOrUpdateVO, String authority, Boolean isControl) {
        Object contract;
        ContractEntity entity = (ContractEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ContractEntity.class));
        ContractEntity oldContractEntity = null;
        if (entity.getId() == null || entity.getId() == 0L) {
            if (StringUtils.isBlank((CharSequence)entity.getBillCode()) && !isControl.booleanValue()) {
                entity.setBillCode(this.getContractBillCode(saveOrUpdateVO));
            }
            entity.setId(IdWorker.getId());
            entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            if (null != entity.getSupplementFlag() && entity.getSupplementFlag() == 0) {
                entity.setMainContractCreateDate(new Date());
            }
            if (entity.getFilingStatus() == null) {
                entity.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
            } else if (entity.getFilingStatus().equals(FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode())) {
                entity.setFilingRef(0);
            }
            if (!isControl.booleanValue() && entity.getTargetResultId() != null) {
                this.validateTargetMny(entity);
                this.updateTargetResult(entity, CommonConstant.OCCUPY_STATE);
            }
        } else {
            oldContractEntity = (ContractEntity)((Object)super.selectById((Serializable)entity.getId()));
            if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
                entity.setBillCode(oldContractEntity.getBillCode());
            } else if (this.checkSameBillCode((ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class)).booleanValue()) {
                throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            if (!isControl.booleanValue() && entity.getTargetResultId() != null) {
                this.validateTargetMny(entity);
                this.updateTargetResult(oldContractEntity, CommonConstant.UN_OCCUPY_STATE);
                this.updateTargetResult(entity, CommonConstant.OCCUPY_STATE);
            }
        }
        if (entity.getSupplementFlag() != null && entity.getSupplementFlag() == 1) {
            this.validateContract(saveOrUpdateVO.getMainContractId(), "\u8865\u5145\u534f\u8bae", saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        }
        if (Objects.equals(FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode(), entity.getFilingStatus())) {
            entity.setFilingRef(0);
        }
        entity.setBaseTaxMny(entity.getContractTaxMny());
        entity.setBaseMny(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny());
        if (!(entity.getContractFileId() == null || (contract = (ContractEntity)((Object)this.service.getById(entity.getId()))) == null || ((ContractEntity)((Object)contract)).getContractCategoryId().equals(entity.getContractCategoryId()) && (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(((ContractEntity)((Object)contract)).getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(((ContractEntity)((Object)contract)).getDraftType())) || !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType()) && !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(entity.getDraftType()))) {
            if (Boolean.FALSE.equals(isControl) && null != ((ContractEntity)((Object)contract)).getContractFileId()) {
                this.delContractFile(((ContractEntity)((Object)contract)).getContractFileId(), authority);
            }
            entity.setContractFileId(null);
            entity.setContractFilePath(null);
        }
        for (ContractDailyRentEntity dailyRentEntity : entity.getDailyRentList()) {
            dailyRentEntity.setSurplusCount(dailyRentEntity.getCount());
        }
        for (ContractMonthRentEntity monthRentEntity : entity.getMonthRentList()) {
            monthRentEntity.setSurplusCount(monthRentEntity.getCount());
        }
        for (ContractNumRentEntity numRentEntity : entity.getNumRentList()) {
            numRentEntity.setSurplusCount(numRentEntity.getCount());
        }
        ContractVO contractVO = null;
        this.logger.error("\u4fdd\u5b58: , {}", (Object)isControl);
        if (!isControl.booleanValue()) {
            if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().equals(entity.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().equals(entity.getDraftType())) {
                entity.setContractFileSyncFlag(false);
            }
            this.saveOrUpdate((Object)entity, false);
            contractVO = this.queryDetail(entity.getId());
        } else {
            List<ContractDailyRentEntity> dailyRentList = entity.getDailyRentList();
            List<ContractMonthRentEntity> monthRentList = entity.getMonthRentList();
            List<ContractNumRentEntity> numRentList = entity.getNumRentList();
            ArrayList<ContractDailyRentEntity> newDailyRentList = new ArrayList<ContractDailyRentEntity>();
            ArrayList<ContractMonthRentEntity> newMonthRentList = new ArrayList<ContractMonthRentEntity>();
            ArrayList<ContractNumRentEntity> newNumRentList = new ArrayList<ContractNumRentEntity>();
            for (ContractDailyRentEntity dailyRentEntity : dailyRentList) {
                if (null == dailyRentEntity.getId()) {
                    dailyRentEntity.setId(IdWorker.getId());
                }
                if ("del".equals(dailyRentEntity.getRowState())) continue;
                newDailyRentList.add(dailyRentEntity);
            }
            for (ContractMonthRentEntity monthRentEntity : monthRentList) {
                if (null == monthRentEntity.getId()) {
                    monthRentEntity.setId(IdWorker.getId());
                }
                if ("del".equals(monthRentEntity.getRowState())) continue;
                newMonthRentList.add(monthRentEntity);
            }
            for (ContractNumRentEntity numRentEntity : numRentList) {
                if (null == numRentEntity.getId()) {
                    numRentEntity.setId(IdWorker.getId());
                }
                if ("del".equals(numRentEntity.getRowState())) continue;
                newNumRentList.add(numRentEntity);
            }
            contractVO = (ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class);
            contractVO.setDailyRentList(BeanMapper.mapList(newDailyRentList, ContractDailyRentVO.class));
            contractVO.setMonthRentList(BeanMapper.mapList(newMonthRentList, ContractMonthRentVO.class));
            contractVO.setNumRentList(BeanMapper.mapList(newNumRentList, ContractNumRentVO.class));
        }
        if (!isControl.booleanValue()) {
            CommonResponse response = this.executionApi.aggPush(this.targetCost(contractVO));
            this.logger.info("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)this.targetCost(contractVO)));
            if (!response.isSuccess()) {
                this.logger.error("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5931\u8d25: , {}", (Object)response.getMsg());
                throw new BusinessException(response.getMsg());
            }
        }
        this.logger.info("\u8fd4\u56de\u6570\u636e: , {}", (Object)isControl);
        return contractVO;
    }

    private Boolean checkSameBillCode(ContractVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ContractEntity::getBillCode, (Object)contractVO.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)contractVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    public Boolean delContractFile(Long fileId, String authority) {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> header = new HashMap<String, String>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);
        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get((String)(this.baseHost + "ejc-file-web/attachment/delete"), params, header, (int)10000, (int)10000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse delResp = (CommonResponse)JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            this.logger.info("\u5728\u7ebf\u8d77\u8349\uff0c\u5220\u9664\u4e0a\u4f20\u5408\u540c\u8fd4\u56de\u4fe1\u606f\uff1a" + delResp.getMsg());
        }
        return true;
    }

    @Override
    public ContractVO queryDetail(Long id) {
        ContractEntity entity = (ContractEntity)((Object)this.selectById(id));
        ContractVO vo = (ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class);
        this.setRowState(vo);
        return vo;
    }

    @Override
    public String delete(List<ContractVO> vos) {
        CommonResponse response;
        ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
        if (ListUtil.isNotEmpty(vos)) {
            for (ContractVO vo : vos) {
                ContractEntity entity = (ContractEntity)((Object)this.selectById(vo.getId()));
                ExecutionVO executionVO = this.targetCost((ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class));
                totalExecutionVOList.add(executionVO.getTotalVO());
                if (null == entity.getTargetResultId()) continue;
                this.updateTargetResult(entity, CommonConstant.UN_OCCUPY_STATE);
            }
        }
        if (!(response = this.executionApi.aggDel(totalExecutionVOList)).isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u5220\u9664\u5931\u8d25\uff01");
        }
        this.removeByIds(vos.stream().map(ContractVO::getId).collect(Collectors.toList()), true);
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    @Override
    public JSONObject pageList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("firstPartyEmployeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        LinkedHashMap orderMap = new LinkedHashMap();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.put("create_time", "desc");
        String filingTypeConfig = this.service.getFilingTypeConfig();
        param.setOrderMap(orderMap);
        IPage pageData = this.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("filingTypeConfig", (Object)filingTypeConfig);
        page.put("contractCount", contractAmountMap);
        return page;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = ContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"round(sum(base_tax_mny),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ContractEntity::getMainContractId, (Object)id);
        lambda.eq(ContractEntity::getSupplementFlag, (Object)ContractVO.CONTRACT_TYPE_SUPPLEMENT);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ContractEntity::getSignatureStatus, (Object)String.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()))).or(c -> (LambdaQueryWrapper)c.notIn(ContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}))).or(c -> (LambdaQueryWrapper)c.eq(ContractEntity::getPerformanceStatus, (Object)String.valueOf(PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode()))));
        List supplementList = super.list((Wrapper)lambda);
        return supplementList.size() == 0;
    }

    @Override
    public SupplementRecordVO querySupplementRecord(Long id) {
        ContractEntity entity = (ContractEntity)((Object)this.selectById(id));
        SupplementRecordVO vo = new SupplementRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setContractMny(entity.getContractMny());
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        vo.setRentType(entity.getRentType());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractEntity::getMainContractId, (Object)id);
        wrapper.orderByDesc(ContractEntity::getSignDate);
        List supplementList = super.list((Wrapper)wrapper);
        vo.setSupplementToalTaxMny(supplementList.stream().filter(e -> e.getContractTaxMny() != null).map(ContractEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setSupplementToalMny(supplementList.stream().filter(e -> e.getContractMny() != null).map(ContractEntity::getContractMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setSupplementNum(Integer.valueOf(supplementList.size()));
        vo.setSupplementMnyRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getSupplementToalTaxMny(), (BigDecimal)vo.getContractTaxMny()), (BigDecimal)new BigDecimal("100")));
        vo.setDetailList(BeanMapper.mapList((Iterable)supplementList, ContractVO.class));
        Boolean filingTypeFlag = this.checkFilingType(id, ContractFilingTypeEnum.\u79df\u8d41\u5408\u540c\u8865\u5145\u534f\u8bae.getTypeCode());
        if (filingTypeFlag.booleanValue()) {
            vo.setEditFlag(true);
        } else {
            vo.setEditFlag(false);
        }
        return vo;
    }

    public void setRowState(ContractVO vo) {
        if (ListUtil.isNotEmpty((List)vo.getDailyRentList())) {
            vo.getDailyRentList().forEach(e -> e.setRowState("edit"));
        }
        if (ListUtil.isNotEmpty((List)vo.getMonthRentList())) {
            vo.getMonthRentList().forEach(e -> e.setRowState("edit"));
        }
        if (ListUtil.isNotEmpty((List)vo.getNumRentList())) {
            vo.getNumRentList().forEach(e -> e.setRowState("edit"));
        }
        if (ListUtil.isNotEmpty((List)vo.getRepairList())) {
            vo.getRepairList().forEach(e -> e.setRowState("edit"));
        }
        if (ListUtil.isNotEmpty((List)vo.getScrapList())) {
            vo.getScrapList().forEach(e -> e.setRowState("edit"));
        }
        if (ListUtil.isNotEmpty((List)vo.getOtherList())) {
            vo.getOtherList().forEach(e -> e.setRowState("edit"));
        }
        if (ListUtil.isNotEmpty((List)vo.getPaymentList())) {
            vo.getPaymentList().forEach(e -> e.setRowState("edit"));
        }
        if (ListUtil.isNotEmpty((List)vo.getClauseList())) {
            vo.getClauseList().forEach(e -> e.setRowState("edit"));
        }
    }

    @Override
    public ExecutionVO targetCost(ContractVO contractVO) {
        List monthRentList;
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setContractId(contractVO.getId());
        totalVO.setSourceId(contractVO.getId());
        totalVO.setBillDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)contractVO.getSignDate()));
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        totalVO.setMemo(contractVO.getMemo());
        totalVO.setBillType("BT220210000000004");
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getCode());
        totalVO.setProjectId(contractVO.getProjectId());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setMoney(contractVO.getContractMny());
        totalVO.setTaxMoney(contractVO.getContractTaxMny());
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        String cardType = contractVO.getAddType() == 0 ? "targetCard" : "addCard";
        String url = null;
        url = contractVO.getSupplementFlag() == 0 ? "/ejc-prormat-frontend/#/contract/card?id=" + contractVO.getId() + "&supplementFlag=" + contractVO.getSupplementFlag() + "&cardType=" + cardType + "&performanceStatus=" + contractVO.getPerformanceStatus() : "/ejc-prormat-frontend/#/contract/supplementCard?id=" + contractVO.getId() + "&supplementFlag=" + contractVO.getSupplementFlag() + "&cardType=" + cardType + "&performanceStatus=" + contractVO.getPerformanceStatus();
        totalVO.setLinkUrl(frontendBaseHost + url);
        List dailyRentList = contractVO.getDailyRentList();
        if (dailyRentList != null) {
            for (ContractDailyRentVO dailyRent : dailyRentList) {
                if ("del".equals(dailyRent.getRowState())) continue;
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(Long.valueOf(dailyRent.getId() == null ? IdWorker.getId() : dailyRent.getId()));
                detailExecutionVO.setSourceBillId(contractVO.getId());
                detailExecutionVO.setCategoryId(dailyRent.getMaterialTypeId());
                detailExecutionVO.setCategoryName(dailyRent.getMaterialTypeName());
                if (dailyRent.getMaterialId() == null) {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                    detailExecutionVO.setDocId(dailyRent.getMaterialTypeId());
                } else {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                    detailExecutionVO.setDocId(dailyRent.getMaterialId());
                }
                detailExecutionVO.setCode(dailyRent.getMaterialCode());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(dailyRent.getMaterialTypeId()).getData();
                if (categoryVO == null) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                } else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
                detailExecutionVO.setName(dailyRent.getMaterialName());
                detailExecutionVO.setUnitId(dailyRent.getUnitId());
                detailExecutionVO.setUnitName(dailyRent.getUnitName());
                detailExecutionVO.setNum(dailyRent.getCount());
                detailExecutionVO.setMoney(dailyRent.getRentMny());
                detailExecutionVO.setSpec(dailyRent.getSpec());
                detailExecutionVO.setTaxMoney(dailyRent.getRentTaxMny());
                detailExecutionVO.setPrice(dailyRent.getUnitPrice());
                detailExecutionVO.setTaxPrice(dailyRent.getUnitTaxPrice());
                detailExecutionVO.setTaxRate(dailyRent.getTax());
                detailExecutionVO.setContractId(contractVO.getId());
                detailExecutionVO.setRentDayNum(dailyRent.getRentDays() == null ? BigDecimal.ZERO : new BigDecimal(dailyRent.getRentDays().toString()));
                detailExecutionVO.setRentType(RentTypeEnum.\u65e5\u79df.getCode());
                detailExecutionVO.setMemo(dailyRent.getMemo());
                detailExecutionVO.setContractDetailId(dailyRent.getId());
                detailList.add(detailExecutionVO);
            }
        }
        if ((monthRentList = contractVO.getMonthRentList()) != null) {
            for (ContractMonthRentVO monthRentVO : monthRentList) {
                if ("del".equals(monthRentVO.getRowState())) continue;
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(Long.valueOf(monthRentVO.getId() == null ? IdWorker.getId() : monthRentVO.getId()));
                detailExecutionVO.setSourceBillId(contractVO.getId());
                detailExecutionVO.setCategoryId(monthRentVO.getMaterialTypeId());
                detailExecutionVO.setCategoryName(monthRentVO.getMaterialTypeName());
                if (monthRentVO.getMaterialId() == null) {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                    detailExecutionVO.setDocId(monthRentVO.getMaterialTypeId());
                } else {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                    detailExecutionVO.setDocId(monthRentVO.getMaterialId());
                }
                detailExecutionVO.setCode(monthRentVO.getMaterialCode());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(monthRentVO.getMaterialTypeId()).getData();
                if (categoryVO == null) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                } else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
                detailExecutionVO.setName(monthRentVO.getMaterialName());
                detailExecutionVO.setUnitId(monthRentVO.getUnitId());
                detailExecutionVO.setUnitName(monthRentVO.getUnitName());
                detailExecutionVO.setNum(monthRentVO.getCount());
                detailExecutionVO.setMoney(monthRentVO.getRentMny());
                detailExecutionVO.setSpec(monthRentVO.getSpec());
                detailExecutionVO.setTaxMoney(monthRentVO.getRentTaxMny());
                detailExecutionVO.setPrice(monthRentVO.getUnitPrice());
                detailExecutionVO.setTaxPrice(monthRentVO.getUnitTaxPrice());
                detailExecutionVO.setTaxRate(monthRentVO.getTax());
                detailExecutionVO.setContractId(contractVO.getId());
                detailExecutionVO.setRentDayNum(monthRentVO.getRentDays() == null ? BigDecimal.ZERO : new BigDecimal(monthRentVO.getRentDays().toString()));
                detailExecutionVO.setRentMonthNum(monthRentVO.getRentMonths() == null ? BigDecimal.ZERO : new BigDecimal(monthRentVO.getRentMonths().toString()));
                detailExecutionVO.setRentType(RentTypeEnum.\u6708\u79df.getCode());
                detailExecutionVO.setMemo(monthRentVO.getMemo());
                detailExecutionVO.setContractDetailId(monthRentVO.getId());
                detailList.add(detailExecutionVO);
            }
        }
        List numRentList = contractVO.getNumRentList();
        if (monthRentList != null) {
            for (ContractNumRentVO numRentVO : numRentList) {
                if ("del".equals(numRentVO.getRowState())) continue;
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(Long.valueOf(numRentVO.getId() == null ? IdWorker.getId() : numRentVO.getId()));
                detailExecutionVO.setSourceBillId(contractVO.getId());
                detailExecutionVO.setCategoryId(numRentVO.getMaterialTypeId());
                detailExecutionVO.setCategoryName(numRentVO.getMaterialTypeName());
                if (numRentVO.getMaterialId() == null) {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                    detailExecutionVO.setDocId(numRentVO.getMaterialTypeId());
                } else {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                    detailExecutionVO.setDocId(numRentVO.getMaterialId());
                }
                detailExecutionVO.setCode(numRentVO.getMaterialCode());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(numRentVO.getMaterialTypeId()).getData();
                if (categoryVO == null) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                } else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
                detailExecutionVO.setName(numRentVO.getMaterialName());
                detailExecutionVO.setUnitId(numRentVO.getUnitId());
                detailExecutionVO.setUnitName(numRentVO.getUnitName());
                detailExecutionVO.setNum(numRentVO.getCount());
                detailExecutionVO.setMoney(numRentVO.getRentMny());
                detailExecutionVO.setSpec(numRentVO.getSpec());
                detailExecutionVO.setTaxMoney(numRentVO.getRentTaxMny());
                detailExecutionVO.setPrice(numRentVO.getUnitPrice());
                detailExecutionVO.setTaxPrice(numRentVO.getUnitTaxPrice());
                detailExecutionVO.setTaxRate(numRentVO.getTax());
                detailExecutionVO.setContractId(contractVO.getId());
                detailExecutionVO.setRentType(RentTypeEnum.\u5de5\u7a0b\u91cf\u79df.getCode());
                detailExecutionVO.setQuantityNum(numRentVO.getQuantities());
                detailExecutionVO.setMemo(numRentVO.getMemo());
                detailExecutionVO.setContractDetailId(numRentVO.getId());
                detailList.add(detailExecutionVO);
            }
        }
        totalVO.setLinkUrl(this.baseHost + url);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public Boolean pushBillToSupCenter(ContractEntity entity) {
        Boolean syncFlag = this.pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON((Object)((Object)entity)), OPERATE, BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
        return syncFlag;
    }

    @Override
    public Boolean delPushBill(ContractEntity entity) {
        Boolean delSuc = this.pushSupUtil.delPushBill((JSONObject)JSONObject.toJSON((Object)((Object)entity)), OPERATE, BILL_TYPE, BILL_NAME, DEL_SUP_BILL_SERVER_URL);
        return delSuc;
    }

    @Override
    public Boolean pushContract(ContractVO vo) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)vo, (Object)data);
            data.setSourceType(ContractTypeEnum.\u5468\u8f6c\u6750\u5408\u540c.getTypeCode());
            data.setContractProperty(Integer.valueOf(SettleEnum.\u652f\u51fa.getCode()));
            String cardType = vo.getAddType() == 0 ? "targetCard" : "addCard";
            String url = null;
            url = vo.getSupplementFlag() == 0 ? "/ejc-prormat-frontend/#/contract/contractMultiCards?id=" + vo.getId() + "&supplementFlag=" + vo.getSupplementFlag() + "&cardType=" + cardType + "&performanceStatus=" + vo.getPerformanceStatus() : "/ejc-prormat-frontend/#/contract/supplementCard?id=" + vo.getId() + "&supplementFlag=" + vo.getSupplementFlag() + "&cardType=" + cardType + "&performanceStatus=" + vo.getPerformanceStatus();
            data.setPcCardUrl(url);
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            if (transDataResp.isSuccess()) {
                return true;
            }
            this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)vo.getId(), (Object)transDataResp.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)vo.getId(), (Object)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String validateContract(Long contractId, String billType, Long billId, String type) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("bill_state", new Parameter("in", (Object)"1,3"));
        c2.getParams().put("signature_status", new Parameter("ne", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        c1.getComplexParams().add(c2);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("main_contract_id", new Parameter("eq", (Object)contractId));
        queryParam.getComplexParams().add(c1);
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam2.getComplexParams().add(c1);
        QueryParam queryParam3 = new QueryParam();
        queryParam3.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam3.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        QueryParam param = (QueryParam)BeanMapper.map((Object)queryParam, QueryParam.class);
        QueryParam param2 = (QueryParam)BeanMapper.map((Object)queryParam2, QueryParam.class);
        QueryParam param3 = (QueryParam)Utils.deepCopy((Object)queryParam3);
        if (billId != null) {
            param.getParams().put("id", new Parameter("ne", (Object)billId));
            param2.getParams().put("id", new Parameter("ne", (Object)billId));
            param3.getParams().put("id", new Parameter("ne", (Object)billId));
        }
        Future<JSONArray> future1 = ListCallable.excute(threadPool, "\u8865\u5145\u534f\u8bae".equals(billType) ? param : queryParam, this.service);
        Future<JSONArray> future2 = ListCallable.excute(threadPool, "\u53d8\u66f4\u5355".equals(billType) ? param2 : queryParam2, this.changeService);
        Future<JSONArray> future3 = ListCallable.excute(threadPool, "\u89e3\u9664\u5355".equals(billType) ? param2 : queryParam2, this.relieveService);
        Future<JSONArray> future4 = ListCallable.excute(threadPool, "\u51bb\u7ed3\u5355".equals(billType) ? param3 : queryParam3, this.freezeService);
        List supplementList = new ArrayList();
        List changeList = new ArrayList();
        List relieveList = new ArrayList();
        List freezeList = new ArrayList();
        try {
            supplementList = JSONObject.parseArray((String)future1.get().toJSONString(), ContractEntity.class);
            changeList = JSONObject.parseArray((String)future2.get().toJSONString(), ChangeEntity.class);
            relieveList = JSONObject.parseArray((String)future3.get().toJSONString(), ContractRelieveEntity.class);
            freezeList = JSONObject.parseArray((String)future4.get().toJSONString(), ContractFreezeEntity.class);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        if (ListUtil.isNotEmpty(supplementList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u6216\u672a\u7b7e\u7ae0\u7684\u8865\u5145\u534f\u8bae\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(changeList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u6216\u672a\u7b7e\u7ae0\u7684\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(freezeList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u51bb\u7ed3\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(relieveList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u6216\u672a\u7b7e\u7ae0\u7684\u89e3\u9664\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public Boolean delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);
        this.logger.info("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\uff01", (Object)id);
        CommonResponse delDataResp = this.contractPoolApi.deleteContract(c);
        if (delDataResp.isSuccess()) {
            return true;
        }
        this.logger.error("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\u5931\u8d25, {}\uff01", (Object)id, (Object)delDataResp.getMsg());
        return false;
    }

    @Override
    public ParamsCheckVO targetCostCtrl(ContractVO contractVO, String authority) {
        ContractVO vo = this.saveOrUpdate(contractVO, authority, true);
        ExecutionVO executionVO = this.targetCost(vo);
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        return (ParamsCheckVO)response.getData();
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        ContractVO contractVO = this.queryDetail(id);
        ExecutionVO executionVO = this.targetCost(contractVO);
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        return (ParamsCheckVO)response.getData();
    }

    @Override
    public ParamsCheckVO checkParams(ContractVO contractVO) {
        ExecutionVO executionVO;
        CommonResponse response;
        CommonResponse ctrlOutConMnyRes;
        CommonResponse project;
        ContractVO vo = this.saveOrUpdate(contractVO, null, true);
        ArrayList<Object> paramsCheckVOS = new ArrayList<Object>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        Long orgId = vo.getOrgId();
        if (vo.getOrgId() == null && (project = this.projectSetApi.getProjectId(vo.getProjectId())).isSuccess() && project.getData() != null) {
            vo.setOrgId(((ProjectPoolSetVO)project.getData()).getProjectDepartmentId());
        }
        if ((ctrlOutConMnyRes = this.paramCheckApi.paramsCheck(vo.getProjectId(), vo.getId(), vo.getContractTaxMny(), orgId)).isSuccess() && ctrlOutConMnyRes.getData() != null) {
            paramsCheckVOS.addAll((Collection)ctrlOutConMnyRes.getData());
        }
        paramsCheckVOS.addAll(this.checkParamsMny(1, vo.getId(), vo.getProjectId(), vo.getContractTaxMny(), orgId));
        ParamsCheckVO costParams = this.costPriceCheckParams(vo);
        if (costParams != null) {
            paramsCheckVOS.add(costParams);
        }
        if ((response = this.executionApi.ctrlCheckVO(executionVO = this.targetCost(vo))).isSuccess() && response.getData() != null) {
            paramsCheckVOS.add(response.getData());
        }
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO paramsCheckVO2 : paramsCheckVOS) {
                String warnType = paramsCheckVO2.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(paramsCheckVO2.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, paramsCheckVO2.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    public ParamsCheckVO costPriceCheckParams(ContractVO vo) {
        MaterialCostPriceApiVO priceHistoryApiVO;
        MaterialCostPriceApiVO materialPriceHistoryApiVO = new MaterialCostPriceApiVO();
        ArrayList<MaterialCostPriceApiVO> materialPriceHistoryApiVOS = new ArrayList<MaterialCostPriceApiVO>();
        if (CollectionUtil.isNotEmpty((Collection)vo.getDailyRentList())) {
            for (ContractDailyRentVO detailVO : vo.getDailyRentList()) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getMaterialId() == null) continue;
                priceHistoryApiVO = new MaterialCostPriceApiVO();
                priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                priceHistoryApiVO.setSpec(detailVO.getSpec());
                priceHistoryApiVO.setPrice(detailVO.getUnitPrice());
                priceHistoryApiVO.setTaxPrice(detailVO.getUnitTaxPrice());
                materialPriceHistoryApiVOS.add(priceHistoryApiVO);
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)vo.getMonthRentList())) {
            for (ContractDailyRentVO detailVO : vo.getMonthRentList()) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getMaterialId() == null) continue;
                priceHistoryApiVO = new MaterialCostPriceApiVO();
                priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                priceHistoryApiVO.setSpec(detailVO.getSpec());
                priceHistoryApiVO.setPrice(detailVO.getUnitPrice());
                priceHistoryApiVO.setTaxPrice(detailVO.getUnitTaxPrice());
                materialPriceHistoryApiVOS.add(priceHistoryApiVO);
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)vo.getNumRentList())) {
            for (ContractDailyRentVO detailVO : vo.getNumRentList()) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getMaterialId() == null) continue;
                priceHistoryApiVO = new MaterialCostPriceApiVO();
                priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                priceHistoryApiVO.setSpec(detailVO.getSpec());
                priceHistoryApiVO.setPrice(detailVO.getUnitPrice());
                priceHistoryApiVO.setTaxPrice(detailVO.getUnitTaxPrice());
                materialPriceHistoryApiVOS.add(priceHistoryApiVO);
            }
        }
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        materialPriceHistoryApiVO.setProjectId(vo.getProjectId());
        materialPriceHistoryApiVO.setMaterialCostPriceApiVOList(materialPriceHistoryApiVOS);
        ParamsCheckVO paramsCheckVO = this.costPriceParams(materialPriceHistoryApiVO, TARGET_COST_CHECK_PARAM_CODE, "\u5408\u540c");
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkParamsMny(Integer purchaseType, Long id, Long projectId, BigDecimal contractTaxMny, Long orgId) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, orgId);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    List<TotalPlanEntity> totalPlanList = this.totalPlanService.listTotalPlanByProjectId(projectId);
                    if (CollectionUtils.isEmpty(totalPlanList)) {
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        paramsCheckVOList.add(paramsCheckVO);
                        return paramsCheckVOList;
                    }
                    if (2 == purchaseType) {
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        continue;
                    }
                    BigDecimal sumEstimatedMny = totalPlanList.stream().map(TotalPlanEntity::getEstimatedMny).reduce(BigDecimal::add).get();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)sumEstimatedMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    BigDecimal sumContractTaxMny = BigDecimal.ZERO;
                    List<ContractEntity> contractEntities = this.listContractByProjectId(id, projectId);
                    List contractListA = contractEntities.stream().filter(e -> PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode().equals(e.getPerformanceStatus()) || PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().equals(e.getPerformanceStatus()) || PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(e.getPerformanceStatus())).collect(Collectors.toList());
                    for (ContractEntity entity : contractListA) {
                        if (ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode().equals(entity.getChangeStatus())) {
                            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                            queryWrapper.eq(ChangeEntity::getContractId, (Object)entity.getId());
                            queryWrapper.eq(BaseEntity::getDr, (Object)0);
                            queryWrapper.notIn(ChangeEntity::getBillState, new Object[]{1, 3});
                            queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
                            List changeList = this.changeService.list((Wrapper)queryWrapper);
                            BigDecimal afterChangeTaxMny = changeList.stream().map(ChangeEntity::getContractTaxMny).reduce(BigDecimal::add).get();
                            sumContractTaxMny = MathUtil.safeAdd(sumContractTaxMny, afterChangeTaxMny);
                            continue;
                        }
                        sumContractTaxMny = MathUtil.safeAdd(sumContractTaxMny, entity.getContractTaxMny());
                    }
                    List contractListB = contractEntities.stream().filter(e -> PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getCode().equals(e.getPerformanceStatus()) || PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode().equals(e.getPerformanceStatus()) || PerformanceStatusEnum.\u5df2\u7ed3\u675f.getCode().equals(e.getPerformanceStatus())).collect(Collectors.toList());
                    BigDecimal sumSettleTaxMny = BigDecimal.ZERO;
                    if (CollectionUtils.isNotEmpty(contractListB)) {
                        List contractIds = contractListB.stream().map(BaseEntity::getId).collect(Collectors.toList());
                        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                        queryWrapper.eq(BaseEntity::getDr, (Object)0);
                        queryWrapper.in(SettleEntity::getContractId, contractIds);
                        List settleList = this.settleService.list((Wrapper)queryWrapper);
                        if (CollectionUtils.isNotEmpty((Collection)settleList)) {
                            sumSettleTaxMny = settleList.stream().map(SettleEntity::getSettleTaxMny).reduce(BigDecimal::add).get();
                        }
                        sumContractTaxMny = MathUtil.safeAdd(sumContractTaxMny, sumSettleTaxMny);
                    }
                    sumContractTaxMny = MathUtil.safeAdd(sumContractTaxMny, contractTaxMny).setScale(2, 4);
                    BigDecimal bigDecimal = contractTaxMny = contractTaxMny != null ? contractTaxMny.setScale(2, 4) : BigDecimal.ZERO;
                    if (sumContractTaxMny.compareTo(comMny) <= 0) {
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        paramsCheckVOList.add(paramsCheckVO);
                        return paramsCheckVOList;
                    }
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("\u79df\u8d41\u91d1\u989d\u8d85\u603b\u8ba1\u5212\u91d1\u989d");
                    paramsCheckDsVO.setOrgName(datum.getOrgName());
                    paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u5408\u540c\u91d1\u989d\u5927\u4e8e\u603b\u8ba1\u5212\u91d1\u989d");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a").append(contractTaxMny).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u5408\u540c\u91d1\u989d\uff1a").append(sumContractTaxMny).append("\u5143\uff0c\u603b\u8ba1\u5212\u91d1\u989d*").append(roleValue).append("% = ").append(comMny).append("\u5143\u3002\u8d85\u7ed3\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)sumContractTaxMny, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOS.add(paramsCheckDsVO);
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public ParamsCheckVO supplementCheckParams(Long id, Long mainContractId, BigDecimal supplementContractTaxMny) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        paramsCheckVOS.addAll(this.checkParamsSupplementMny(id, mainContractId, supplementContractTaxMny));
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkParamsSupplementMny(Long id, Long mainContractId, BigDecimal supplementContractTaxMny) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ContractEntity mainContractEntity = (ContractEntity)((Object)super.selectById((Serializable)mainContractId));
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(SUPPLEMENT_CHECK_PARAM_CODE, mainContractEntity.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)mainContractEntity.getContractTaxMny(), (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(ContractEntity::getMainContractId, (Object)mainContractId);
                    queryWrapper.in(ContractEntity::getBillState, new Object[]{1, 3});
                    queryWrapper.eq(BaseEntity::getDr, (Object)0);
                    queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
                    List supplementContractList = super.list((Wrapper)queryWrapper);
                    BigDecimal sumSupplementContractTaxMny = BigDecimal.ZERO;
                    if (CollectionUtils.isNotEmpty((Collection)supplementContractList)) {
                        sumSupplementContractTaxMny = supplementContractList.stream().map(ContractEntity::getContractTaxMny).reduce(BigDecimal::add).get();
                    }
                    sumSupplementContractTaxMny = ComputeUtil.safeAdd((BigDecimal)sumSupplementContractTaxMny, (BigDecimal)supplementContractTaxMny).setScale(2, 4);
                    BigDecimal bigDecimal = supplementContractTaxMny = supplementContractTaxMny != null ? supplementContractTaxMny.setScale(2, 4) : BigDecimal.ZERO;
                    if (sumSupplementContractTaxMny.compareTo(comMny) <= 0) {
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        paramsCheckVOList.add(paramsCheckVO);
                        return paramsCheckVOList;
                    }
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("\u8865\u5145\u534f\u8bae\u8d85\u5408\u540c\u91d1\u989d");
                    paramsCheckDsVO.setOrgName(datum.getOrgName());
                    paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u8865\u5145\u534f\u8bae\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u8865\u5145\u534f\u8bae\u91d1\u989d\uff1a").append(supplementContractTaxMny).append("\u5143\uff0c\u542b\u672c\u6b21\u8865\u5145\u534f\u8bae\u91d1\u989d\uff1a").append(sumSupplementContractTaxMny).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("% = ").append(comMny).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)sumSupplementContractTaxMny, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOS.add(paramsCheckDsVO);
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public List<Map<String, Object>> querySettleWarnContract(List<SqlParam> sqlParamList) {
        return ((ContractMapper)this.baseMapper).querySettleWarnContract(sqlParamList);
    }

    @Override
    public Boolean syncPushExecution(Long id) {
        CommonResponse response;
        ContractVO contractVO = this.queryDetail(id);
        if (PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode().equals(contractVO.getPerformanceStatus())) {
            LambdaQueryWrapper relieveWrapper = new LambdaQueryWrapper();
            relieveWrapper.eq(ContractRelieveEntity::getContractId, (Object)contractVO.getId());
            List relieveList = this.relieveService.list((Wrapper)relieveWrapper);
            ExecutionVO executionVO2 = this.relieveService.targetCost((ContractRelieveEntity)((Object)relieveList.get(0)));
            response = this.executionApi.aggPush(executionVO2);
            this.logger.info("\u5408\u540c\u89e3\u9664\u63a8\u9001\u76ee\u6807\u6210\u672c\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)executionVO2));
            if (!response.isSuccess()) {
                this.logger.error("\u5408\u540c\u89e3\u9664\u63a8\u9001\u76ee\u6807\u6210\u672c\u5931\u8d25: , {}", (Object)response.getMsg());
                throw new BusinessException(response.getMsg());
            }
        }
        ExecutionVO executionVO = null;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ChangeEntity::getContractId, (Object)id);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.changeService.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            executionVO = this.targetCost(contractVO);
        } else {
            ChangeEntity changeEntity = (ChangeEntity)((Object)list.get(0));
            executionVO = this.changeService.targetCost((ChangeVO)BeanMapper.map((Object)((Object)changeEntity), ChangeVO.class));
        }
        response = this.executionApi.aggPush(executionVO);
        this.logger.info("\u5408\u540c\u63a8\u9001\u76ee\u6807\u6210\u672c\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)executionVO));
        if (!response.isSuccess()) {
            this.logger.error("\u5408\u540c\u63a8\u9001\u76ee\u6807\u6210\u672c\u5931\u8d25: , {}", (Object)response.getMsg());
            throw new BusinessException(response.getMsg());
        }
        return true;
    }

    @Override
    public Integer queryTotalSettleNum(Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SettleEntity::getContractId, (Object)id);
        wrapper.in(SettleEntity::getBillState, Arrays.asList(1, 3));
        List list = this.settleService.list((Wrapper)wrapper);
        if (ListUtil.isNotEmpty((List)list)) {
            return list.size();
        }
        return 0;
    }

    @Override
    public List<ContractEntity> listContractByProjectId(Long id, Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (null != id) {
            queryWrapper.ne(BaseEntity::getId, (Object)id);
        }
        queryWrapper.eq(ContractEntity::getProjectId, (Object)projectId);
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq(BaseEntity::getDr, (Object)0);
        return super.list((Wrapper)queryWrapper);
    }

    @Override
    public boolean delWatermarkContractFile(Long watermarkFileId) {
        Assert.notNull((Object)watermarkFileId, (String)"\u6c34\u5370\u5408\u540c\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CommonResponse res = this.attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            this.logger.error("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a{}", (Object)res.getMsg(), (Object)watermarkFileId);
            throw new BusinessException("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + res.getMsg() + "\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a" + watermarkFileId);
        }
        return true;
    }

    @Override
    public ContractPaymentRecordVO queryPaymentApplyList(Long id) {
        Boolean contractFilingFlag;
        ContractPaymentRecordVO resultVO = new ContractPaymentRecordVO();
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById(id));
        resultVO.setContractId(id);
        resultVO.setContractTaxMny(contractEntity.getContractTaxMny());
        resultVO.setContractMny(contractEntity.getContractMny());
        resultVO.setPerformanceStatus(contractEntity.getPerformanceStatus());
        resultVO.setSignatureStatus(contractEntity.getSignatureStatus());
        resultVO.setChangeStatus(contractEntity.getChangeStatus());
        resultVO.setRentType(contractEntity.getRentType());
        CommonResponse resultData = this.paymentApplyApi.queryListByContractId(id);
        if (!resultData.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5408\u540c\u4ed8\u6b3e\u5931\u8d25");
        }
        List paymentApplyVOList = (List)resultData.getData();
        if (ListUtil.isNotEmpty((List)paymentApplyVOList)) {
            resultVO.setTotalApplyMny(paymentApplyVOList.stream().map(PaymentApplyVO::getApplyMny).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
            resultVO.setTotalActualMny(paymentApplyVOList.stream().map(PaymentApplyVO::getActualMny).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
            resultVO.setTotalApprovalMny(paymentApplyVOList.stream().map(PaymentApplyVO::getApprovalMny).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
            paymentApplyVOList.forEach(item -> {
                item.setApplyMny(item.getApplyMny() != null ? item.getApplyMny() : BigDecimal.ZERO);
                item.setActualMny(item.getActualMny() != null ? item.getActualMny() : BigDecimal.ZERO);
                item.setApprovalMny(item.getApprovalMny() != null ? item.getApprovalMny() : BigDecimal.ZERO);
            });
            resultVO.setPaymentApplyList(paymentApplyVOList);
        } else {
            resultVO.setTotalApplyMny(BigDecimal.ZERO);
            resultVO.setTotalActualMny(BigDecimal.ZERO);
            resultVO.setTotalApprovalMny(BigDecimal.ZERO);
        }
        if (resultVO.getTotalActualMny() != null) {
            resultVO.setPaymentRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)resultVO.getTotalActualMny(), (BigDecimal)resultVO.getContractTaxMny()), (BigDecimal)new BigDecimal("100")));
        } else {
            resultVO.setPaymentRate(BigDecimal.ZERO);
        }
        CommonResponse addFlagData = this.paymentApplyApi.queryAddFlagContractId(id);
        if (addFlagData != null && addFlagData.getData() != null && ((String)addFlagData.getData()).equals("1")) {
            resultVO.setAddFlag(Boolean.valueOf(true));
        }
        if ((contractFilingFlag = this.service.checkFilingType(id, ContractFilingTypeEnum.\u5408\u540c\u4ed8\u6b3e\u7533\u8bf7.getTypeCode())).booleanValue()) {
            resultVO.setAddFlag(Boolean.valueOf(true));
        } else {
            resultVO.setAddFlag(Boolean.valueOf(false));
        }
        return resultVO;
    }

    @Override
    public Boolean validateTargetMny(ContractEntity entity) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractEntity::getTargetResultId, (Object)entity.getTargetResultId());
        if (entity.getId() != null) {
            wrapper.ne(BaseEntity::getId, (Object)entity.getId());
        }
        List list = this.list((Wrapper)wrapper);
        BigDecimal sumContractTaxMny = list.stream().map(ContractEntity::getBaseTaxMny).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        if ((sumContractTaxMny = ComputeUtil.safeAdd((BigDecimal)sumContractTaxMny, (BigDecimal)entity.getContractTaxMny())).compareTo(entity.getTargetTaxMny() != null ? entity.getTargetTaxMny() : BigDecimal.ZERO) > 0) {
            throw new BusinessException("\u5408\u540c\u91d1\u989d\u8d85\u8fc7\u5b9a\u6807\u91d1\u989d\uff0c\u4e0d\u53ef\u4fdd\u5b58\uff01");
        }
        return true;
    }

    @Override
    public List<SignContractVo> queryContractByTargetResultId(List<String> targetResultIdList) {
        ArrayList<SignContractVo> rtnList = new ArrayList<SignContractVo>();
        if (ListUtil.isEmpty(targetResultIdList)) {
            return rtnList;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("targetResultId", new Parameter("in", targetResultIdList));
        queryParam.getOrderMap().put("signDate", "desc");
        List entityList = this.queryList(queryParam, false);
        if (ListUtil.isEmpty((List)entityList)) {
            return rtnList;
        }
        for (ContractEntity entity : entityList) {
            SignContractVo vo = new SignContractVo();
            vo.setBillCode(entity.getBillCode());
            vo.setContractId(entity.getId());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());
            vo.setSupplierName(entity.getSupplierName());
            vo.setContractMny(entity.getContractMny());
            vo.setContractTaxMny(entity.getContractTaxMny());
            vo.setSignDate(entity.getSignDate());
            vo.setBillState(entity.getBillState());
            vo.setLinkUrl(this.getContractLinkUrl(entity.getTargetResultId(), entity.getId(), entity.getSupplementFlag(), entity.getPerformanceStatus(), entity.getAddType()));
            rtnList.add(vo);
        }
        return rtnList;
    }

    private String getContractLinkUrl(Long targetResultId, Long contractId, Integer supplementFlag, String performanceStatus, Integer addType) {
        String cardType = addType == 0 ? "targetCard" : "addCard";
        String url = null;
        url = supplementFlag == 0 ? "/ejc-prormat-frontend/#/contract/contractMultiCards?id=" + contractId + "&supplementFlag=" + supplementFlag + "&cardType=" + cardType + "&performanceStatus=" + performanceStatus : "/ejc-prormat-frontend/#/contract/supplementCard?id=" + contractId + "&supplementFlag=" + supplementFlag + "&cardType=" + cardType + "&performanceStatus=" + performanceStatus;
        return url;
    }

    private String getContractBillCode(ContractVO contractVo) {
        String contractBillCode;
        this.logger.info("\u751f\u6210\u7f16\u7801\u89c4\u5219\uff0cGenerateBillCodeType=\uff1a{}", (Object)this.GenerateBillCodeType);
        if (Objects.equals(contractVo.getSupplementFlag(), ContractVO.CONTRACT_TYPE_SUPPLEMENT)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(ContractEntity::getMainContractId, (Object)contractVo.getMainContractId());
            wrapper.in(ContractEntity::getBillState, Arrays.asList(1, 3));
            List list = this.list((Wrapper)wrapper);
            String supplementNum = "";
            supplementNum = list.size() < 10 ? supplementNum + "0" + (list.size() + 1) : supplementNum + (list.size() + 1);
            contractBillCode = contractVo.getMainContractCode() + "-2-" + supplementNum;
        } else {
            switch (this.GenerateBillCodeType) {
                case "common": {
                    BillCodeParam billCodeParam = BillCodeParam.build((String)PRO_RMAT_CONTRACT, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)contractVo);
                    CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                    if (billCode.isSuccess()) {
                        contractBillCode = (String)billCode.getData();
                        break;
                    }
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                case "ynjt": {
                    BillCodeParam billCodeParamYnjt = BillCodeParam.build((String)PURCHASE_CONTRACT_YNJT, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)contractVo);
                    CommonResponse billCodeFirstPart = this.billCodeApi.generateBillCode(billCodeParamYnjt);
                    if (!billCodeFirstPart.isSuccess()) {
                        this.logger.error("\u4fdd\u5b58\u5408\u540c\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5408\u540c\u5408\u540c\u5931\u8d25: {}", (Object)billCodeFirstPart.getMsg());
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    String orgSub = contractVo.getParentOrgCode().substring(contractVo.getParentOrgCode().length() - 3);
                    CommonSNVO commonSNVO = new CommonSNVO();
                    commonSNVO.setSnLength(Integer.valueOf(4));
                    commonSNVO.setTenantId(InvocationInfoProxy.getTenantid());
                    commonSNVO.setDimension(orgSub);
                    commonSNVO.setSourceType("YNJTCLCG");
                    CommonResponse snResp = this.commonSNAPI.getNext(commonSNVO);
                    if (!snResp.isSuccess()) {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    contractBillCode = (String)billCodeFirstPart.getData() + orgSub + (String)snResp.getData();
                    break;
                }
                default: {
                    throw new BusinessException("\u7f16\u7801\u751f\u6210\u5931\u8d25\uff01");
                }
            }
        }
        return contractBillCode;
    }

    public void updateTargetResult(ContractEntity entity, Integer type) {
        if (entity.getTargetResultId() == null) {
            return;
        }
        TenderPicketageVO vo = new TenderPicketageVO();
        vo.setId(entity.getTargetResultId());
        vo.setContractMoneyTax(entity.getContractTaxMny());
        vo.setContractMoney(entity.getContractMny());
        CommonResponse response = 1 == type ? this.tenderRmatApi.updateStatus(vo) : this.tenderRmatApi.delUpdateStatus(vo);
        this.logger.info("\u4fee\u6539\u5b9a\u6807\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
        if (!response.isSuccess()) {
            throw new BusinessException(1 == type ? "\u5360\u7528" : "\u91ca\u653e\u5b9a\u6807\u7ed3\u679c\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
    }

    @Override
    public String getFilingTypeConfig() {
        String filingTypeConfig = "0";
        CommonResponse response = this.paramConfigApi.getByCode("P-eg7rBO0134");
        if (!response.isSuccess() || response.getData() == null) {
            this.logger.error("\u6839\u636e\u5f52\u6863\u53c2\u6570\u7f16\u7801-{}\uff0c\u67e5\u8be2\u7cfb\u7edf\u53c2\u6570\uff08\u5408\u540c\u5f52\u6863\u63a7\u5236\uff09\u914d\u7f6e\u4fe1\u606f\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)"P-eg7rBO0134", (Object)response.getMsg());
        } else if (null != ((ParamRegisterSetVO)response.getData()).getValueData()) {
            filingTypeConfig = ((ParamRegisterSetVO)response.getData()).getValueData();
        }
        return filingTypeConfig;
    }

    @Override
    public Boolean checkFilingType(Long contractId, String contractTypeCode) {
        Boolean addFlag = true;
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)contractId));
        if (null != contractEntity && 1 != contractEntity.getFilingStatus()) {
            String filingTypeConfig = this.getFilingTypeConfig();
            if ("1".equals(filingTypeConfig)) {
                switch (ContractFilingTypeEnum.getEnumByCode((String)contractTypeCode)) {
                    case \u79df\u8d41\u5408\u540c\u53d8\u66f4: {
                        addFlag = false;
                        break;
                    }
                    case \u79df\u8d41\u5408\u540c\u8865\u5145\u534f\u8bae: {
                        addFlag = false;
                        break;
                    }
                    case \u79df\u8d41\u5408\u540c\u7ed3\u7b97: {
                        addFlag = false;
                        break;
                    }
                    case \u5408\u540c\u4ed8\u6b3e\u7533\u8bf7: {
                        addFlag = false;
                    }
                }
            } else {
                addFlag = "2".equals(filingTypeConfig) ? Boolean.valueOf(false) : Boolean.valueOf(true);
            }
        }
        return addFlag;
    }

    @Override
    public void delById(Long id) {
        ((ContractMapper)this.baseMapper).delById(id);
    }

    @Override
    public void delChangeById(Long id) {
        ((ContractMapper)this.baseMapper).delChangeById(id);
    }

    @Override
    public void delRecordById(Long id) {
        ((ContractMapper)this.baseMapper).delRecordById(id);
    }

    @Override
    public ParamsCheckVO costPriceParams(MaterialCostPriceApiVO materialPriceHistoryApiVO, String code, String type) {
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        List detailList = materialPriceHistoryApiVO.getMaterialCostPriceApiVOList();
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            this.logger.info("detailList\u4e3a\u7a7a\u76f4\u63a5\u8fd4\u56de\u7ed3\u679c");
            return paramsCheckVO;
        }
        List materialIds = detailList.stream().map(MaterialCostPriceApiVO::getMaterialId).collect(Collectors.toList());
        Long orgId = materialPriceHistoryApiVO.getOrgId();
        if (null == orgId) {
            this.logger.info("orgId\u4e3a\u7a7a");
            return paramsCheckVO;
        }
        CommonResponse maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(code, orgId);
        if (!maxParamByCode.isSuccess() && null == maxParamByCode.getData()) {
            this.logger.info(maxParamByCode.getMsg());
            return paramsCheckVO;
        }
        List maxParamVOS = (List)maxParamByCode.getData();
        this.logger.info("\u4ef7\u683c\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)maxParamVOS));
        CommonResponse dutyRes = this.dutyApi.queryPriceByRentDocIds(materialPriceHistoryApiVO.getProjectId(), DocTypeEnum.\u7269\u6599\u6863\u6848.getCode(), materialIds);
        Map dutyMap = (Map)dutyRes.getData();
        if (null == dutyRes) {
            this.logger.info("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u4ef7\u683c\u4e3a\u7a7a");
            return paramsCheckVO;
        }
        if (null == dutyMap) {
            this.logger.info("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u4ef7\u683cmap\u4e3a\u7a7a");
            return paramsCheckVO;
        }
        if (CollectionUtils.isNotEmpty((Collection)maxParamVOS)) {
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOCost = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();
                paramsCheckVOCost.setWarnType(paramsArray[maxParamVO.getControlType()]);
                for (MaterialCostPriceApiVO detailVO : detailList) {
                    BigDecimal maxPriceParam;
                    BigDecimal maxPrice = dutyMap.get(detailVO.getMaterialId()) == null ? BigDecimal.ZERO : ((BigDecimal)dutyMap.get(detailVO.getMaterialId())).setScale(4, 4);
                    BigDecimal price = detailVO.getPrice() == null ? BigDecimal.ZERO : detailVO.getPrice().setScale(4, 4);
                    if (price.compareTo(maxPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)maxPrice, (BigDecimal)roleValueMax), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) <= 0) continue;
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + (detailVO.getSpec() == null ? "" : "+" + detailVO.getSpec()));
                    paramsCheckDsVO.setWarnName(type + "\u5355\u4ef7\u5927\u4e8e\u76ee\u6807\u6210\u672c\u5355\u4ef7");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(type + "\u5355\u4ef7\uff1a").append(price).append("\uff0c\u76ee\u6807\u6210\u672c\u5355\u4ef7:(").append(maxPrice).append("),\u76ee\u6807\u6210\u672c\u5355\u4ef7*").append(roleValueMax).append("%:").append(maxPriceParam).append("\u5143\uff0c\u8d85\u51fa\uff1a").append(ComputeUtil.safeSub((BigDecimal)price, (BigDecimal)maxPriceParam).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
                paramsCheckVOCost.setDataSource(checkDsVOSMax);
                paramsCheckVOS.add(paramsCheckVOCost);
            }
        }
        String[] paramsArr = new String[]{"alert", "warn", "none"};
        HashMap<String, List> map = new HashMap<String, List>();
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArr) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        List sucVoList;
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Long tenantid = InvocationInfoProxy.getTenantid();
        HashMap orgVOMap = new HashMap();
        HashMap<String, ProjectPoolSetVO> projectPoolVoMap = new HashMap<String, ProjectPoolSetVO>();
        HashMap contractPoolVoNoCodeMap = new HashMap();
        HashMap<String, SupplierVO> supplierVOMap = new HashMap<String, SupplierVO>();
        HashMap<String, OrgVO> projectOrgVoMap = new HashMap<String, OrgVO>();
        HashMap<String, EmployeeVO> employeeVOMap = new HashMap<String, EmployeeVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            if (entity == null) continue;
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        if (mf == null) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6587\u4ef6\u4e2d\u6ca1\u6709\u6570\u636e");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<ImportContractVO> successList = new ArrayList<ImportContractVO>();
        ArrayList<ImportContractVO> errorList = new ArrayList<ImportContractVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 20) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            if (result.size() >= 10000) {
                throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc710000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
            }
            Map<Object, Object> defMap = new HashMap();
            HashMap<String, Long> defParamMap = new HashMap<String, Long>();
            defParamMap.put("tenantId", tenantid);
            String defCondition = JSONObject.toJSONString(defParamMap);
            CommonResponse defRes = this.defdocApi.queryDetailListByDefdocCode("tax-invoice-type", defCondition);
            if (defRes.isSuccess() && defRes.getData() != null) {
                List defList = (List)defRes.getData();
                defMap = defList.stream().collect(Collectors.toMap(item -> item.get("name") == null ? "" : item.get("name").toString(), item -> item.get("id") == null ? "" : item.get("id").toString()));
            }
            for (int i = 1; i < result.size(); ++i) {
                Long orgIdP = 0L;
                List datas = (List)result.get(i);
                ImportContractVO detailVO = new ImportContractVO();
                String contractCodeEx = (String)datas.get(0);
                detailVO.setContractCode(contractCodeEx);
                detailVO.setBillCode(contractCodeEx);
                String contractNameEx = (String)datas.get(1);
                detailVO.setContractName(contractNameEx);
                String projectNameEx = (String)datas.get(2);
                detailVO.setProjectName(projectNameEx);
                String contractCategoryName = (String)datas.get(3);
                detailVO.setCategoryName(contractCategoryName);
                detailVO.setContractCategoryName(contractCategoryName);
                String partyaNameEx = (String)datas.get(4);
                detailVO.setPartyaName(partyaNameEx);
                detailVO.setFirstPartyName(partyaNameEx);
                String partyaEmploee = (String)datas.get(5);
                detailVO.setPartyaEmploee(partyaEmploee);
                detailVO.setFirstPartyEmployeeName(partyaEmploee);
                String partyaEmploeePhone = (String)datas.get(6);
                detailVO.setFirstPartyPhone(partyaEmploeePhone);
                detailVO.setPartyaEmploeePhone(partyaEmploeePhone);
                String partybNameEx = (String)datas.get(7);
                detailVO.setPartybName(partybNameEx);
                detailVO.setSupplierEmployeeName(partybNameEx);
                String partybEmploee = (String)datas.get(8);
                detailVO.setPartybEmploee(partybEmploee);
                detailVO.setSupplierEmployeeName(partybEmploee);
                String partybEmploeePhone = (String)datas.get(9);
                detailVO.setPartybEmploeePhone(partybEmploeePhone);
                detailVO.setSupplierPhone(partybEmploeePhone);
                String signDateStrEx = (String)datas.get(10);
                String signPlaceEx = (String)datas.get(11);
                detailVO.setSignAddress(signDateStrEx);
                detailVO.setSignPlace(signPlaceEx);
                String priceTypeName = (String)datas.get(12);
                detailVO.setRentCalculationType(priceTypeName);
                detailVO.setPriceTypeName(priceTypeName);
                String monthSettlementDayStr = (String)datas.get(13);
                detailVO.setMonthSettlementDayStr(monthSettlementDayStr);
                String calcDate = (String)datas.get(14);
                String stopDate = (String)datas.get(15);
                String taxRateEx = (String)datas.get(16);
                detailVO.setTaxRateStr(taxRateEx);
                String contractStatus = (String)datas.get(17);
                detailVO.setContractStatus(contractStatus);
                detailVO.setPerformanceStatus(contractStatus);
                String invoiceType = (String)datas.get(18);
                detailVO.setInvoiceType(invoiceType);
                String memoEx = (String)datas.get(19);
                detailVO.setMemo(memoEx);
                if (StringUtils.isBlank((CharSequence)contractNameEx)) {
                    detailVO.setErrorMessage("\u5408\u540c\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    detailVO.setContractName(contractNameEx);
                }
                detailVO.setBillCode(contractCodeEx);
                detailVO.setContractCode(contractCodeEx);
                if (StringUtils.isBlank((CharSequence)projectNameEx)) {
                    detailVO.setErrorMessage("\u9879\u76ee\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    ProjectPoolSetVO projectPoolSetVOFlag = null;
                    if (MapUtils.isEmpty(projectPoolVoMap) || projectPoolVoMap.get(projectNameEx) == null) {
                        CommonResponse projectVOListRes = this.projectPoolApi.queryProjectListByNameAndTenantId(projectNameEx, tenantid);
                        if (projectVOListRes.isSuccess()) {
                            List projectVOList = (List)projectVOListRes.getData();
                            if (CollectionUtils.isEmpty((Collection)projectVOList)) {
                                detailVO.setErrorMessage("\u6839\u636e\u9879\u76ee\u540d\u79f0\u67e5\u8be2\u4e0d\u5230\u9879\u76ee\u4fe1\u606f");
                            } else if (projectVOList.size() == 1) {
                                ProjectPoolSetVO projectPoolSetVO;
                                projectPoolSetVOFlag = projectPoolSetVO = (ProjectPoolSetVO)projectVOList.get(0);
                                Long orgId = projectPoolSetVO.getOrgId();
                                String orgCode = projectPoolSetVO.getOrgCode();
                                String orgName = projectPoolSetVO.getOrgName();
                                Long projectDepartmentId1 = projectPoolSetVO.getProjectDepartmentId();
                                String projectDepartmentName = projectPoolSetVO.getProjectDepartmentName();
                                String projectDepartmentCode = projectPoolSetVO.getProjectDepartmentCode();
                                detailVO.setOrgId(projectDepartmentId1);
                                detailVO.setOrgCode(projectDepartmentCode);
                                detailVO.setOrgName(projectDepartmentName);
                                detailVO.setParentOrgId(orgId);
                                detailVO.setParentOrgCode(orgCode);
                                detailVO.setParentOrgName(orgName);
                                detailVO.setProjectId(projectPoolSetVO.getId());
                                detailVO.setProjectName(projectPoolSetVO.getName());
                                projectPoolVoMap.put(projectNameEx, projectPoolSetVO);
                            } else {
                                detailVO.setErrorMessage("\u6839\u636e\u9879\u76ee\u540d\u79f0\u67e5\u8be2\u5230\u591a\u4e2a\u9879\u76ee\u4fe1\u606f");
                            }
                        } else {
                            detailVO.setErrorMessage("\u6839\u636e\u9879\u76ee\u540d\u79f0\u67e5\u8be2\u4e0d\u5230\u9879\u76ee\u4fe1\u606f");
                        }
                    } else {
                        ProjectPoolSetVO projectPoolSetVO;
                        projectPoolSetVOFlag = projectPoolSetVO = (ProjectPoolSetVO)projectPoolVoMap.get(projectNameEx);
                        Long orgId = projectPoolSetVO.getOrgId();
                        String orgCode = projectPoolSetVO.getOrgCode();
                        String orgName = projectPoolSetVO.getOrgName();
                        Long projectDepartmentId1 = projectPoolSetVO.getProjectDepartmentId();
                        String projectDepartmentName = projectPoolSetVO.getProjectDepartmentName();
                        String projectDepartmentCode = projectPoolSetVO.getProjectDepartmentCode();
                        detailVO.setOrgId(projectDepartmentId1);
                        detailVO.setOrgCode(projectDepartmentCode);
                        detailVO.setOrgName(projectDepartmentName);
                        detailVO.setParentOrgId(orgId);
                        detailVO.setParentOrgCode(orgCode);
                        detailVO.setParentOrgName(orgName);
                        detailVO.setProjectId(projectPoolSetVO.getId());
                        detailVO.setProjectName(projectPoolSetVO.getName());
                    }
                    if (projectPoolSetVOFlag != null) {
                        OrgVO data;
                        CommonResponse orgVO;
                        Long orgId = projectPoolSetVOFlag.getOrgId();
                        Long projectDepartmentId1 = projectPoolSetVOFlag.getProjectDepartmentId();
                        if (projectOrgVoMap.isEmpty() || projectOrgVoMap.get(String.valueOf(orgId)) == null) {
                            orgVO = this.orgApi.detailById(orgId);
                            if (orgVO.isSuccess()) {
                                data = (OrgVO)orgVO.getData();
                                projectOrgVoMap.put(String.valueOf(orgId), data);
                                if (data == null) {
                                    detailVO.setErrorMessage("\u6839\u636e\u7ec4\u7ec7id\u67e5\u8be2\u4e0d\u5230\u7ec4\u7ec7\u4fe1\u606f");
                                } else {
                                    detailVO.setParentOrgCode(data.getCode());
                                }
                            } else {
                                detailVO.setErrorMessage(orgVO.getMsg());
                            }
                        } else {
                            detailVO.setParentOrgCode(((OrgVO)projectOrgVoMap.get(String.valueOf(orgId))).getCode());
                        }
                        if (projectOrgVoMap.isEmpty() || projectOrgVoMap.get(String.valueOf(projectDepartmentId1)) == null) {
                            orgVO = this.orgApi.detailById(projectDepartmentId1);
                            if (orgVO.isSuccess()) {
                                data = (OrgVO)orgVO.getData();
                                projectOrgVoMap.put(String.valueOf(projectDepartmentId1), data);
                                if (data == null) {
                                    detailVO.setErrorMessage("\u6839\u636e\u7ec4\u7ec7id\u67e5\u8be2\u4e0d\u5230\u7ec4\u7ec7\u4fe1\u606f");
                                } else {
                                    detailVO.setOrgCode(data.getCode());
                                }
                            }
                        } else {
                            detailVO.setOrgCode(((OrgVO)projectOrgVoMap.get(String.valueOf(projectDepartmentId1))).getCode());
                        }
                    } else {
                        detailVO.setErrorMessage("\u6839\u636e\u9879\u76ee\u540d\u79f0\u67e5\u8be2\u4e0d\u5230\u9879\u76ee\u4fe1\u606f");
                    }
                }
                if (StringUtils.isBlank((CharSequence)contractCategoryName)) {
                    detailVO.setErrorMessage("\u5408\u540c\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
                } else if (!contractCategoryName.equals("\u5468\u8f6c\u6750\u79df\u8d41")) {
                    detailVO.setErrorMessage("\u5408\u540c\u7c7b\u522b\u53ea\u80fd\u662f\u5468\u8f6c\u6750\u79df\u8d41");
                } else {
                    detailVO.setContractCategoryName("\u5468\u8f6c\u6750\u79df\u8d41");
                    detailVO.setCategoryName("\u5468\u8f6c\u6750\u79df\u8d41");
                    detailVO.setContractCategoryId(Long.valueOf(1912683813876535298L));
                }
                if (StringUtils.isBlank((CharSequence)partyaNameEx)) {
                    detailVO.setErrorMessage("\u5408\u540c\u7532\u65b9\u4e0d\u53ef\u4e3a\u7a7a");
                } else if (MapUtils.isEmpty(supplierVOMap) || supplierVOMap.get(partyaNameEx) == null) {
                    CommonResponse orgVORes = this.shareSupplierApi.findOneByName(partyaNameEx, tenantid);
                    if (orgVORes.isSuccess()) {
                        SupplierVO orgVO = (SupplierVO)orgVORes.getData();
                        if (orgVO == null) {
                            detailVO.setErrorMessage("\u6839\u636e\u5408\u540c\u7532\u65b9\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                        } else {
                            supplierVOMap.put(partyaNameEx, orgVO);
                            detailVO.setPartyaId(orgVO.getId());
                            detailVO.setPartyaName(orgVO.getName());
                            detailVO.setFirstPartyId(orgVO.getId());
                            detailVO.setFirstPartyName(orgVO.getName());
                        }
                    } else {
                        detailVO.setErrorMessage("\u6839\u636e\u5408\u540c\u7532\u65b9\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                    }
                } else {
                    SupplierVO orgVO = (SupplierVO)supplierVOMap.get(partyaNameEx);
                    detailVO.setPartyaId(orgVO.getId());
                    detailVO.setPartyaName(orgVO.getName());
                    detailVO.setFirstPartyId(orgVO.getId());
                    detailVO.setFirstPartyName(orgVO.getName());
                }
                if (StringUtils.isBlank((CharSequence)partyaEmploee)) {
                    detailVO.setErrorMessage("\u5408\u540c\u7532\u65b9\u7ecf\u529e\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
                } else if (MapUtils.isEmpty(employeeVOMap) || employeeVOMap.get(partyaEmploee) == null) {
                    CommonResponse map = this.employeeApi.getEmployeeMapByNames(Collections.singletonList(partyaEmploee));
                    if (map.isSuccess()) {
                        Map data = (Map)map.getData();
                        if (data == null) {
                            detailVO.setErrorMessage("\u6839\u636e\u7532\u65b9\u7ecf\u529e\u4eba\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                        } else {
                            EmployeeVO employeeVO = (EmployeeVO)data.get(partyaEmploee);
                            employeeVOMap.put(partyaEmploee, employeeVO);
                            detailVO.setPartyaEmploee(partyaEmploee);
                            detailVO.setFirstPartyEmployeeId(employeeVO.getId());
                            detailVO.setFirstPartyEmployeeName(employeeVO.getName());
                        }
                    } else {
                        detailVO.setErrorMessage("\u6839\u636e\u7532\u65b9\u7ecf\u529e\u4eba\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                    }
                } else {
                    EmployeeVO employeeVO = (EmployeeVO)employeeVOMap.get(partyaEmploee);
                    detailVO.setPartyaEmploee(partyaEmploee);
                    detailVO.setFirstPartyEmployeeId(employeeVO.getId());
                    detailVO.setFirstPartyEmployeeName(employeeVO.getName());
                }
                if (StringUtils.isBlank((CharSequence)partyaEmploeePhone)) {
                    detailVO.setErrorMessage("\u5408\u540c\u7532\u65b9\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    detailVO.setFirstPartyPhone(partyaEmploeePhone);
                    detailVO.setPartyaEmploeePhone(partyaEmploeePhone);
                }
                if (StringUtils.isBlank((CharSequence)partybNameEx)) {
                    detailVO.setErrorMessage("\u5408\u540c\u4e59\u65b9\u4e0d\u53ef\u4e3a\u7a7a");
                } else if (MapUtils.isEmpty(supplierVOMap) || supplierVOMap.get(partybNameEx) == null) {
                    CommonResponse supplierVORes = this.shareSupplierApi.findOneByName(partybNameEx, tenantid);
                    if (supplierVORes.isSuccess()) {
                        SupplierVO supplierVO = (SupplierVO)supplierVORes.getData();
                        if (supplierVO == null) {
                            detailVO.setErrorMessage("\u6839\u636e\u5408\u540c\u4e59\u65b9\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                        } else {
                            supplierVOMap.put(partybNameEx, supplierVO);
                            detailVO.setPartybId(supplierVO.getId());
                            detailVO.setPartybName(supplierVO.getName());
                            detailVO.setSupplierId(supplierVO.getId());
                            detailVO.setSupplierName(supplierVO.getName());
                        }
                    } else {
                        detailVO.setErrorMessage("\u6839\u636e\u5408\u540c\u4e59\u65b9\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                    }
                } else {
                    SupplierVO supplierVO = (SupplierVO)supplierVOMap.get(partybNameEx);
                    detailVO.setPartybId(supplierVO.getId());
                    detailVO.setPartybName(supplierVO.getName());
                    detailVO.setSupplierId(supplierVO.getId());
                    detailVO.setSupplierName(supplierVO.getName());
                }
                if (StringUtils.isBlank((CharSequence)partybEmploee)) {
                    detailVO.setErrorMessage("\u5408\u540c\u4e59\u65b9\u7ecf\u529e\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    detailVO.setSupplierEmployeeName(partybEmploee);
                    detailVO.setPartybEmploee(partybEmploee);
                }
                if (StringUtils.isBlank((CharSequence)partybEmploeePhone)) {
                    detailVO.setErrorMessage("\u5408\u540c\u4e59\u65b9\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    detailVO.setPartybEmploeePhone(partybEmploeePhone);
                    detailVO.setSupplierPhone(partybEmploeePhone);
                }
                if (StringUtils.isBlank((CharSequence)signDateStrEx)) {
                    detailVO.setErrorMessage("\u7b7e\u8ba2\u65e5\u671f\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    try {
                        detailVO.setSignDate(HSSFDateUtil.getJavaDate((double)Double.parseDouble(signDateStrEx)));
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u7b7e\u8ba2\u65e5\u671f\u586b\u5199\u4e0d\u6b63\u786e");
                    }
                }
                detailVO.setSignPlace(signPlaceEx);
                detailVO.setSignAddress(signPlaceEx);
                if (StringUtils.isBlank((CharSequence)priceTypeName)) {
                    detailVO.setErrorMessage("\u8ba1\u79df\u65b9\u5f0f\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    String[] value = priceTypeName.split(",");
                    StringBuilder res = new StringBuilder();
                    for (String var13 : value) {
                        if (var13.equals("\u65e5\u79df")) {
                            res.append("0,");
                            continue;
                        }
                        if (var13.equals("\u6708\u79df")) {
                            res.append("1,");
                            continue;
                        }
                        if (var13.equals("\u5de5\u7a0b\u91cf\u79df")) {
                            res.append("2,");
                            continue;
                        }
                        detailVO.setErrorMessage("\u8ba1\u79df\u65b9\u5f0f\u586b\u5199\u4e0d\u6b63\u786e");
                        break;
                    }
                    if (res.length() > 0 && res.charAt(res.length() - 1) == ',') {
                        res.setLength(res.length() - 1);
                    }
                    detailVO.setRentCalculationType(res.toString());
                }
                if (StringUtils.isBlank((CharSequence)monthSettlementDayStr) && StringUtils.isNotBlank((CharSequence)priceTypeName) && priceTypeName.contains("\u6708\u79df")) {
                    detailVO.setErrorMessage("\u6708\u7ed3\u7b97\u65e5\u4e0d\u53ef\u4e3a\u7a7a");
                } else if (StringUtils.isNotBlank((CharSequence)priceTypeName) && priceTypeName.contains("\u6708\u79df")) {
                    if (!monthSettlementDayStr.equals("\u6700\u540e\u4e00\u5929")) {
                        try {
                            detailVO.setMonthSettlementDay(Integer.valueOf(Integer.parseInt(monthSettlementDayStr.substring(0, monthSettlementDayStr.length() - 1))));
                        }
                        catch (Exception e) {
                            detailVO.setErrorMessage("\u6708\u7ed3\u7b97\u65e5\u586b\u5199\u4e0d\u6b63\u786e");
                        }
                    } else if (monthSettlementDayStr.equals("\u6700\u540e\u4e00\u5929")) {
                        detailVO.setMonthSettlementDay(Integer.valueOf(30));
                    } else {
                        detailVO.setErrorMessage("\u6708\u7ed3\u7b97\u65e5\u586b\u5199\u4e0d\u6b63\u786e");
                    }
                }
                if (StringUtils.isBlank((CharSequence)calcDate)) {
                    detailVO.setErrorMessage("\u8ba1\u79df\u65e5\u671f\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    try {
                        detailVO.setRentCalculationDate(HSSFDateUtil.getJavaDate((double)Double.parseDouble(calcDate)));
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u8ba1\u79df\u65e5\u671f\u586b\u5199\u4e0d\u6b63\u786e");
                    }
                }
                if (StringUtils.isBlank((CharSequence)stopDate)) {
                    detailVO.setErrorMessage("\u6b62\u79df\u65e5\u671f\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    try {
                        detailVO.setEndRentCalculationDate(HSSFDateUtil.getJavaDate((double)Double.parseDouble(stopDate)));
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u6b62\u79df\u65e5\u671f\u586b\u5199\u4e0d\u6b63\u786e");
                    }
                }
                if (StringUtils.isBlank((CharSequence)taxRateEx)) {
                    detailVO.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    try {
                        BigDecimal taxRate = new BigDecimal(taxRateEx);
                        if (taxRate.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u5c0f\u4e8e0");
                        } else {
                            detailVO.setTaxRate(taxRate);
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (StringUtils.isBlank((CharSequence)contractStatus) && StringUtils.isNotBlank((CharSequence)priceTypeName) && priceTypeName.contains("\u6708\u79df")) {
                    detailVO.setErrorMessage("\u5408\u540c\u5c65\u7ea6\u72b6\u6001\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    if (StringUtils.isBlank((CharSequence)contractStatus)) {
                        detailVO.setPerformanceStatus(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode());
                    }
                    if (PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getDescription().equals(contractStatus)) {
                        detailVO.setPerformanceStatus(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode());
                    } else if (PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getDescription().equals(contractStatus)) {
                        detailVO.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                    } else if (PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getDescription().equals(contractStatus)) {
                        detailVO.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getCode());
                    } else if (PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getDescription().equals(contractStatus)) {
                        detailVO.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode());
                    } else if (PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getDescription().equals(contractStatus)) {
                        detailVO.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode());
                    } else {
                        detailVO.setErrorMessage("\u5408\u540c\u5c65\u7ea6\u72b6\u6001\u586b\u5199\u4e0d\u6b63\u786e");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)invoiceType)) {
                    String invoiceTypeIdStr = (String)defMap.get(invoiceType);
                    Long invoiceTypeId = null;
                    if (StringUtils.isNotBlank((CharSequence)invoiceTypeIdStr)) {
                        invoiceTypeId = Long.parseLong(invoiceTypeIdStr);
                        detailVO.setInvoiceTypeId(invoiceTypeId);
                        detailVO.setInvoiceTypeName(invoiceType);
                    } else {
                        detailVO.setErrorMessage("\u53d1\u7968\u7c7b\u578b\u586b\u5199\u4e0d\u6b63\u786e");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)memoEx) && memoEx.length() > 100) {
                    detailVO.setErrorMessage("\u5907\u6ce8\u957f\u5ea6\u4e0d\u53ef\u5927\u4e8e100");
                } else {
                    detailVO.setMemo(memoEx);
                }
                if (StringUtils.isBlank((CharSequence)detailVO.getErrorMessage())) {
                    detailVO.setHandleType(Integer.valueOf(1));
                    detailVO.setHandleTypeName("\u662f");
                    successList.add(detailVO);
                } else {
                    errorList.add(detailVO);
                }
                detailVO.setSupplementFlag(Integer.valueOf(0));
                detailVO.setSupplementFlagName("\u5426");
                detailVO.setFilingStatus(Integer.valueOf(0));
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        Date createTime = new Date();
        UserContext userContext = this.sessionManager.getUserContext();
        String userCode = "";
        if (userContext != null) {
            userCode = userContext.getUserCode();
        }
        if (CollectionUtils.isNotEmpty((Collection)(sucVoList = BeanMapper.mapList(successList, ContractVO.class)))) {
            for (ContractVO vo : sucVoList) {
                vo.setCreateTime(createTime);
                vo.setCreateUserCode(userCode);
                long contractId = IdWorker.getId();
                if (!StringUtils.isBlank((CharSequence)vo.getBillCode())) continue;
                String contractBillCode = this.getContractBillCode(vo);
                vo.setBillCode(contractBillCode);
            }
            List sucEntityList = BeanMapper.mapList((Iterable)sucVoList, ContractEntity.class);
            this.saveOrUpdateBatch(sucEntityList, sucEntityList.size(), false);
        }
        return CommonResponse.success((Object)json);
    }
}

