/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.rmat.bean.NeedPlanDetailEntity;
import com.ejianc.business.pro.rmat.bean.NeedPlanEntity;
import com.ejianc.business.pro.rmat.mapper.NeedPlanMapper;
import com.ejianc.business.pro.rmat.service.INeedPlanService;
import com.ejianc.business.pro.rmat.vo.NeedPlanDetailRefVO;
import com.ejianc.business.pro.rmat.vo.NeedPlanVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="needPlanService")
public class NeedPlanServiceImpl
extends BaseServiceImpl<NeedPlanMapper, NeedPlanEntity>
implements INeedPlanService {
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "PRORMAT_NEED_PLAN_01";

    @Override
    public CommonResponse<NeedPlanVO> saveOrUpdate(NeedPlanVO saveOrUpdateVO) {
        NeedPlanEntity entity = (NeedPlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, NeedPlanEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        List<NeedPlanDetailEntity> planDetailList = entity.getPlanDetailList();
        String materialName = "";
        if (CollectionUtils.isNotEmpty(planDetailList)) {
            ArrayList<NeedPlanDetailEntity> list = new ArrayList<NeedPlanDetailEntity>();
            for (NeedPlanDetailEntity planDetail : planDetailList) {
                if (!"del".equals(planDetail.getRowState())) {
                    if (StringUtils.isNotBlank((CharSequence)planDetail.getMaterialName())) {
                        materialName = StringUtils.isNotBlank((CharSequence)materialName) ? materialName + "," + planDetail.getMaterialName() : planDetail.getMaterialName();
                    }
                    list.add(planDetail);
                }
                BigDecimal nums = planDetail.getNums() == null ? BigDecimal.ZERO : planDetail.getNums();
                BigDecimal occupyNums = planDetail.getOccupyNums() == null ? BigDecimal.ZERO : planDetail.getOccupyNums();
                BigDecimal surplusNums = nums.subtract(occupyNums);
                planDetail.setSurplusNums(surplusNums);
                planDetail.setOccupyNums(occupyNums);
                planDetail.setNums(nums);
            }
            Integer planFlag = entity.getPlanFlag() == null ? 1 : entity.getPlanFlag();
            entity.setPlanFlag(planFlag);
            entity.setMaterialName(materialName);
            if (CollectionUtils.isEmpty(list)) {
                throw new BusinessException("\u6700\u5c11\u6709\u4e00\u6761\u8ba1\u5212\u660e\u7ec6\uff01");
            }
        } else {
            throw new BusinessException("\u6700\u5c11\u6709\u4e00\u6761\u8ba1\u5212\u660e\u7ec6\uff01");
        }
        super.saveOrUpdate((Object)entity, false);
        NeedPlanVO vo = (NeedPlanVO)BeanMapper.map((Object)((Object)entity), NeedPlanVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public List<NeedPlanDetailRefVO> getPlanByMaterialId(List<Long> materialListId, QueryWrapper wrapper) {
        List<NeedPlanDetailRefVO> planVOList = ((NeedPlanMapper)this.baseMapper).getPlanByMaterialId(materialListId, wrapper);
        return planVOList;
    }
}

