/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.rmat.bean.ContractDailyRentEntity;
import com.ejianc.business.pro.rmat.bean.ContractEntity;
import com.ejianc.business.pro.rmat.bean.ContractMonthRentEntity;
import com.ejianc.business.pro.rmat.bean.RecordDailyRentEntity;
import com.ejianc.business.pro.rmat.bean.RecordEntity;
import com.ejianc.business.pro.rmat.bean.RecordMonthRentEntity;
import com.ejianc.business.pro.rmat.bean.RentCalculateDailyEntity;
import com.ejianc.business.pro.rmat.bean.RentCalculateEntity;
import com.ejianc.business.pro.rmat.bean.RentCalculateMonthEntity;
import com.ejianc.business.pro.rmat.bean.RentCalculateNumEntity;
import com.ejianc.business.pro.rmat.enums.BillTypeEnum;
import com.ejianc.business.pro.rmat.enums.MaterialStateEnum;
import com.ejianc.business.pro.rmat.mapper.RentCalculateMapper;
import com.ejianc.business.pro.rmat.service.IContractService;
import com.ejianc.business.pro.rmat.service.IMaterialService;
import com.ejianc.business.pro.rmat.service.IRecordDailyRentService;
import com.ejianc.business.pro.rmat.service.IRecordMonthRentService;
import com.ejianc.business.pro.rmat.service.IRecordService;
import com.ejianc.business.pro.rmat.service.IRentCalculateService;
import com.ejianc.business.pro.rmat.utils.DateUtil;
import com.ejianc.business.pro.rmat.utils.DetailListUtil;
import com.ejianc.business.pro.rmat.utils.ValidateUtil;
import com.ejianc.business.pro.rmat.vo.MaterialFlowVO;
import com.ejianc.business.pro.rmat.vo.RecordDailyRentVO;
import com.ejianc.business.pro.rmat.vo.RecordMonthRentVO;
import com.ejianc.business.pro.rmat.vo.RentCalculateCacheVO;
import com.ejianc.business.pro.rmat.vo.RentCalculateDailyVO;
import com.ejianc.business.pro.rmat.vo.RentCalculateMonthVO;
import com.ejianc.business.pro.rmat.vo.RentCalculateNumVO;
import com.ejianc.business.pro.rmat.vo.RentCalculateVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rentCalculateService")
public class RentCalculateServiceImpl
extends BaseServiceImpl<RentCalculateMapper, RentCalculateEntity>
implements IRentCalculateService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IRecordService recordService;
    @Autowired
    private IRecordDailyRentService dailyRecordService;
    @Autowired
    private IRecordMonthRentService monthRecordService;
    @Autowired
    private IExecutionApi executionApi;
    private static final String BILL_CODE = "PRO_RMAT_RENT_CALCULATE";
    private static final String BILL_NAME = BillTypeEnum.\u79df\u91d1\u8ba1\u7b97\u5355.getName();
    private static final String RENT_TYPE_DAY = "0";
    private static final String RENT_TYPE_MONTH = "1";

    @Override
    public RentCalculateVO saveOrUpdate(RentCalculateVO saveOrUpdateVO) {
        this.materialService.validateContract(saveOrUpdateVO.getContractId(), BILL_NAME, saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        this.validateTime(saveOrUpdateVO, "\u4fdd\u5b58");
        RentCalculateEntity entity = (RentCalculateEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, RentCalculateEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setRelationFlag(RENT_TYPE_DAY);
        entity.setProportionFlag(RENT_TYPE_DAY);
        super.saveOrUpdate((Object)entity, false);
        this.saveCost(entity, 1);
        return (RentCalculateVO)BeanMapper.map((Object)((Object)entity), RentCalculateVO.class);
    }

    @Override
    public String validateTime(RentCalculateVO rentVO, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contractId", rentVO.getContractId());
        if (rentVO.getId() != null) {
            params.put("billType", BILL_NAME);
            params.put("billId", rentVO.getId());
        }
        Date lastDate = this.materialService.getLastDate(params);
        Map<Date, Date> maxTimeMap = this.materialService.getMaxTime(params);
        if (lastDate == null) {
            return "\u672a\u83b7\u53d6\u6700\u5927\u5355\u636e\u65e5\u671f\uff01";
        }
        if (ValidateUtil.compareDate((Date)rentVO.getRentDate(), (Date)lastDate, maxTimeMap, (Date)rentVO.getCreateTime())) {
            throw new BusinessException(DateUtil.formatDate((Date)rentVO.getRentDate()) + "\u5c0f\u4e8e\u6700\u5927\u5355\u636e\u65e5\u671f\u3010" + DateUtil.formatDate((Date)lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public CommonResponse<RentCalculateVO> pushCost(RentCalculateVO vo) {
        RentCalculateEntity entity = (RentCalculateEntity)((Object)((RentCalculateMapper)this.baseMapper).selectById(vo.getId()));
        if (CollectionUtils.isNotEmpty((Collection)vo.getDailyList())) {
            List dailyList = BeanMapper.mapList((Iterable)vo.getDailyList(), RentCalculateDailyEntity.class);
            entity.setDailyList(dailyList);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getMonthList())) {
            List monthList = BeanMapper.mapList((Iterable)vo.getMonthList(), RentCalculateMonthEntity.class);
            entity.setMonthList(monthList);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getNumList())) {
            List numList = BeanMapper.mapList((Iterable)vo.getNumList(), RentCalculateNumEntity.class);
            entity.setNumList(numList);
        }
        super.saveOrUpdate((Object)entity, false);
        this.costPush(entity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), RentCalculateVO.class));
    }

    @Override
    public void costPush(RentCalculateEntity entity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<RentCalculateDailyEntity> dailyList = entity.getDailyList();
        List<RentCalculateMonthEntity> monthList = entity.getMonthList();
        List<RentCalculateNumEntity> numList = entity.getNumList();
        String relationFlag = RENT_TYPE_MONTH;
        if (CollectionUtils.isNotEmpty(dailyList)) {
            for (RentCalculateDailyEntity rentCalculateDailyEntity : dailyList) {
                if (null != rentCalculateDailyEntity.getSubjectId() && null != rentCalculateDailyEntity.getWbsId()) continue;
                relationFlag = RENT_TYPE_DAY;
                break;
            }
        }
        if (CollectionUtils.isNotEmpty(monthList)) {
            for (RentCalculateMonthEntity rentCalculateMonthEntity : monthList) {
                if (null != rentCalculateMonthEntity.getSubjectId() && null != rentCalculateMonthEntity.getWbsId()) continue;
                relationFlag = RENT_TYPE_DAY;
                break;
            }
        }
        if (CollectionUtils.isNotEmpty(numList)) {
            for (RentCalculateNumEntity rentCalculateNumEntity : numList) {
                if (null != rentCalculateNumEntity.getSubjectId() && null != rentCalculateNumEntity.getWbsId()) continue;
                relationFlag = RENT_TYPE_DAY;
                break;
            }
        }
        if (CollectionUtils.isEmpty(dailyList) && CollectionUtils.isEmpty(monthList) && CollectionUtils.isEmpty(numList)) {
            relationFlag = RENT_TYPE_DAY;
        }
        this.saveCost(entity, 1);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        updateWrapper.set(RentCalculateEntity::getRelationFlag, (Object)relationFlag);
        super.update((Wrapper)updateWrapper);
    }

    private void saveCost(RentCalculateEntity entity, Integer effectiveStatus) {
        List<RentCalculateNumEntity> list;
        List<RentCalculateMonthEntity> monthList;
        ArrayList<CostDetailVO> costVOList = new ArrayList<CostDetailVO>();
        List<RentCalculateDailyEntity> dailyList = entity.getDailyList();
        if (CollectionUtils.isNotEmpty(dailyList)) {
            for (RentCalculateDailyEntity rentCalculateDailyEntity : dailyList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(rentCalculateDailyEntity.getSubjectId());
                costDetailVO.setSubjectCode(rentCalculateDailyEntity.getSubjectCode());
                costDetailVO.setSubjectName(rentCalculateDailyEntity.getSubjectName());
                costDetailVO.setWbsId(rentCalculateDailyEntity.getWbsId());
                costDetailVO.setWbsCode(rentCalculateDailyEntity.getWbsCode());
                costDetailVO.setWbsName(rentCalculateDailyEntity.getWbsName());
                costDetailVO.setSourceId(entity.getId());
                costDetailVO.setSourceDetailId(rentCalculateDailyEntity.getId());
                costDetailVO.setHappenTaxMny(rentCalculateDailyEntity.getDailyRentTaxMny());
                costDetailVO.setHappenMny(rentCalculateDailyEntity.getDailyRentMny());
                costDetailVO.setHappenDate(entity.getRentDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("PRO_RMAT_CALCULATE");
                costDetailVO.setSourceTabType("PRO_RMAT_CALCULATE_DAILY");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVO.setSourceBillCode(entity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u5468\u8f6c\u6750\u79df\u91d1\u8ba1\u7b97\u5355.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-prormat-frontend/#/calculate/card?id=" + entity.getId());
                costVOList.add(costDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(monthList = entity.getMonthList())) {
            for (RentCalculateMonthEntity rentCalculateMonthEntity : monthList) {
                CostDetailVO costVO = new CostDetailVO();
                costVO.setSubjectId(rentCalculateMonthEntity.getSubjectId());
                costVO.setSubjectCode(rentCalculateMonthEntity.getSubjectCode());
                costVO.setSubjectName(rentCalculateMonthEntity.getSubjectName());
                costVO.setWbsId(rentCalculateMonthEntity.getWbsId());
                costVO.setWbsCode(rentCalculateMonthEntity.getWbsCode());
                costVO.setWbsName(rentCalculateMonthEntity.getWbsName());
                costVO.setSourceId(rentCalculateMonthEntity.getRentId());
                costVO.setSourceDetailId(rentCalculateMonthEntity.getId());
                costVO.setHappenTaxMny(rentCalculateMonthEntity.getMonthRentTaxMny());
                costVO.setHappenMny(rentCalculateMonthEntity.getMonthRentMny());
                costVO.setHappenDate(entity.getRentDate());
                costVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costVO.setSourceType("PRO_RMAT_CALCULATE");
                costVO.setSourceTabType("PRO_RMAT_CALCULATE_DAILY");
                costVO.setProjectId(entity.getProjectId());
                costVOList.add(costVO);
            }
        }
        if (CollectionUtils.isNotEmpty(list = entity.getNumList())) {
            for (RentCalculateNumEntity detail : list) {
                CostDetailVO costVO = new CostDetailVO();
                costVO.setSubjectId(detail.getSubjectId());
                costVO.setSubjectCode(detail.getSubjectCode());
                costVO.setSubjectName(detail.getSubjectName());
                costVO.setWbsId(detail.getWbsId());
                costVO.setWbsCode(detail.getWbsCode());
                costVO.setWbsName(detail.getWbsName());
                costVO.setSourceId(detail.getRentId());
                costVO.setSourceDetailId(detail.getId());
                costVO.setHappenTaxMny(detail.getNumRentTaxMny());
                costVO.setHappenMny(detail.getNumRentMny());
                costVO.setHappenDate(entity.getRentDate());
                costVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costVO.setSourceType("PRO_RMAT_CALCULATE");
                costVO.setSourceTabType("PRO_RMAT_CALCULATE_DAILY");
                costVO.setProjectId(entity.getProjectId());
                costVOList.add(costVO);
            }
        }
        if (ListUtil.isNotEmpty(costVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costVOList));
            CommonResponse commonResponse = this.costDetailApi.saveSubject(costVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)commonResponse));
            if (!commonResponse.isSuccess()) {
                throw new BusinessException(commonResponse.getMsg());
            }
        }
    }

    @Override
    public void pullCost(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)id);
        updateWrapper.set(RentCalculateEntity::getRelationFlag, (Object)RENT_TYPE_DAY);
        super.update((Wrapper)updateWrapper);
        this.costDetailApi.deleteSubject(id);
    }

    @Override
    public RentCalculateVO automaticRental(RentCalculateVO vo) {
        List checkList;
        if (vo == null || vo.getContractId() == null) {
            throw new BusinessException("\u5408\u540c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (vo.getRentDate() == null) {
            throw new BusinessException("\u79df\u91d1\u8ba1\u7b97\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long contractId = vo.getContractId();
        Date endDate = DateUtil.concatDate((Date)vo.getRentDate(), (Date)new Date());
        this.logger.info("\u5f00\u59cb\u79df\u91d1\u81ea\u52a8\u8ba1\u7b97\uff0c\u5408\u540cid\uff1a{}\uff0c\u79df\u91d1\u8ba1\u7b97\u65e5\u671f\uff1a{}\u3002>>>>>>>>>>>>>>>>>>>>>>>>>>", (Object)contractId, (Object)endDate);
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("billState", new Parameter("not_in", (Object)"1,3"));
        if (null != vo.getId()) {
            param.getParams().put("id", new Parameter("ne", (Object)vo.getId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(checkList = super.queryList(param, false)))) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u79df\u91d1\u8ba1\u7b97\u5355");
        }
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getOrderMap().put("rentDate", "desc");
        List lastList = super.queryList(param, false);
        Date startDate = null;
        if (CollectionUtils.isNotEmpty((Collection)lastList)) {
            RentCalculateEntity last = (RentCalculateEntity)((Object)lastList.get(0));
            startDate = DateUtil.concatDate((Date)DateUtil.dayAddOne((Date)last.getRentDate()), (Date)last.getCreateTime());
        }
        this.logger.info(">>>>\u67e5\u8be2\u5df2\u5165\u573a\u7269\u6599\u4fe1\u606fstart");
        List<com.ejianc.business.pro.rmat.vo.MaterialVO> reportList = this.materialService.queryCalculateList(contractId, startDate, endDate);
        if (CollectionUtils.isEmpty(reportList)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u5408\u540c\u4e0b\u7269\u6599\u5165\u573a\u4fe1\u606f");
        }
        this.logger.info("<<<<\u67e5\u8be2\u5df2\u5165\u573a\u53f0\u8d26\u4fe1\u606fend\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(reportList));
        this.logger.info(">>>>\u67e5\u8be2\u5408\u540c\u4fe1\u606fstart");
        ContractEntity contract = (ContractEntity)((Object)DetailListUtil.selectById(contractId, this.contractService));
        this.logger.info("\u4e3b\u5408\u540c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)contract)));
        Map<String, Map<Long, List<RentCalculateCacheVO>>> contractAllMap = this.getContractRecord(contract, endDate);
        this.logger.info(">>>>\u5bf9\u67e5\u8be2\u6570\u636e\u8fdb\u884c\u64cd\u4f5c");
        RentCalculateEntity entity = new RentCalculateEntity();
        ArrayList<RentCalculateDailyEntity> dailyList = new ArrayList<RentCalculateDailyEntity>();
        ArrayList<RentCalculateMonthEntity> monthList = new ArrayList<RentCalculateMonthEntity>();
        ArrayList<RentCalculateCacheVO> dailyVOList = new ArrayList<RentCalculateCacheVO>();
        ArrayList<RentCalculateCacheVO> monthVOList = new ArrayList<RentCalculateCacheVO>();
        for (com.ejianc.business.pro.rmat.vo.MaterialVO materialVO : reportList) {
            if (RENT_TYPE_DAY.equals(materialVO.getRentCalculationType())) {
                this.packParameterDetailAndContract(dailyVOList, contractAllMap, materialVO, RENT_TYPE_DAY, contract.getMonthSettlementDay());
                continue;
            }
            if (!RENT_TYPE_MONTH.equals(materialVO.getRentCalculationType())) continue;
            this.packParameterDetailAndContract(monthVOList, contractAllMap, materialVO, RENT_TYPE_MONTH, contract.getMonthSettlementDay());
        }
        Set ids = reportList.stream().map(com.ejianc.business.pro.rmat.vo.MaterialVO::getMaterialId).collect(Collectors.toSet());
        CommonResponse resp = this.materialApi.queryMaterialByIds(new ArrayList(ids));
        Map<Long, Object> materialMap = new HashMap<Long, MaterialVO>();
        if (resp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)resp.getData()))) {
            materialMap = ((List)resp.getData()).stream().collect(Collectors.toMap(MaterialVO::getId, Function.identity()));
        }
        this.setRentalDayDetailValue(dailyVOList, dailyList, materialMap);
        this.setRentalMonthDetailValue(monthVOList, monthList, materialMap);
        entity.setDailyList(dailyList);
        entity.setMonthList(monthList);
        this.setRentalValue(entity, contract, endDate);
        this.logger.info(">>>>\u79df\u91d1\u81ea\u52a8\u8ba1\u7b97\u7ed3\u675f\uff0c\u8f93\u51fa\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
        return (RentCalculateVO)BeanMapper.map((Object)((Object)entity), RentCalculateVO.class);
    }

    @Override
    public void delById(Long id) {
        CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(id);
        this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        Boolean flag = ((RentCalculateMapper)this.baseMapper).delById(id);
        if (Boolean.FALSE.equals(flag)) {
            throw new BusinessException("\u5220\u9664\u5931\u8d25!");
        }
    }

    @Override
    public ParamsCheckVO checkParams(RentCalculateVO vo) {
        CommonResponse costResponse;
        ParamsCheckVO costRes;
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        CostCtrlVO costCtrlVO = this.sjCost(vo);
        if (null != costCtrlVO && null != (costRes = (ParamsCheckVO)(costResponse = this.executionApi.ctrlCost(costCtrlVO)).getData())) {
            paramsCheckVOS.add(costRes);
        }
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    public CostCtrlVO sjCost(RentCalculateVO vo) {
        List numRentList;
        List monthRentList;
        HashMap<Long, CostCtrlDetailVO> map = new HashMap<Long, CostCtrlDetailVO>();
        List dailyRentList = vo.getDailyList();
        if (CollectionUtils.isNotEmpty((Collection)dailyRentList)) {
            for (RentCalculateDailyVO dailyRent : dailyRentList) {
                CostCtrlDetailVO costCtrlDetailVO;
                BigDecimal dailyRenTaxMny;
                if (null == dailyRent.getSubjectId() || "del".equals(dailyRent.getRowState())) continue;
                BigDecimal dailyRenMny = dailyRent.getDailyRentMny() == null ? BigDecimal.ZERO : dailyRent.getDailyRentMny();
                BigDecimal bigDecimal = dailyRenTaxMny = dailyRent.getDailyRentTaxMny() == null ? BigDecimal.ZERO : dailyRent.getDailyRentTaxMny();
                if (map.containsKey(dailyRent.getSubjectId())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(dailyRent.getSubjectId());
                    BigDecimal mny = costCtrlDetailVO.getMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getMny();
                    BigDecimal taxMny = costCtrlDetailVO.getTaxMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getTaxMny();
                    costCtrlDetailVO.setMny(mny.add(dailyRenMny));
                    costCtrlDetailVO.setTaxMny(taxMny.add(dailyRenTaxMny));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(dailyRent.getSubjectId());
                costCtrlDetailVO.setMny(dailyRenMny);
                costCtrlDetailVO.setTaxMny(dailyRenTaxMny);
                map.put(dailyRent.getSubjectId(), costCtrlDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(monthRentList = vo.getMonthList()))) {
            for (RentCalculateMonthVO dailyRent : monthRentList) {
                CostCtrlDetailVO costCtrlDetailVO;
                BigDecimal dailyRenTaxMny;
                if (null == dailyRent.getSubjectId() || "del".equals(dailyRent.getRowState())) continue;
                BigDecimal dailyRenMny = dailyRent.getMonthRentMny() == null ? BigDecimal.ZERO : dailyRent.getMonthRentMny();
                BigDecimal bigDecimal = dailyRenTaxMny = dailyRent.getMonthRentTaxMny() == null ? BigDecimal.ZERO : dailyRent.getMonthRentTaxMny();
                if (map.containsKey(dailyRent.getSubjectId())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(dailyRent.getSubjectId());
                    BigDecimal mny = costCtrlDetailVO.getMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getMny();
                    BigDecimal taxMny = costCtrlDetailVO.getTaxMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getTaxMny();
                    costCtrlDetailVO.setMny(mny.add(dailyRenMny));
                    costCtrlDetailVO.setTaxMny(taxMny.add(dailyRenTaxMny));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(dailyRent.getSubjectId());
                costCtrlDetailVO.setMny(dailyRenMny);
                costCtrlDetailVO.setTaxMny(dailyRenTaxMny);
                map.put(dailyRent.getSubjectId(), costCtrlDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(numRentList = vo.getNumList()))) {
            for (RentCalculateNumVO dailyRent : numRentList) {
                CostCtrlDetailVO costCtrlDetailVO;
                BigDecimal dailyRenTaxMny;
                if (null == dailyRent.getSubjectId() || "del".equals(dailyRent.getRowState())) continue;
                BigDecimal dailyRenMny = dailyRent.getNumRentMny() == null ? BigDecimal.ZERO : dailyRent.getNumRentMny();
                BigDecimal bigDecimal = dailyRenTaxMny = dailyRent.getNumRentTaxMny() == null ? BigDecimal.ZERO : dailyRent.getNumRentTaxMny();
                if (map.containsKey(dailyRent.getSubjectId())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(dailyRent.getSubjectId());
                    BigDecimal mny = costCtrlDetailVO.getMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getMny();
                    BigDecimal taxMny = costCtrlDetailVO.getTaxMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getTaxMny();
                    costCtrlDetailVO.setMny(mny.add(dailyRenMny));
                    costCtrlDetailVO.setTaxMny(taxMny.add(dailyRenTaxMny));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(dailyRent.getSubjectId());
                costCtrlDetailVO.setMny(dailyRenMny);
                costCtrlDetailVO.setTaxMny(dailyRenTaxMny);
                map.put(dailyRent.getSubjectId(), costCtrlDetailVO);
            }
        }
        if (null != map && map.size() > 0) {
            CostCtrlVO ctrlVO = new CostCtrlVO();
            if (null != vo.getId()) {
                ctrlVO.setSourceId(vo.getId());
            }
            ctrlVO.setOrgId(vo.getOrgId());
            ctrlVO.setProjectId(vo.getProjectId());
            ctrlVO.setDetailList(new ArrayList(map.values()));
            return ctrlVO;
        }
        return null;
    }

    private void setRentalDayDetailValue(List<RentCalculateCacheVO> resultList, List<RentCalculateDailyEntity> dailyList, Map<Long, MaterialVO> materialMap) {
        if (CollectionUtils.isEmpty(resultList)) {
            return;
        }
        for (RentCalculateCacheVO vo : resultList) {
            RecordDailyRentVO recordVO = vo.getDailyRecord();
            RentCalculateDailyEntity entity = new RentCalculateDailyEntity();
            entity.setSourceId(recordVO.getSourceBid());
            entity.setMaterialTypeId(recordVO.getMaterialTypeId());
            entity.setMaterialTypeName(recordVO.getMaterialTypeName());
            entity.setMaterialId(recordVO.getMaterialId());
            entity.setMaterialCode(recordVO.getMaterialCode());
            entity.setMaterialName(recordVO.getMaterialName());
            entity.setSpec(recordVO.getSpec());
            entity.setUnitId(recordVO.getUnitId());
            entity.setUnitName(recordVO.getUnitName());
            entity.setUnitTaxPrice(recordVO.getUnitTaxPrice());
            entity.setUnitPrice(recordVO.getUnitPrice());
            entity.setStopUnitTaxPrice(recordVO.getStopUnitTaxPrice());
            entity.setStopUnitPrice(recordVO.getStopUnitPrice());
            entity.setTaxRate(recordVO.getTaxRate());
            entity.setContractDetailId(vo.getContractDetailId());
            entity.setStartDate(vo.getStartDate());
            entity.setEndDate(vo.getEndDate());
            entity.setNum(vo.getNum());
            entity.setUseStatus(String.valueOf(vo.getMaterialState() - 2));
            entity.setRentDayDate(DateUtil.getSubDay((Date)vo.getEndDate(), (Date)vo.getStartDate()));
            if (MaterialStateEnum.\u542f\u7528.getCode().equals(vo.getMaterialState())) {
                entity.setDailyRentMny(this.getMny(entity.getUnitPrice(), entity.getRentDayDate(), entity.getNum()));
                entity.setDailyRentTaxMny(this.getMny(entity.getUnitTaxPrice(), entity.getRentDayDate(), entity.getNum()));
            } else if (MaterialStateEnum.\u505c\u7528.getCode().equals(vo.getMaterialState())) {
                entity.setDailyRentMny(this.getMny(entity.getStopUnitPrice(), entity.getRentDayDate(), entity.getNum()));
                entity.setDailyRentTaxMny(this.getMny(entity.getStopUnitTaxPrice(), entity.getRentDayDate(), entity.getNum()));
            }
            entity.setDailyTax(ComputeUtil.safeSub((BigDecimal)entity.getDailyRentTaxMny(), (BigDecimal)entity.getDailyRentMny()));
            if (materialMap.containsKey(entity.getMaterialId())) {
                MaterialVO material = materialMap.get(entity.getMaterialId());
                entity.setSubjectId(material.getSubjectId());
                entity.setSubjectName(material.getSubjectName());
            }
            entity.setId(IdWorker.getId());
            entity.setRowState("add");
            dailyList.add(entity);
        }
        if (CollectionUtils.isNotEmpty(dailyList)) {
            dailyList.sort(Comparator.comparing(RentCalculateDailyEntity::getContractDetailId).thenComparing(RentCalculateDailyEntity::getStartDate));
        }
    }

    private void setRentalMonthDetailValue(List<RentCalculateCacheVO> resultList, List<RentCalculateMonthEntity> monthList, Map<Long, MaterialVO> materialMap) {
        if (CollectionUtils.isEmpty(resultList)) {
            return;
        }
        ArrayList<RentCalculateMonthEntity> rstList = new ArrayList<RentCalculateMonthEntity>();
        for (RentCalculateCacheVO vo : resultList) {
            RecordMonthRentVO recordVO = vo.getMonthRecord();
            RentCalculateMonthEntity entity = new RentCalculateMonthEntity();
            entity.setSourceId(recordVO.getSourceBid());
            entity.setMaterialTypeId(recordVO.getMaterialTypeId());
            entity.setMaterialTypeName(recordVO.getMaterialTypeName());
            entity.setMaterialId(recordVO.getMaterialId());
            entity.setMaterialCode(recordVO.getMaterialCode());
            entity.setMaterialName(recordVO.getMaterialName());
            entity.setContractDetailId(vo.getContractDetailId());
            entity.setSpec(recordVO.getSpec());
            entity.setUnitId(recordVO.getUnitId());
            entity.setUnitName(recordVO.getUnitName());
            entity.setUnitTaxPrice(recordVO.getUnitTaxPrice());
            entity.setUnitPrice(recordVO.getUnitPrice());
            entity.setLackMonthDayUnitTaxPrice(recordVO.getLackMonthDayUnitTaxPrice());
            entity.setLackMonthDayUnitPrice(recordVO.getLackMonthDayUnitPrice());
            entity.setStopUnitTaxPrice(recordVO.getStopUnitTaxPrice());
            entity.setStopUnitPrice(recordVO.getStopUnitPrice());
            entity.setTaxRate(recordVO.getTaxRate());
            entity.setStartDate(vo.getStartDate());
            entity.setEndDate(vo.getEndDate());
            entity.setNum(vo.getNum());
            entity.setUseStatus(String.valueOf(vo.getMaterialState() - 2));
            if (MaterialStateEnum.\u505c\u7528.getCode().equals(vo.getMaterialState())) {
                Integer days = DateUtil.getSubDay((Date)vo.getEndDate(), (Date)vo.getStartDate());
                entity.setMonthRentMny(this.getMny(entity.getStopUnitPrice(), days, entity.getNum()));
                entity.setMonthRentTaxMny(this.getMny(entity.getStopUnitTaxPrice(), days, entity.getNum()));
                entity.setRentDayDate(days);
                entity.setRentMonthDate(0);
            } else {
                this.monthSum(entity, vo);
            }
            entity.setMonthTax(ComputeUtil.safeSub((BigDecimal)entity.getMonthRentTaxMny(), (BigDecimal)entity.getMonthRentMny()));
            if (materialMap.containsKey(entity.getMaterialId())) {
                MaterialVO material = materialMap.get(entity.getMaterialId());
                entity.setSubjectId(material.getSubjectId());
                entity.setSubjectName(material.getSubjectName());
            }
            entity.setId(IdWorker.getId());
            entity.setRowState("add");
            rstList.add(entity);
        }
        rstList.sort(Comparator.comparing(RentCalculateMonthEntity::getStartDate));
        this.logger.info("\u5408\u5e76\u524d\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(rstList));
        monthList.addAll(rstList);
        if (CollectionUtils.isNotEmpty(monthList)) {
            monthList.sort(Comparator.comparing(RentCalculateMonthEntity::getContractDetailId).thenComparing(RentCalculateMonthEntity::getStartDate));
        }
    }

    private void monthSum(RentCalculateMonthEntity entity, RentCalculateCacheVO vo) {
        Date startDate = entity.getStartDate();
        int[] mo = DateUtil.dayCompare((Date)startDate, (Date)entity.getEndDate());
        int month = mo[0];
        int day = mo[1];
        BigDecimal num = entity.getNum();
        BigDecimal monthMny = this.getMny(entity.getUnitPrice(), month, num);
        BigDecimal monthTaxMny = this.getMny(entity.getUnitTaxPrice(), month, num);
        BigDecimal dayMny = this.getMny(entity.getLackMonthDayUnitPrice(), day, num);
        BigDecimal dayTaxMny = this.getMny(entity.getLackMonthDayUnitTaxPrice(), day, num);
        entity.setMonthRentMny(ComputeUtil.safeAdd((BigDecimal)monthMny, (BigDecimal)dayMny));
        entity.setMonthRentTaxMny(ComputeUtil.safeAdd((BigDecimal)monthTaxMny, (BigDecimal)dayTaxMny));
        entity.setRentMonthDate(month);
        entity.setRentDayDate(day);
    }

    private void setRentalValue(RentCalculateEntity entity, ContractEntity contract, Date date) {
        entity.setRentDate(date);
        entity.setCalculateType(RENT_TYPE_MONTH);
        entity.setRelationFlag(RENT_TYPE_DAY);
        entity.setProportionFlag(RENT_TYPE_DAY);
        entity.setSettleFlag(0);
        entity.setProjectId(contract.getProjectId());
        entity.setProjectCode(contract.getProjectCode());
        entity.setProjectName(contract.getProjectName());
        entity.setOrgId(contract.getOrgId());
        entity.setOrgCode(contract.getOrgCode());
        entity.setOrgName(contract.getOrgName());
        entity.setParentOrgId(contract.getParentOrgId());
        entity.setParentOrgCode(contract.getParentOrgCode());
        entity.setParentOrgName(contract.getParentOrgName());
        entity.setContractId(contract.getId());
        entity.setContractCode(contract.getBillCode());
        entity.setContractName(contract.getContractName());
        entity.setSupplierId(contract.getSupplierId());
        entity.setSupplierName(contract.getSupplierName());
        entity.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setEmployeeName(this.sessionManager.getUserContext().getEmployeeName());
        entity.setDeptId(this.sessionManager.getUserContext().getDeptId());
        entity.setDeptName(this.sessionManager.getUserContext().getDeptName());
        entity.setRentCalculationType(contract.getRentCalculationType());
        entity.setMonthSettlementDay(contract.getMonthSettlementDay());
        BigDecimal rentMny = BigDecimal.ZERO;
        BigDecimal rentTaxMny = BigDecimal.ZERO;
        BigDecimal rentTax = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(entity.getDailyList())) {
            for (RentCalculateDailyEntity rentCalculateDailyEntity : entity.getDailyList()) {
                rentMny = ComputeUtil.safeAdd((BigDecimal)rentMny, (BigDecimal)rentCalculateDailyEntity.getDailyRentMny());
                rentTaxMny = ComputeUtil.safeAdd((BigDecimal)rentTaxMny, (BigDecimal)rentCalculateDailyEntity.getDailyRentTaxMny());
                rentTax = ComputeUtil.safeAdd((BigDecimal)rentTax, (BigDecimal)rentCalculateDailyEntity.getDailyTax());
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getMonthList())) {
            for (RentCalculateMonthEntity rentCalculateMonthEntity : entity.getMonthList()) {
                rentMny = ComputeUtil.safeAdd((BigDecimal)rentMny, (BigDecimal)rentCalculateMonthEntity.getMonthRentMny());
                rentTaxMny = ComputeUtil.safeAdd((BigDecimal)rentTaxMny, (BigDecimal)rentCalculateMonthEntity.getMonthRentTaxMny());
                rentTax = ComputeUtil.safeAdd((BigDecimal)rentTax, (BigDecimal)rentCalculateMonthEntity.getMonthTax());
            }
        }
        entity.setRentMny(rentMny);
        entity.setRentTaxMny(rentTaxMny);
        entity.setRentTax(rentTax);
    }

    private void packParameterDetailAndContract(List<RentCalculateCacheVO> resultList, Map<String, Map<Long, List<RentCalculateCacheVO>>> contractAllMap, com.ejianc.business.pro.rmat.vo.MaterialVO materialVO, String rentType, Integer day) {
        Map<Long, List<RentCalculateCacheVO>> map = contractAllMap.get(rentType);
        if (MapUtils.isEmpty(map)) {
            return;
        }
        List<RentCalculateCacheVO> cacheList = map.get(materialVO.getContractDetailId());
        if (CollectionUtils.isEmpty(cacheList) && CollectionUtils.isNotEmpty(cacheList = map.get(materialVO.getMaterialTypeId()))) {
            cacheList.forEach(e -> {
                if (null != e.getDailyRecord()) {
                    e.getDailyRecord().setMaterialId(materialVO.getMaterialId());
                    e.getDailyRecord().setMaterialCode(materialVO.getMaterialCode());
                    e.getDailyRecord().setMaterialName(materialVO.getMaterialName());
                }
                if (null != e.getMonthRecord()) {
                    e.getMonthRecord().setMaterialId(materialVO.getMaterialId());
                    e.getMonthRecord().setMaterialCode(materialVO.getMaterialCode());
                    e.getMonthRecord().setMaterialName(materialVO.getMaterialName());
                }
            });
        }
        if (CollectionUtils.isEmpty(cacheList)) {
            return;
        }
        cacheList.sort(Comparator.comparing(RentCalculateCacheVO::getStartDate));
        List flowList = materialVO.getFlowList();
        List<RentCalculateCacheVO> result = new ArrayList<RentCalculateCacheVO>();
        ArrayList<MaterialFlowVO> beginList = materialVO.getBeginList();
        if (CollectionUtils.isEmpty((Collection)beginList) && CollectionUtils.isNotEmpty((Collection)flowList)) {
            MaterialFlowVO start = (MaterialFlowVO)BeanMapper.map(flowList.get(0), MaterialFlowVO.class);
            start.setNum(BigDecimal.ZERO);
            start.setStartedNum(BigDecimal.ZERO);
            start.setStopedNum(((MaterialFlowVO)flowList.get(0)).getNum());
            beginList = new ArrayList<MaterialFlowVO>(Arrays.asList(start));
            MaterialFlowVO stop = (MaterialFlowVO)BeanMapper.map((Object)start, MaterialFlowVO.class);
            stop.setMaterialState(MaterialStateEnum.\u505c\u7528.getCode());
            stop.setUseStatus(RENT_TYPE_DAY);
            beginList.add(stop);
        }
        if (CollectionUtils.isNotEmpty((Collection)beginList) && beginList.size() == 1 && CollectionUtils.isNotEmpty((Collection)flowList)) {
            MaterialFlowVO data = (MaterialFlowVO)BeanMapper.map(beginList.get(0), MaterialFlowVO.class);
            data.setNum(BigDecimal.ZERO);
            if (RENT_TYPE_DAY.equals(((MaterialFlowVO)beginList.get(0)).getUseStatus())) {
                data.setMaterialState(MaterialStateEnum.\u542f\u7528.getCode());
                data.setSourceType(MaterialStateEnum.\u542f\u7528.getDescription());
                data.setUseStatus(RENT_TYPE_MONTH);
            } else {
                data.setMaterialState(MaterialStateEnum.\u505c\u7528.getCode());
                data.setSourceType(MaterialStateEnum.\u505c\u7528.getDescription());
                data.setUseStatus(RENT_TYPE_DAY);
            }
            beginList.add(data);
        }
        if (CollectionUtils.isNotEmpty((Collection)beginList)) {
            for (RentCalculateCacheVO cache : cacheList) {
                for (MaterialFlowVO begin : beginList) {
                    this.dealFlowList(materialVO, cache, begin, CollectionUtils.isNotEmpty((Collection)flowList) ? (MaterialFlowVO)flowList.get(0) : null, result, null);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)flowList)) {
            flowList.sort(Comparator.comparing(MaterialFlowVO::getOperationDate));
            for (RentCalculateCacheVO cache : cacheList) {
                for (MaterialFlowVO begin : beginList) {
                    for (int i = 0; i < flowList.size(); ++i) {
                        MaterialFlowVO detailVO = (MaterialFlowVO)flowList.get(i);
                        MaterialFlowVO detailVO1 = i == flowList.size() - 1 ? null : (MaterialFlowVO)flowList.get(i + 1);
                        this.dealFlowList(materialVO, cache, detailVO, detailVO1, result, RENT_TYPE_MONTH.equals(begin.getUseStatus()));
                    }
                }
            }
        }
        result = this.packResultCacheVo(result, day);
        resultList.addAll(result);
        this.logger.info("\u79df\u8d41\u65b9\u5f0f\uff1a{}\uff0c\u7ec4\u88c5\u7ed3\u679c\uff1a{}", (Object)rentType, (Object)JSONObject.toJSONString(resultList));
    }

    private void dealFlowList(com.ejianc.business.pro.rmat.vo.MaterialVO materialVO, RentCalculateCacheVO cache, MaterialFlowVO detailVO, MaterialFlowVO detailVO1, List<RentCalculateCacheVO> result, Boolean beginFlag) {
        Date startDate;
        if (detailVO1 != null) {
            this.setBeginNum(detailVO, detailVO1);
        }
        RentCalculateCacheVO vo = this.transferCacheVO(materialVO, detailVO, cache, beginFlag);
        Date date = startDate = MaterialStateEnum.\u9000\u573a.getCode().equals(detailVO.getMaterialState()) ? DateUtil.beginOfDate((Date)DateUtil.dayAddOne((Date)detailVO.getOperationDate())) : detailVO.getOperationDate();
        if (detailVO1 == null) {
            if (DateUtil.compareDate((Date)detailVO.getOperationDate(), (Date)cache.getStartDate()) > 0) {
                if (DateUtil.compareDate((Date)detailVO.getOperationDate(), (Date)cache.getEndDate()) > 0) {
                    return;
                }
                this.setValue(startDate, cache.getEndDate(), vo, result);
            } else {
                this.setValue(cache.getStartDate(), cache.getEndDate(), vo, result);
            }
        } else {
            Date endDate;
            Date date2 = endDate = MaterialStateEnum.\u9000\u573a.getCode().equals(detailVO1.getMaterialState()) ? detailVO1.getOperationDate() : DateUtil.endOfDate((Date)DateUtil.daySubOne((Date)detailVO1.getOperationDate()));
            if (DateUtil.compareDate((Date)detailVO.getOperationDate(), (Date)cache.getStartDate()) > 0) {
                if (DateUtil.compareDate((Date)detailVO.getOperationDate(), (Date)cache.getEndDate()) > 0) {
                    return;
                }
                if (DateUtil.compareDate((Date)detailVO1.getOperationDate(), (Date)cache.getEndDate()) > 0) {
                    this.setValue(startDate, cache.getEndDate(), vo, result);
                } else {
                    this.setValue(startDate, endDate, vo, result);
                }
            } else if (DateUtil.compareDate((Date)detailVO1.getOperationDate(), (Date)cache.getEndDate()) > 0) {
                this.setValue(cache.getStartDate(), cache.getEndDate(), vo, result);
            } else {
                this.setValue(cache.getStartDate(), endDate, vo, result);
            }
        }
    }

    private void setBeginNum(MaterialFlowVO detailVO, MaterialFlowVO detailVO1) {
        if (MaterialStateEnum.\u9000\u573a.getCode().equals(detailVO1.getMaterialState())) {
            if (RENT_TYPE_MONTH.equals(detailVO1.getUseStatus())) {
                detailVO1.setStartedNum(ComputeUtil.safeSub((BigDecimal)detailVO.getStartedNum(), (BigDecimal)detailVO1.getNum()));
                detailVO1.setStopedNum(detailVO.getStopedNum());
            } else {
                detailVO1.setStartedNum(detailVO.getStartedNum());
                detailVO1.setStopedNum(ComputeUtil.safeSub((BigDecimal)detailVO.getStopedNum(), (BigDecimal)detailVO1.getNum()));
            }
        } else if (RENT_TYPE_MONTH.equals(detailVO1.getUseStatus())) {
            detailVO1.setStartedNum(ComputeUtil.safeAdd((BigDecimal)detailVO.getStartedNum(), (BigDecimal)detailVO1.getNum()));
            detailVO1.setStopedNum(ComputeUtil.safeSub((BigDecimal)detailVO.getStopedNum(), (BigDecimal)detailVO1.getNum()));
        } else {
            detailVO1.setStartedNum(ComputeUtil.safeSub((BigDecimal)detailVO.getStartedNum(), (BigDecimal)detailVO1.getNum()));
            detailVO1.setStopedNum(ComputeUtil.safeAdd((BigDecimal)detailVO.getStopedNum(), (BigDecimal)detailVO1.getNum()));
        }
    }

    private void setValue(Date startDate, Date endDate, RentCalculateCacheVO vo, List<RentCalculateCacheVO> result) {
        if (DateUtil.compareDate((Date)startDate, (Date)endDate) > 0) {
            return;
        }
        vo.setStartDate(startDate);
        vo.setEndDate(endDate);
        if (ComputeUtil.isLessOrEqual((BigDecimal)vo.getNum(), (BigDecimal)BigDecimal.ZERO)) {
            return;
        }
        result.add(vo);
    }

    private RentCalculateCacheVO transferCacheVO(com.ejianc.business.pro.rmat.vo.MaterialVO materialVO, MaterialFlowVO detailVO, RentCalculateCacheVO cache, Boolean flag) {
        RentCalculateCacheVO vo = new RentCalculateCacheVO();
        String rentType = materialVO.getRentCalculationType();
        vo.setParameterId(materialVO.getId());
        vo.setContractDetailId(materialVO.getContractDetailId());
        vo.setRentType(rentType);
        if (RENT_TYPE_DAY.equals(rentType)) {
            vo.setDailyRecord(cache.getDailyRecord());
        } else if (RENT_TYPE_MONTH.equals(rentType)) {
            vo.setMonthRecord(cache.getMonthRecord());
        }
        if (flag == null) {
            vo.setNum(detailVO.getNum());
            vo.setMaterialState(detailVO.getMaterialState());
        } else if (flag.booleanValue()) {
            vo.setNum(detailVO.getStartedNum());
            vo.setMaterialState(MaterialStateEnum.\u542f\u7528.getCode());
        } else {
            vo.setNum(detailVO.getStopedNum());
            vo.setMaterialState(MaterialStateEnum.\u505c\u7528.getCode());
        }
        return vo;
    }

    private boolean checkCacheVoIsMerge(RentCalculateCacheVO vo1, RentCalculateCacheVO vo2) {
        if (!vo1.getMaterialState().equals(vo2.getMaterialState())) {
            return true;
        }
        BigDecimal price1 = null;
        BigDecimal price2 = null;
        if (RENT_TYPE_DAY.equals(vo1.getRentType())) {
            price1 = vo1.getDailyRecord().getUnitTaxPrice();
            price2 = vo2.getDailyRecord().getUnitTaxPrice();
            if (MaterialStateEnum.\u505c\u7528.getCode().equals(vo1.getMaterialState())) {
                price1 = vo1.getDailyRecord().getStopUnitTaxPrice();
                price2 = vo2.getDailyRecord().getStopUnitTaxPrice();
            }
        } else if (RENT_TYPE_MONTH.equals(vo1.getRentType())) {
            price1 = vo1.getMonthRecord().getUnitTaxPrice();
            price2 = vo2.getMonthRecord().getUnitTaxPrice();
            if (MaterialStateEnum.\u505c\u7528.getCode().equals(vo1.getMaterialState())) {
                price1 = vo1.getMonthRecord().getStopUnitTaxPrice();
                price2 = vo2.getMonthRecord().getStopUnitTaxPrice();
            }
        } else {
            return true;
        }
        if (price1.equals(price2)) {
            vo1.setEndDate(vo2.getEndDate());
            return false;
        }
        return true;
    }

    private List<RentCalculateCacheVO> packResultCacheVo(List<RentCalculateCacheVO> resultList, Integer day) {
        ArrayList<RentCalculateCacheVO> rtnList = new ArrayList<RentCalculateCacheVO>();
        for (RentCalculateCacheVO vo : resultList) {
            if (RENT_TYPE_MONTH.equals(vo.getRentType()) && MaterialStateEnum.\u542f\u7528.getCode().equals(vo.getMaterialState())) {
                Date endDate;
                Date endUpDate;
                Date startBeginDate = DateUtil.monthDay((Date)vo.getStartDate(), (Integer)day);
                Date startEndDate = DateUtil.monthDay((Date)DateUtil.monthAddOne((Date)vo.getStartDate()), (Integer)day);
                Date endBeginDate = DateUtil.monthDay((Date)vo.getEndDate(), (Integer)day);
                Date endEndDate = DateUtil.monthDay((Date)DateUtil.monthAddOne((Date)vo.getEndDate()), (Integer)day);
                if (DateUtil.compareDay((Date)vo.getStartDate(), (Date)startBeginDate) < 0) {
                    if (DateUtil.compareDay((Date)vo.getEndDate(), (Date)startBeginDate) < 0) {
                        rtnList.add(vo);
                        continue;
                    }
                    if (DateUtil.compareDay((Date)vo.getEndDate(), (Date)startBeginDate) > 0 && DateUtil.compareDay((Date)vo.getEndDate(), (Date)startEndDate) < 0) {
                        this.setRstValue(vo.getStartDate(), startBeginDate, vo, rtnList);
                        this.setRstValue(DateUtil.dayAddOne((Date)startBeginDate), vo.getEndDate(), vo, rtnList);
                        continue;
                    }
                    if (DateUtil.compareDay((Date)vo.getEndDate(), (Date)startEndDate) > 0 && DateUtil.compareDay((Date)vo.getEndDate(), (Date)endBeginDate) < 0) {
                        this.setRstValue(vo.getStartDate(), startBeginDate, vo, rtnList);
                        endUpDate = DateUtil.monthDay((Date)DateUtil.addMonths((Date)vo.getEndDate(), (int)-1), (Integer)day);
                        if (DateUtil.compareDay((Date)endUpDate, (Date)startEndDate) > 0) {
                            this.setRstValue(DateUtil.dayAddOne((Date)startBeginDate), endUpDate, vo, rtnList);
                            endDate = endUpDate;
                        } else {
                            this.setRstValue(DateUtil.dayAddOne((Date)startBeginDate), startEndDate, vo, rtnList);
                            endDate = startEndDate;
                        }
                        this.setRstValue(DateUtil.dayAddOne((Date)endDate), vo.getEndDate(), vo, rtnList);
                        continue;
                    }
                    if (DateUtil.compareDay((Date)vo.getEndDate(), (Date)startEndDate) > 0 && DateUtil.compareDay((Date)vo.getEndDate(), (Date)endBeginDate) > 0) {
                        this.setRstValue(vo.getStartDate(), startBeginDate, vo, rtnList);
                        if (DateUtil.compareDay((Date)endBeginDate, (Date)startEndDate) > 0) {
                            this.setRstValue(DateUtil.dayAddOne((Date)startBeginDate), endBeginDate, vo, rtnList);
                        }
                        this.setRstValue(DateUtil.dayAddOne((Date)endBeginDate), vo.getEndDate(), vo, rtnList);
                        continue;
                    }
                    rtnList.add(vo);
                    continue;
                }
                if (DateUtil.compareDay((Date)vo.getStartDate(), (Date)startBeginDate) > 0) {
                    if (DateUtil.compareDay((Date)vo.getEndDate(), (Date)startEndDate) < 0) {
                        rtnList.add(vo);
                        continue;
                    }
                    if (DateUtil.compareDay((Date)vo.getEndDate(), (Date)startEndDate) > 0 && DateUtil.compareDay((Date)vo.getEndDate(), (Date)endBeginDate) < 0) {
                        this.setRstValue(vo.getStartDate(), startEndDate, vo, rtnList);
                        endUpDate = DateUtil.monthDay((Date)DateUtil.addMonths((Date)vo.getEndDate(), (int)-1), (Integer)day);
                        if (DateUtil.compareDay((Date)endUpDate, (Date)startEndDate) > 0) {
                            this.setRstValue(DateUtil.dayAddOne((Date)startEndDate), endUpDate, vo, rtnList);
                            endDate = endUpDate;
                        } else {
                            endDate = startEndDate;
                        }
                        this.setRstValue(DateUtil.dayAddOne((Date)endDate), vo.getEndDate(), vo, rtnList);
                        continue;
                    }
                    if (DateUtil.compareDay((Date)vo.getEndDate(), (Date)startEndDate) > 0 && DateUtil.compareDay((Date)vo.getEndDate(), (Date)endBeginDate) > 0) {
                        this.setRstValue(vo.getStartDate(), startEndDate, vo, rtnList);
                        if (DateUtil.compareDay((Date)endBeginDate, (Date)startEndDate) > 0) {
                            this.setRstValue(DateUtil.dayAddOne((Date)startEndDate), endBeginDate, vo, rtnList);
                        }
                        this.setRstValue(DateUtil.dayAddOne((Date)endBeginDate), vo.getEndDate(), vo, rtnList);
                        continue;
                    }
                    rtnList.add(vo);
                    continue;
                }
                this.setRstValue(vo.getStartDate(), startBeginDate, vo, rtnList);
                if (DateUtil.compareDay((Date)vo.getEndDate(), (Date)startBeginDate) <= 0) continue;
                this.setRstValue(DateUtil.dayAddOne((Date)startBeginDate), vo.getEndDate(), vo, rtnList);
                continue;
            }
            rtnList.add(vo);
        }
        rtnList.sort(Comparator.comparing(RentCalculateCacheVO::getStartDate));
        return rtnList;
    }

    private void setRstValue(Date start, Date end, RentCalculateCacheVO vo, List<RentCalculateCacheVO> rtnList) {
        RentCalculateCacheVO rstvo = new RentCalculateCacheVO();
        rstvo.setStartDate(start);
        rstvo.setEndDate(end);
        rstvo.setNum(vo.getNum());
        rstvo.setMaterialState(vo.getMaterialState());
        rstvo.setRentType(vo.getRentType());
        rstvo.setMonthRecord(vo.getMonthRecord());
        rstvo.setParameterId(vo.getParameterId());
        rstvo.setContractType(vo.getContractType());
        rtnList.add(rstvo);
    }

    private Map<String, Map<Long, List<RentCalculateCacheVO>>> getContractRecord(ContractEntity contract, Date endDate) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contract.getId()));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getParams().put("changeDate", new Parameter("le", (Object)endDate));
        queryParam.getOrderMap().put("changeDate", "asc");
        List recordList = this.recordService.queryList(queryParam, false);
        HashMap<String, Map<Long, List<RentCalculateCacheVO>>> rtnMap = new HashMap<String, Map<Long, List<RentCalculateCacheVO>>>();
        Date signDate = DateUtil.concatDate((Date)contract.getSignDate(), (Date)contract.getCreateTime());
        int version = 0;
        if (CollectionUtils.isEmpty((Collection)recordList)) {
            this.packContractMap(contract, rtnMap, signDate, endDate, version, signDate);
            this.logger.info("<<<<\u5408\u540c\u672a\u67e5\u8be2\u5230\u53d8\u66f4\u8bb0\u5f55\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(rtnMap));
            return rtnMap;
        }
        List recordIds = recordList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("recordId", new Parameter("in", recordIds));
        List dailyList = this.dailyRecordService.queryList(param, false);
        List monthList = this.monthRecordService.queryList(param, false);
        Map<Long, List<RecordDailyRentEntity>> dayMap = dailyList.stream().collect(Collectors.groupingBy(RecordDailyRentEntity::getRecordId));
        Map<Long, List<RecordMonthRentEntity>> monthMap = monthList.stream().collect(Collectors.groupingBy(RecordMonthRentEntity::getRecordId));
        Date startDate = null;
        Date changeDate = null;
        for (int i = 0; i < recordList.size(); ++i) {
            RentCalculateCacheVO vo;
            Map<Long, List<Object>> detailMap;
            RecordEntity record = (RecordEntity)((Object)recordList.get(i));
            record.setDailyRentList(dayMap.get(record.getId()));
            record.setMonthRentList(monthMap.get(record.getId()));
            if (startDate == null) {
                startDate = DateUtil.concatDate((Date)record.getSignDate(), (Date)record.getCreateTime());
            }
            if (DateUtil.compareDate((Date)startDate, (Date)(changeDate = DateUtil.concatDate((Date)record.getChangeDate(), (Date)record.getCreateTime()))) > 0) continue;
            if (CollectionUtils.isNotEmpty(record.getDailyRentList())) {
                detailMap = (HashMap<Long, List<RentCalculateCacheVO>>)rtnMap.get(RENT_TYPE_DAY);
                if (detailMap == null) {
                    detailMap = new HashMap<Long, List<RentCalculateCacheVO>>();
                }
                for (RecordDailyRentEntity recordDailyRentEntity : record.getDailyRentList()) {
                    vo = new RentCalculateCacheVO();
                    vo.setRentType(RENT_TYPE_DAY);
                    if (null != recordDailyRentEntity.getMaterialId()) {
                        vo.setMaterialId(recordDailyRentEntity.getMaterialId());
                    } else {
                        vo.setMaterialId(recordDailyRentEntity.getMaterialTypeId());
                    }
                    vo.setContractDetailId(recordDailyRentEntity.getSourceBid());
                    vo.setStartDate(startDate);
                    if (!DateUtil.isSameDay((Date)startDate, (Date)signDate) && !detailMap.containsKey(vo.getMaterialId())) {
                        vo.setStartDate(signDate);
                    }
                    vo.setEndDate(DateUtil.daySubOne((Date)changeDate));
                    vo.setNum(recordDailyRentEntity.getCount());
                    vo.setContractType(Integer.valueOf(1));
                    vo.setDailyRecord((RecordDailyRentVO)BeanMapper.map((Object)((Object)recordDailyRentEntity), RecordDailyRentVO.class));
                    vo.setVersion(Integer.valueOf(version));
                    this.packCacheMap(vo, detailMap);
                }
                rtnMap.put(RENT_TYPE_DAY, detailMap);
            }
            if (CollectionUtils.isNotEmpty(record.getMonthRentList())) {
                detailMap = (Map)rtnMap.get(RENT_TYPE_MONTH);
                if (detailMap == null) {
                    detailMap = new HashMap();
                }
                for (RecordMonthRentEntity recordMonthRentEntity : record.getMonthRentList()) {
                    vo = new RentCalculateCacheVO();
                    vo.setRentType(RENT_TYPE_MONTH);
                    if (null != recordMonthRentEntity.getMaterialId()) {
                        vo.setMaterialId(recordMonthRentEntity.getMaterialId());
                    } else {
                        vo.setMaterialId(recordMonthRentEntity.getMaterialTypeId());
                    }
                    vo.setContractDetailId(recordMonthRentEntity.getSourceBid());
                    vo.setStartDate(startDate);
                    if (!DateUtil.isSameDay((Date)startDate, (Date)signDate) && !detailMap.containsKey(vo.getMaterialId())) {
                        vo.setStartDate(signDate);
                    }
                    vo.setEndDate(DateUtil.daySubOne((Date)changeDate));
                    vo.setNum(recordMonthRentEntity.getCount());
                    vo.setContractType(Integer.valueOf(1));
                    vo.setMonthRecord((RecordMonthRentVO)BeanMapper.map((Object)((Object)recordMonthRentEntity), RecordMonthRentVO.class));
                    vo.setVersion(Integer.valueOf(version));
                    this.packCacheMap(vo, detailMap);
                }
                rtnMap.put(RENT_TYPE_MONTH, detailMap);
            }
            startDate = DateUtil.concatDate((Date)record.getChangeDate(), (Date)record.getCreateTime());
            ++version;
        }
        this.packContractMap(contract, rtnMap, changeDate, endDate, version, signDate);
        this.logger.info("<<<<\u5904\u7406\u5408\u540c\u4fe1\u606f\u7ed3\u675f\uff0c\u5904\u7406\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(rtnMap));
        return rtnMap;
    }

    private void packCacheMap(RentCalculateCacheVO vo, Map<Long, List<RentCalculateCacheVO>> map) {
        if (map == null) {
            map = new HashMap<Long, List<RentCalculateCacheVO>>();
        }
        if (map.containsKey(vo.getContractDetailId())) {
            map.get(vo.getContractDetailId()).add(vo);
        } else {
            map.put(vo.getContractDetailId(), new ArrayList<RentCalculateCacheVO>(Arrays.asList(vo)));
        }
    }

    private void packContractMap(ContractEntity contract, Map<String, Map<Long, List<RentCalculateCacheVO>>> rtnMap, Date startDate, Date endDate, int version, Date signDate) {
        RentCalculateCacheVO vo;
        RecordDailyRentVO record;
        Map<Long, List<RentCalculateCacheVO>> detailMap;
        if (DateUtil.compareDate((Date)endDate, (Date)startDate) < 0) {
            return;
        }
        if (CollectionUtils.isNotEmpty(contract.getDailyRentList())) {
            detailMap = rtnMap.get(RENT_TYPE_DAY);
            if (detailMap == null) {
                detailMap = new HashMap<Long, List<RentCalculateCacheVO>>();
            }
            record = new RecordDailyRentVO();
            for (ContractDailyRentEntity contractDailyRentEntity : contract.getDailyRentList()) {
                vo = new RentCalculateCacheVO();
                vo.setRentType(RENT_TYPE_DAY);
                if (null != contractDailyRentEntity.getMaterialId()) {
                    vo.setMaterialId(contractDailyRentEntity.getMaterialId());
                } else {
                    vo.setMaterialId(contractDailyRentEntity.getMaterialTypeId());
                }
                vo.setContractDetailId(contractDailyRentEntity.getId());
                vo.setStartDate(startDate);
                if (!DateUtil.isSameDay((Date)startDate, (Date)signDate) && !detailMap.containsKey(vo.getContractDetailId())) {
                    vo.setStartDate(signDate);
                }
                vo.setEndDate(endDate);
                vo.setNum(contractDailyRentEntity.getCount());
                vo.setContractType(Integer.valueOf(0));
                record = (RecordDailyRentVO)BeanMapper.map((Object)((Object)contractDailyRentEntity), RecordDailyRentVO.class);
                record.setSourceBid(contractDailyRentEntity.getId());
                vo.setDailyRecord(record);
                vo.setVersion(Integer.valueOf(version));
                this.packCacheMap(vo, detailMap);
            }
            rtnMap.put(RENT_TYPE_DAY, detailMap);
        }
        if (CollectionUtils.isNotEmpty(contract.getMonthRentList())) {
            detailMap = rtnMap.get(RENT_TYPE_MONTH);
            if (detailMap == null) {
                detailMap = new HashMap<Long, List<RentCalculateCacheVO>>();
            }
            record = new RecordMonthRentVO();
            for (ContractMonthRentEntity contractMonthRentEntity : contract.getMonthRentList()) {
                vo = new RentCalculateCacheVO();
                vo.setRentType(RENT_TYPE_MONTH);
                if (null != contractMonthRentEntity.getMaterialId()) {
                    vo.setMaterialId(contractMonthRentEntity.getMaterialId());
                } else {
                    vo.setMaterialId(contractMonthRentEntity.getMaterialTypeId());
                }
                vo.setContractDetailId(contractMonthRentEntity.getId());
                vo.setStartDate(startDate);
                if (!DateUtil.isSameDay((Date)startDate, (Date)signDate) && !detailMap.containsKey(vo.getContractDetailId())) {
                    vo.setStartDate(signDate);
                }
                vo.setEndDate(endDate);
                vo.setNum(contractMonthRentEntity.getCount());
                vo.setContractType(Integer.valueOf(0));
                record = (RecordMonthRentVO)BeanMapper.map((Object)((Object)contractMonthRentEntity), RecordMonthRentVO.class);
                record.setSourceBid(contractMonthRentEntity.getId());
                vo.setMonthRecord((RecordMonthRentVO)record);
                vo.setVersion(Integer.valueOf(version));
                this.packCacheMap(vo, detailMap);
            }
            rtnMap.put(RENT_TYPE_MONTH, detailMap);
        }
    }

    private BigDecimal getMny(BigDecimal price, Integer days, BigDecimal num) {
        return ComputeUtil.safeMultiply((BigDecimal)price, (BigDecimal[])new BigDecimal[]{new BigDecimal(days), num});
    }
}

