/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.rmat.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.pro.rmat.bean.TotalPlanChangeEntity;
import com.ejianc.business.pro.rmat.bean.TotalPlanDetailEntity;
import com.ejianc.business.pro.rmat.bean.TotalPlanDetailHistoryEntity;
import com.ejianc.business.pro.rmat.bean.TotalPlanEntity;
import com.ejianc.business.pro.rmat.bean.TotalPlanHistoryEntity;
import com.ejianc.business.pro.rmat.mapper.TotalPlanMapper;
import com.ejianc.business.pro.rmat.service.ITotalPlanChangeService;
import com.ejianc.business.pro.rmat.service.ITotalPlanDetailService;
import com.ejianc.business.pro.rmat.service.ITotalPlanHistoryService;
import com.ejianc.business.pro.rmat.service.ITotalPlanService;
import com.ejianc.business.pro.rmat.utils.SortUtil;
import com.ejianc.business.pro.rmat.utils.TreeNodeBUtil;
import com.ejianc.business.pro.rmat.vo.PlanContrastV0;
import com.ejianc.business.pro.rmat.vo.TotalPlanDetailVO;
import com.ejianc.business.pro.rmat.vo.TotalPlanVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="totalPlanService")
public class TotalPlanServiceImpl
extends BaseServiceImpl<TotalPlanMapper, TotalPlanEntity>
implements ITotalPlanService {
    private static final String BILL_CODE = "PRO_TOTAL_PLAN_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ITotalPlanDetailService detailService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private ITotalPlanChangeService changeService;
    @Autowired
    private ITotalPlanHistoryService historyService;

    @Override
    public TotalPlanVO saveOrUpdateTotalPlan(TotalPlanVO saveorUpdateVO, Boolean isControl) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        TotalPlanEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            entity = (TotalPlanEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, TotalPlanEntity.class));
            operateType = "edit";
        } else {
            LambdaQueryWrapper lambd = new LambdaQueryWrapper();
            lambd.eq(TotalPlanEntity::getProjectId, (Object)saveorUpdateVO.getProjectId());
            lambd.eq(BaseEntity::getDr, (Object)BaseVO.DR_UNDELETE);
            List list = super.list((Wrapper)lambd);
            if (null != list && list.size() > 0) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u9879\u76ee\u4e0b\u5df2\u5b58\u5728\u5468\u8f6c\u6750\u603b\u8ba1\u5212\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01");
            }
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity = (TotalPlanEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, TotalPlanEntity.class));
            entity.setChangeStatus(1);
            entity.setId(IdWorker.getId());
            operateType = "add";
        }
        entity.setBaseMny(entity.getEstimatedMny());
        if (!isControl.booleanValue()) {
            super.saveOrUpdate((Object)entity);
        } else {
            List<TotalPlanDetailEntity> detailEntityList = entity.getDetailList();
            ArrayList<TotalPlanDetailEntity> detailEntityListNew = new ArrayList<TotalPlanDetailEntity>();
            if (CollectionUtils.isNotEmpty(detailEntityList)) {
                for (TotalPlanDetailEntity cdEntity : detailEntityList) {
                    if (null == cdEntity.getId()) {
                        cdEntity.setId(IdWorker.getId());
                    }
                    if ("del".equals(cdEntity.getRowState())) continue;
                    detailEntityListNew.add(cdEntity);
                }
                entity.setDetailList(detailEntityListNew);
            }
        }
        TotalPlanVO totalPlanVO = null;
        List<TotalPlanDetailEntity> detailEntityList = entity.getDetailList();
        ArrayList<TotalPlanDetailEntity> detailEntitys = new ArrayList<TotalPlanDetailEntity>();
        ArrayList<Long> delIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (TotalPlanDetailEntity cdEntity : detailEntityList) {
                if ("add".equals(cdEntity.getRowState())) {
                    cdEntity.setId(IdWorker.getId());
                }
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (TotalPlanDetailEntity cdEntity : detailEntityList) {
                if (StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) {
                    cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
                }
                cdEntity.setChangeType(0);
                cdEntity.setTotalId(entity.getId());
                if (!"del".equals(cdEntity.getRowState())) {
                    detailEntitys.add(cdEntity);
                    continue;
                }
                delIds.add(cdEntity.getId());
            }
        }
        if (!isControl.booleanValue()) {
            if (delIds.size() > 0) {
                this.detailService.removeByIds(delIds);
            }
            if (detailEntitys.size() > 0) {
                this.detailService.saveOrUpdateBatch(detailEntitys, detailEntitys.size(), false);
            }
            totalPlanVO = this.queryDetail(entity.getId(), true);
            String frontendBaseHost = "";
            frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
            String linkUrl = frontendBaseHost + "ejc-prormat-frontend/#/totalPlan/card?id=" + entity.getId();
            ExecutionVO executionVO = this.targetCost(this.queryDetail(entity.getId(), false), linkUrl);
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        } else {
            totalPlanVO = (TotalPlanVO)BeanMapper.map((Object)((Object)entity), TotalPlanVO.class);
            totalPlanVO.setDetailList(BeanMapper.mapList(detailEntitys, TotalPlanDetailVO.class));
        }
        return totalPlanVO;
    }

    @Override
    public ExecutionVO targetCost(TotalPlanVO totalPlanVO, String linkUrl) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(totalPlanVO.getId());
        totalVO.setTenantId(totalPlanVO.getTenantId());
        totalVO.setBillCode(totalPlanVO.getBillCode());
        totalVO.setMemo(totalPlanVO.getMemo());
        totalVO.setBillType("BT220209000000005");
        totalVO.setBillCategory(BillCategoryEnum.\u8ba1\u5212.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.\u5468\u8f6c\u6750\u6750\u6599\u603b\u8ba1\u5212.getCode());
        totalVO.setProjectId(totalPlanVO.getProjectId());
        totalVO.setBillDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)(null == totalPlanVO.getCreateTime() ? new Date() : totalPlanVO.getCreateTime())));
        totalVO.setOrgId(totalPlanVO.getOrgId());
        totalVO.setMoney(totalPlanVO.getEstimatedMny());
        totalVO.setTaxMoney(totalPlanVO.getEstimatedMny());
        totalVO.setLinkUrl(linkUrl);
        totalVO.setBillDate(totalPlanVO.getCreateTime() != null ? totalPlanVO.getCreateTime().toString() : null);
        for (TotalPlanDetailVO planDetailVO : totalPlanVO.getDetailList()) {
            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
            detailExecutionVO.setSourceId(planDetailVO.getId());
            detailExecutionVO.setSourceBillId(totalPlanVO.getId());
            detailExecutionVO.setCategoryId(planDetailVO.getMaterialTypeId());
            detailExecutionVO.setCategoryName(planDetailVO.getMaterialTypeName());
            if (planDetailVO.getMaterialId() == null) {
                detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
            }
            detailExecutionVO.setCode(planDetailVO.getMaterialCode());
            detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
            detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
            MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(planDetailVO.getMaterialTypeId()).getData();
            if (categoryVO == null) {
                detailExecutionVO.setCategoryInnerCode(null);
                detailExecutionVO.setCategoryCode(null);
            } else {
                detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                detailExecutionVO.setCategoryCode(categoryVO.getCode());
            }
            detailExecutionVO.setDocId(Long.valueOf(planDetailVO.getSourceId() == null ? 1439116437228298666L : planDetailVO.getSourceId()));
            detailExecutionVO.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
            detailExecutionVO.setName(planDetailVO.getMaterialName());
            detailExecutionVO.setSpec(planDetailVO.getSpec());
            detailExecutionVO.setUnitId(planDetailVO.getUnitId());
            detailExecutionVO.setUnitName(planDetailVO.getUnit());
            detailExecutionVO.setNum(planDetailVO.getNum());
            detailExecutionVO.setMoney(planDetailVO.getMny());
            detailExecutionVO.setTaxMoney(planDetailVO.getMny());
            detailList.add(detailExecutionVO);
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public TotalPlanVO queryDetail(Long id, boolean detailHasChildren) {
        TotalPlanEntity entity = (TotalPlanEntity)((Object)super.selectById((Serializable)id));
        TotalPlanVO vo = (TotalPlanVO)BeanMapper.map((Object)((Object)entity), TotalPlanVO.class);
        List detailVoListDb = vo.getDetailList();
        ArrayList detailVoList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailVoListDb)) {
            detailVoListDb.forEach(detailEntity -> {
                if (null == detailEntity.getChangeType() || 2 != detailEntity.getChangeType()) {
                    detailVoList.add(detailEntity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailVoList)) {
            for (TotalPlanDetailVO cdEntity : detailVoList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            new SortUtil().entryListToSort(detailVoList, "treeIndex");
            if (detailHasChildren) {
                vo.setDetailList(TreeNodeBUtil.buildTree(detailVoList));
            } else {
                vo.setDetailList(detailVoList);
            }
        }
        return vo;
    }

    @Override
    public void delByPlanId(Long id) {
        ((TotalPlanMapper)this.baseMapper).delByPlanId(id);
    }

    @Override
    public void delByIds(List<TotalPlanVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            for (TotalPlanVO masterPlanVO : vos) {
                ExecutionVO executionVO = this.targetCost((TotalPlanVO)BeanMapper.map((Object)((TotalPlanMapper)this.baseMapper).selectById(masterPlanVO.getId()), TotalPlanVO.class), "");
                totalExecutionVOList.add(executionVO.getTotalVO());
            }
            this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
            List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(ids)) {
                super.removeByIds(ids);
            }
        }
    }

    @Override
    public ParamsCheckVO targetCostCtrl(TotalPlanVO totalPlanVO) {
        TotalPlanVO planVO = this.saveOrUpdateTotalPlan(totalPlanVO, true);
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        String linkUrl = frontendBaseHost + "ejc-prormat-frontend/#/totalPlan/card?id=" + planVO.getId();
        ExecutionVO executionVO = this.targetCost(planVO, linkUrl);
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        return (ParamsCheckVO)response.getData();
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        TotalPlanVO planVO = this.queryDetail(id, true);
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        String linkUrl = frontendBaseHost + "ejc-prormat-frontend/#/totalPlan/card?id=" + planVO.getId();
        ExecutionVO executionVO = this.targetCost(planVO, linkUrl);
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        return (ParamsCheckVO)response.getData();
    }

    @Override
    public List<TotalPlanEntity> listTotalPlanByProjectId(Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TotalPlanEntity::getProjectId, (Object)projectId);
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq(BaseEntity::getDr, (Object)0);
        queryWrapper.in(TotalPlanEntity::getBillState, new Object[]{1, 3});
        return super.list((Wrapper)queryWrapper);
    }

    @Override
    public Boolean syncPushExecution(Long id) {
        TotalPlanVO totalPlanVO = this.queryDetail(id, false);
        if (totalPlanVO.getChangeStatus() == 2) {
            TotalPlanChangeEntity planChangeEntity = (TotalPlanChangeEntity)((Object)this.changeService.selectById(totalPlanVO.getChangeId()));
            ArrayList<TotalExecutionVO> totalExecutionVOList0 = new ArrayList<TotalExecutionVO>();
            ExecutionVO executionVO0 = this.targetCost((TotalPlanVO)BeanMapper.map((Object)((Object)planChangeEntity), TotalPlanVO.class), "");
            totalExecutionVOList0.add(executionVO0.getTotalVO());
            this.logger.info("\u76ee\u6807\u6210\u672c\u53d8\u66f4\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList0));
            CommonResponse response2 = this.executionApi.aggDel(totalExecutionVOList0);
            if (!response2.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response2.getMsg());
            }
            String frontendBaseHost = "";
            frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
            String linkUrl = frontendBaseHost + "ejc-prormat-frontend/#/totalPlan/changeCard?id=" + totalPlanVO.getChangeId();
            ExecutionVO executionVO = this.targetCost((TotalPlanVO)BeanMapper.map((Object)((Object)planChangeEntity), TotalPlanVO.class), linkUrl);
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        } else {
            if (totalPlanVO.getChangeVersion() != 1) {
                ArrayList<TotalExecutionVO> totalExecutionVOList1 = new ArrayList<TotalExecutionVO>();
                LambdaQueryWrapper lam = new LambdaQueryWrapper();
                lam.eq(BaseEntity::getDr, (Object)0);
                lam.eq(TotalPlanChangeEntity::getTotalId, (Object)id);
                lam.eq(TotalPlanChangeEntity::getChangeVersion, (Object)totalPlanVO.getChangeVersion());
                lam.in(TotalPlanChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
                List list = this.changeService.list((Wrapper)lam);
                if (list != null && list.size() > 0) {
                    TotalPlanChangeEntity masterPlanChangeEntity = (TotalPlanChangeEntity)((Object)list.get(0));
                    ExecutionVO executionVO2 = this.targetCost((TotalPlanVO)BeanMapper.map((Object)((Object)masterPlanChangeEntity), TotalPlanVO.class), "");
                    totalExecutionVOList1.add(executionVO2.getTotalVO());
                    this.logger.info("\u76ee\u6807\u6210\u672c\u53d8\u66f4\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList1));
                    CommonResponse response2 = this.executionApi.aggDel(totalExecutionVOList1);
                    if (!response2.isSuccess()) {
                        throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response2.getMsg());
                    }
                }
            }
            String frontendBaseHost = "";
            frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
            String linkUrl = frontendBaseHost + "ejc-prormat-frontend/#/totalPlan/card?id=" + id;
            ExecutionVO executionVO = this.targetCost(totalPlanVO, linkUrl);
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        return true;
    }

    @Override
    public List<PlanContrastV0> getContrastInfo(Long planId, Long oldPlanId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TotalPlanDetailEntity::getTotalId, (Object)planId);
        List list = this.detailService.list((Wrapper)wrapper);
        LambdaQueryWrapper historyWrapper = new LambdaQueryWrapper();
        historyWrapper.eq(TotalPlanHistoryEntity::getChangeId, (Object)oldPlanId);
        TotalPlanHistoryEntity historyEntity = (TotalPlanHistoryEntity)((Object)this.historyService.getOne((Wrapper)historyWrapper));
        List<TotalPlanDetailHistoryEntity> historyEntityList = ((TotalPlanHistoryEntity)((Object)this.historyService.selectById(historyEntity.getId()))).getDetailList();
        List voList = BeanMapper.mapList((Iterable)list, PlanContrastV0.class);
        for (PlanContrastV0 vo : voList) {
            Map map = historyEntityList.stream().collect(Collectors.toMap(TotalPlanDetailHistoryEntity::getSourceId, Function.identity()));
            if (!map.containsKey(vo.getSourceId())) continue;
            TotalPlanDetailHistoryEntity entity = (TotalPlanDetailHistoryEntity)((Object)map.get(vo.getSourceId()));
            vo.setOldNum(entity.getNum());
            vo.setOldMny(entity.getMny());
            vo.setOldPlanUseTime(entity.getPlanUseTime());
            vo.setOldStandard(entity.getStandard());
            vo.setOldMemo(entity.getMemo());
        }
        return voList;
    }
}

