package com.ejianc.business.plan.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 分包总计划变更实体
 * 
 * @author generator
 * 
 */
public class PlanChangeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectId; // 所属项目Id
    private String projectName; // 所属项目名称
    private String projectCode; // 所属项目编码
    private String billCode; // 计划编码
    private BigDecimal totalPlanTaxMny; // 现计划金额
    private BigDecimal totalPlanMny; // 现计划金额无税
    private String memo; // 备注
    private Long orgId; // 所属项目部Id
    private String orgName; // 所属项目部名称
    private Integer billState; // 单据状态
    private String changeUserName; // 变更人
    private String changeReason; // 变更原因
    private BigDecimal originalPlanTaxMny; // 原计划金额
    private BigDecimal originalPlanMny; // 原计划金额(无税)
    private Long sourcePlanId; // 源计划数据Id
    private String createUserName; // 创建人名称
    private String modifyUserName; // 修改人名称
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date effectiveDate; // 生效日期
    private Integer changeVersion; // 变更版本
    private Long employeeId;//经办人id
    private String employeeName; // 经办人
    private Long departmentId; // 经办单位id
    private String departmentName; // 经办单位
    private Long parentOrgId; // 项目部上级组织id
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private Integer subType; // 分包类型 0-劳务分包 1-专业分包


    private List<PlanDetailChangeVO> planDetailList = new ArrayList<>();

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public BigDecimal getTotalPlanTaxMny() {
        return totalPlanTaxMny;
    }

    public void setTotalPlanTaxMny(BigDecimal totalPlanTaxMny) {
        this.totalPlanTaxMny = totalPlanTaxMny;
    }

    public BigDecimal getTotalPlanMny() {
        return totalPlanMny;
    }

    public void setTotalPlanMny(BigDecimal totalPlanMny) {
        this.totalPlanMny = totalPlanMny;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getChangeUserName() {
        return changeUserName;
    }

    public void setChangeUserName(String changeUserName) {
        this.changeUserName = changeUserName;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public BigDecimal getOriginalPlanTaxMny() {
        return originalPlanTaxMny;
    }

    public void setOriginalPlanTaxMny(BigDecimal originalPlanTaxMny) {
        this.originalPlanTaxMny = originalPlanTaxMny;
    }

    public BigDecimal getOriginalPlanMny() {
        return originalPlanMny;
    }

    public void setOriginalPlanMny(BigDecimal originalPlanMny) {
        this.originalPlanMny = originalPlanMny;
    }

    public Long getSourcePlanId() {
        return sourcePlanId;
    }

    public void setSourcePlanId(Long sourcePlanId) {
        this.sourcePlanId = sourcePlanId;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public List<PlanDetailChangeVO> getPlanDetailList() {
        return planDetailList;
    }

    public void setPlanDetailList(List<PlanDetailChangeVO> planDetailList) {
        this.planDetailList = planDetailList;
    }
}
