package com.ejianc.business.prosub.vo;

import com.ejianc.business.prosub.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 分包合同明细
 * 
 * @author generator
 * 
 */
public class ContractDetailVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;


    /**
     * 清单编号
     */
    private String detailCode;

    /**
     * 清单名称
     */
    private String detailName;

    /**
     * 清单价格类型
     */
    private String docPriceTypeName;

    /**
     * 序号
     */
    private String treeIndex;

    /**
     * 工作内容
     */
    private String detailWorkContent;

    /**
     * 计量规则
     */
    private String detailMeasurementRules;

    /**
     * 单位
     */
    private String detailUnit;

    /**
     * 工程量
     */
    private BigDecimal detailNum;

    /**
     * 单价（无税）
     */
    private BigDecimal detailPrice;

    /**
     * 税率
     */
    private BigDecimal detailTaxRate;

    /**
     * 金额（无税）
     */
    private BigDecimal detailMny;

    /**
     * 单价(含税）
     */
    private BigDecimal detailTaxPrice;

    /**
     * 金额（含税）
     */
    private BigDecimal detailTaxMny;

    /**
     * 税额
     */
    private BigDecimal detailTax;

    /**
     * 备注
     */
    private String detailMemo;

    /**
     * 来源数据Id
     */
    private Long sourceId;

    /**
     * 来源类型：档案 doc    总计划 plan    目标成功 target    定标结果新增 targetResult
     */
    private String sourceType;

    /**
     * 所属合同Id
     */
    private Long contractId;

    /**
     * 变更主键
     */
    private Long changeId;

    /**
     * 变更子表主键
     */
    private Long changeBid;

    /**
     * 父ID
     */
    private Long parentId;

    private String tid;
    private String tpid;
    private List<ITreeNodeB> children;

    /**
     * 变更类型
     */
    private String changeType;

    /**
     * 档案分类Id
     */
    private Long docCategoryId;

    /**
     * 档案Id
     */
    private Long docId;

    /**
     * 总计划id（总计划来源的数据的总计划id）
     */
    private Long planId;

    /**
     * 人工费金额（含税）
     */
    private BigDecimal detailArtificialTaxMny;

    /**
     * 人工费金额（无税）
     */
    private BigDecimal detailArtificialMny;

    /**
     * 人工费税额
     */
    private BigDecimal detailArtificialTax;

    /**
     * 人工费单价（含税）
     */
    private BigDecimal detailArtificialTaxPrice;

    /**
     * 人工费单价（无税）
     */
    private BigDecimal detailArtificialPrice;

    /**
     * 是否末级
     */
    private Boolean leafFlag;

    /**
     * 定标来源的总工程量
     */
    private BigDecimal detailTargetResultNum;

    /**
     * 定标来源的单价（无税）
     */
    private BigDecimal detailTargetResultPrice;

    /**
     * 定标来源的剩余可用工程量（不入库）
     */
    private BigDecimal detailTargetResultRemainderNum;

    /**
     * 初始版本占用定标工程量
     */
    private BigDecimal detailBaseTargetResultNum;

    /**
     * 定标来源的sellId（用于定标回写）
     */
    private Long detailTargetResultSellId;

    private String historyPriceArea;//历史价格区间（无税）
    private String historyTaxPriceArea;//历史价格区间（含税）
    private String guidePriceArea; // 公司指导价区间（无税）
    private String guideTaxPriceArea; // 公司指导价区间（含税）


    /***子表导出使用字段***/
    /**
     * 单价（无税）
     */
    private String detailPriceStr;

    /**
     * 税率
     */
    private String detailTaxRateStr;

    /**
     * 金额（无税）
     */
    private String detailMnyStr;

    /**
     * 单价(含税）
     */
    private String detailTaxPriceStr;

    /**
     * 金额（含税）
     */
    private String detailTaxMnyStr;

    /**
     * 税额
     */
    private String detailTaxStr;

    /**
     * 人工费金额（含税）
     */
    private String detailArtificialTaxMnyStr;

    /**
     * 人工费金额（无税）
     */
    private String detailArtificialMnyStr;

    /**
     * 人工费税额
     */
    private String detailArtificialTaxStr;

    /**
     * 人工费单价（含税）
     */
    private String detailArtificialTaxPriceStr;

    /**
     * 人工费单价（无税）
     */
    private String detailArtificialPriceStr;
    private String materialEquipmentSupply; //材料设备供应

    public String getDetailPriceStr() {
        return detailPriceStr;
    }

    public void setDetailPriceStr(String detailPriceStr) {
        this.detailPriceStr = detailPriceStr;
    }

    public String getDetailTaxRateStr() {
        return detailTaxRateStr;
    }

    public void setDetailTaxRateStr(String detailTaxRateStr) {
        this.detailTaxRateStr = detailTaxRateStr;
    }

    public String getDetailMnyStr() {
        return detailMnyStr;
    }

    public void setDetailMnyStr(String detailMnyStr) {
        this.detailMnyStr = detailMnyStr;
    }

    public String getDetailTaxPriceStr() {
        return detailTaxPriceStr;
    }

    public void setDetailTaxPriceStr(String detailTaxPriceStr) {
        this.detailTaxPriceStr = detailTaxPriceStr;
    }

    public String getDetailTaxMnyStr() {
        return detailTaxMnyStr;
    }

    public void setDetailTaxMnyStr(String detailTaxMnyStr) {
        this.detailTaxMnyStr = detailTaxMnyStr;
    }

    public String getDetailTaxStr() {
        return detailTaxStr;
    }

    public void setDetailTaxStr(String detailTaxStr) {
        this.detailTaxStr = detailTaxStr;
    }

    public String getDetailArtificialTaxMnyStr() {
        return detailArtificialTaxMnyStr;
    }

    public void setDetailArtificialTaxMnyStr(String detailArtificialTaxMnyStr) {
        this.detailArtificialTaxMnyStr = detailArtificialTaxMnyStr;
    }

    public String getDetailArtificialMnyStr() {
        return detailArtificialMnyStr;
    }

    public void setDetailArtificialMnyStr(String detailArtificialMnyStr) {
        this.detailArtificialMnyStr = detailArtificialMnyStr;
    }

    public String getDetailArtificialTaxStr() {
        return detailArtificialTaxStr;
    }

    public void setDetailArtificialTaxStr(String detailArtificialTaxStr) {
        this.detailArtificialTaxStr = detailArtificialTaxStr;
    }

    public String getDetailArtificialTaxPriceStr() {
        return detailArtificialTaxPriceStr;
    }

    public void setDetailArtificialTaxPriceStr(String detailArtificialTaxPriceStr) {
        this.detailArtificialTaxPriceStr = detailArtificialTaxPriceStr;
    }

    public String getDetailArtificialPriceStr() {
        return detailArtificialPriceStr;
    }

    public void setDetailArtificialPriceStr(String detailArtificialPriceStr) {
        this.detailArtificialPriceStr = detailArtificialPriceStr;
    }

    public String getDetailCode() {
        return detailCode;
    }

    public void setDetailCode(String detailCode) {
        this.detailCode = detailCode;
    }

    public String getDetailName() {
        return detailName;
    }

    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public String getDetailWorkContent() {
        return detailWorkContent;
    }

    public void setDetailWorkContent(String detailWorkContent) {
        this.detailWorkContent = detailWorkContent;
    }

    public String getDetailMeasurementRules() {
        return detailMeasurementRules;
    }

    public void setDetailMeasurementRules(String detailMeasurementRules) {
        this.detailMeasurementRules = detailMeasurementRules;
    }

    public String getDetailUnit() {
        return detailUnit;
    }

    public void setDetailUnit(String detailUnit) {
        this.detailUnit = detailUnit;
    }

    public BigDecimal getDetailNum() {
        return detailNum;
    }

    public void setDetailNum(BigDecimal detailNum) {
        this.detailNum = detailNum;
    }

    public BigDecimal getDetailPrice() {
        return detailPrice;
    }

    public void setDetailPrice(BigDecimal detailPrice) {
        this.detailPrice = detailPrice;
    }

    public BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    public void setDetailTaxRate(BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }

    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }

    public BigDecimal getDetailTaxPrice() {
        return detailTaxPrice;
    }

    public void setDetailTaxPrice(BigDecimal detailTaxPrice) {
        this.detailTaxPrice = detailTaxPrice;
    }

    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }

    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }

    public String getDetailMemo() {
        return detailMemo;
    }

    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Long getChangeBid() {
        return changeBid;
    }

    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }


    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public Long getDocCategoryId() {
        return docCategoryId;
    }

    public void setDocCategoryId(Long docCategoryId) {
        this.docCategoryId = docCategoryId;
    }

    public Long getDocId() {
        return docId;
    }

    public void setDocId(Long docId) {
        this.docId = docId;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public BigDecimal getDetailArtificialTaxMny() {
        return detailArtificialTaxMny;
    }

    public void setDetailArtificialTaxMny(BigDecimal detailArtificialTaxMny) {
        this.detailArtificialTaxMny = detailArtificialTaxMny;
    }

    public BigDecimal getDetailArtificialMny() {
        return detailArtificialMny;
    }

    public void setDetailArtificialMny(BigDecimal detailArtificialMny) {
        this.detailArtificialMny = detailArtificialMny;
    }

    public BigDecimal getDetailArtificialTax() {
        return detailArtificialTax;
    }

    public void setDetailArtificialTax(BigDecimal detailArtificialTax) {
        this.detailArtificialTax = detailArtificialTax;
    }

    public BigDecimal getDetailArtificialTaxPrice() {
        return detailArtificialTaxPrice;
    }

    public void setDetailArtificialTaxPrice(BigDecimal detailArtificialTaxPrice) {
        this.detailArtificialTaxPrice = detailArtificialTaxPrice;
    }

    public BigDecimal getDetailArtificialPrice() {
        return detailArtificialPrice;
    }

    public void setDetailArtificialPrice(BigDecimal detailArtificialPrice) {
        this.detailArtificialPrice = detailArtificialPrice;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    public BigDecimal getDetailTargetResultNum() {
        return detailTargetResultNum;
    }

    public void setDetailTargetResultNum(BigDecimal detailTargetResultNum) {
        this.detailTargetResultNum = detailTargetResultNum;
    }

    public BigDecimal getDetailTargetResultPrice() {
        return detailTargetResultPrice;
    }

    public void setDetailTargetResultPrice(BigDecimal detailTargetResultPrice) {
        this.detailTargetResultPrice = detailTargetResultPrice;
    }

    public BigDecimal getDetailTargetResultRemainderNum() {
        return detailTargetResultRemainderNum;
    }

    public void setDetailTargetResultRemainderNum(BigDecimal detailTargetResultRemainderNum) {
        this.detailTargetResultRemainderNum = detailTargetResultRemainderNum;
    }

    public BigDecimal getDetailBaseTargetResultNum() {
        return detailBaseTargetResultNum;
    }

    public void setDetailBaseTargetResultNum(BigDecimal detailBaseTargetResultNum) {
        this.detailBaseTargetResultNum = detailBaseTargetResultNum;
    }

    public Long getDetailTargetResultSellId() {
        return detailTargetResultSellId;
    }

    public void setDetailTargetResultSellId(Long detailTargetResultSellId) {
        this.detailTargetResultSellId = detailTargetResultSellId;
    }

    public String getDocPriceTypeName() {
        return docPriceTypeName;
    }

    public void setDocPriceTypeName(String docPriceTypeName) {
        this.docPriceTypeName = docPriceTypeName;
    }

    public String getHistoryPriceArea() {
        return historyPriceArea;
    }

    public void setHistoryPriceArea(String historyPriceArea) {
        this.historyPriceArea = historyPriceArea;
    }

    public String getHistoryTaxPriceArea() {
        return historyTaxPriceArea;
    }

    public void setHistoryTaxPriceArea(String historyTaxPriceArea) {
        this.historyTaxPriceArea = historyTaxPriceArea;
    }

    public String getGuidePriceArea() {
        return guidePriceArea;
    }

    public void setGuidePriceArea(String guidePriceArea) {
        this.guidePriceArea = guidePriceArea;
    }

    public String getGuideTaxPriceArea() {
        return guideTaxPriceArea;
    }

    public void setGuideTaxPriceArea(String guideTaxPriceArea) {
        this.guideTaxPriceArea = guideTaxPriceArea;
    }

    public String getMaterialEquipmentSupply() {
        return materialEquipmentSupply;
    }

    public void setMaterialEquipmentSupply(String materialEquipmentSupply) {
        this.materialEquipmentSupply = materialEquipmentSupply;
    }
}
